// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Typing game example
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef GAME_H
#define GAME_H

#include <vector>
#include <inti/signal-system.h>
#include <inti/timedate.h>
#include <inti/gdk/event.h>

using namespace Inti;

class Badguy;
class Player;

// The Game class is the "model" representing a game;
// the GameView widget displays it.
class Game : public SignalEmitter
{
public:
  Game (Player * player);
  ~Game ();

  bool started () const { return started_; }
  void start ();
  void set_paused (bool state);
  
  void set_size (int width, int height);
  int width () const { return width_; }
  int height () const { return height_; }

  const vector<Badguy*> & badguys () const { return badguys_; }

  void add_badguy (Badguy * badguy);
  void delete_badguy (Badguy * badguy);

  bool process_key (const Gdk::EventKey & key);

  void adjust_score (int delta);
  void adjust_shields (int delta);

  int score () const { return score_; }
  int shields () const { return shields_; }
  
  typedef Signal0<void> UpdateSignalType;
  typedef SignalProxy<SignalEmitter, UpdateSignalType> UpdateSignalProxyType;
  
  UpdateSignalProxyType sig_update ()
  {
    return UpdateSignalProxyType (this, &update_signal);
  }
  
private:
  static UpdateSignalType update_signal;

  bool started_;
  bool paused_;
  
  Player * player_;
  
  int width_;
  int height_;

  vector<Badguy*> badguys_;

  Connection timeout_;

  int score_;
  int shields_;

  TimeStamp last_stamp_;
  
  Game (const Game &);
  Game & operator= (const Game&);

  bool on_timeout ();
};

#endif







