/* $Id: gsl_ran.h,v 1.2 1996/10/24 17:28:52 jt Exp $ */
#ifndef _gsl_ran_zuf_RANDOM_H_
#define _gsl_ran_zuf_RANDOM_H_

double gsl_ran_zuf_uniform(void);
void gsl_ran_zuf_seed(int);

unsigned long gsl_ran_zuf_random(void);
double gsl_ran_zuf_max();

void *gsl_ran_zuf_getRandomState(void);
void gsl_ran_zuf_setRandomState(void *);

unsigned long gsl_ran_zuf_random_wstate(void *);
double gsl_ran_zuf_uniform_wstate(void *);
void gsl_ran_zuf_seed_wstate(void *, int);

/* Note: it's kind of ugly to have the gaussian random state defined
 * so explicitly, if we used void *'s we would lose some typechecking
 * ability, but it would look better.  maybe if we just called it
 * gsl_ran_zuf_gState, it wouldn't be so bad...  */
typedef struct {
    int ng;
    double g;
    void *randomState;
} gsl_ran_zuf_gaussianRandomState;

void gsl_ran_zuf_copyGaussState(gsl_ran_zuf_gaussianRandomState *,
                            gsl_ran_zuf_gaussianRandomState *);
gsl_ran_zuf_gaussianRandomState *gsl_ran_zuf_getGaussState(void);
void gsl_ran_zuf_setGaussState(gsl_ran_zuf_gaussianRandomState *);
double gsl_ran_zuf_gaussian_wstate(gsl_ran_zuf_gaussianRandomState *);
double gsl_ran_zuf_gaussian();

#endif /* _gsl_ran_zuf_RANDOM_H_ */
