#
# gnatsweb-site.pl -
#     Gnatsweb site-specific variables and subroutines.
#
# $Id: gnatsweb-site-sente.pl,v 2.1 1999/04/11 17:11:23 kenstir Exp $

# Name you want in the page banner.  See also &site_start_html.
$site_banner_text = 'Sente gnatsweb';

# Default domain for email addresses.  This get tacked onto the end of
# the user name, but can be overridden.
$site_default_domain = 'senteinc.com';

# site_callback -
#     Override gnatsweb behavior under certain circumstances.
#
#     Return undef if not handling it.
#
sub site_callback {
    my($reason, @args) = @_;

    # Use warn() to facilitate debugging.  Look for the messages in the
    # system log, e.g. /var/log/httpd/error_log
    #warn "site_callback: @_\n";

    if ($reason eq 'sendpr_description')
    {
        # default Description text
        return 
" Customer?: <yes/no>
 Company: <company_name>
 Contact: <contact_name>
 Email: <address>
";
    }
    elsif ($reason eq 'sendpr_fix')
    {
        # default Fix text
        return 
" Fix for: 
 Fixed in: 
";
    }
    elsif ($reason eq 'page_footer')
    {
        # override footer html
        my($title) = @args;
        if ($title eq 'View PR')
        {
            # Add one-click buttons at footer of view PR page.
            return sente_view_postlude();
        }
        #return h3("$title -- page_footer");
    }
    #elsif ($reason eq 'page_heading')
    #{
    #    # override heading html
    #    my($title, $heading) = @args;
    #    return h1({-style=>'color:red'}, $heading);
    #}
    #elsif ($reason eq 'page_start_html')
    #{
    #    # override initial html
    #    my($title) = @args;
    #    return start_html(-title=>$title, -bgcolor=>'yellow') .
    #        hr({-width=>'50%', -noshade=>1, -size=>10});
    #}
    #elsif ($reason eq 'page_end_html')
    #{
    #    # override final html
    #    my $title = shift(@args);
    #    return h3("$title -- page_end_html") . end_html();
    #}
    undef;
}

# sente_view_postlude -
#
#     Print forms which perform one-click actions.
#
sub sente_view_postlude
{
    # These one-click actions only apply to editors.
    return undef unless can_edit();

    # Canned reasons to submit as "-Why" fields during one-click actions.
    my(%reason) =
        ('mine',     "[This is a standard response.]\n" .
                     "This issue is mine.",
         'analyzed', "[This is a standard response.]\n" .
                     "I understand the problem.",
         );

    # This bit of HTML is common to all one-click actions.
    my $common_html = $q->start_form();
    $common_html .= $q->hidden(-name=>'Editor', -value=>$user, -override=>1);
    $common_html .= $q->hidden(-name=>'Last-Modified',
                               -value=>$fields{'Last-Modified'},
                               -override=>1);
    $common_html .= $q->hidden(-name=>'pr', -value=>$pr, -override=>1);
    $common_html .= $q->hidden(-name=>'cmd',
                               -value=>'submit edit',
                               -override=>1);

    my $html = "<table cellpadding=0 cellspacing=0 border=0>\n";
    $html .= '<tr align=left valign=top><td>'
        . $common_html
        . $q->hidden(-name=>'Responsible', -value=>$user, -override=>1)
        . $q->hidden(-name=>'Responsible-Why',
                     -value=>$reason{'mine'},
                     -override=>1)
        . $q->submit(-name=>'unused', -value=>'mine')
        . $q->end_form()
        . '</td>'
        . '<td>&nbsp;'
        . '<td><strong>Responsible = me</strong></td>'
        . '<td>&nbsp;'
        . "<td><pre><small>$reason{'mine'}</small></pre></td>"
        . '</tr>';
    $html .= '<tr align=left valign=top><td>'
        . $common_html
        . $q->hidden(-name=>'State', -value=>'analyzed', -override=>1)
        . $q->hidden(-name=>'State-Why',
                     -value=>$reason{'analyzed'},
                     -override=>1)
        . $q->submit(-name=>'unused', -value=>'analyzed')
        . $q->end_form()
        . '</td>'
        . '<td>&nbsp;'
        . '<td><strong>State = analyzed</strong></td>'
        . '<td>&nbsp;'
        . "<td><pre><small>$reason{'analyzed'}</small></pre></td>"
        . '</tr>';
    $html .= '</table>';
    #warn "---html---\n$html\n---\n";
    $html;
}
