'\"
'\" Copyright (c) 1997 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) labeledframe.n 1.21 97/1/30 16:04:44
'/" 
.so man.macros
.HS labeledframe iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
labeledframe \- Create and manipulate a labeled frame widget
.SH SYNOPSIS
\fBlabeledframe\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Archetype <- labeledframe
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderwidth\fR	\fBcursor\fR
\fBforeground\fR	\fBrelief\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBiPadX\fR
Class:	\fBIPad\fR
Command-Line Switch:	\fB-ipadx\fR
.fi
.IP
Specifies horizontal padding space between the border and the childsite.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 0.
.LP
.nf
Name:	\fBiPadY\fR
Class:	\fBIPad\fR
Command-Line Switch:	\fB-ipady\fR
.fi
.IP
Specifies vertical padding space between the border and the childsite.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 0.
.LP
.nf
Name:	\fBlabelBitmap\fR
Class:	\fBBitmap\fR
Command-Line Switch:	\fB-labelbitmap\fR
.fi
.IP
Specifies a bitmap to display in the label, in any of the forms 
acceptable to \fBTk_GetBitmap\fR.  This option overrides the \fIlabeltext\fR
option.
.LP
.nf
Name:	\fBlabelImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-labelimage\fR
.fi
.IP
Specifies a image to be used as the label. The image may be any of the
values created by the \fBimage create\fR command.  This option overrides
both the \fIlabelbitmap\fR and \fIlabeletext\fR options.
.LP
.nf
Name:	\fBlabelMargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-labelmargin\fR
.fi
.IP
Specifies the distance between the inner ede of the hull frames relief,
and the label in any of the forms acceptable to \fBTk_GetPixels\fR. 
The default is 10 pixels.
.LP
.nf
Name:	\fBlabelText\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-labeltext\fR
.fi
.IP
Specifies the text of the label around the childsite.
.LP
.nf
Name:	\fBlabelVariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB-labelvariable\fR
.fi
.IP
Specifies the text variable of the label around the childsite.
.LP
.nf
Name:	\fBlabelFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-labelfont\fR
.fi
.IP
Specifies the font of the label around the childsite.
.LP
.nf
Name:	\fBlabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-labelpos\fR
.fi
.IP
Specifies the position of the label within the grooved relief of the hull widget.
\fB ne, n, nw, se, s, sw, en, e, es, wn, w, ws\fR  Default is \fBn\fR.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBlabeledframe\fR command creates a hull frame with a
grooved relief, a label positioned within the grooved relief of
the hull frame, and a frame childsite.  The frame childsite can filled with any
widget via a derived class or though the use of the childsite method.
This class was designed to be a general purpose base class for supporting the 
combination of labeled frame and a childsite.  The options include the
ability to position the label at configurable locations within the
grooved relief of the hull frame, and control the display of the label.
.SH "METHODS"
.PP
The \fBlabeledframe\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for labeledframe widgets:
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBchildsite\fR
Return the path name of the child site.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBlabeledframe\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBlabeledframe\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBlabel\fR
Class:	\fBlabel\fR
.fi
.IP
The label component provides the label for the labeled widget.  See the 
"label" widget manual entry for details on the label component item.
.fi
.LP

.SH EXAMPLE
.IP
The labeledframe was primarily meant to be a base class.  The
Radiobox is a good example of a derived classe of the labeledframe class.
In order to provide equal support for composite classes, the 'childsite' methods
also exists.  The following is an example of 'childsite' method usage.
.LP
.DS
 labeledframe .lw -labeltext "Entry Frame" -labelpos n
 pack .lw -fill both -expand yes -padx 10 -pady 10
 set cs [.lw childsite]

 pack [Entryfield $cs.entry1 -labeltext "Name:"] -side top -fill x
 pack [Spinint $cs.entry2 -labeltext "Number:"] -side top -fill x
 pack [Pushbutton $cs.entry3 -text "Details:"] -side top -fill x

.DE
.SH AUTHOR
John A. Tucker
.SH KEYWORDS
labeledframe, widget
