.\" Copyright (c) 1992 Free Software Foundation
.\" See section COPYING for conditions for redistribution
.\" $Id: texindex.man,v 1.1 1993/02/26 02:00:12 zoo Exp $
.TH texindex 1 "2mar1992" "GNU Tools" "GNU Tools"
.de BP
.sp
.ti -.2i
\(**
..

.SH NAME
texindex -- sort index files for Texinfo manuals
.SH SYNOPSIS
.hy 0
.na
.TP
\fBtexindex\fP [\|\fB\-k\fP\|] \fIindexfile\fP [\|\fB\-o\fP \fIoutfile\fP\|]\|.\|.\|.
.ad b
.hy 1
.SH DESCRIPTION
.B texindex
is an auxiliary program used to sort indices for printed manuals
written with Texinfo (the GNU documentation file).  
.B texindex
is meant for use with TeX, the freely available text formatter.

When you format a Texinfo file (a documentation file written in the
GNU documentation format) with the shell command 
.BR tex ,
several auxiliary files are written as well as the primary output
file.  These files contain information for indices, cross references,
and so on.  Formatting with 
.B tex
a second time will incorporate this information into the printed
manual.

However, the 
.B tex
formatting command itself does not sort the indices; it
writes an output file of unsorted index data.  This is a misfeature of
TeX.  Hence, to generate a printed index, you first need a sorted
index to work from.  This is what
.B texindex
is for.

TeX outputs unsorted index files under
names that obey a standard convention (for Texinfo manuals).  These names are the name of
your main input file to the `tex' formatting command, with everything
after the first period thrown away, and the two letter names of
indices added at the end.  For example, the raw index output files for
the input file `\|\fBfoo.texinfo\fP\|' would be `\|\fBfoo.cp\fP\|', 
`\|\fBfoo.vr\fP\|', `\|\fBfoo.fn\fP\|', `\|\fBfoo.tp\fP\|',
`\|\fBfoo.pg\fP\|' and `\|\fBfoo.ky\fP\|'.  Those are exactly the arguments to
give to 
.BR texindex .
More simply, you can use `\|\fB??\|\fP' as ``wild-cards'' and
give the command in this form:

.B
\ \ \ \ \ texindex\ foo.??

You may execute `\|\fBtexindex\ foo.??\fP\|' even if there are
similarly named files with two letter extensions that are not index
files, such as `\|\fBfoo.el\fP\|'.  The
.B texindex
command reports but otherwise ignores such files.

For each file specified, `texindex' generates a sorted index file.
By default, the name of the sorted file is made by appending `s' to
the input file name; you can use another output filename with the 
.B \-o
option, but this is not recommended---the Texinfo format's command for
printing indices won't know to look for files with different names.
.B 
texindex
does not alter the raw index output file.

After you have sorted the indices, you need to rerun the 
.B tex
formatting command on the Texinfo file.
.SH OPTIONS
.TP
.B \-k
Keep temporary working files.
.TP
\fB\-o\fP \fIoutfile\fP
Use \fIoutfile\fP as the name for the sorted file for data from the
immediately preceding index file.  This is not recommended as part of
producing printed manuals, since the Texinfo macros expect sorted
index files with the standard names.
.SH ENVIRONMENT
.TP
.B TMPDIR
Directory for writing temporary files.  If this environment variable
is not defined, the default is `\|\fB/tmp\fP\|'.
.SH "SEE ALSO"
.BR tex ( 1 ),
.BR info ( 1 ),
.BR makeinfo ( 1 );
.BR ` texinfo "' entry in `" info ';
.I
Texinfo: the GNU Documentation Format
by Robert J. Chassell and Richard M. Stallman
.SH COPYING
Copyright (c) 1992 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
