dnl
dnl Check to see if this version of GNU C++ is afflicted by bugs in
dnl __complex__ float support.
dnl
dnl Define BUGGY_FLOAT_COMPLEX if buggy.
dnl
dnl GLIBCPP_CHECK_FLOAT_COMPLEX_SUPPORT
AC_DEFUN(GLIBCPP_CHECK_FLOAT_COMPLEX_SUPPORT, [
  AC_REQUIRE([AC_PROG_CXX])
  AC_MSG_CHECKING([for GNU C++ float __complex__ support])
  AC_CACHE_VAL(glibcpp_cv_float_complex, [
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS
    rm -f conftest.h
    cat > conftest.h <<EOB
      //
      // Check for buggy __complex__ that causes ICE in most versions of egcs
      // and gcc-2.95.x on certain platforms (eg., x86-win32).
      //
      // See http://egcs.cygnus.com/ml/gcc-bugs/1999-07/msg00845.html for
      // more info on the bug itself.
      //
      struct
      float_complex
      {
       __complex__ float m_value;
       float_complex (float = 0.0f, float = 0.0f);
       float_complex (__complex__ float val) : m_value (val) {}
       float_complex foo (const float_complex &val)
         { return float_complex (~val.m_value); }
      };
EOB
    AC_TRY_COMPILE([#include "conftest.h"], ,
      glibcpp_cv_float_complex=ok,
      glibcpp_cv_float_complex=buggy
    )
    AC_LANG_RESTORE
  ])
  AC_MSG_RESULT($glibcpp_cv_float_complex)
  if test $glibcpp_cv_float_complex = buggy; then
    AC_DEFINE(_GLIBCPP_BUGGY_FLOAT_COMPLEX)
  fi
])


dnl
dnl Check for certain special build configurations.
dnl
dnl GLIBCPP_ENABLE_DEBUG
dnl --enable-debug sets '-ggdb -O0'.
dnl --disable-debug sets '-g' and whatever optimization options the
dnl     compiler can handle.
dnl  +  Perhaps --enable-maintainer-mode should automatically turn this on?
dnl  +  Perhaps -D/-U of NDEBUG, DEBUG, DEBUG_ASSERT, ...?
dnl  +  Usage:  GLIBCPP_ENABLE_DEBUG[(DEFAULT)]
dnl       Where DEFAULT is either `yes' or `no'.  If ommitted, it
dnl       defaults to `no'.
dnl
dnl GLIBCPP_ENABLE_NAMESPACES
dnl --enable-namespaces sets '-fhonor-std' and defines _GLIBCPP_USE_NAMESPACES
dnl --disable-namespaces sets '-fno-honor-std' (the macro should be
dnl     undefined by default in whatever.h.in).
dnl  +  Eventually, this will go away.
dnl  +  Usage:  GLIBCPP_ENABLE_NAMESPACES[(DEFAULT)]
dnl       Where DEFAULT is either `yes' or `no'.  If ommitted, it
dnl       defaults to `no'.
dnl
dnl Based on the AC_ENABLE macros found in aclocal.m4, but how they
dnl got there isn't documented.
dnl

dnl GLIBCPP_ENABLE_DEBUG
AC_DEFUN(GLIBCPP_ENABLE_DEBUG, [dnl
define([GLIBCPP_ENABLE_DEBUG_DEFAULT], ifelse($1, yes, yes, no))dnl
AC_ARG_ENABLE(debug,
changequote(<<, >>)dnl
<<  --enable-debug          extra debugging, turn off optimization [default=>>GLIBCPP_ENABLE_DEBUG_DEFAULT],
changequote([, ])dnl
[case "$enableval" in
 yes) enable_debug=yes ;;
 no)  enable_debug=no ;;
 *)   AC_MSG_ERROR([Unknown argument to enable/disable extra debugging]) ;;
 esac],
enable_debug=GLIBCPP_ENABLE_DEBUG_DEFAULT)dnl
dnl Option parsed, now set things appropriately
case "$enable_debug" in
    yes)  DEBUGFLAGS='-ggdb -O0'
          ;;
    no)   DEBUGFLAGS='-g'
          ;;
esac
AC_SUBST(DEBUGFLAGS)
])


dnl GLIBCPP_ENABLE_NAMESPACES
AC_DEFUN(GLIBCPP_ENABLE_NAMESPACES, [dnl
define([GLIBCPP_ENABLE_NAMESPACES_DEFAULT], ifelse($1, yes, yes, no))dnl
AC_ARG_ENABLE(namespaces,
changequote(<<, >>)dnl
<<  --enable-namespaces     turns on 'std' [default=>>GLIBCPP_ENABLE_NAMESPACES_DEFAULT],
changequote([, ])dnl
[case "$enableval" in
 yes) enable_namespaces=yes ;;
 no)  enable_namespaces=no ;;
 *)   AC_MSG_ERROR([Unknown argument to enable/disable namespaces]) ;;
 esac],
enable_namespaces=GLIBCPP_ENABLE_NAMESPACES_DEFAULT)dnl
dnl Option parsed, now set things appropriately
case "$enable_namespaces" in
    yes)  NAMESPACES='-fhonor-std'
          AC_DEFINE(_GLIBCPP_USE_NAMESPACES)
          ;;
    no)   NAMESPACES='-fno-honor-std'
          ;;
esac
AC_SUBST(NAMESPACES)
])

