// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"
#include "Domain/Interval.h"
#include "Utilities/Inform.h"
#include <iostream>
#include <iomanip>
#include "Utilities/Tester.h"

int main(int argc, char *argv[])
{
  // initialize Pooma
  Pooma::initialize(argc,argv);
 
  Pooma::Tester tester(argc, argv);
  // create some Inform instances
  Inform A("POOMA-II:A");
  Inform B("POOMA-II:B");

  // add another connection to stderr for B
  Inform::ID_t connection = B.open(std::cerr);

  // write A's output also to a file
  Inform::ID_t connection2 = A.open("inform_test.dat", Inform::out);

  // simple test prints, which should have leading and trailing blank lines
  A << "------" << std::endl;
  A << std::endl
    << "This should have a leading and following blank line."
    << std::endl << std::endl;
  A << "------" << std::endl;
  B << "------" << std::endl;
  B << std::endl
    << "This should have a leading and following blank line."
    << std::endl << std::endl;
  B << "------" << std::endl;

  // print some domains to this, to test output to ostream:
  Interval<1> X(1,5);
  A << "Interval X = " << X << ", with no endl, just flush";
  A << std::flush;

  // use some manipulators
  int val = 2;
  int val2 = 1234;
  A << std::setw(4) << std::setfill('#') << val << ": should be ###2"
    << std::endl;
  B << val2 << " = " << std::hex << val2 << " (hex), ";
  B << std::oct << val2 << " (oct)" << std::endl;

  // close B's second connection
  B.close(connection);
  B << "This line should only appear once." << std::endl;

  // should be some blank lines
  A << std::endl << std::endl
    << "There should be two blank lines, then this." << std::endl;

  // inform about file to check
  A << std::endl
    << "The file 'inform_test.dat' should contain copies of all";
  A << " the lines written to the 'A' stream." << std::endl;

  int res = tester.results();

  // finalize Pooma
  Pooma::finalize();

  return res;
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: inform_test.cpp,v $   $Author: swhaney $
// $Revision: 1.9 $   $Date: 2000/03/07 13:18:32 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
