// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Tiny bounds checking test
//-----------------------------------------------------------------------------

#include "Pooma/Configuration.h"

#ifdef POOMA_BOUNDS_CHECK
#undef POOMA_BOUNDS_CHECK
#define POOMA_BOUNDS_CHECK POOMA_YES
#endif

#include "Tiny/TinyMatrix.h"
#include "Tiny/Vector.h"
#include "Tiny/VectorTinyMatrix.h"

#include <iostream>

int ecnt = 0;

int main()
{
#if POOMA_EXCEPTIONS
  try 
    {
      Vector<3, double> v;
      v(0) = 0.0; v(1) = 2.0; v(2) = -4.0;
      v(6) = 1.3;
    }
  catch (Pooma::Assertion &a)
    {
      a.print(std::cerr);
      std::cerr << std::endl;
      ecnt++;
    }
  try 
    {
      TinyMatrix<2, 3, double> t;
      t(0, 0) = 0.0; t(0, 1) = 2.0; t(0, 2) = -4.0;
      t(1, 0) = 0.2; t(1, 1) = 2.6; t(1, 2) = -0.4;
      t(-1,0) = 1.3;
    }
  catch (Pooma::Assertion &a)
    {
      a.print(std::cerr);
      std::cerr << std::endl;
      ecnt++;
    }
#else
    {
      // The following bounds violation causes a POOMA assertion
      // failure, which makes the test appear to have failed when in
      // fact it behaved correctly.  As there is no way to handle the
      // bounds failure gracefully without exceptions, the code is
      // inactivated.
      
//       Vector<3, double> v;
//       v(0) = 0.0; v(1) = 2.0; v(2) = -4.0;
//       v(6) = 1.3;
      ecnt = 2;
    }
#endif

  if (ecnt == 2)
    {
      std::cerr << "PASSED" << std::endl;
      return 0;
    }
  else
    {
      std::cerr << "FAILED" << std::endl;
      return 1;
    }
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: t2.cpp,v $   $Author: swhaney $
// $Revision: 1.5 $   $Date: 2000/03/07 13:18:20 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
