// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// DistributedMapper<Dim>
//-----------------------------------------------------------------------------

#ifndef POOMA_DISTRIBUTEDMAPPER_H
#define POOMA_DISTRIBUTEDMAPPER_H

#include "Partition/ContextMapper.h"
#include "Partition/ContiguousMapper.h"
#include "Partition/BisectionMapper.h"
#include "Partition/UniformMapper.h"

template<int Dim>
class DistributedMapper
  : public ContextMapper<Dim>
{ 
public:
  //============================================================
  // Typedefs and enumerations
  //============================================================
  typedef Interval<Dim>                       Domain_t;
  typedef Node<Domain_t>                      Value_t;
  typedef std::vector<Value_t *>              List_t;

  template<class Partitioner>
  DistributedMapper(const Partitioner & gp) 
    : blocks_m(gp.blocks())
  {
  }


  void map(const List_t & templist) const
  {
    int ncontexts = Pooma::contexts();
    int npc = templist.size()/ncontexts;
    // if there are more contexts then patches, assign one
    // patch per context for as many patches as there are. 
    if(ncontexts> templist.size())
      {
	// we should probably alert the user here!!
	npc = 1;
	ncontexts = templist.size();
      }

    if (Dim == 1)
      {
	// work around, since UniformMapper is 1-dim
	uniformMap(blocks_m,templist,WrappedInt<Dim>());
      }
    else if(npc<3)
      {
	ContiguousMapper<Dim>(blocks_m).map(templist);
      }
    else
      {
	BisectionMapper<Dim>(blocks_m).map(templist);
      }
    return;      
  }

  void uniformMap(const Loc<1> &blocks,
		  const List_t &templist,
		  const WrappedInt<1>&) const
  {
    UniformMapper(blocks).map(templist);
  }

  template <int D>
  void uniformMap(const Loc<D> &,
		  const List_t &,
		  const WrappedInt<D>&) const
  {
    PAssert(false); // uniformMapper is 1 D only 
  }

  // member data
private:

  Loc<Dim> blocks_m;

};

#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: DistributedMapper.h,v $   $Author: sa_smith $
// $Revision: 1.5 $   $Date: 2000/06/06 16:38:53 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
