// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
//   RangeMaker
//-----------------------------------------------------------------------------

#ifndef POOMA_DATABROWSER_RANGEMAKER_H
#define POOMA_DATABROWSER_RANGEMAKER_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
// 
// Classes:
//
// RangeMaker : ???
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------
#include "Domain/Range.h"

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//
// Full Description:
//
// Classes:
//
// RangeMaker:
// 
// RangeMaker is a functor class ....
// 
//-----------------------------------------------------------------------------

// See DataBrowser.h, in further partial specializations of dbprint<>(), for
// why this RangeMaker class exists:

template<int Dim, int NumIntArgs>
class RangeMaker;

// Run through all the meaningful combinations of Dim and NumIntArgs and make
// partial specializations of RangeMaker:

// For Dim=NumIntArgs, interpret as requesting a single element:


// --------------------------------------------------------
// Dim = 1

template<>
class RangeMaker<1,1>
{
public:
  RangeMaker() { }
  Range<1> operator()(const int& i0)
  {
    return Range<1>(i0,i0,1);
  }
};

template<>
class RangeMaker<1,2>
{
public:
  RangeMaker() { }
  Range<1> operator()(const int& i0, const int& i1)
  {
    return Range<1>(i0, i1, 1);
  }
};

template<>
class RangeMaker<1,3>
{
public:
  RangeMaker() { }
  Range<1> operator()(const int& i0, const int& i1, const int& i2)
  {
    return Range<1>(Range<1>(i0, i1, i2));
  }
};


// --------------------------------------------------------
// Dim = 2

template<>
class RangeMaker<2,1>
{
public:
  RangeMaker() { }
  Range<2> operator()(const int& i0)
  {
    return Range<2>(Range<1>(i0), Range<1>(i0));
  }
};

template<>
class RangeMaker<2,2>
{
public:
  RangeMaker() { }
  Range<2> operator()(const int& i0, const int& i1)
  {
    return Range<2>(Range<1>(i0, i0, 1), Range<1>(i1, i1, 1));
  }
};

template<>
class RangeMaker<2,4>
{
public:
  RangeMaker() { }
  Range<2> operator()(const int& i0, const int& i1, const int& i2, const int& i3)
  {
    return Range<2>(Range<1>(i0, i1, 1), Range<1>(i2, i3, 1));
  }
};

template<>
class RangeMaker<2,6>
{
public:
  RangeMaker() { }
  Range<2> operator()(const int& i0, const int& i1, const int& i2, const int& i3, 
                      const int& i4, const int& i5)
  {
    return Range<2>(Range<1>(i0, i1, i2), Range<1>(i3, i4, i5));
  }
};


// --------------------------------------------------------
// Dim = 3

template<>
class RangeMaker<3,1>
{
public:
  RangeMaker() { }
  Range<3> operator()(const int& i0)
  {
    return Range<3>(Range<1>(i0), Range<1>(i0), Range<1>(i0));
  }
};

template<>
class RangeMaker<3,3>
{
public:
  RangeMaker() { }
  Range<3> operator()(const int& i0, const int& i1, const int& i2)
  {
    return Range<3>(Range<1>(i0, i0, 1), Range<1>(i1, i1, 1), 
                    Range<1>(i2, i2, 1));
  }
};

template<>
class RangeMaker<3,6>
{
public:
  RangeMaker() { }
  Range<3> operator()(const int& i0, const int& i1, const int& i2, 
                      const int& i3, const int& i4, const int& i5)
  {
    return Range<3>(Range<1>(i0, i1, 1), Range<1>(i2, i3, 1), 
                    Range<1>(i4, i5, 1));
  }
};

template<>
class RangeMaker<3,9>
{
public:
  RangeMaker() { }
  Range<3> operator()(const int& i0, const int& i1, const int& i2, 
                      const int& i3, const int& i4, const int& i5, 
                      const int& i6, const int& i7, const int& i8)
  {
    return Range<3>(Range<1>(i0, i1, i2), Range<1>(i3, i4, i5), 
                    Range<1>(i6, i7, i8));
  }
};


// --------------------------------------------------------
// Dim = 4

template<>
class RangeMaker<4,1>
{
public:
  RangeMaker() { }
  Range<4> operator()(const int& i0)
  {
    return Range<4>(Range<1>(i0), Range<1>(i0), Range<1>(i0), Range<1>(i0));
  }
};

template<>
class RangeMaker<4,4>
{
public:
  RangeMaker() { }
  Range<4> operator()(const int& i0, const int& i1, const int& i2, 
                      const int& i3)
  {
    return Range<4>(Range<1>(i0, i0, 1), Range<1>(i1, i1, 1), 
                    Range<1>(i2, i2, 1), Range<1>(i3, i3, 1));
  }
};

template<>
class RangeMaker<4,6>
{
public:
  RangeMaker() { }
  Range<4> operator()(const int& i0, const int& i1, const int& i2, 
                      const int& i3, const int& i4, const int& i5)
  {
    return Range<4>(Range<1>(i0, i1, 1), Range<1>(i2, i3, 1), 
                    Range<1>(i4, i5, 1));
  }
};

template<>
class RangeMaker<4,12>
{
public:
  RangeMaker() { }
  Range<4> operator()(const int& i0, const int& i1, const int& i2, 
                      const int& i3, const int& i4, const int& i5, 
                      const int& i6, const int& i7, const int& i8, 
                      const int& i9, const int& i10, const int& i11)
  {
    return Range<4>(Range<1>(i0, i1, i2), Range<1>(i3, i4, i5), 
                    Range<1>(i6, i7, i8), Range<1>(i9, i10, i11));
  }
};

#endif     // POOMA_DATABROWSER_RANGEMAKER_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: RangeMaker.h,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/03/07 13:16:30 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
