# Initialize default values for make variables.
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license

#
# Variables may need to change according to OS and tool installation differences.
# This file could become a <system>.mk, somewhat like Imake uses.
# Note that some assignments are wrapped in "ifndef/endif" conditionals. Such an
# assignment won't override an environment variable. In no case does one of these
# assignments override a commandline argument to make.
#
# Any of these may be overridden in the suite file, or the user-prefs file.
################################################################################

# Put the first rule here, so 'default' becomes the default target everywhere.
.PHONY : default
default::

################################################################################
# Set paths to utilities, if necessary
# Allow most tools to be chosen according to the user's path. However
# some tools just don't work right. In those cases, you may supply something
# explicit.

ifndef BROWSER
BROWSER     = netscape
endif
#CAT        = cat
#CD         = cd
COMPRESS    = compress
#CP         = cp
CVS         = cvs
#DATE       = date
#ECHO       = echo
FIND        = find
GNUTAR      = tar
GREP        = grep
GZIP        = gzip
GUNZIP      = gunzip
#HOSTNAME   = hostname
#LN         = ln
#LS         = ls
MAKEDEPEND  = makedepend
#MKDIR      = mkdir
#MV         = mv
ifndef PAGER
PAGER       = more
endif
PERL        = perl
#RM         = rm
SED         = sed
# You may need to change SHELL to point to your Korn shell
SHELL       = /bin/sh
SORT        = sort
TAR         = /bin/tar
TIME        = /usr/bin/time -p
#TIME        = time
TOUCH       = touch
TR          = tr
WC          = wc
XARGS       = /bin/xargs
XTERM       = xterm

################################################################################
# Set some defaults, unless specified on the command line or in the
# user prefs file. 

ifndef LD_PARALLEL
LD_PARALLEL = 1
endif

# Default pass through compiler/linker is PASS=1
PASS = 1

# Perhaps Purify stuff belongs in the suite files?
PURIFY_HOME    = /usr/local/packages/purify-4.1-irix6
PURIFY         = /usr/local/packages/purify-4.1-irix6/purify

# Provide for choice in output redirection.
# Use something like this in your suite file to get stderr & stdout to
# go to both the terminal and the info file.
#SUITE_REDIRECT = 2>&1 | tee -a $(INFO_FILE)
SUITE_REDIRECT = >> $(INFO_FILE) 2>&1

# This is the default list of targets built by the "default::" rule.
# The += operator doesn't work properly on an uninitialized variable.
LOCAL_OBJS :=


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: variables.mk,v $   $Author: julianc $
#  $Revision: 1.6 $   $Date: 1999/04/26 23:36:59 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
