# Rules for transforming one suffix to another. Primarily compilation.
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license


#TARGET		DEPENDENCY			COMMAND(S)
#$(ODIR)/%.e:	$(THISDIR)/%.c;			$(TouchToSuite)
#$(ODIR)/%.o:	$(THISDIR)/%.cc;		$(TouchToSuite)
#$(ODIR)/%.o:	$(THISDIR)/%.cpp;		$(TouchToSuite)
#$(ODIR)/%.o:	$(THISDIR)/%.C;			$(TouchToSuite)

$(ODIR)/%.o:	$(THISDIR)/%.cc;		$(CXXToSuite)
ifdef TAUPROFILE
$(ODIR)/%.o:	$(ODIR)/%.cpp;			$(CXXProfileToSuite) 
$(ODIR)/%.cpp:	$(ODIR)/%.pdb $(THISDIR)/%.cpp; $(CXXInstrumentToSuite) 
$(ODIR)/%.pdb:  $(THISDIR)/%.cpp; 		$(CXXToPDB)

$(ODIR)/%.o:	$(ODIR)/%.C;			$(CXXProfileToSuite) 
$(ODIR)/%.C:	$(ODIR)/%.pdb $(THISDIR)/%.C; 	$(CXXInstrumentToSuite) 
$(ODIR)/%.pdb:  $(THISDIR)/%.C; 		$(CXXToPDB)
else
$(ODIR)/%.o:	$(THISDIR)/%.cpp;		$(CXXToSuite) 
$(ODIR)/%.o:	$(THISDIR)/%.C;			$(CXXToSuite)
endif

$(ODIR)/%.e:	$(THISDIR)/%.c;			$(PreprocessToSuite)
$(ODIR)/%.e:	$(THISDIR)/%.cc;		$(PreprocessToSuite)
$(ODIR)/%.e:	$(THISDIR)/%.cpp;		$(PreprocessToSuite)
$(ODIR)/%.e:	$(THISDIR)/%.C;			$(PreprocessToSuite)

#$(ODIR)/%.o:	$(THISDIR)/%.c;			$(CCToSuite)

$(ODIR)/%.o:	$(THISDIR)/%.F;			$(F77ToSuite)
$(ODIR)/%.o:	$(THISDIR)/%.f;			$(F77ToSuite)
$(ODIR)/%.o:	$(ODIR)/%.f;			$(F77ToSuite)

$(ODIR)/%.a:	$(LOCAL_OBJS);			$(ArchiveToSuite)
$(ODIR)/%.so:	$(LOCAL_OBJS);			$(ArchiveToSuite)

#$(ODIR)/%.f:	$(PF_OUT)/%.f;			$(CPToSuite)
#$(PF_OUT)/%.f:	$(THISDIR)/%.g ajax;		$(AjaxToPF_out)
#%.o:		%.f;				$(FCToSuite)\; @$(ProblemEcho)


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: compilerules.mk,v $   $Author: bfh $
#  $Revision: 1.6 $   $Date: 1999/02/26 01:23:44 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
