// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// macro POOMA_PURIFY_CONSTRUCTORS()
//-----------------------------------------------------------------------------

#ifndef POOMA_UTILITIES_PURIFYCONSTRUCTORS_H
#define POOMA_UTILITIES_PURIFYCONSTRUCTORS_H

#include "Pooma/Configuration.h"

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
//
// POOMA_PURIFY_CONSTRUCTORS:
//
// POOMA_PURIFY_CONSTRUCTORS is a macro that can be used to generate an empty
// constructor, copy constructor and destructor for tag classes.  Because
// empty classes need to be implemented with some storage, copying empty
// classes can lead to accessing uninitialized memory, which leads purify
// to report errors.
//
// This macro generates no code if POOMA_PURIFY is not enabled, since some
// compilers (egcs) can generate more optimized code if the compiler generates
// the default constructors.
//
//-----------------------------------------------------------------------------

#if POOMA_PURIFY

#define POOMA_PURIFY_CONSTRUCTORS(CLASS)  \
  CLASS() { }   \
  ~CLASS() { }   \
  CLASS(const CLASS &) { }

#else

#define POOMA_PURIFY_CONSTRUCTORS(CLASS)

#endif

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_UTILITIES_PURIFYCONSTRUCTORS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: PurifyConstructors.h,v $   $Author: sa_smith $
// $Revision: 1.4 $   $Date: 2000/05/26 00:28:29 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
