// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// RemoteReader<T>
// TagGenerator
// OutstandingMessages
//-----------------------------------------------------------------------------

#ifndef POOMA_CHEETAH_MESSAGING_H
#define POOMA_CHEETAH_MESSAGING_H

//-----------------------------------------------------------------------------
// Overview: 
//
// Functions and classes needed to support interaction with the cheetah
// messaging library.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"

#if POOMA_CHEETAH
# include "Cheetah/Cheetah.h"
#endif

#include <vector>

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// TagGenerator
//
// There exist situations where pooma needs to generate identifying tags for
// data being transferred from one context to another.
// In order to generate the correct data-flow, pooma needs to manage a set of
// tags that identify bricks being transferred from context to context.
//
//-----------------------------------------------------------------------------

class TagGenerator
{
public:

  TagGenerator()
    : send_m(1), receive_m(1)
  {
    send_m[0]    = 0;
    receive_m[0] = 0;
  }

  TagGenerator(int n)
    : send_m(n), receive_m(n)
  {
    int i;
    for (i = 0; i < n; ++i)
      {
        send_m[i]    = 0;
        receive_m[i] = 0;
      }
  }

  int send(int otherContext)
  {
    int tag = send_m[otherContext];
    send_m[otherContext]++;
    return tag;
  }

  int receive(int otherContext)
  {
    int tag = receive_m[otherContext];
    receive_m[otherContext]++;
    return tag;
  }

private:

  std::vector<int> send_m;
  std::vector<int> receive_m;
};

namespace Pooma {

extern int expectedMessages_g;

#if POOMA_CHEETAH

extern Cheetah::MatchingHandler *indexHandler_g;
extern Cheetah::MatchingHandler *reductionHandler_g;
extern Cheetah::MatchingHandler *remoteEngineHandler_g;
extern Cheetah::MatchingHandler *particleSwapHandler_g;


inline Cheetah::MatchingHandler *indexHandler()
{
  return indexHandler_g;
}

inline Cheetah::MatchingHandler *reductionHandler()
{
  return reductionHandler_g;
}

inline Cheetah::MatchingHandler *remoteEngineHandler()
{
  return remoteEngineHandler_g;
}

inline Cheetah::MatchingHandler *particleSwapHandler()
{
  return particleSwapHandler_g;
}
#endif

void initializeCheetahHelpers(int contexts);
void finalizeCheetahHelpers();

int sendTag(int context);

int receiveTag(int context);

inline void addIncomingMessage()
{
  expectedMessages_g++;
}

inline void gotIncomingMessage()
{
  expectedMessages_g--;
}

inline bool incomingMessages()
{
  return (expectedMessages_g > 0);
}

}

#endif     // POOMA_CHEETAH_MESSAGING_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Messaging.h,v $   $Author: rasmussn $
// $Revision: 1.4 $   $Date: 2000/05/03 19:01:43 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
