// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_POOMA_PROFILE_H
#define POOMA_POOMA_PROFILE_H

//-----------------------------------------------------------------------------
// TAU Profiling. In the absence of profiling or tracing, don't include TAU 
// headers.  Otherwise, include the standard TAU profiling header.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Overview
//   Wrapper around the decision on whether to include the full Tau profiling
// headers, or just define empty macros.  This will include the full Tau
// files if POOMA_PROFILE or POOMA_TRACE are set to non-zero values.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Pooma/Configuration.h"


#if POOMA_PROFILE || POOMA_TRACE

// if we're using profiling, include the standard Tau header
# include "Profile/Profiler.h"

#else 

// In the absence of profiling, define the macros as null
# define TYPE_STRING(profileString, str)
# define PROFILED_BLOCK(name, type)

# define TAU_TYPE_STRING(profileString, str)
# define TAU_PROFILE(name, type, group)
# define TAU_PROFILE_TIMER(var, name, type, group)
# define TAU_PROFILE_START(var)
# define TAU_PROFILE_STOP(var)
# define TAU_PROFILE_STMT(stmt)
# define TAU_PROFILE_EXIT(msg)
# define TAU_PROFILE_INIT(argc, argv)
# define TAU_PROFILE_SET_NODE(node)
# define TAU_PROFILE_SET_CONTEXT(context)
# define TAU_PROFILE_CALLSTACK()

# define TAU_REGISTER_EVENT(event, name)
# define TAU_EVENT(event, data)
# define TAU_EVENT_DISABLE_MIN(event)
# define TAU_EVENT_DISABLE_MAX(event)
# define TAU_EVENT_DISABLE_MEAN(event)
# define TAU_EVENT_DISABLE_STDDEV(event)
# define TAU_STORE_ALL_EVENTS
# define TAU_REPORT_STATISTICS()
# define TAU_REPORT_THREAD_STATISTICS()
# define TAU_REGISTER_THREAD()

# define CT(obj)

# define TAU_TRACE_SENDMSG(type, destination, length)
# define TAU_TRACE_RECVMSG(type, source, length)

#endif // POOMA_PROFILE || POOMA_TRACE


#endif // POOMA_UTILITIES_POOMAPROFILE_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Profile.h,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:18:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
