// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// AssertEquals
//-----------------------------------------------------------------------------

#ifndef POOMA_PETE_ASSERTEQUALS_H
#define POOMA_PETE_ASSERTEQUALS_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "PETE/PETE.h"
#include "Utilities/PAssert.h"

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
// AssertEquals is a handy class for asserting conformance of an integer value
// in expressions.  An example is the numPatches function that arrays have.
// For the patch function to make sense on an array containing an expression,
// all the arrays in the expression must have the same number of patches.
// Scalars have zero patches, but we wish to ignore them, so AssertEquals
// allows you to set an integer value that you wish to ignore.
//
//-----------------------------------------------------------------------------

struct AssertEquals
{
  AssertEquals(int ignore = 0) : ignore_m(ignore) { }
  int ignore_m;
};

template<class Op>
struct Combine2<int, int, Op, AssertEquals>
{
  typedef int Type_t;
  inline static
  Type_t combine(const int &a, const int &b,
		 const Op &, const AssertEquals &ae)
  {
    int ret = a;
    if ((a != ae.ignore_m) && (b != ae.ignore_m))
    {
      PAssert(a == b);
    }
    else
    {
      if (b != ae.ignore_m) return ret = b;
    }
    return ret;
  }
};

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_PETE_ASSERTEQUALS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: AssertEquals.h,v $   $Author: swhaney $
// $Revision: 1.2 $   $Date: 2000/03/07 13:18:06 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
