// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Classes:
//   TouchesConstructNodePtr
//   TouchesConstructNodeObj
//   TouchesConstructINode
//
// Functions:
//   touchesConstruct
//-----------------------------------------------------------------------------

#ifndef POOMA_LAYOUT_TOUCHESCONSTRUCT_H
#define POOMA_LAYOUT_TOUCHESCONSTRUCT_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//
// touchesConstruct is a factory method that is used to build Nodes and INodes
// by various layout touches methods.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Utilities/Unique.h"
#include "Layout/Node.h"
#include "Layout/GlobalIDDataBase.h"

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
// TouchesConstructNodePtr, TouchesConstructNodeObj, and
// TouchesConstructINode
//   - tags for selecting specializations of...
//
// touchesConstruct
//   - overloaded factory method. Uses above tags to select version.
//     The appropriate version returns the object named in the tag.
//
//-----------------------------------------------------------------------------

struct TouchesConstructNodePtr {
  TouchesConstructNodePtr(){};
  ~TouchesConstructNodePtr(){};
};
struct TouchesConstructNodeObj {
  TouchesConstructNodeObj(){};
  ~TouchesConstructNodeObj(){};
};

// Build Node and return pointer; caller is responsible for deleting

template<class Domain>
inline Node<Domain> *
touchesConstruct(const Domain &owned, 
		 int affinity, int c, int gid, int lid,
		 const TouchesConstructNodePtr &)
{
  return new Node<Domain>(affinity, owned, c, gid, lid);
}

template<class Domain, class AllocatedDomain>
inline Node<Domain,AllocatedDomain> *
touchesConstruct(const Domain &owned, const AllocatedDomain &allocated,
		 int affinity, int c, int gid, int lid,
		 const TouchesConstructNodePtr &)
{
  return new Node<Domain,AllocatedDomain>
             (affinity, owned, allocated, c, gid, lid);
}

// Build Node object

template<class Domain>
inline Node<Domain>
touchesConstruct(const Domain &owned, 
		 int affinity, int c, int gid, int lid, 
		  const TouchesConstructNodeObj &)
{
  return Node<Domain>(affinity, owned, c, gid, lid);
}

template<class Domain, class AllocatedDomain>
inline Node<Domain,AllocatedDomain>
touchesConstruct(const Domain &owned, const AllocatedDomain &allocated,
		 int affinity, int c, int gid, int lid, 
		 const TouchesConstructNodeObj &)
{
  return Node<Domain,AllocatedDomain>(affinity, owned, allocated, c, gid, lid);
}

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_LAYOUT_TOUCHESCONSTRUCT_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: TouchesConstruct.h,v $   $Author: sa_smith $
// $Revision: 1.8 $   $Date: 2000/03/16 23:13:41 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
