// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Classes:
//   Grad
// Global Function Templates:
//   grad
//-----------------------------------------------------------------------------

#ifndef POOMA_FIELD_DIFFOPS_GRAD_H
#define POOMA_FIELD_DIFFOPS_GRAD_H

//-----------------------------------------------------------------------------
// Overview: 
//
// Classes:
//
// Grad	:  Gradient operator (functor) on discrete Fields.
//
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// 
// Global Function Templates:
// 
// div()   :  Wrapper function around FieldStencil<Grad>::operator() . The Grad
//            functors actually used are partial specializations of the generic
//            Div that come from Grad.URM.h or Grad.RM.h, for example.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Field/Field.h"
#include "Field/FieldStencil.h"

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
// 
// Classes:
//
// Grad:
// 
// Grad is a functor class serving as the "Functor" template parameter for
// FieldStencil<Functor,Expression>, which implements discrete 
// gradient operator.
// Partial specializations implement various combinations of input and output
// centerings, for specific coordinate systems, and different finite-differenc
// orders, are defined in other headers like Grad.[URM,RM].h .
// 
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// 
// Global Function Templates:
// 
// grad() : Gradient. Takes a ConstField of scalars (or Vectors) on a 
//          discrete geometry with one centering and returns a ConstField of
//          Vectors (or Tensors) on a geometry that's the same except
//          (possibly) for the centering. All the work happens in the embedded
//          Grad functor partial specialization, in its operator() methods.
//-----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// General Grad template
// ----------------------------------------------------------------------------

template<class OutputCentering, class Geometry, class T>
class Grad { };


// ----------------------------------------------------------------------------
// 
// Global Function Templates:
//
// ----------------------------------------------------------------------------

// Gradient.

template<class OutputCentering, class Geometry, class T, class EngineTag>
typename 
  View1<FieldStencil<Grad<OutputCentering, Geometry, T> >, 
    ConstField<Geometry, T, EngineTag> >::Type_t 
grad(const ConstField<Geometry, T, EngineTag> &f)
{
  typedef FieldStencil<Grad<OutputCentering, Geometry, T> > Functor_t;
  typedef ConstField<Geometry, T, EngineTag> Expression_t;
  typedef View1<Functor_t, Expression_t> Ret_t;
  return Ret_t::make(Functor_t(), f);
}

#endif     // POOMA_FIELD_DIFFOPS_GRAD_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Grad.h,v $   $Author: swhaney $
// $Revision: 1.6 $   $Date: 2000/03/07 13:17:11 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
