// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Array test 28: remote assignment.
//-----------------------------------------------------------------------------

// Bring in Pooma array machinery.

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Loc.h"
#include "Domain/Interval.h"
#include "Partition/UniformGridPartition.h"
#include "Layout/UniformGridLayout.h"
#include "Engine/BrickEngine.h"
#include "Engine/CompressibleBrick.h"
#include "Engine/MultiPatchEngine.h"
#include "Engine/RemoteEngine.h"
#include "Array/Array.h"
#include "Array/Reductions.h"
#include "Tiny/Vector.h"

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

#if POOMA_CHEETAH

  Interval<3> I3(6,6,6);
  Array<3> a0(I3), b0(I3);
  Array<3, double, Remote<CompressibleBrick> > a1(I3), b1(I3);
  
  Loc<3> blocks(1,1,2);
  UniformGridPartition<3> partition(blocks);   
  UniformGridLayout<3> layout(I3, partition, DistributedTag());
  
  Array<3, double, MultiPatch<UniformTag,Remote<Brick> > > 
    a2(layout), b2(layout);
  Array<3, double, MultiPatch<UniformTag,Remote<CompressibleBrick> > > 
    a3(layout), b3(layout);

  b0 = 0.0;
  b1 = 1.0;
  b2 = 2.0;
  b3 = 3.0;
  
  a0 = b0; tester.check(all(a0 == 0.0));
  a1 = b1; tester.check(all(a1 == 1.0));
  a2 = b2; tester.check(all(a2 == 2.0));
  a3 = b3; tester.check(all(a3 == 3.0));

  a0 = b1; tester.check(all(a0 == 1.0));
  a1 = b2; tester.check(all(a1 == 2.0));
  a2 = b3; tester.check(all(a2 == 3.0));
  a3 = b0; tester.check(all(a3 == 0.0));

  a0 = b2; tester.check(all(a0 == 2.0));
  a1 = b3; tester.check(all(a1 == 3.0));
  a2 = b0; tester.check(all(a2 == 0.0));
  a3 = b1; tester.check(all(a3 == 1.0));

  a0 = b3; tester.check(all(a0 == 3.0));
  a1 = b0; tester.check(all(a1 == 0.0));
  a2 = b1; tester.check(all(a2 == 1.0));
  a3 = b2; tester.check(all(a3 == 2.0));

  Array<3, Vector<2, double>, Remote<Brick> > a4(I3);

  a4 = Vector<2, double>(1.0, 2.0);

  tester.check(all(a4.comp(1) == 2.0));

#endif // POOMA_CHEETAH

  int ret = tester.results( "array_test28" );
  Pooma::finalize();
  return ret; 
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test28.cpp,v $   $Author: sa_smith $
// $Revision: 1.2 $   $Date: 2000/06/20 04:45:43 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
