#!/usr/bin/env perl 
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license

# Script to display compile times and object and executable file sizes.
# laa, 1997

$DEBUG = 0;

$VERSION  = "19-November-1997";
$VERSION  = "05-January-1998";
$VERSION  = "12-February-1998";
$top      = $ARGV[0];

$totalWall = 0;
$totalReal = 0;
$totalUser = 0;
$totalSys = 0;

print sprintf "%10s  %7s  %7s  %7s  %7s  %20s  %10s  %s\n", "Bytes", "wall", "real", "user", "sys", "SUITE", "PASS", "Filename";

# It shouldn't be necessary to chdir, but if $top is a symbolic link
# find seems to work better.
chdir $top;
$command = qq(find . -name "*.info");
@filelist = `$command`;

foreach $infofile (@filelist) {
	# .o objectfiles
	if    ($infofile =~ /(\S+\.o)_(\S+)\.info/)   { 
		$objectfile     = $1;
		$pass           = $2;
		$size           = filesize ($objectfile);

	}
	# executables
	elsif    ($infofile =~ /(\S+)_(\S+)\.info/)   { 
		$objectfile     = $1;
		$pass           = $2;
	$objectcopy     = "$1_$2";
		$size           = filesize ($objectcopy);
	}
	($wall, $real, $user, $sys) = &elapsedtime ($infofile);
	($suite,$ofile) = $objectfile =~ /^.*\/(\S+)\/(\S*$)/;
	$objectfile     =~ s/$top\///;
	print sprintf "%10d  %7s  %7s  %7s  %7s  %20s  %10s  %s\n", $size, $wall, $real, $user, $sys, $suite, $pass, $ofile;
       $totalWall += $wall; $totalReal += $real; $totalUser += $user; $totalSys += $sys;
#exit if ($DEBUG);
}
print sprintf "%10s  %7s  %7s  %7s  %7s  %20s  %10s  %s\n", "", "----", "----", "----", "----", "", "", "";
print sprintf "%10s  %7s  %7s  %7s  %7s  %20s  %10s  %s\n", "", $totalWall, $totalReal, $totalUser, $totalSys, "", "", "";

################################################################################
sub filesize {
	my ($filename) = @_;
	my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat $filename;
	$size;
}

################################################################################
sub elapsedtime {
	my ($infofile) = @_;
	my  ($wall, $real, $user, $sys) = ("?", "?", "?", "?");

	open (F, "<$infofile") or die "Can't open $infofile for reading";
	$t1 = <F>;
	while ( <F> ) {
		$t2 = $_;
		if ($_ =~ /^real +(\d*:*\d*\.\d+)$/) { $real = $1 };
		if ($_ =~ /^user +(\d*:*\d*\.\d+)$/) { $user = $1 };
		if ($_ =~ /^sys +(\d*:*\d*\.\d+)$/) { $sys = $1 };
	}
	close (F);

	$t1 =~ s/:0/: /g;
	$t2 =~ s/:0/: /g;
	($dow1,$mon1,$day1,$hour1,$min1,$sec1,$tz1,$year1) = split(/[ :]+/, $t1);
	($dow2,$mon2,$day2,$hour2,$min2,$sec2,$tz2,$year2) = split(/[ :]+/, $t2);
	$seconds1 = ($hour1 * 3600) + ($min1 * 60) + $sec1;
	$seconds2 = ($hour2 * 3600) + ($min2 * 60) + $sec2;
	$wall  =  $seconds2 - $seconds1;
	$wall  = "?" unless ($t1 =~ /^[A-z]{1,3} +[A-z]{1,3} +[ \d]{1,2} +[ \d]{1,2}:[ \d]{1,2}:[ \d]{1,2}/);
	$wall  = "?" unless ($t2 =~ /^[A-z]{1,3} +[A-z]{1,3} +[ \d]{1,2} +[ \d]{1,2}:[ \d]{1,2}:[ \d]{1,2}/);
	my @array = ($wall, $real, $user, $sys);
}

# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: showtimes.pl,v $   $Author: julianc $
#  $Revision: 1.7 $   $Date: 1999/07/21 22:19:35 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
