#! /bin/sh
# Copyright (C) 2013
# Copyright (C) H.J. Lu <hjl.tools@gmail.com>, 2015.
# This file is part of elfutils.
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# elfutils is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. $srcdir/test-subr.sh

# Note some testfiles are also used in run-allregs.sh.

# Shows return address, CFA location expression and register rules
# from ABI's default CFI program as setup by arch ebl backend hook
# abi_cfi unless overridden by CIE and FDE program at given address.

# EM_386 (function main 0x080489b8)
testfiles testfile11
testrun_compare ${abs_builddir}/addrcfi -e testfile11 0x080489b8 <<\EOF
.eh_frame has 0x80489b8 => [0x80489b8, 0x80489b9):
	return address in reg8
	CFA location expression: bregx(4,4)
	integer reg0 (%eax): undefined
	integer reg1 (%ecx): undefined
	integer reg2 (%edx): undefined
	integer reg3 (%ebx): same_value
	integer reg4 (%esp): location expression: call_frame_cfa stack_value
	integer reg5 (%ebp): same_value
	integer reg6 (%esi): same_value
	integer reg7 (%edi): same_value
	integer reg8 (%eip): location expression: call_frame_cfa plus_uconst(-4)
	integer reg9 (%eflags): undefined
	integer reg10 (%trapno): undefined
	x87 reg11 (%st0): undefined
	x87 reg12 (%st1): undefined
	x87 reg13 (%st2): undefined
	x87 reg14 (%st3): undefined
	x87 reg15 (%st4): undefined
	x87 reg16 (%st5): undefined
	x87 reg17 (%st6): undefined
	x87 reg18 (%st7): undefined
	SSE reg21 (%xmm0): undefined
	SSE reg22 (%xmm1): undefined
	SSE reg23 (%xmm2): undefined
	SSE reg24 (%xmm3): undefined
	SSE reg25 (%xmm4): undefined
	SSE reg26 (%xmm5): undefined
	SSE reg27 (%xmm6): undefined
	SSE reg28 (%xmm7): undefined
	MMX reg29 (%mm0): undefined
	MMX reg30 (%mm1): undefined
	MMX reg31 (%mm2): undefined
	MMX reg32 (%mm3): undefined
	MMX reg33 (%mm4): undefined
	MMX reg34 (%mm5): undefined
	MMX reg35 (%mm6): undefined
	MMX reg36 (%mm7): undefined
	FPU-control reg37 (%fctrl): undefined
	FPU-control reg38 (%fstat): undefined
	FPU-control reg39 (%mxcsr): undefined
	segment reg40 (%es): same_value
	segment reg41 (%cs): same_value
	segment reg42 (%ss): same_value
	segment reg43 (%ds): same_value
	segment reg44 (%fs): same_value
	segment reg45 (%gs): same_value
.debug_frame has 0x80489b8 => [0x80489b8, 0x80489b9):
	return address in reg8
	CFA location expression: bregx(4,4)
	integer reg0 (%eax): undefined
	integer reg1 (%ecx): undefined
	integer reg2 (%edx): undefined
	integer reg3 (%ebx): same_value
	integer reg4 (%esp): location expression: call_frame_cfa stack_value
	integer reg5 (%ebp): same_value
	integer reg6 (%esi): same_value
	integer reg7 (%edi): same_value
	integer reg8 (%eip): location expression: call_frame_cfa plus_uconst(-4)
	integer reg9 (%eflags): undefined
	integer reg10 (%trapno): undefined
	x87 reg11 (%st0): undefined
	x87 reg12 (%st1): undefined
	x87 reg13 (%st2): undefined
	x87 reg14 (%st3): undefined
	x87 reg15 (%st4): undefined
	x87 reg16 (%st5): undefined
	x87 reg17 (%st6): undefined
	x87 reg18 (%st7): undefined
	SSE reg21 (%xmm0): undefined
	SSE reg22 (%xmm1): undefined
	SSE reg23 (%xmm2): undefined
	SSE reg24 (%xmm3): undefined
	SSE reg25 (%xmm4): undefined
	SSE reg26 (%xmm5): undefined
	SSE reg27 (%xmm6): undefined
	SSE reg28 (%xmm7): undefined
	MMX reg29 (%mm0): undefined
	MMX reg30 (%mm1): undefined
	MMX reg31 (%mm2): undefined
	MMX reg32 (%mm3): undefined
	MMX reg33 (%mm4): undefined
	MMX reg34 (%mm5): undefined
	MMX reg35 (%mm6): undefined
	MMX reg36 (%mm7): undefined
	FPU-control reg37 (%fctrl): undefined
	FPU-control reg38 (%fstat): undefined
	FPU-control reg39 (%mxcsr): undefined
	segment reg40 (%es): same_value
	segment reg41 (%cs): same_value
	segment reg42 (%ss): same_value
	segment reg43 (%ds): same_value
	segment reg44 (%fs): same_value
	segment reg45 (%gs): same_value
EOF

# EM_X86_64 (function foo 0x00000000000009d0)
testfiles testfile12
testrun_compare ${abs_builddir}/addrcfi -e testfile12 0x00000000000009d0 <<\EOF
.eh_frame has 0x9d0 => [0x9d0, 0x9d1):
	return address in reg16
	CFA location expression: bregx(7,8)
	integer reg0 (%rax): same_value
	integer reg1 (%rdx): undefined
	integer reg2 (%rcx): undefined
	integer reg3 (%rbx): undefined
	integer reg4 (%rsi): undefined
	integer reg5 (%rdi): undefined
	integer reg6 (%rbp): same_value
	integer reg7 (%rsp): location expression: call_frame_cfa stack_value
	integer reg8 (%r8): undefined
	integer reg9 (%r9): undefined
	integer reg10 (%r10): undefined
	integer reg11 (%r11): undefined
	integer reg12 (%r12): same_value
	integer reg13 (%r13): same_value
	integer reg14 (%r14): same_value
	integer reg15 (%r15): same_value
	integer reg16 (%rip): location expression: call_frame_cfa plus_uconst(-8)
	SSE reg17 (%xmm0): undefined
	SSE reg18 (%xmm1): undefined
	SSE reg19 (%xmm2): undefined
	SSE reg20 (%xmm3): undefined
	SSE reg21 (%xmm4): undefined
	SSE reg22 (%xmm5): undefined
	SSE reg23 (%xmm6): undefined
	SSE reg24 (%xmm7): undefined
	SSE reg25 (%xmm8): undefined
	SSE reg26 (%xmm9): undefined
	SSE reg27 (%xmm10): undefined
	SSE reg28 (%xmm11): undefined
	SSE reg29 (%xmm12): undefined
	SSE reg30 (%xmm13): undefined
	SSE reg31 (%xmm14): undefined
	SSE reg32 (%xmm15): undefined
	x87 reg33 (%st0): undefined
	x87 reg34 (%st1): undefined
	x87 reg35 (%st2): undefined
	x87 reg36 (%st3): undefined
	x87 reg37 (%st4): undefined
	x87 reg38 (%st5): undefined
	x87 reg39 (%st6): undefined
	x87 reg40 (%st7): undefined
	MMX reg41 (%mm0): undefined
	MMX reg42 (%mm1): undefined
	MMX reg43 (%mm2): undefined
	MMX reg44 (%mm3): undefined
	MMX reg45 (%mm4): undefined
	MMX reg46 (%mm5): undefined
	MMX reg47 (%mm6): undefined
	MMX reg48 (%mm7): undefined
	integer reg49 (%rflags): undefined
	segment reg50 (%es): undefined
	segment reg51 (%cs): undefined
	segment reg52 (%ss): undefined
	segment reg53 (%ds): undefined
	segment reg54 (%fs): undefined
	segment reg55 (%gs): undefined
	segment reg58 (%fs.base): undefined
	segment reg59 (%gs.base): undefined
	control reg62 (%tr): undefined
	control reg63 (%ldtr): undefined
	control reg64 (%mxcsr): undefined
	control reg65 (%fcw): undefined
	control reg66 (%fsw): undefined
.debug_frame has 0x9d0 => [0x9d0, 0x9d1):
	return address in reg16
	CFA location expression: bregx(7,8)
	integer reg0 (%rax): same_value
	integer reg1 (%rdx): undefined
	integer reg2 (%rcx): undefined
	integer reg3 (%rbx): undefined
	integer reg4 (%rsi): undefined
	integer reg5 (%rdi): undefined
	integer reg6 (%rbp): same_value
	integer reg7 (%rsp): location expression: call_frame_cfa stack_value
	integer reg8 (%r8): undefined
	integer reg9 (%r9): undefined
	integer reg10 (%r10): undefined
	integer reg11 (%r11): undefined
	integer reg12 (%r12): same_value
	integer reg13 (%r13): same_value
	integer reg14 (%r14): same_value
	integer reg15 (%r15): same_value
	integer reg16 (%rip): location expression: call_frame_cfa plus_uconst(-8)
	SSE reg17 (%xmm0): undefined
	SSE reg18 (%xmm1): undefined
	SSE reg19 (%xmm2): undefined
	SSE reg20 (%xmm3): undefined
	SSE reg21 (%xmm4): undefined
	SSE reg22 (%xmm5): undefined
	SSE reg23 (%xmm6): undefined
	SSE reg24 (%xmm7): undefined
	SSE reg25 (%xmm8): undefined
	SSE reg26 (%xmm9): undefined
	SSE reg27 (%xmm10): undefined
	SSE reg28 (%xmm11): undefined
	SSE reg29 (%xmm12): undefined
	SSE reg30 (%xmm13): undefined
	SSE reg31 (%xmm14): undefined
	SSE reg32 (%xmm15): undefined
	x87 reg33 (%st0): undefined
	x87 reg34 (%st1): undefined
	x87 reg35 (%st2): undefined
	x87 reg36 (%st3): undefined
	x87 reg37 (%st4): undefined
	x87 reg38 (%st5): undefined
	x87 reg39 (%st6): undefined
	x87 reg40 (%st7): undefined
	MMX reg41 (%mm0): undefined
	MMX reg42 (%mm1): undefined
	MMX reg43 (%mm2): undefined
	MMX reg44 (%mm3): undefined
	MMX reg45 (%mm4): undefined
	MMX reg46 (%mm5): undefined
	MMX reg47 (%mm6): undefined
	MMX reg48 (%mm7): undefined
	integer reg49 (%rflags): undefined
	segment reg50 (%es): undefined
	segment reg51 (%cs): undefined
	segment reg52 (%ss): undefined
	segment reg53 (%ds): undefined
	segment reg54 (%fs): undefined
	segment reg55 (%gs): undefined
	segment reg58 (%fs.base): undefined
	segment reg59 (%gs.base): undefined
	control reg62 (%tr): undefined
	control reg63 (%ldtr): undefined
	control reg64 (%mxcsr): undefined
	control reg65 (%fcw): undefined
	control reg66 (%fsw): undefined
EOF

# EM_PPC (function bar 0x100004c0)
# Note. First only in .debug_frame, second only in .eh_frame.
#
# = bar.c =
#
# static int b1 = 1;
# int b2 = 1;
#
# static int
# foo (int a)
# {
#   return a + b2;
# }
#
# int bar (int b)
# {
#   return b - foo (b - b1);
# }
#
# = foo.c =
#
# extern int bar (int b);
# extern int b2;
#
# int
# main (int argc, char ** argv)
# {
#   return bar (argc + b2);
# }
#
# gcc -g -O2 -m32 -c foo.c
# gcc -g -O2 -m32 -c bar.c
# gcc -g -O2 m32 -o testfileppc32 foo.o bar.o
testfiles testfileppc32
testrun_compare ${abs_builddir}/addrcfi -e testfileppc32 0x100004c0 <<\EOF
dwarf_cfi_addrframe (.eh_frame): no matching address range
.debug_frame has 0x100004c0 => [0x100004c0, 0x100004d0):
	return address in reg65
	CFA location expression: bregx(1)
	integer reg0 (r0): undefined
	integer reg1 (r1): location expression: call_frame_cfa stack_value
	integer reg2 (r2): same_value
	integer reg3 (r3): undefined
	integer reg4 (r4): undefined
	integer reg5 (r5): undefined
	integer reg6 (r6): undefined
	integer reg7 (r7): undefined
	integer reg8 (r8): undefined
	integer reg9 (r9): undefined
	integer reg10 (r10): undefined
	integer reg11 (r11): undefined
	integer reg12 (r12): undefined
	integer reg13 (r13): same_value
	integer reg14 (r14): same_value
	integer reg15 (r15): same_value
	integer reg16 (r16): same_value
	integer reg17 (r17): same_value
	integer reg18 (r18): same_value
	integer reg19 (r19): same_value
	integer reg20 (r20): same_value
	integer reg21 (r21): same_value
	integer reg22 (r22): same_value
	integer reg23 (r23): same_value
	integer reg24 (r24): same_value
	integer reg25 (r25): same_value
	integer reg26 (r26): same_value
	integer reg27 (r27): same_value
	integer reg28 (r28): same_value
	integer reg29 (r29): same_value
	integer reg30 (r30): same_value
	integer reg31 (r31): same_value
	FPU reg32 (f0): undefined
	FPU reg33 (f1): undefined
	FPU reg34 (f2): undefined
	FPU reg35 (f3): undefined
	FPU reg36 (f4): undefined
	FPU reg37 (f5): undefined
	FPU reg38 (f6): undefined
	FPU reg39 (f7): undefined
	FPU reg40 (f8): undefined
	FPU reg41 (f9): undefined
	FPU reg42 (f10): undefined
	FPU reg43 (f11): undefined
	FPU reg44 (f12): undefined
	FPU reg45 (f13): undefined
	FPU reg46 (f14): undefined
	FPU reg47 (f15): undefined
	FPU reg48 (f16): undefined
	FPU reg49 (f17): undefined
	FPU reg50 (f18): undefined
	FPU reg51 (f19): undefined
	FPU reg52 (f20): undefined
	FPU reg53 (f21): undefined
	FPU reg54 (f22): undefined
	FPU reg55 (f23): undefined
	FPU reg56 (f24): undefined
	FPU reg57 (f25): undefined
	FPU reg58 (f26): undefined
	FPU reg59 (f27): undefined
	FPU reg60 (f28): undefined
	FPU reg61 (f29): undefined
	FPU reg62 (f30): undefined
	FPU reg63 (f31): undefined
	integer reg64 (cr): undefined
	FPU reg65 (fpscr): same_value
	integer reg66 (msr): undefined
	vector reg67 (vscr): undefined
	privileged reg70 (sr0): undefined
	privileged reg71 (sr1): undefined
	privileged reg72 (sr2): undefined
	privileged reg73 (sr3): undefined
	privileged reg74 (sr4): undefined
	privileged reg75 (sr5): undefined
	privileged reg76 (sr6): undefined
	privileged reg77 (sr7): undefined
	privileged reg78 (sr8): undefined
	privileged reg79 (sr9): undefined
	privileged reg80 (sr10): undefined
	privileged reg81 (sr11): undefined
	privileged reg82 (sr12): undefined
	privileged reg83 (sr13): undefined
	privileged reg84 (sr14): undefined
	privileged reg85 (sr15): undefined
	privileged reg100 (mq): undefined
	privileged reg101 (xer): undefined
	privileged reg102 (spr2): undefined
	privileged reg103 (spr3): undefined
	privileged reg104 (spr4): undefined
	privileged reg105 (spr5): undefined
	privileged reg106 (spr6): undefined
	privileged reg107 (spr7): undefined
	privileged reg108 (lr): undefined
	privileged reg109 (ctr): undefined
	privileged reg110 (spr10): undefined
	privileged reg111 (spr11): undefined
	privileged reg112 (spr12): undefined
	privileged reg113 (spr13): undefined
	privileged reg114 (spr14): undefined
	privileged reg115 (spr15): undefined
	privileged reg116 (spr16): undefined
	privileged reg117 (spr17): undefined
	privileged reg118 (dsisr): undefined
	privileged reg119 (dar): undefined
	privileged reg120 (spr20): undefined
	privileged reg121 (spr21): undefined
	privileged reg122 (dec): undefined
	privileged reg123 (spr23): undefined
	privileged reg124 (spr24): undefined
	privileged reg125 (spr25): undefined
	privileged reg126 (spr26): undefined
	privileged reg127 (spr27): undefined
	privileged reg128 (spr28): undefined
	privileged reg129 (spr29): undefined
	privileged reg130 (spr30): undefined
	privileged reg131 (spr31): undefined
	privileged reg132 (spr32): undefined
	privileged reg133 (spr33): undefined
	privileged reg134 (spr34): undefined
	privileged reg135 (spr35): undefined
	privileged reg136 (spr36): undefined
	privileged reg137 (spr37): undefined
	privileged reg138 (spr38): undefined
	privileged reg139 (spr39): undefined
	privileged reg140 (spr40): undefined
	privileged reg141 (spr41): undefined
	privileged reg142 (spr42): undefined
	privileged reg143 (spr43): undefined
	privileged reg144 (spr44): undefined
	privileged reg145 (spr45): undefined
	privileged reg146 (spr46): undefined
	privileged reg147 (spr47): undefined
	privileged reg148 (spr48): undefined
	privileged reg149 (spr49): undefined
	privileged reg150 (spr50): undefined
	privileged reg151 (spr51): undefined
	privileged reg152 (spr52): undefined
	privileged reg153 (spr53): undefined
	privileged reg154 (spr54): undefined
	privileged reg155 (spr55): undefined
	privileged reg156 (spr56): undefined
	privileged reg157 (spr57): undefined
	privileged reg158 (spr58): undefined
	privileged reg159 (spr59): undefined
	privileged reg160 (spr60): undefined
	privileged reg161 (spr61): undefined
	privileged reg162 (spr62): undefined
	privileged reg163 (spr63): undefined
	privileged reg164 (spr64): undefined
	privileged reg165 (spr65): undefined
	privileged reg166 (spr66): undefined
	privileged reg167 (spr67): undefined
	privileged reg168 (spr68): undefined
	privileged reg169 (spr69): undefined
	privileged reg170 (spr70): undefined
	privileged reg171 (spr71): undefined
	privileged reg172 (spr72): undefined
	privileged reg173 (spr73): undefined
	privileged reg174 (spr74): undefined
	privileged reg175 (spr75): undefined
	privileged reg176 (spr76): undefined
	privileged reg177 (spr77): undefined
	privileged reg178 (spr78): undefined
	privileged reg179 (spr79): undefined
	privileged reg180 (spr80): undefined
	privileged reg181 (spr81): undefined
	privileged reg182 (spr82): undefined
	privileged reg183 (spr83): undefined
	privileged reg184 (spr84): undefined
	privileged reg185 (spr85): undefined
	privileged reg186 (spr86): undefined
	privileged reg187 (spr87): undefined
	privileged reg188 (spr88): undefined
	privileged reg189 (spr89): undefined
	privileged reg190 (spr90): undefined
	privileged reg191 (spr91): undefined
	privileged reg192 (spr92): undefined
	privileged reg193 (spr93): undefined
	privileged reg194 (spr94): undefined
	privileged reg195 (spr95): undefined
	privileged reg196 (spr96): undefined
	privileged reg197 (spr97): undefined
	privileged reg198 (spr98): undefined
	privileged reg199 (spr99): undefined
	privileged reg200 (spr100): undefined
	privileged reg201 (spr101): undefined
	privileged reg202 (spr102): undefined
	privileged reg203 (spr103): undefined
	privileged reg204 (spr104): undefined
	privileged reg205 (spr105): undefined
	privileged reg206 (spr106): undefined
	privileged reg207 (spr107): undefined
	privileged reg208 (spr108): undefined
	privileged reg209 (spr109): undefined
	privileged reg210 (spr110): undefined
	privileged reg211 (spr111): undefined
	privileged reg212 (spr112): undefined
	privileged reg213 (spr113): undefined
	privileged reg214 (spr114): undefined
	privileged reg215 (spr115): undefined
	privileged reg216 (spr116): undefined
	privileged reg217 (spr117): undefined
	privileged reg218 (spr118): undefined
	privileged reg219 (spr119): undefined
	privileged reg220 (spr120): undefined
	privileged reg221 (spr121): undefined
	privileged reg222 (spr122): undefined
	privileged reg223 (spr123): undefined
	privileged reg224 (spr124): undefined
	privileged reg225 (spr125): undefined
	privileged reg226 (spr126): undefined
	privileged reg227 (spr127): undefined
	privileged reg228 (spr128): undefined
	privileged reg229 (spr129): undefined
	privileged reg230 (spr130): undefined
	privileged reg231 (spr131): undefined
	privileged reg232 (spr132): undefined
	privileged reg233 (spr133): undefined
	privileged reg234 (spr134): undefined
	privileged reg235 (spr135): undefined
	privileged reg236 (spr136): undefined
	privileged reg237 (spr137): undefined
	privileged reg238 (spr138): undefined
	privileged reg239 (spr139): undefined
	privileged reg240 (spr140): undefined
	privileged reg241 (spr141): undefined
	privileged reg242 (spr142): undefined
	privileged reg243 (spr143): undefined
	privileged reg244 (spr144): undefined
	privileged reg245 (spr145): undefined
	privileged reg246 (spr146): undefined
	privileged reg247 (spr147): undefined
	privileged reg248 (spr148): undefined
	privileged reg249 (spr149): undefined
	privileged reg250 (spr150): undefined
	privileged reg251 (spr151): undefined
	privileged reg252 (spr152): undefined
	privileged reg253 (spr153): undefined
	privileged reg254 (spr154): undefined
	privileged reg255 (spr155): undefined
	privileged reg256 (spr156): undefined
	privileged reg257 (spr157): undefined
	privileged reg258 (spr158): undefined
	privileged reg259 (spr159): undefined
	privileged reg260 (spr160): undefined
	privileged reg261 (spr161): undefined
	privileged reg262 (spr162): undefined
	privileged reg263 (spr163): undefined
	privileged reg264 (spr164): undefined
	privileged reg265 (spr165): undefined
	privileged reg266 (spr166): undefined
	privileged reg267 (spr167): undefined
	privileged reg268 (spr168): undefined
	privileged reg269 (spr169): undefined
	privileged reg270 (spr170): undefined
	privileged reg271 (spr171): undefined
	privileged reg272 (spr172): undefined
	privileged reg273 (spr173): undefined
	privileged reg274 (spr174): undefined
	privileged reg275 (spr175): undefined
	privileged reg276 (spr176): undefined
	privileged reg277 (spr177): undefined
	privileged reg278 (spr178): undefined
	privileged reg279 (spr179): undefined
	privileged reg280 (spr180): undefined
	privileged reg281 (spr181): undefined
	privileged reg282 (spr182): undefined
	privileged reg283 (spr183): undefined
	privileged reg284 (spr184): undefined
	privileged reg285 (spr185): undefined
	privileged reg286 (spr186): undefined
	privileged reg287 (spr187): undefined
	privileged reg288 (spr188): undefined
	privileged reg289 (spr189): undefined
	privileged reg290 (spr190): undefined
	privileged reg291 (spr191): undefined
	privileged reg292 (spr192): undefined
	privileged reg293 (spr193): undefined
	privileged reg294 (spr194): undefined
	privileged reg295 (spr195): undefined
	privileged reg296 (spr196): undefined
	privileged reg297 (spr197): undefined
	privileged reg298 (spr198): undefined
	privileged reg299 (spr199): undefined
	privileged reg300 (spr200): undefined
	privileged reg301 (spr201): undefined
	privileged reg302 (spr202): undefined
	privileged reg303 (spr203): undefined
	privileged reg304 (spr204): undefined
	privileged reg305 (spr205): undefined
	privileged reg306 (spr206): undefined
	privileged reg307 (spr207): undefined
	privileged reg308 (spr208): undefined
	privileged reg309 (spr209): undefined
	privileged reg310 (spr210): undefined
	privileged reg311 (spr211): undefined
	privileged reg312 (spr212): undefined
	privileged reg313 (spr213): undefined
	privileged reg314 (spr214): undefined
	privileged reg315 (spr215): undefined
	privileged reg316 (spr216): undefined
	privileged reg317 (spr217): undefined
	privileged reg318 (spr218): undefined
	privileged reg319 (spr219): undefined
	privileged reg320 (spr220): undefined
	privileged reg321 (spr221): undefined
	privileged reg322 (spr222): undefined
	privileged reg323 (spr223): undefined
	privileged reg324 (spr224): undefined
	privileged reg325 (spr225): undefined
	privileged reg326 (spr226): undefined
	privileged reg327 (spr227): undefined
	privileged reg328 (spr228): undefined
	privileged reg329 (spr229): undefined
	privileged reg330 (spr230): undefined
	privileged reg331 (spr231): undefined
	privileged reg332 (spr232): undefined
	privileged reg333 (spr233): undefined
	privileged reg334 (spr234): undefined
	privileged reg335 (spr235): undefined
	privileged reg336 (spr236): undefined
	privileged reg337 (spr237): undefined
	privileged reg338 (spr238): undefined
	privileged reg339 (spr239): undefined
	privileged reg340 (spr240): undefined
	privileged reg341 (spr241): undefined
	privileged reg342 (spr242): undefined
	privileged reg343 (spr243): undefined
	privileged reg344 (spr244): undefined
	privileged reg345 (spr245): undefined
	privileged reg346 (spr246): undefined
	privileged reg347 (spr247): undefined
	privileged reg348 (spr248): undefined
	privileged reg349 (spr249): undefined
	privileged reg350 (spr250): undefined
	privileged reg351 (spr251): undefined
	privileged reg352 (spr252): undefined
	privileged reg353 (spr253): undefined
	privileged reg354 (spr254): undefined
	privileged reg355 (spr255): undefined
	vector reg356 (vrsave): undefined
	privileged reg357 (spr257): undefined
	privileged reg358 (spr258): undefined
	privileged reg359 (spr259): undefined
	privileged reg360 (spr260): undefined
	privileged reg361 (spr261): undefined
	privileged reg362 (spr262): undefined
	privileged reg363 (spr263): undefined
	privileged reg364 (spr264): undefined
	privileged reg365 (spr265): undefined
	privileged reg366 (spr266): undefined
	privileged reg367 (spr267): undefined
	privileged reg368 (spr268): undefined
	privileged reg369 (spr269): undefined
	privileged reg370 (spr270): undefined
	privileged reg371 (spr271): undefined
	privileged reg372 (spr272): undefined
	privileged reg373 (spr273): undefined
	privileged reg374 (spr274): undefined
	privileged reg375 (spr275): undefined
	privileged reg376 (spr276): undefined
	privileged reg377 (spr277): undefined
	privileged reg378 (spr278): undefined
	privileged reg379 (spr279): undefined
	privileged reg380 (spr280): undefined
	privileged reg381 (spr281): undefined
	privileged reg382 (spr282): undefined
	privileged reg383 (spr283): undefined
	privileged reg384 (spr284): undefined
	privileged reg385 (spr285): undefined
	privileged reg386 (spr286): undefined
	privileged reg387 (spr287): undefined
	privileged reg388 (spr288): undefined
	privileged reg389 (spr289): undefined
	privileged reg390 (spr290): undefined
	privileged reg391 (spr291): undefined
	privileged reg392 (spr292): undefined
	privileged reg393 (spr293): undefined
	privileged reg394 (spr294): undefined
	privileged reg395 (spr295): undefined
	privileged reg396 (spr296): undefined
	privileged reg397 (spr297): undefined
	privileged reg398 (spr298): undefined
	privileged reg399 (spr299): undefined
	privileged reg400 (spr300): undefined
	privileged reg401 (spr301): undefined
	privileged reg402 (spr302): undefined
	privileged reg403 (spr303): undefined
	privileged reg404 (spr304): undefined
	privileged reg405 (spr305): undefined
	privileged reg406 (spr306): undefined
	privileged reg407 (spr307): undefined
	privileged reg408 (spr308): undefined
	privileged reg409 (spr309): undefined
	privileged reg410 (spr310): undefined
	privileged reg411 (spr311): undefined
	privileged reg412 (spr312): undefined
	privileged reg413 (spr313): undefined
	privileged reg414 (spr314): undefined
	privileged reg415 (spr315): undefined
	privileged reg416 (spr316): undefined
	privileged reg417 (spr317): undefined
	privileged reg418 (spr318): undefined
	privileged reg419 (spr319): undefined
	privileged reg420 (spr320): undefined
	privileged reg421 (spr321): undefined
	privileged reg422 (spr322): undefined
	privileged reg423 (spr323): undefined
	privileged reg424 (spr324): undefined
	privileged reg425 (spr325): undefined
	privileged reg426 (spr326): undefined
	privileged reg427 (spr327): undefined
	privileged reg428 (spr328): undefined
	privileged reg429 (spr329): undefined
	privileged reg430 (spr330): undefined
	privileged reg431 (spr331): undefined
	privileged reg432 (spr332): undefined
	privileged reg433 (spr333): undefined
	privileged reg434 (spr334): undefined
	privileged reg435 (spr335): undefined
	privileged reg436 (spr336): undefined
	privileged reg437 (spr337): undefined
	privileged reg438 (spr338): undefined
	privileged reg439 (spr339): undefined
	privileged reg440 (spr340): undefined
	privileged reg441 (spr341): undefined
	privileged reg442 (spr342): undefined
	privileged reg443 (spr343): undefined
	privileged reg444 (spr344): undefined
	privileged reg445 (spr345): undefined
	privileged reg446 (spr346): undefined
	privileged reg447 (spr347): undefined
	privileged reg448 (spr348): undefined
	privileged reg449 (spr349): undefined
	privileged reg450 (spr350): undefined
	privileged reg451 (spr351): undefined
	privileged reg452 (spr352): undefined
	privileged reg453 (spr353): undefined
	privileged reg454 (spr354): undefined
	privileged reg455 (spr355): undefined
	privileged reg456 (spr356): undefined
	privileged reg457 (spr357): undefined
	privileged reg458 (spr358): undefined
	privileged reg459 (spr359): undefined
	privileged reg460 (spr360): undefined
	privileged reg461 (spr361): undefined
	privileged reg462 (spr362): undefined
	privileged reg463 (spr363): undefined
	privileged reg464 (spr364): undefined
	privileged reg465 (spr365): undefined
	privileged reg466 (spr366): undefined
	privileged reg467 (spr367): undefined
	privileged reg468 (spr368): undefined
	privileged reg469 (spr369): undefined
	privileged reg470 (spr370): undefined
	privileged reg471 (spr371): undefined
	privileged reg472 (spr372): undefined
	privileged reg473 (spr373): undefined
	privileged reg474 (spr374): undefined
	privileged reg475 (spr375): undefined
	privileged reg476 (spr376): undefined
	privileged reg477 (spr377): undefined
	privileged reg478 (spr378): undefined
	privileged reg479 (spr379): undefined
	privileged reg480 (spr380): undefined
	privileged reg481 (spr381): undefined
	privileged reg482 (spr382): undefined
	privileged reg483 (spr383): undefined
	privileged reg484 (spr384): undefined
	privileged reg485 (spr385): undefined
	privileged reg486 (spr386): undefined
	privileged reg487 (spr387): undefined
	privileged reg488 (spr388): undefined
	privileged reg489 (spr389): undefined
	privileged reg490 (spr390): undefined
	privileged reg491 (spr391): undefined
	privileged reg492 (spr392): undefined
	privileged reg493 (spr393): undefined
	privileged reg494 (spr394): undefined
	privileged reg495 (spr395): undefined
	privileged reg496 (spr396): undefined
	privileged reg497 (spr397): undefined
	privileged reg498 (spr398): undefined
	privileged reg499 (spr399): undefined
	privileged reg500 (spr400): undefined
	privileged reg501 (spr401): undefined
	privileged reg502 (spr402): undefined
	privileged reg503 (spr403): undefined
	privileged reg504 (spr404): undefined
	privileged reg505 (spr405): undefined
	privileged reg506 (spr406): undefined
	privileged reg507 (spr407): undefined
	privileged reg508 (spr408): undefined
	privileged reg509 (spr409): undefined
	privileged reg510 (spr410): undefined
	privileged reg511 (spr411): undefined
	privileged reg512 (spr412): undefined
	privileged reg513 (spr413): undefined
	privileged reg514 (spr414): undefined
	privileged reg515 (spr415): undefined
	privileged reg516 (spr416): undefined
	privileged reg517 (spr417): undefined
	privileged reg518 (spr418): undefined
	privileged reg519 (spr419): undefined
	privileged reg520 (spr420): undefined
	privileged reg521 (spr421): undefined
	privileged reg522 (spr422): undefined
	privileged reg523 (spr423): undefined
	privileged reg524 (spr424): undefined
	privileged reg525 (spr425): undefined
	privileged reg526 (spr426): undefined
	privileged reg527 (spr427): undefined
	privileged reg528 (spr428): undefined
	privileged reg529 (spr429): undefined
	privileged reg530 (spr430): undefined
	privileged reg531 (spr431): undefined
	privileged reg532 (spr432): undefined
	privileged reg533 (spr433): undefined
	privileged reg534 (spr434): undefined
	privileged reg535 (spr435): undefined
	privileged reg536 (spr436): undefined
	privileged reg537 (spr437): undefined
	privileged reg538 (spr438): undefined
	privileged reg539 (spr439): undefined
	privileged reg540 (spr440): undefined
	privileged reg541 (spr441): undefined
	privileged reg542 (spr442): undefined
	privileged reg543 (spr443): undefined
	privileged reg544 (spr444): undefined
	privileged reg545 (spr445): undefined
	privileged reg546 (spr446): undefined
	privileged reg547 (spr447): undefined
	privileged reg548 (spr448): undefined
	privileged reg549 (spr449): undefined
	privileged reg550 (spr450): undefined
	privileged reg551 (spr451): undefined
	privileged reg552 (spr452): undefined
	privileged reg553 (spr453): undefined
	privileged reg554 (spr454): undefined
	privileged reg555 (spr455): undefined
	privileged reg556 (spr456): undefined
	privileged reg557 (spr457): undefined
	privileged reg558 (spr458): undefined
	privileged reg559 (spr459): undefined
	privileged reg560 (spr460): undefined
	privileged reg561 (spr461): undefined
	privileged reg562 (spr462): undefined
	privileged reg563 (spr463): undefined
	privileged reg564 (spr464): undefined
	privileged reg565 (spr465): undefined
	privileged reg566 (spr466): undefined
	privileged reg567 (spr467): undefined
	privileged reg568 (spr468): undefined
	privileged reg569 (spr469): undefined
	privileged reg570 (spr470): undefined
	privileged reg571 (spr471): undefined
	privileged reg572 (spr472): undefined
	privileged reg573 (spr473): undefined
	privileged reg574 (spr474): undefined
	privileged reg575 (spr475): undefined
	privileged reg576 (spr476): undefined
	privileged reg577 (spr477): undefined
	privileged reg578 (spr478): undefined
	privileged reg579 (spr479): undefined
	privileged reg580 (spr480): undefined
	privileged reg581 (spr481): undefined
	privileged reg582 (spr482): undefined
	privileged reg583 (spr483): undefined
	privileged reg584 (spr484): undefined
	privileged reg585 (spr485): undefined
	privileged reg586 (spr486): undefined
	privileged reg587 (spr487): undefined
	privileged reg588 (spr488): undefined
	privileged reg589 (spr489): undefined
	privileged reg590 (spr490): undefined
	privileged reg591 (spr491): undefined
	privileged reg592 (spr492): undefined
	privileged reg593 (spr493): undefined
	privileged reg594 (spr494): undefined
	privileged reg595 (spr495): undefined
	privileged reg596 (spr496): undefined
	privileged reg597 (spr497): undefined
	privileged reg598 (spr498): undefined
	privileged reg599 (spr499): undefined
	privileged reg600 (spr500): undefined
	privileged reg601 (spr501): undefined
	privileged reg602 (spr502): undefined
	privileged reg603 (spr503): undefined
	privileged reg604 (spr504): undefined
	privileged reg605 (spr505): undefined
	privileged reg606 (spr506): undefined
	privileged reg607 (spr507): undefined
	privileged reg608 (spr508): undefined
	privileged reg609 (spr509): undefined
	privileged reg610 (spr510): undefined
	privileged reg611 (spr511): undefined
	vector reg612 (spefscr): undefined
	privileged reg613 (spr513): undefined
	privileged reg614 (spr514): undefined
	privileged reg615 (spr515): undefined
	privileged reg616 (spr516): undefined
	privileged reg617 (spr517): undefined
	privileged reg618 (spr518): undefined
	privileged reg619 (spr519): undefined
	privileged reg620 (spr520): undefined
	privileged reg621 (spr521): undefined
	privileged reg622 (spr522): undefined
	privileged reg623 (spr523): undefined
	privileged reg624 (spr524): undefined
	privileged reg625 (spr525): undefined
	privileged reg626 (spr526): undefined
	privileged reg627 (spr527): undefined
	privileged reg628 (spr528): undefined
	privileged reg629 (spr529): undefined
	privileged reg630 (spr530): undefined
	privileged reg631 (spr531): undefined
	privileged reg632 (spr532): undefined
	privileged reg633 (spr533): undefined
	privileged reg634 (spr534): undefined
	privileged reg635 (spr535): undefined
	privileged reg636 (spr536): undefined
	privileged reg637 (spr537): undefined
	privileged reg638 (spr538): undefined
	privileged reg639 (spr539): undefined
	privileged reg640 (spr540): undefined
	privileged reg641 (spr541): undefined
	privileged reg642 (spr542): undefined
	privileged reg643 (spr543): undefined
	privileged reg644 (spr544): undefined
	privileged reg645 (spr545): undefined
	privileged reg646 (spr546): undefined
	privileged reg647 (spr547): undefined
	privileged reg648 (spr548): undefined
	privileged reg649 (spr549): undefined
	privileged reg650 (spr550): undefined
	privileged reg651 (spr551): undefined
	privileged reg652 (spr552): undefined
	privileged reg653 (spr553): undefined
	privileged reg654 (spr554): undefined
	privileged reg655 (spr555): undefined
	privileged reg656 (spr556): undefined
	privileged reg657 (spr557): undefined
	privileged reg658 (spr558): undefined
	privileged reg659 (spr559): undefined
	privileged reg660 (spr560): undefined
	privileged reg661 (spr561): undefined
	privileged reg662 (spr562): undefined
	privileged reg663 (spr563): undefined
	privileged reg664 (spr564): undefined
	privileged reg665 (spr565): undefined
	privileged reg666 (spr566): undefined
	privileged reg667 (spr567): undefined
	privileged reg668 (spr568): undefined
	privileged reg669 (spr569): undefined
	privileged reg670 (spr570): undefined
	privileged reg671 (spr571): undefined
	privileged reg672 (spr572): undefined
	privileged reg673 (spr573): undefined
	privileged reg674 (spr574): undefined
	privileged reg675 (spr575): undefined
	privileged reg676 (spr576): undefined
	privileged reg677 (spr577): undefined
	privileged reg678 (spr578): undefined
	privileged reg679 (spr579): undefined
	privileged reg680 (spr580): undefined
	privileged reg681 (spr581): undefined
	privileged reg682 (spr582): undefined
	privileged reg683 (spr583): undefined
	privileged reg684 (spr584): undefined
	privileged reg685 (spr585): undefined
	privileged reg686 (spr586): undefined
	privileged reg687 (spr587): undefined
	privileged reg688 (spr588): undefined
	privileged reg689 (spr589): undefined
	privileged reg690 (spr590): undefined
	privileged reg691 (spr591): undefined
	privileged reg692 (spr592): undefined
	privileged reg693 (spr593): undefined
	privileged reg694 (spr594): undefined
	privileged reg695 (spr595): undefined
	privileged reg696 (spr596): undefined
	privileged reg697 (spr597): undefined
	privileged reg698 (spr598): undefined
	privileged reg699 (spr599): undefined
	privileged reg700 (spr600): undefined
	privileged reg701 (spr601): undefined
	privileged reg702 (spr602): undefined
	privileged reg703 (spr603): undefined
	privileged reg704 (spr604): undefined
	privileged reg705 (spr605): undefined
	privileged reg706 (spr606): undefined
	privileged reg707 (spr607): undefined
	privileged reg708 (spr608): undefined
	privileged reg709 (spr609): undefined
	privileged reg710 (spr610): undefined
	privileged reg711 (spr611): undefined
	privileged reg712 (spr612): undefined
	privileged reg713 (spr613): undefined
	privileged reg714 (spr614): undefined
	privileged reg715 (spr615): undefined
	privileged reg716 (spr616): undefined
	privileged reg717 (spr617): undefined
	privileged reg718 (spr618): undefined
	privileged reg719 (spr619): undefined
	privileged reg720 (spr620): undefined
	privileged reg721 (spr621): undefined
	privileged reg722 (spr622): undefined
	privileged reg723 (spr623): undefined
	privileged reg724 (spr624): undefined
	privileged reg725 (spr625): undefined
	privileged reg726 (spr626): undefined
	privileged reg727 (spr627): undefined
	privileged reg728 (spr628): undefined
	privileged reg729 (spr629): undefined
	privileged reg730 (spr630): undefined
	privileged reg731 (spr631): undefined
	privileged reg732 (spr632): undefined
	privileged reg733 (spr633): undefined
	privileged reg734 (spr634): undefined
	privileged reg735 (spr635): undefined
	privileged reg736 (spr636): undefined
	privileged reg737 (spr637): undefined
	privileged reg738 (spr638): undefined
	privileged reg739 (spr639): undefined
	privileged reg740 (spr640): undefined
	privileged reg741 (spr641): undefined
	privileged reg742 (spr642): undefined
	privileged reg743 (spr643): undefined
	privileged reg744 (spr644): undefined
	privileged reg745 (spr645): undefined
	privileged reg746 (spr646): undefined
	privileged reg747 (spr647): undefined
	privileged reg748 (spr648): undefined
	privileged reg749 (spr649): undefined
	privileged reg750 (spr650): undefined
	privileged reg751 (spr651): undefined
	privileged reg752 (spr652): undefined
	privileged reg753 (spr653): undefined
	privileged reg754 (spr654): undefined
	privileged reg755 (spr655): undefined
	privileged reg756 (spr656): undefined
	privileged reg757 (spr657): undefined
	privileged reg758 (spr658): undefined
	privileged reg759 (spr659): undefined
	privileged reg760 (spr660): undefined
	privileged reg761 (spr661): undefined
	privileged reg762 (spr662): undefined
	privileged reg763 (spr663): undefined
	privileged reg764 (spr664): undefined
	privileged reg765 (spr665): undefined
	privileged reg766 (spr666): undefined
	privileged reg767 (spr667): undefined
	privileged reg768 (spr668): undefined
	privileged reg769 (spr669): undefined
	privileged reg770 (spr670): undefined
	privileged reg771 (spr671): undefined
	privileged reg772 (spr672): undefined
	privileged reg773 (spr673): undefined
	privileged reg774 (spr674): undefined
	privileged reg775 (spr675): undefined
	privileged reg776 (spr676): undefined
	privileged reg777 (spr677): undefined
	privileged reg778 (spr678): undefined
	privileged reg779 (spr679): undefined
	privileged reg780 (spr680): undefined
	privileged reg781 (spr681): undefined
	privileged reg782 (spr682): undefined
	privileged reg783 (spr683): undefined
	privileged reg784 (spr684): undefined
	privileged reg785 (spr685): undefined
	privileged reg786 (spr686): undefined
	privileged reg787 (spr687): undefined
	privileged reg788 (spr688): undefined
	privileged reg789 (spr689): undefined
	privileged reg790 (spr690): undefined
	privileged reg791 (spr691): undefined
	privileged reg792 (spr692): undefined
	privileged reg793 (spr693): undefined
	privileged reg794 (spr694): undefined
	privileged reg795 (spr695): undefined
	privileged reg796 (spr696): undefined
	privileged reg797 (spr697): undefined
	privileged reg798 (spr698): undefined
	privileged reg799 (spr699): undefined
	privileged reg800 (spr700): undefined
	privileged reg801 (spr701): undefined
	privileged reg802 (spr702): undefined
	privileged reg803 (spr703): undefined
	privileged reg804 (spr704): undefined
	privileged reg805 (spr705): undefined
	privileged reg806 (spr706): undefined
	privileged reg807 (spr707): undefined
	privileged reg808 (spr708): undefined
	privileged reg809 (spr709): undefined
	privileged reg810 (spr710): undefined
	privileged reg811 (spr711): undefined
	privileged reg812 (spr712): undefined
	privileged reg813 (spr713): undefined
	privileged reg814 (spr714): undefined
	privileged reg815 (spr715): undefined
	privileged reg816 (spr716): undefined
	privileged reg817 (spr717): undefined
	privileged reg818 (spr718): undefined
	privileged reg819 (spr719): undefined
	privileged reg820 (spr720): undefined
	privileged reg821 (spr721): undefined
	privileged reg822 (spr722): undefined
	privileged reg823 (spr723): undefined
	privileged reg824 (spr724): undefined
	privileged reg825 (spr725): undefined
	privileged reg826 (spr726): undefined
	privileged reg827 (spr727): undefined
	privileged reg828 (spr728): undefined
	privileged reg829 (spr729): undefined
	privileged reg830 (spr730): undefined
	privileged reg831 (spr731): undefined
	privileged reg832 (spr732): undefined
	privileged reg833 (spr733): undefined
	privileged reg834 (spr734): undefined
	privileged reg835 (spr735): undefined
	privileged reg836 (spr736): undefined
	privileged reg837 (spr737): undefined
	privileged reg838 (spr738): undefined
	privileged reg839 (spr739): undefined
	privileged reg840 (spr740): undefined
	privileged reg841 (spr741): undefined
	privileged reg842 (spr742): undefined
	privileged reg843 (spr743): undefined
	privileged reg844 (spr744): undefined
	privileged reg845 (spr745): undefined
	privileged reg846 (spr746): undefined
	privileged reg847 (spr747): undefined
	privileged reg848 (spr748): undefined
	privileged reg849 (spr749): undefined
	privileged reg850 (spr750): undefined
	privileged reg851 (spr751): undefined
	privileged reg852 (spr752): undefined
	privileged reg853 (spr753): undefined
	privileged reg854 (spr754): undefined
	privileged reg855 (spr755): undefined
	privileged reg856 (spr756): undefined
	privileged reg857 (spr757): undefined
	privileged reg858 (spr758): undefined
	privileged reg859 (spr759): undefined
	privileged reg860 (spr760): undefined
	privileged reg861 (spr761): undefined
	privileged reg862 (spr762): undefined
	privileged reg863 (spr763): undefined
	privileged reg864 (spr764): undefined
	privileged reg865 (spr765): undefined
	privileged reg866 (spr766): undefined
	privileged reg867 (spr767): undefined
	privileged reg868 (spr768): undefined
	privileged reg869 (spr769): undefined
	privileged reg870 (spr770): undefined
	privileged reg871 (spr771): undefined
	privileged reg872 (spr772): undefined
	privileged reg873 (spr773): undefined
	privileged reg874 (spr774): undefined
	privileged reg875 (spr775): undefined
	privileged reg876 (spr776): undefined
	privileged reg877 (spr777): undefined
	privileged reg878 (spr778): undefined
	privileged reg879 (spr779): undefined
	privileged reg880 (spr780): undefined
	privileged reg881 (spr781): undefined
	privileged reg882 (spr782): undefined
	privileged reg883 (spr783): undefined
	privileged reg884 (spr784): undefined
	privileged reg885 (spr785): undefined
	privileged reg886 (spr786): undefined
	privileged reg887 (spr787): undefined
	privileged reg888 (spr788): undefined
	privileged reg889 (spr789): undefined
	privileged reg890 (spr790): undefined
	privileged reg891 (spr791): undefined
	privileged reg892 (spr792): undefined
	privileged reg893 (spr793): undefined
	privileged reg894 (spr794): undefined
	privileged reg895 (spr795): undefined
	privileged reg896 (spr796): undefined
	privileged reg897 (spr797): undefined
	privileged reg898 (spr798): undefined
	privileged reg899 (spr799): undefined
	privileged reg900 (spr800): undefined
	privileged reg901 (spr801): undefined
	privileged reg902 (spr802): undefined
	privileged reg903 (spr803): undefined
	privileged reg904 (spr804): undefined
	privileged reg905 (spr805): undefined
	privileged reg906 (spr806): undefined
	privileged reg907 (spr807): undefined
	privileged reg908 (spr808): undefined
	privileged reg909 (spr809): undefined
	privileged reg910 (spr810): undefined
	privileged reg911 (spr811): undefined
	privileged reg912 (spr812): undefined
	privileged reg913 (spr813): undefined
	privileged reg914 (spr814): undefined
	privileged reg915 (spr815): undefined
	privileged reg916 (spr816): undefined
	privileged reg917 (spr817): undefined
	privileged reg918 (spr818): undefined
	privileged reg919 (spr819): undefined
	privileged reg920 (spr820): undefined
	privileged reg921 (spr821): undefined
	privileged reg922 (spr822): undefined
	privileged reg923 (spr823): undefined
	privileged reg924 (spr824): undefined
	privileged reg925 (spr825): undefined
	privileged reg926 (spr826): undefined
	privileged reg927 (spr827): undefined
	privileged reg928 (spr828): undefined
	privileged reg929 (spr829): undefined
	privileged reg930 (spr830): undefined
	privileged reg931 (spr831): undefined
	privileged reg932 (spr832): undefined
	privileged reg933 (spr833): undefined
	privileged reg934 (spr834): undefined
	privileged reg935 (spr835): undefined
	privileged reg936 (spr836): undefined
	privileged reg937 (spr837): undefined
	privileged reg938 (spr838): undefined
	privileged reg939 (spr839): undefined
	privileged reg940 (spr840): undefined
	privileged reg941 (spr841): undefined
	privileged reg942 (spr842): undefined
	privileged reg943 (spr843): undefined
	privileged reg944 (spr844): undefined
	privileged reg945 (spr845): undefined
	privileged reg946 (spr846): undefined
	privileged reg947 (spr847): undefined
	privileged reg948 (spr848): undefined
	privileged reg949 (spr849): undefined
	privileged reg950 (spr850): undefined
	privileged reg951 (spr851): undefined
	privileged reg952 (spr852): undefined
	privileged reg953 (spr853): undefined
	privileged reg954 (spr854): undefined
	privileged reg955 (spr855): undefined
	privileged reg956 (spr856): undefined
	privileged reg957 (spr857): undefined
	privileged reg958 (spr858): undefined
	privileged reg959 (spr859): undefined
	privileged reg960 (spr860): undefined
	privileged reg961 (spr861): undefined
	privileged reg962 (spr862): undefined
	privileged reg963 (spr863): undefined
	privileged reg964 (spr864): undefined
	privileged reg965 (spr865): undefined
	privileged reg966 (spr866): undefined
	privileged reg967 (spr867): undefined
	privileged reg968 (spr868): undefined
	privileged reg969 (spr869): undefined
	privileged reg970 (spr870): undefined
	privileged reg971 (spr871): undefined
	privileged reg972 (spr872): undefined
	privileged reg973 (spr873): undefined
	privileged reg974 (spr874): undefined
	privileged reg975 (spr875): undefined
	privileged reg976 (spr876): undefined
	privileged reg977 (spr877): undefined
	privileged reg978 (spr878): undefined
	privileged reg979 (spr879): undefined
	privileged reg980 (spr880): undefined
	privileged reg981 (spr881): undefined
	privileged reg982 (spr882): undefined
	privileged reg983 (spr883): undefined
	privileged reg984 (spr884): undefined
	privileged reg985 (spr885): undefined
	privileged reg986 (spr886): undefined
	privileged reg987 (spr887): undefined
	privileged reg988 (spr888): undefined
	privileged reg989 (spr889): undefined
	privileged reg990 (spr890): undefined
	privileged reg991 (spr891): undefined
	privileged reg992 (spr892): undefined
	privileged reg993 (spr893): undefined
	privileged reg994 (spr894): undefined
	privileged reg995 (spr895): undefined
	privileged reg996 (spr896): undefined
	privileged reg997 (spr897): undefined
	privileged reg998 (spr898): undefined
	privileged reg999 (spr899): undefined
	vector reg1124 (vr0): undefined
	vector reg1125 (vr1): undefined
	vector reg1126 (vr2): undefined
	vector reg1127 (vr3): undefined
	vector reg1128 (vr4): undefined
	vector reg1129 (vr5): undefined
	vector reg1130 (vr6): undefined
	vector reg1131 (vr7): undefined
	vector reg1132 (vr8): undefined
	vector reg1133 (vr9): undefined
	vector reg1134 (vr10): undefined
	vector reg1135 (vr11): undefined
	vector reg1136 (vr12): undefined
	vector reg1137 (vr13): undefined
	vector reg1138 (vr14): undefined
	vector reg1139 (vr15): undefined
	vector reg1140 (vr16): undefined
	vector reg1141 (vr17): undefined
	vector reg1142 (vr18): undefined
	vector reg1143 (vr19): undefined
	vector reg1144 (vr20): undefined
	vector reg1145 (vr21): undefined
	vector reg1146 (vr22): undefined
	vector reg1147 (vr23): undefined
	vector reg1148 (vr24): undefined
	vector reg1149 (vr25): undefined
	vector reg1150 (vr26): undefined
	vector reg1151 (vr27): undefined
	vector reg1152 (vr28): undefined
	vector reg1153 (vr29): undefined
	vector reg1154 (vr30): undefined
	vector reg1155 (vr31): undefined
EOF

testrun_compare ${abs_builddir}/addrcfi -e testfileppc32 0x100004d2 <<\EOF
.eh_frame has 0x100004d2 => [0x100004d0, 0x100004d4):
	return address in reg65
	CFA location expression: bregx(1)
	integer reg0 (r0): undefined
	integer reg1 (r1): location expression: call_frame_cfa stack_value
	integer reg2 (r2): same_value
	integer reg3 (r3): undefined
	integer reg4 (r4): undefined
	integer reg5 (r5): undefined
	integer reg6 (r6): undefined
	integer reg7 (r7): undefined
	integer reg8 (r8): undefined
	integer reg9 (r9): undefined
	integer reg10 (r10): undefined
	integer reg11 (r11): undefined
	integer reg12 (r12): undefined
	integer reg13 (r13): same_value
	integer reg14 (r14): same_value
	integer reg15 (r15): same_value
	integer reg16 (r16): same_value
	integer reg17 (r17): same_value
	integer reg18 (r18): same_value
	integer reg19 (r19): same_value
	integer reg20 (r20): same_value
	integer reg21 (r21): same_value
	integer reg22 (r22): same_value
	integer reg23 (r23): same_value
	integer reg24 (r24): same_value
	integer reg25 (r25): same_value
	integer reg26 (r26): same_value
	integer reg27 (r27): same_value
	integer reg28 (r28): same_value
	integer reg29 (r29): same_value
	integer reg30 (r30): same_value
	integer reg31 (r31): same_value
	FPU reg32 (f0): undefined
	FPU reg33 (f1): undefined
	FPU reg34 (f2): undefined
	FPU reg35 (f3): undefined
	FPU reg36 (f4): undefined
	FPU reg37 (f5): undefined
	FPU reg38 (f6): undefined
	FPU reg39 (f7): undefined
	FPU reg40 (f8): undefined
	FPU reg41 (f9): undefined
	FPU reg42 (f10): undefined
	FPU reg43 (f11): undefined
	FPU reg44 (f12): undefined
	FPU reg45 (f13): undefined
	FPU reg46 (f14): undefined
	FPU reg47 (f15): undefined
	FPU reg48 (f16): undefined
	FPU reg49 (f17): undefined
	FPU reg50 (f18): undefined
	FPU reg51 (f19): undefined
	FPU reg52 (f20): undefined
	FPU reg53 (f21): undefined
	FPU reg54 (f22): undefined
	FPU reg55 (f23): undefined
	FPU reg56 (f24): undefined
	FPU reg57 (f25): undefined
	FPU reg58 (f26): undefined
	FPU reg59 (f27): undefined
	FPU reg60 (f28): undefined
	FPU reg61 (f29): undefined
	FPU reg62 (f30): undefined
	FPU reg63 (f31): undefined
	integer reg64 (cr): undefined
	FPU reg65 (fpscr): same_value
	integer reg66 (msr): undefined
	vector reg67 (vscr): undefined
	privileged reg70 (sr0): undefined
	privileged reg71 (sr1): undefined
	privileged reg72 (sr2): undefined
	privileged reg73 (sr3): undefined
	privileged reg74 (sr4): undefined
	privileged reg75 (sr5): undefined
	privileged reg76 (sr6): undefined
	privileged reg77 (sr7): undefined
	privileged reg78 (sr8): undefined
	privileged reg79 (sr9): undefined
	privileged reg80 (sr10): undefined
	privileged reg81 (sr11): undefined
	privileged reg82 (sr12): undefined
	privileged reg83 (sr13): undefined
	privileged reg84 (sr14): undefined
	privileged reg85 (sr15): undefined
	privileged reg100 (mq): undefined
	privileged reg101 (xer): undefined
	privileged reg102 (spr2): undefined
	privileged reg103 (spr3): undefined
	privileged reg104 (spr4): undefined
	privileged reg105 (spr5): undefined
	privileged reg106 (spr6): undefined
	privileged reg107 (spr7): undefined
	privileged reg108 (lr): undefined
	privileged reg109 (ctr): undefined
	privileged reg110 (spr10): undefined
	privileged reg111 (spr11): undefined
	privileged reg112 (spr12): undefined
	privileged reg113 (spr13): undefined
	privileged reg114 (spr14): undefined
	privileged reg115 (spr15): undefined
	privileged reg116 (spr16): undefined
	privileged reg117 (spr17): undefined
	privileged reg118 (dsisr): undefined
	privileged reg119 (dar): undefined
	privileged reg120 (spr20): undefined
	privileged reg121 (spr21): undefined
	privileged reg122 (dec): undefined
	privileged reg123 (spr23): undefined
	privileged reg124 (spr24): undefined
	privileged reg125 (spr25): undefined
	privileged reg126 (spr26): undefined
	privileged reg127 (spr27): undefined
	privileged reg128 (spr28): undefined
	privileged reg129 (spr29): undefined
	privileged reg130 (spr30): undefined
	privileged reg131 (spr31): undefined
	privileged reg132 (spr32): undefined
	privileged reg133 (spr33): undefined
	privileged reg134 (spr34): undefined
	privileged reg135 (spr35): undefined
	privileged reg136 (spr36): undefined
	privileged reg137 (spr37): undefined
	privileged reg138 (spr38): undefined
	privileged reg139 (spr39): undefined
	privileged reg140 (spr40): undefined
	privileged reg141 (spr41): undefined
	privileged reg142 (spr42): undefined
	privileged reg143 (spr43): undefined
	privileged reg144 (spr44): undefined
	privileged reg145 (spr45): undefined
	privileged reg146 (spr46): undefined
	privileged reg147 (spr47): undefined
	privileged reg148 (spr48): undefined
	privileged reg149 (spr49): undefined
	privileged reg150 (spr50): undefined
	privileged reg151 (spr51): undefined
	privileged reg152 (spr52): undefined
	privileged reg153 (spr53): undefined
	privileged reg154 (spr54): undefined
	privileged reg155 (spr55): undefined
	privileged reg156 (spr56): undefined
	privileged reg157 (spr57): undefined
	privileged reg158 (spr58): undefined
	privileged reg159 (spr59): undefined
	privileged reg160 (spr60): undefined
	privileged reg161 (spr61): undefined
	privileged reg162 (spr62): undefined
	privileged reg163 (spr63): undefined
	privileged reg164 (spr64): undefined
	privileged reg165 (spr65): undefined
	privileged reg166 (spr66): undefined
	privileged reg167 (spr67): undefined
	privileged reg168 (spr68): undefined
	privileged reg169 (spr69): undefined
	privileged reg170 (spr70): undefined
	privileged reg171 (spr71): undefined
	privileged reg172 (spr72): undefined
	privileged reg173 (spr73): undefined
	privileged reg174 (spr74): undefined
	privileged reg175 (spr75): undefined
	privileged reg176 (spr76): undefined
	privileged reg177 (spr77): undefined
	privileged reg178 (spr78): undefined
	privileged reg179 (spr79): undefined
	privileged reg180 (spr80): undefined
	privileged reg181 (spr81): undefined
	privileged reg182 (spr82): undefined
	privileged reg183 (spr83): undefined
	privileged reg184 (spr84): undefined
	privileged reg185 (spr85): undefined
	privileged reg186 (spr86): undefined
	privileged reg187 (spr87): undefined
	privileged reg188 (spr88): undefined
	privileged reg189 (spr89): undefined
	privileged reg190 (spr90): undefined
	privileged reg191 (spr91): undefined
	privileged reg192 (spr92): undefined
	privileged reg193 (spr93): undefined
	privileged reg194 (spr94): undefined
	privileged reg195 (spr95): undefined
	privileged reg196 (spr96): undefined
	privileged reg197 (spr97): undefined
	privileged reg198 (spr98): undefined
	privileged reg199 (spr99): undefined
	privileged reg200 (spr100): undefined
	privileged reg201 (spr101): undefined
	privileged reg202 (spr102): undefined
	privileged reg203 (spr103): undefined
	privileged reg204 (spr104): undefined
	privileged reg205 (spr105): undefined
	privileged reg206 (spr106): undefined
	privileged reg207 (spr107): undefined
	privileged reg208 (spr108): undefined
	privileged reg209 (spr109): undefined
	privileged reg210 (spr110): undefined
	privileged reg211 (spr111): undefined
	privileged reg212 (spr112): undefined
	privileged reg213 (spr113): undefined
	privileged reg214 (spr114): undefined
	privileged reg215 (spr115): undefined
	privileged reg216 (spr116): undefined
	privileged reg217 (spr117): undefined
	privileged reg218 (spr118): undefined
	privileged reg219 (spr119): undefined
	privileged reg220 (spr120): undefined
	privileged reg221 (spr121): undefined
	privileged reg222 (spr122): undefined
	privileged reg223 (spr123): undefined
	privileged reg224 (spr124): undefined
	privileged reg225 (spr125): undefined
	privileged reg226 (spr126): undefined
	privileged reg227 (spr127): undefined
	privileged reg228 (spr128): undefined
	privileged reg229 (spr129): undefined
	privileged reg230 (spr130): undefined
	privileged reg231 (spr131): undefined
	privileged reg232 (spr132): undefined
	privileged reg233 (spr133): undefined
	privileged reg234 (spr134): undefined
	privileged reg235 (spr135): undefined
	privileged reg236 (spr136): undefined
	privileged reg237 (spr137): undefined
	privileged reg238 (spr138): undefined
	privileged reg239 (spr139): undefined
	privileged reg240 (spr140): undefined
	privileged reg241 (spr141): undefined
	privileged reg242 (spr142): undefined
	privileged reg243 (spr143): undefined
	privileged reg244 (spr144): undefined
	privileged reg245 (spr145): undefined
	privileged reg246 (spr146): undefined
	privileged reg247 (spr147): undefined
	privileged reg248 (spr148): undefined
	privileged reg249 (spr149): undefined
	privileged reg250 (spr150): undefined
	privileged reg251 (spr151): undefined
	privileged reg252 (spr152): undefined
	privileged reg253 (spr153): undefined
	privileged reg254 (spr154): undefined
	privileged reg255 (spr155): undefined
	privileged reg256 (spr156): undefined
	privileged reg257 (spr157): undefined
	privileged reg258 (spr158): undefined
	privileged reg259 (spr159): undefined
	privileged reg260 (spr160): undefined
	privileged reg261 (spr161): undefined
	privileged reg262 (spr162): undefined
	privileged reg263 (spr163): undefined
	privileged reg264 (spr164): undefined
	privileged reg265 (spr165): undefined
	privileged reg266 (spr166): undefined
	privileged reg267 (spr167): undefined
	privileged reg268 (spr168): undefined
	privileged reg269 (spr169): undefined
	privileged reg270 (spr170): undefined
	privileged reg271 (spr171): undefined
	privileged reg272 (spr172): undefined
	privileged reg273 (spr173): undefined
	privileged reg274 (spr174): undefined
	privileged reg275 (spr175): undefined
	privileged reg276 (spr176): undefined
	privileged reg277 (spr177): undefined
	privileged reg278 (spr178): undefined
	privileged reg279 (spr179): undefined
	privileged reg280 (spr180): undefined
	privileged reg281 (spr181): undefined
	privileged reg282 (spr182): undefined
	privileged reg283 (spr183): undefined
	privileged reg284 (spr184): undefined
	privileged reg285 (spr185): undefined
	privileged reg286 (spr186): undefined
	privileged reg287 (spr187): undefined
	privileged reg288 (spr188): undefined
	privileged reg289 (spr189): undefined
	privileged reg290 (spr190): undefined
	privileged reg291 (spr191): undefined
	privileged reg292 (spr192): undefined
	privileged reg293 (spr193): undefined
	privileged reg294 (spr194): undefined
	privileged reg295 (spr195): undefined
	privileged reg296 (spr196): undefined
	privileged reg297 (spr197): undefined
	privileged reg298 (spr198): undefined
	privileged reg299 (spr199): undefined
	privileged reg300 (spr200): undefined
	privileged reg301 (spr201): undefined
	privileged reg302 (spr202): undefined
	privileged reg303 (spr203): undefined
	privileged reg304 (spr204): undefined
	privileged reg305 (spr205): undefined
	privileged reg306 (spr206): undefined
	privileged reg307 (spr207): undefined
	privileged reg308 (spr208): undefined
	privileged reg309 (spr209): undefined
	privileged reg310 (spr210): undefined
	privileged reg311 (spr211): undefined
	privileged reg312 (spr212): undefined
	privileged reg313 (spr213): undefined
	privileged reg314 (spr214): undefined
	privileged reg315 (spr215): undefined
	privileged reg316 (spr216): undefined
	privileged reg317 (spr217): undefined
	privileged reg318 (spr218): undefined
	privileged reg319 (spr219): undefined
	privileged reg320 (spr220): undefined
	privileged reg321 (spr221): undefined
	privileged reg322 (spr222): undefined
	privileged reg323 (spr223): undefined
	privileged reg324 (spr224): undefined
	privileged reg325 (spr225): undefined
	privileged reg326 (spr226): undefined
	privileged reg327 (spr227): undefined
	privileged reg328 (spr228): undefined
	privileged reg329 (spr229): undefined
	privileged reg330 (spr230): undefined
	privileged reg331 (spr231): undefined
	privileged reg332 (spr232): undefined
	privileged reg333 (spr233): undefined
	privileged reg334 (spr234): undefined
	privileged reg335 (spr235): undefined
	privileged reg336 (spr236): undefined
	privileged reg337 (spr237): undefined
	privileged reg338 (spr238): undefined
	privileged reg339 (spr239): undefined
	privileged reg340 (spr240): undefined
	privileged reg341 (spr241): undefined
	privileged reg342 (spr242): undefined
	privileged reg343 (spr243): undefined
	privileged reg344 (spr244): undefined
	privileged reg345 (spr245): undefined
	privileged reg346 (spr246): undefined
	privileged reg347 (spr247): undefined
	privileged reg348 (spr248): undefined
	privileged reg349 (spr249): undefined
	privileged reg350 (spr250): undefined
	privileged reg351 (spr251): undefined
	privileged reg352 (spr252): undefined
	privileged reg353 (spr253): undefined
	privileged reg354 (spr254): undefined
	privileged reg355 (spr255): undefined
	vector reg356 (vrsave): undefined
	privileged reg357 (spr257): undefined
	privileged reg358 (spr258): undefined
	privileged reg359 (spr259): undefined
	privileged reg360 (spr260): undefined
	privileged reg361 (spr261): undefined
	privileged reg362 (spr262): undefined
	privileged reg363 (spr263): undefined
	privileged reg364 (spr264): undefined
	privileged reg365 (spr265): undefined
	privileged reg366 (spr266): undefined
	privileged reg367 (spr267): undefined
	privileged reg368 (spr268): undefined
	privileged reg369 (spr269): undefined
	privileged reg370 (spr270): undefined
	privileged reg371 (spr271): undefined
	privileged reg372 (spr272): undefined
	privileged reg373 (spr273): undefined
	privileged reg374 (spr274): undefined
	privileged reg375 (spr275): undefined
	privileged reg376 (spr276): undefined
	privileged reg377 (spr277): undefined
	privileged reg378 (spr278): undefined
	privileged reg379 (spr279): undefined
	privileged reg380 (spr280): undefined
	privileged reg381 (spr281): undefined
	privileged reg382 (spr282): undefined
	privileged reg383 (spr283): undefined
	privileged reg384 (spr284): undefined
	privileged reg385 (spr285): undefined
	privileged reg386 (spr286): undefined
	privileged reg387 (spr287): undefined
	privileged reg388 (spr288): undefined
	privileged reg389 (spr289): undefined
	privileged reg390 (spr290): undefined
	privileged reg391 (spr291): undefined
	privileged reg392 (spr292): undefined
	privileged reg393 (spr293): undefined
	privileged reg394 (spr294): undefined
	privileged reg395 (spr295): undefined
	privileged reg396 (spr296): undefined
	privileged reg397 (spr297): undefined
	privileged reg398 (spr298): undefined
	privileged reg399 (spr299): undefined
	privileged reg400 (spr300): undefined
	privileged reg401 (spr301): undefined
	privileged reg402 (spr302): undefined
	privileged reg403 (spr303): undefined
	privileged reg404 (spr304): undefined
	privileged reg405 (spr305): undefined
	privileged reg406 (spr306): undefined
	privileged reg407 (spr307): undefined
	privileged reg408 (spr308): undefined
	privileged reg409 (spr309): undefined
	privileged reg410 (spr310): undefined
	privileged reg411 (spr311): undefined
	privileged reg412 (spr312): undefined
	privileged reg413 (spr313): undefined
	privileged reg414 (spr314): undefined
	privileged reg415 (spr315): undefined
	privileged reg416 (spr316): undefined
	privileged reg417 (spr317): undefined
	privileged reg418 (spr318): undefined
	privileged reg419 (spr319): undefined
	privileged reg420 (spr320): undefined
	privileged reg421 (spr321): undefined
	privileged reg422 (spr322): undefined
	privileged reg423 (spr323): undefined
	privileged reg424 (spr324): undefined
	privileged reg425 (spr325): undefined
	privileged reg426 (spr326): undefined
	privileged reg427 (spr327): undefined
	privileged reg428 (spr328): undefined
	privileged reg429 (spr329): undefined
	privileged reg430 (spr330): undefined
	privileged reg431 (spr331): undefined
	privileged reg432 (spr332): undefined
	privileged reg433 (spr333): undefined
	privileged reg434 (spr334): undefined
	privileged reg435 (spr335): undefined
	privileged reg436 (spr336): undefined
	privileged reg437 (spr337): undefined
	privileged reg438 (spr338): undefined
	privileged reg439 (spr339): undefined
	privileged reg440 (spr340): undefined
	privileged reg441 (spr341): undefined
	privileged reg442 (spr342): undefined
	privileged reg443 (spr343): undefined
	privileged reg444 (spr344): undefined
	privileged reg445 (spr345): undefined
	privileged reg446 (spr346): undefined
	privileged reg447 (spr347): undefined
	privileged reg448 (spr348): undefined
	privileged reg449 (spr349): undefined
	privileged reg450 (spr350): undefined
	privileged reg451 (spr351): undefined
	privileged reg452 (spr352): undefined
	privileged reg453 (spr353): undefined
	privileged reg454 (spr354): undefined
	privileged reg455 (spr355): undefined
	privileged reg456 (spr356): undefined
	privileged reg457 (spr357): undefined
	privileged reg458 (spr358): undefined
	privileged reg459 (spr359): undefined
	privileged reg460 (spr360): undefined
	privileged reg461 (spr361): undefined
	privileged reg462 (spr362): undefined
	privileged reg463 (spr363): undefined
	privileged reg464 (spr364): undefined
	privileged reg465 (spr365): undefined
	privileged reg466 (spr366): undefined
	privileged reg467 (spr367): undefined
	privileged reg468 (spr368): undefined
	privileged reg469 (spr369): undefined
	privileged reg470 (spr370): undefined
	privileged reg471 (spr371): undefined
	privileged reg472 (spr372): undefined
	privileged reg473 (spr373): undefined
	privileged reg474 (spr374): undefined
	privileged reg475 (spr375): undefined
	privileged reg476 (spr376): undefined
	privileged reg477 (spr377): undefined
	privileged reg478 (spr378): undefined
	privileged reg479 (spr379): undefined
	privileged reg480 (spr380): undefined
	privileged reg481 (spr381): undefined
	privileged reg482 (spr382): undefined
	privileged reg483 (spr383): undefined
	privileged reg484 (spr384): undefined
	privileged reg485 (spr385): undefined
	privileged reg486 (spr386): undefined
	privileged reg487 (spr387): undefined
	privileged reg488 (spr388): undefined
	privileged reg489 (spr389): undefined
	privileged reg490 (spr390): undefined
	privileged reg491 (spr391): undefined
	privileged reg492 (spr392): undefined
	privileged reg493 (spr393): undefined
	privileged reg494 (spr394): undefined
	privileged reg495 (spr395): undefined
	privileged reg496 (spr396): undefined
	privileged reg497 (spr397): undefined
	privileged reg498 (spr398): undefined
	privileged reg499 (spr399): undefined
	privileged reg500 (spr400): undefined
	privileged reg501 (spr401): undefined
	privileged reg502 (spr402): undefined
	privileged reg503 (spr403): undefined
	privileged reg504 (spr404): undefined
	privileged reg505 (spr405): undefined
	privileged reg506 (spr406): undefined
	privileged reg507 (spr407): undefined
	privileged reg508 (spr408): undefined
	privileged reg509 (spr409): undefined
	privileged reg510 (spr410): undefined
	privileged reg511 (spr411): undefined
	privileged reg512 (spr412): undefined
	privileged reg513 (spr413): undefined
	privileged reg514 (spr414): undefined
	privileged reg515 (spr415): undefined
	privileged reg516 (spr416): undefined
	privileged reg517 (spr417): undefined
	privileged reg518 (spr418): undefined
	privileged reg519 (spr419): undefined
	privileged reg520 (spr420): undefined
	privileged reg521 (spr421): undefined
	privileged reg522 (spr422): undefined
	privileged reg523 (spr423): undefined
	privileged reg524 (spr424): undefined
	privileged reg525 (spr425): undefined
	privileged reg526 (spr426): undefined
	privileged reg527 (spr427): undefined
	privileged reg528 (spr428): undefined
	privileged reg529 (spr429): undefined
	privileged reg530 (spr430): undefined
	privileged reg531 (spr431): undefined
	privileged reg532 (spr432): undefined
	privileged reg533 (spr433): undefined
	privileged reg534 (spr434): undefined
	privileged reg535 (spr435): undefined
	privileged reg536 (spr436): undefined
	privileged reg537 (spr437): undefined
	privileged reg538 (spr438): undefined
	privileged reg539 (spr439): undefined
	privileged reg540 (spr440): undefined
	privileged reg541 (spr441): undefined
	privileged reg542 (spr442): undefined
	privileged reg543 (spr443): undefined
	privileged reg544 (spr444): undefined
	privileged reg545 (spr445): undefined
	privileged reg546 (spr446): undefined
	privileged reg547 (spr447): undefined
	privileged reg548 (spr448): undefined
	privileged reg549 (spr449): undefined
	privileged reg550 (spr450): undefined
	privileged reg551 (spr451): undefined
	privileged reg552 (spr452): undefined
	privileged reg553 (spr453): undefined
	privileged reg554 (spr454): undefined
	privileged reg555 (spr455): undefined
	privileged reg556 (spr456): undefined
	privileged reg557 (spr457): undefined
	privileged reg558 (spr458): undefined
	privileged reg559 (spr459): undefined
	privileged reg560 (spr460): undefined
	privileged reg561 (spr461): undefined
	privileged reg562 (spr462): undefined
	privileged reg563 (spr463): undefined
	privileged reg564 (spr464): undefined
	privileged reg565 (spr465): undefined
	privileged reg566 (spr466): undefined
	privileged reg567 (spr467): undefined
	privileged reg568 (spr468): undefined
	privileged reg569 (spr469): undefined
	privileged reg570 (spr470): undefined
	privileged reg571 (spr471): undefined
	privileged reg572 (spr472): undefined
	privileged reg573 (spr473): undefined
	privileged reg574 (spr474): undefined
	privileged reg575 (spr475): undefined
	privileged reg576 (spr476): undefined
	privileged reg577 (spr477): undefined
	privileged reg578 (spr478): undefined
	privileged reg579 (spr479): undefined
	privileged reg580 (spr480): undefined
	privileged reg581 (spr481): undefined
	privileged reg582 (spr482): undefined
	privileged reg583 (spr483): undefined
	privileged reg584 (spr484): undefined
	privileged reg585 (spr485): undefined
	privileged reg586 (spr486): undefined
	privileged reg587 (spr487): undefined
	privileged reg588 (spr488): undefined
	privileged reg589 (spr489): undefined
	privileged reg590 (spr490): undefined
	privileged reg591 (spr491): undefined
	privileged reg592 (spr492): undefined
	privileged reg593 (spr493): undefined
	privileged reg594 (spr494): undefined
	privileged reg595 (spr495): undefined
	privileged reg596 (spr496): undefined
	privileged reg597 (spr497): undefined
	privileged reg598 (spr498): undefined
	privileged reg599 (spr499): undefined
	privileged reg600 (spr500): undefined
	privileged reg601 (spr501): undefined
	privileged reg602 (spr502): undefined
	privileged reg603 (spr503): undefined
	privileged reg604 (spr504): undefined
	privileged reg605 (spr505): undefined
	privileged reg606 (spr506): undefined
	privileged reg607 (spr507): undefined
	privileged reg608 (spr508): undefined
	privileged reg609 (spr509): undefined
	privileged reg610 (spr510): undefined
	privileged reg611 (spr511): undefined
	vector reg612 (spefscr): undefined
	privileged reg613 (spr513): undefined
	privileged reg614 (spr514): undefined
	privileged reg615 (spr515): undefined
	privileged reg616 (spr516): undefined
	privileged reg617 (spr517): undefined
	privileged reg618 (spr518): undefined
	privileged reg619 (spr519): undefined
	privileged reg620 (spr520): undefined
	privileged reg621 (spr521): undefined
	privileged reg622 (spr522): undefined
	privileged reg623 (spr523): undefined
	privileged reg624 (spr524): undefined
	privileged reg625 (spr525): undefined
	privileged reg626 (spr526): undefined
	privileged reg627 (spr527): undefined
	privileged reg628 (spr528): undefined
	privileged reg629 (spr529): undefined
	privileged reg630 (spr530): undefined
	privileged reg631 (spr531): undefined
	privileged reg632 (spr532): undefined
	privileged reg633 (spr533): undefined
	privileged reg634 (spr534): undefined
	privileged reg635 (spr535): undefined
	privileged reg636 (spr536): undefined
	privileged reg637 (spr537): undefined
	privileged reg638 (spr538): undefined
	privileged reg639 (spr539): undefined
	privileged reg640 (spr540): undefined
	privileged reg641 (spr541): undefined
	privileged reg642 (spr542): undefined
	privileged reg643 (spr543): undefined
	privileged reg644 (spr544): undefined
	privileged reg645 (spr545): undefined
	privileged reg646 (spr546): undefined
	privileged reg647 (spr547): undefined
	privileged reg648 (spr548): undefined
	privileged reg649 (spr549): undefined
	privileged reg650 (spr550): undefined
	privileged reg651 (spr551): undefined
	privileged reg652 (spr552): undefined
	privileged reg653 (spr553): undefined
	privileged reg654 (spr554): undefined
	privileged reg655 (spr555): undefined
	privileged reg656 (spr556): undefined
	privileged reg657 (spr557): undefined
	privileged reg658 (spr558): undefined
	privileged reg659 (spr559): undefined
	privileged reg660 (spr560): undefined
	privileged reg661 (spr561): undefined
	privileged reg662 (spr562): undefined
	privileged reg663 (spr563): undefined
	privileged reg664 (spr564): undefined
	privileged reg665 (spr565): undefined
	privileged reg666 (spr566): undefined
	privileged reg667 (spr567): undefined
	privileged reg668 (spr568): undefined
	privileged reg669 (spr569): undefined
	privileged reg670 (spr570): undefined
	privileged reg671 (spr571): undefined
	privileged reg672 (spr572): undefined
	privileged reg673 (spr573): undefined
	privileged reg674 (spr574): undefined
	privileged reg675 (spr575): undefined
	privileged reg676 (spr576): undefined
	privileged reg677 (spr577): undefined
	privileged reg678 (spr578): undefined
	privileged reg679 (spr579): undefined
	privileged reg680 (spr580): undefined
	privileged reg681 (spr581): undefined
	privileged reg682 (spr582): undefined
	privileged reg683 (spr583): undefined
	privileged reg684 (spr584): undefined
	privileged reg685 (spr585): undefined
	privileged reg686 (spr586): undefined
	privileged reg687 (spr587): undefined
	privileged reg688 (spr588): undefined
	privileged reg689 (spr589): undefined
	privileged reg690 (spr590): undefined
	privileged reg691 (spr591): undefined
	privileged reg692 (spr592): undefined
	privileged reg693 (spr593): undefined
	privileged reg694 (spr594): undefined
	privileged reg695 (spr595): undefined
	privileged reg696 (spr596): undefined
	privileged reg697 (spr597): undefined
	privileged reg698 (spr598): undefined
	privileged reg699 (spr599): undefined
	privileged reg700 (spr600): undefined
	privileged reg701 (spr601): undefined
	privileged reg702 (spr602): undefined
	privileged reg703 (spr603): undefined
	privileged reg704 (spr604): undefined
	privileged reg705 (spr605): undefined
	privileged reg706 (spr606): undefined
	privileged reg707 (spr607): undefined
	privileged reg708 (spr608): undefined
	privileged reg709 (spr609): undefined
	privileged reg710 (spr610): undefined
	privileged reg711 (spr611): undefined
	privileged reg712 (spr612): undefined
	privileged reg713 (spr613): undefined
	privileged reg714 (spr614): undefined
	privileged reg715 (spr615): undefined
	privileged reg716 (spr616): undefined
	privileged reg717 (spr617): undefined
	privileged reg718 (spr618): undefined
	privileged reg719 (spr619): undefined
	privileged reg720 (spr620): undefined
	privileged reg721 (spr621): undefined
	privileged reg722 (spr622): undefined
	privileged reg723 (spr623): undefined
	privileged reg724 (spr624): undefined
	privileged reg725 (spr625): undefined
	privileged reg726 (spr626): undefined
	privileged reg727 (spr627): undefined
	privileged reg728 (spr628): undefined
	privileged reg729 (spr629): undefined
	privileged reg730 (spr630): undefined
	privileged reg731 (spr631): undefined
	privileged reg732 (spr632): undefined
	privileged reg733 (spr633): undefined
	privileged reg734 (spr634): undefined
	privileged reg735 (spr635): undefined
	privileged reg736 (spr636): undefined
	privileged reg737 (spr637): undefined
	privileged reg738 (spr638): undefined
	privileged reg739 (spr639): undefined
	privileged reg740 (spr640): undefined
	privileged reg741 (spr641): undefined
	privileged reg742 (spr642): undefined
	privileged reg743 (spr643): undefined
	privileged reg744 (spr644): undefined
	privileged reg745 (spr645): undefined
	privileged reg746 (spr646): undefined
	privileged reg747 (spr647): undefined
	privileged reg748 (spr648): undefined
	privileged reg749 (spr649): undefined
	privileged reg750 (spr650): undefined
	privileged reg751 (spr651): undefined
	privileged reg752 (spr652): undefined
	privileged reg753 (spr653): undefined
	privileged reg754 (spr654): undefined
	privileged reg755 (spr655): undefined
	privileged reg756 (spr656): undefined
	privileged reg757 (spr657): undefined
	privileged reg758 (spr658): undefined
	privileged reg759 (spr659): undefined
	privileged reg760 (spr660): undefined
	privileged reg761 (spr661): undefined
	privileged reg762 (spr662): undefined
	privileged reg763 (spr663): undefined
	privileged reg764 (spr664): undefined
	privileged reg765 (spr665): undefined
	privileged reg766 (spr666): undefined
	privileged reg767 (spr667): undefined
	privileged reg768 (spr668): undefined
	privileged reg769 (spr669): undefined
	privileged reg770 (spr670): undefined
	privileged reg771 (spr671): undefined
	privileged reg772 (spr672): undefined
	privileged reg773 (spr673): undefined
	privileged reg774 (spr674): undefined
	privileged reg775 (spr675): undefined
	privileged reg776 (spr676): undefined
	privileged reg777 (spr677): undefined
	privileged reg778 (spr678): undefined
	privileged reg779 (spr679): undefined
	privileged reg780 (spr680): undefined
	privileged reg781 (spr681): undefined
	privileged reg782 (spr682): undefined
	privileged reg783 (spr683): undefined
	privileged reg784 (spr684): undefined
	privileged reg785 (spr685): undefined
	privileged reg786 (spr686): undefined
	privileged reg787 (spr687): undefined
	privileged reg788 (spr688): undefined
	privileged reg789 (spr689): undefined
	privileged reg790 (spr690): undefined
	privileged reg791 (spr691): undefined
	privileged reg792 (spr692): undefined
	privileged reg793 (spr693): undefined
	privileged reg794 (spr694): undefined
	privileged reg795 (spr695): undefined
	privileged reg796 (spr696): undefined
	privileged reg797 (spr697): undefined
	privileged reg798 (spr698): undefined
	privileged reg799 (spr699): undefined
	privileged reg800 (spr700): undefined
	privileged reg801 (spr701): undefined
	privileged reg802 (spr702): undefined
	privileged reg803 (spr703): undefined
	privileged reg804 (spr704): undefined
	privileged reg805 (spr705): undefined
	privileged reg806 (spr706): undefined
	privileged reg807 (spr707): undefined
	privileged reg808 (spr708): undefined
	privileged reg809 (spr709): undefined
	privileged reg810 (spr710): undefined
	privileged reg811 (spr711): undefined
	privileged reg812 (spr712): undefined
	privileged reg813 (spr713): undefined
	privileged reg814 (spr714): undefined
	privileged reg815 (spr715): undefined
	privileged reg816 (spr716): undefined
	privileged reg817 (spr717): undefined
	privileged reg818 (spr718): undefined
	privileged reg819 (spr719): undefined
	privileged reg820 (spr720): undefined
	privileged reg821 (spr721): undefined
	privileged reg822 (spr722): undefined
	privileged reg823 (spr723): undefined
	privileged reg824 (spr724): undefined
	privileged reg825 (spr725): undefined
	privileged reg826 (spr726): undefined
	privileged reg827 (spr727): undefined
	privileged reg828 (spr728): undefined
	privileged reg829 (spr729): undefined
	privileged reg830 (spr730): undefined
	privileged reg831 (spr731): undefined
	privileged reg832 (spr732): undefined
	privileged reg833 (spr733): undefined
	privileged reg834 (spr734): undefined
	privileged reg835 (spr735): undefined
	privileged reg836 (spr736): undefined
	privileged reg837 (spr737): undefined
	privileged reg838 (spr738): undefined
	privileged reg839 (spr739): undefined
	privileged reg840 (spr740): undefined
	privileged reg841 (spr741): undefined
	privileged reg842 (spr742): undefined
	privileged reg843 (spr743): undefined
	privileged reg844 (spr744): undefined
	privileged reg845 (spr745): undefined
	privileged reg846 (spr746): undefined
	privileged reg847 (spr747): undefined
	privileged reg848 (spr748): undefined
	privileged reg849 (spr749): undefined
	privileged reg850 (spr750): undefined
	privileged reg851 (spr751): undefined
	privileged reg852 (spr752): undefined
	privileged reg853 (spr753): undefined
	privileged reg854 (spr754): undefined
	privileged reg855 (spr755): undefined
	privileged reg856 (spr756): undefined
	privileged reg857 (spr757): undefined
	privileged reg858 (spr758): undefined
	privileged reg859 (spr759): undefined
	privileged reg860 (spr760): undefined
	privileged reg861 (spr761): undefined
	privileged reg862 (spr762): undefined
	privileged reg863 (spr763): undefined
	privileged reg864 (spr764): undefined
	privileged reg865 (spr765): undefined
	privileged reg866 (spr766): undefined
	privileged reg867 (spr767): undefined
	privileged reg868 (spr768): undefined
	privileged reg869 (spr769): undefined
	privileged reg870 (spr770): undefined
	privileged reg871 (spr771): undefined
	privileged reg872 (spr772): undefined
	privileged reg873 (spr773): undefined
	privileged reg874 (spr774): undefined
	privileged reg875 (spr775): undefined
	privileged reg876 (spr776): undefined
	privileged reg877 (spr777): undefined
	privileged reg878 (spr778): undefined
	privileged reg879 (spr779): undefined
	privileged reg880 (spr780): undefined
	privileged reg881 (spr781): undefined
	privileged reg882 (spr782): undefined
	privileged reg883 (spr783): undefined
	privileged reg884 (spr784): undefined
	privileged reg885 (spr785): undefined
	privileged reg886 (spr786): undefined
	privileged reg887 (spr787): undefined
	privileged reg888 (spr788): undefined
	privileged reg889 (spr789): undefined
	privileged reg890 (spr790): undefined
	privileged reg891 (spr791): undefined
	privileged reg892 (spr792): undefined
	privileged reg893 (spr793): undefined
	privileged reg894 (spr794): undefined
	privileged reg895 (spr795): undefined
	privileged reg896 (spr796): undefined
	privileged reg897 (spr797): undefined
	privileged reg898 (spr798): undefined
	privileged reg899 (spr799): undefined
	privileged reg900 (spr800): undefined
	privileged reg901 (spr801): undefined
	privileged reg902 (spr802): undefined
	privileged reg903 (spr803): undefined
	privileged reg904 (spr804): undefined
	privileged reg905 (spr805): undefined
	privileged reg906 (spr806): undefined
	privileged reg907 (spr807): undefined
	privileged reg908 (spr808): undefined
	privileged reg909 (spr809): undefined
	privileged reg910 (spr810): undefined
	privileged reg911 (spr811): undefined
	privileged reg912 (spr812): undefined
	privileged reg913 (spr813): undefined
	privileged reg914 (spr814): undefined
	privileged reg915 (spr815): undefined
	privileged reg916 (spr816): undefined
	privileged reg917 (spr817): undefined
	privileged reg918 (spr818): undefined
	privileged reg919 (spr819): undefined
	privileged reg920 (spr820): undefined
	privileged reg921 (spr821): undefined
	privileged reg922 (spr822): undefined
	privileged reg923 (spr823): undefined
	privileged reg924 (spr824): undefined
	privileged reg925 (spr825): undefined
	privileged reg926 (spr826): undefined
	privileged reg927 (spr827): undefined
	privileged reg928 (spr828): undefined
	privileged reg929 (spr829): undefined
	privileged reg930 (spr830): undefined
	privileged reg931 (spr831): undefined
	privileged reg932 (spr832): undefined
	privileged reg933 (spr833): undefined
	privileged reg934 (spr834): undefined
	privileged reg935 (spr835): undefined
	privileged reg936 (spr836): undefined
	privileged reg937 (spr837): undefined
	privileged reg938 (spr838): undefined
	privileged reg939 (spr839): undefined
	privileged reg940 (spr840): undefined
	privileged reg941 (spr841): undefined
	privileged reg942 (spr842): undefined
	privileged reg943 (spr843): undefined
	privileged reg944 (spr844): undefined
	privileged reg945 (spr845): undefined
	privileged reg946 (spr846): undefined
	privileged reg947 (spr847): undefined
	privileged reg948 (spr848): undefined
	privileged reg949 (spr849): undefined
	privileged reg950 (spr850): undefined
	privileged reg951 (spr851): undefined
	privileged reg952 (spr852): undefined
	privileged reg953 (spr853): undefined
	privileged reg954 (spr854): undefined
	privileged reg955 (spr855): undefined
	privileged reg956 (spr856): undefined
	privileged reg957 (spr857): undefined
	privileged reg958 (spr858): undefined
	privileged reg959 (spr859): undefined
	privileged reg960 (spr860): undefined
	privileged reg961 (spr861): undefined
	privileged reg962 (spr862): undefined
	privileged reg963 (spr863): undefined
	privileged reg964 (spr864): undefined
	privileged reg965 (spr865): undefined
	privileged reg966 (spr866): undefined
	privileged reg967 (spr867): undefined
	privileged reg968 (spr868): undefined
	privileged reg969 (spr869): undefined
	privileged reg970 (spr870): undefined
	privileged reg971 (spr871): undefined
	privileged reg972 (spr872): undefined
	privileged reg973 (spr873): undefined
	privileged reg974 (spr874): undefined
	privileged reg975 (spr875): undefined
	privileged reg976 (spr876): undefined
	privileged reg977 (spr877): undefined
	privileged reg978 (spr878): undefined
	privileged reg979 (spr879): undefined
	privileged reg980 (spr880): undefined
	privileged reg981 (spr881): undefined
	privileged reg982 (spr882): undefined
	privileged reg983 (spr883): undefined
	privileged reg984 (spr884): undefined
	privileged reg985 (spr885): undefined
	privileged reg986 (spr886): undefined
	privileged reg987 (spr887): undefined
	privileged reg988 (spr888): undefined
	privileged reg989 (spr889): undefined
	privileged reg990 (spr890): undefined
	privileged reg991 (spr891): undefined
	privileged reg992 (spr892): undefined
	privileged reg993 (spr893): undefined
	privileged reg994 (spr894): undefined
	privileged reg995 (spr895): undefined
	privileged reg996 (spr896): undefined
	privileged reg997 (spr897): undefined
	privileged reg998 (spr898): undefined
	privileged reg999 (spr899): undefined
	vector reg1124 (vr0): undefined
	vector reg1125 (vr1): undefined
	vector reg1126 (vr2): undefined
	vector reg1127 (vr3): undefined
	vector reg1128 (vr4): undefined
	vector reg1129 (vr5): undefined
	vector reg1130 (vr6): undefined
	vector reg1131 (vr7): undefined
	vector reg1132 (vr8): undefined
	vector reg1133 (vr9): undefined
	vector reg1134 (vr10): undefined
	vector reg1135 (vr11): undefined
	vector reg1136 (vr12): undefined
	vector reg1137 (vr13): undefined
	vector reg1138 (vr14): undefined
	vector reg1139 (vr15): undefined
	vector reg1140 (vr16): undefined
	vector reg1141 (vr17): undefined
	vector reg1142 (vr18): undefined
	vector reg1143 (vr19): undefined
	vector reg1144 (vr20): undefined
	vector reg1145 (vr21): undefined
	vector reg1146 (vr22): undefined
	vector reg1147 (vr23): undefined
	vector reg1148 (vr24): undefined
	vector reg1149 (vr25): undefined
	vector reg1150 (vr26): undefined
	vector reg1151 (vr27): undefined
	vector reg1152 (vr28): undefined
	vector reg1153 (vr29): undefined
	vector reg1154 (vr30): undefined
	vector reg1155 (vr31): undefined
dwarf_cfi_addrframe (.debug_frame): no matching address range
EOF

# EM_PPC64 (function bar 0x00000000100005b0)
# Note. Only in .debug_frame, not in .eh_frame.
# Same as testfileppc32 but without -m32.
testfiles testfileppc64
testrun_compare ${abs_builddir}/addrcfi -e testfileppc64 0x00000000100005b0 <<\EOF
dwarf_cfi_addrframe (.eh_frame): no matching address range
.debug_frame has 0x100005b0 => [0x100005b0, 0x100005d0):
	return address in reg65
	CFA location expression: bregx(1)
	integer reg0 (r0): undefined
	integer reg1 (r1): location expression: call_frame_cfa stack_value
	integer reg2 (r2): same_value
	integer reg3 (r3): undefined
	integer reg4 (r4): undefined
	integer reg5 (r5): undefined
	integer reg6 (r6): undefined
	integer reg7 (r7): undefined
	integer reg8 (r8): undefined
	integer reg9 (r9): undefined
	integer reg10 (r10): undefined
	integer reg11 (r11): undefined
	integer reg12 (r12): undefined
	integer reg13 (r13): same_value
	integer reg14 (r14): same_value
	integer reg15 (r15): same_value
	integer reg16 (r16): same_value
	integer reg17 (r17): same_value
	integer reg18 (r18): same_value
	integer reg19 (r19): same_value
	integer reg20 (r20): same_value
	integer reg21 (r21): same_value
	integer reg22 (r22): same_value
	integer reg23 (r23): same_value
	integer reg24 (r24): same_value
	integer reg25 (r25): same_value
	integer reg26 (r26): same_value
	integer reg27 (r27): same_value
	integer reg28 (r28): same_value
	integer reg29 (r29): same_value
	integer reg30 (r30): same_value
	integer reg31 (r31): same_value
	FPU reg32 (f0): undefined
	FPU reg33 (f1): undefined
	FPU reg34 (f2): undefined
	FPU reg35 (f3): undefined
	FPU reg36 (f4): undefined
	FPU reg37 (f5): undefined
	FPU reg38 (f6): undefined
	FPU reg39 (f7): undefined
	FPU reg40 (f8): undefined
	FPU reg41 (f9): undefined
	FPU reg42 (f10): undefined
	FPU reg43 (f11): undefined
	FPU reg44 (f12): undefined
	FPU reg45 (f13): undefined
	FPU reg46 (f14): undefined
	FPU reg47 (f15): undefined
	FPU reg48 (f16): undefined
	FPU reg49 (f17): undefined
	FPU reg50 (f18): undefined
	FPU reg51 (f19): undefined
	FPU reg52 (f20): undefined
	FPU reg53 (f21): undefined
	FPU reg54 (f22): undefined
	FPU reg55 (f23): undefined
	FPU reg56 (f24): undefined
	FPU reg57 (f25): undefined
	FPU reg58 (f26): undefined
	FPU reg59 (f27): undefined
	FPU reg60 (f28): undefined
	FPU reg61 (f29): undefined
	FPU reg62 (f30): undefined
	FPU reg63 (f31): undefined
	integer reg64 (cr): undefined
	FPU reg65 (fpscr): same_value
	integer reg66 (msr): undefined
	vector reg67 (vscr): undefined
	privileged reg70 (sr0): undefined
	privileged reg71 (sr1): undefined
	privileged reg72 (sr2): undefined
	privileged reg73 (sr3): undefined
	privileged reg74 (sr4): undefined
	privileged reg75 (sr5): undefined
	privileged reg76 (sr6): undefined
	privileged reg77 (sr7): undefined
	privileged reg78 (sr8): undefined
	privileged reg79 (sr9): undefined
	privileged reg80 (sr10): undefined
	privileged reg81 (sr11): undefined
	privileged reg82 (sr12): undefined
	privileged reg83 (sr13): undefined
	privileged reg84 (sr14): undefined
	privileged reg85 (sr15): undefined
	privileged reg100 (spr0): undefined
	privileged reg101 (xer): undefined
	privileged reg102 (spr2): undefined
	privileged reg103 (spr3): undefined
	privileged reg104 (spr4): undefined
	privileged reg105 (spr5): undefined
	privileged reg106 (spr6): undefined
	privileged reg107 (spr7): undefined
	privileged reg108 (lr): undefined
	privileged reg109 (ctr): undefined
	privileged reg110 (spr10): undefined
	privileged reg111 (spr11): undefined
	privileged reg112 (spr12): undefined
	privileged reg113 (spr13): undefined
	privileged reg114 (spr14): undefined
	privileged reg115 (spr15): undefined
	privileged reg116 (spr16): undefined
	privileged reg117 (spr17): undefined
	privileged reg118 (dsisr): undefined
	privileged reg119 (dar): undefined
	privileged reg120 (spr20): undefined
	privileged reg121 (spr21): undefined
	privileged reg122 (dec): undefined
	privileged reg123 (spr23): undefined
	privileged reg124 (spr24): undefined
	privileged reg125 (spr25): undefined
	privileged reg126 (spr26): undefined
	privileged reg127 (spr27): undefined
	privileged reg128 (spr28): undefined
	privileged reg129 (spr29): undefined
	privileged reg130 (spr30): undefined
	privileged reg131 (spr31): undefined
	privileged reg132 (spr32): undefined
	privileged reg133 (spr33): undefined
	privileged reg134 (spr34): undefined
	privileged reg135 (spr35): undefined
	privileged reg136 (spr36): undefined
	privileged reg137 (spr37): undefined
	privileged reg138 (spr38): undefined
	privileged reg139 (spr39): undefined
	privileged reg140 (spr40): undefined
	privileged reg141 (spr41): undefined
	privileged reg142 (spr42): undefined
	privileged reg143 (spr43): undefined
	privileged reg144 (spr44): undefined
	privileged reg145 (spr45): undefined
	privileged reg146 (spr46): undefined
	privileged reg147 (spr47): undefined
	privileged reg148 (spr48): undefined
	privileged reg149 (spr49): undefined
	privileged reg150 (spr50): undefined
	privileged reg151 (spr51): undefined
	privileged reg152 (spr52): undefined
	privileged reg153 (spr53): undefined
	privileged reg154 (spr54): undefined
	privileged reg155 (spr55): undefined
	privileged reg156 (spr56): undefined
	privileged reg157 (spr57): undefined
	privileged reg158 (spr58): undefined
	privileged reg159 (spr59): undefined
	privileged reg160 (spr60): undefined
	privileged reg161 (spr61): undefined
	privileged reg162 (spr62): undefined
	privileged reg163 (spr63): undefined
	privileged reg164 (spr64): undefined
	privileged reg165 (spr65): undefined
	privileged reg166 (spr66): undefined
	privileged reg167 (spr67): undefined
	privileged reg168 (spr68): undefined
	privileged reg169 (spr69): undefined
	privileged reg170 (spr70): undefined
	privileged reg171 (spr71): undefined
	privileged reg172 (spr72): undefined
	privileged reg173 (spr73): undefined
	privileged reg174 (spr74): undefined
	privileged reg175 (spr75): undefined
	privileged reg176 (spr76): undefined
	privileged reg177 (spr77): undefined
	privileged reg178 (spr78): undefined
	privileged reg179 (spr79): undefined
	privileged reg180 (spr80): undefined
	privileged reg181 (spr81): undefined
	privileged reg182 (spr82): undefined
	privileged reg183 (spr83): undefined
	privileged reg184 (spr84): undefined
	privileged reg185 (spr85): undefined
	privileged reg186 (spr86): undefined
	privileged reg187 (spr87): undefined
	privileged reg188 (spr88): undefined
	privileged reg189 (spr89): undefined
	privileged reg190 (spr90): undefined
	privileged reg191 (spr91): undefined
	privileged reg192 (spr92): undefined
	privileged reg193 (spr93): undefined
	privileged reg194 (spr94): undefined
	privileged reg195 (spr95): undefined
	privileged reg196 (spr96): undefined
	privileged reg197 (spr97): undefined
	privileged reg198 (spr98): undefined
	privileged reg199 (spr99): undefined
	privileged reg200 (spr100): undefined
	privileged reg201 (spr101): undefined
	privileged reg202 (spr102): undefined
	privileged reg203 (spr103): undefined
	privileged reg204 (spr104): undefined
	privileged reg205 (spr105): undefined
	privileged reg206 (spr106): undefined
	privileged reg207 (spr107): undefined
	privileged reg208 (spr108): undefined
	privileged reg209 (spr109): undefined
	privileged reg210 (spr110): undefined
	privileged reg211 (spr111): undefined
	privileged reg212 (spr112): undefined
	privileged reg213 (spr113): undefined
	privileged reg214 (spr114): undefined
	privileged reg215 (spr115): undefined
	privileged reg216 (spr116): undefined
	privileged reg217 (spr117): undefined
	privileged reg218 (spr118): undefined
	privileged reg219 (spr119): undefined
	privileged reg220 (spr120): undefined
	privileged reg221 (spr121): undefined
	privileged reg222 (spr122): undefined
	privileged reg223 (spr123): undefined
	privileged reg224 (spr124): undefined
	privileged reg225 (spr125): undefined
	privileged reg226 (spr126): undefined
	privileged reg227 (spr127): undefined
	privileged reg228 (spr128): undefined
	privileged reg229 (spr129): undefined
	privileged reg230 (spr130): undefined
	privileged reg231 (spr131): undefined
	privileged reg232 (spr132): undefined
	privileged reg233 (spr133): undefined
	privileged reg234 (spr134): undefined
	privileged reg235 (spr135): undefined
	privileged reg236 (spr136): undefined
	privileged reg237 (spr137): undefined
	privileged reg238 (spr138): undefined
	privileged reg239 (spr139): undefined
	privileged reg240 (spr140): undefined
	privileged reg241 (spr141): undefined
	privileged reg242 (spr142): undefined
	privileged reg243 (spr143): undefined
	privileged reg244 (spr144): undefined
	privileged reg245 (spr145): undefined
	privileged reg246 (spr146): undefined
	privileged reg247 (spr147): undefined
	privileged reg248 (spr148): undefined
	privileged reg249 (spr149): undefined
	privileged reg250 (spr150): undefined
	privileged reg251 (spr151): undefined
	privileged reg252 (spr152): undefined
	privileged reg253 (spr153): undefined
	privileged reg254 (spr154): undefined
	privileged reg255 (spr155): undefined
	privileged reg256 (spr156): undefined
	privileged reg257 (spr157): undefined
	privileged reg258 (spr158): undefined
	privileged reg259 (spr159): undefined
	privileged reg260 (spr160): undefined
	privileged reg261 (spr161): undefined
	privileged reg262 (spr162): undefined
	privileged reg263 (spr163): undefined
	privileged reg264 (spr164): undefined
	privileged reg265 (spr165): undefined
	privileged reg266 (spr166): undefined
	privileged reg267 (spr167): undefined
	privileged reg268 (spr168): undefined
	privileged reg269 (spr169): undefined
	privileged reg270 (spr170): undefined
	privileged reg271 (spr171): undefined
	privileged reg272 (spr172): undefined
	privileged reg273 (spr173): undefined
	privileged reg274 (spr174): undefined
	privileged reg275 (spr175): undefined
	privileged reg276 (spr176): undefined
	privileged reg277 (spr177): undefined
	privileged reg278 (spr178): undefined
	privileged reg279 (spr179): undefined
	privileged reg280 (spr180): undefined
	privileged reg281 (spr181): undefined
	privileged reg282 (spr182): undefined
	privileged reg283 (spr183): undefined
	privileged reg284 (spr184): undefined
	privileged reg285 (spr185): undefined
	privileged reg286 (spr186): undefined
	privileged reg287 (spr187): undefined
	privileged reg288 (spr188): undefined
	privileged reg289 (spr189): undefined
	privileged reg290 (spr190): undefined
	privileged reg291 (spr191): undefined
	privileged reg292 (spr192): undefined
	privileged reg293 (spr193): undefined
	privileged reg294 (spr194): undefined
	privileged reg295 (spr195): undefined
	privileged reg296 (spr196): undefined
	privileged reg297 (spr197): undefined
	privileged reg298 (spr198): undefined
	privileged reg299 (spr199): undefined
	privileged reg300 (spr200): undefined
	privileged reg301 (spr201): undefined
	privileged reg302 (spr202): undefined
	privileged reg303 (spr203): undefined
	privileged reg304 (spr204): undefined
	privileged reg305 (spr205): undefined
	privileged reg306 (spr206): undefined
	privileged reg307 (spr207): undefined
	privileged reg308 (spr208): undefined
	privileged reg309 (spr209): undefined
	privileged reg310 (spr210): undefined
	privileged reg311 (spr211): undefined
	privileged reg312 (spr212): undefined
	privileged reg313 (spr213): undefined
	privileged reg314 (spr214): undefined
	privileged reg315 (spr215): undefined
	privileged reg316 (spr216): undefined
	privileged reg317 (spr217): undefined
	privileged reg318 (spr218): undefined
	privileged reg319 (spr219): undefined
	privileged reg320 (spr220): undefined
	privileged reg321 (spr221): undefined
	privileged reg322 (spr222): undefined
	privileged reg323 (spr223): undefined
	privileged reg324 (spr224): undefined
	privileged reg325 (spr225): undefined
	privileged reg326 (spr226): undefined
	privileged reg327 (spr227): undefined
	privileged reg328 (spr228): undefined
	privileged reg329 (spr229): undefined
	privileged reg330 (spr230): undefined
	privileged reg331 (spr231): undefined
	privileged reg332 (spr232): undefined
	privileged reg333 (spr233): undefined
	privileged reg334 (spr234): undefined
	privileged reg335 (spr235): undefined
	privileged reg336 (spr236): undefined
	privileged reg337 (spr237): undefined
	privileged reg338 (spr238): undefined
	privileged reg339 (spr239): undefined
	privileged reg340 (spr240): undefined
	privileged reg341 (spr241): undefined
	privileged reg342 (spr242): undefined
	privileged reg343 (spr243): undefined
	privileged reg344 (spr244): undefined
	privileged reg345 (spr245): undefined
	privileged reg346 (spr246): undefined
	privileged reg347 (spr247): undefined
	privileged reg348 (spr248): undefined
	privileged reg349 (spr249): undefined
	privileged reg350 (spr250): undefined
	privileged reg351 (spr251): undefined
	privileged reg352 (spr252): undefined
	privileged reg353 (spr253): undefined
	privileged reg354 (spr254): undefined
	privileged reg355 (spr255): undefined
	vector reg356 (vrsave): undefined
	privileged reg357 (spr257): undefined
	privileged reg358 (spr258): undefined
	privileged reg359 (spr259): undefined
	privileged reg360 (spr260): undefined
	privileged reg361 (spr261): undefined
	privileged reg362 (spr262): undefined
	privileged reg363 (spr263): undefined
	privileged reg364 (spr264): undefined
	privileged reg365 (spr265): undefined
	privileged reg366 (spr266): undefined
	privileged reg367 (spr267): undefined
	privileged reg368 (spr268): undefined
	privileged reg369 (spr269): undefined
	privileged reg370 (spr270): undefined
	privileged reg371 (spr271): undefined
	privileged reg372 (spr272): undefined
	privileged reg373 (spr273): undefined
	privileged reg374 (spr274): undefined
	privileged reg375 (spr275): undefined
	privileged reg376 (spr276): undefined
	privileged reg377 (spr277): undefined
	privileged reg378 (spr278): undefined
	privileged reg379 (spr279): undefined
	privileged reg380 (spr280): undefined
	privileged reg381 (spr281): undefined
	privileged reg382 (spr282): undefined
	privileged reg383 (spr283): undefined
	privileged reg384 (spr284): undefined
	privileged reg385 (spr285): undefined
	privileged reg386 (spr286): undefined
	privileged reg387 (spr287): undefined
	privileged reg388 (spr288): undefined
	privileged reg389 (spr289): undefined
	privileged reg390 (spr290): undefined
	privileged reg391 (spr291): undefined
	privileged reg392 (spr292): undefined
	privileged reg393 (spr293): undefined
	privileged reg394 (spr294): undefined
	privileged reg395 (spr295): undefined
	privileged reg396 (spr296): undefined
	privileged reg397 (spr297): undefined
	privileged reg398 (spr298): undefined
	privileged reg399 (spr299): undefined
	privileged reg400 (spr300): undefined
	privileged reg401 (spr301): undefined
	privileged reg402 (spr302): undefined
	privileged reg403 (spr303): undefined
	privileged reg404 (spr304): undefined
	privileged reg405 (spr305): undefined
	privileged reg406 (spr306): undefined
	privileged reg407 (spr307): undefined
	privileged reg408 (spr308): undefined
	privileged reg409 (spr309): undefined
	privileged reg410 (spr310): undefined
	privileged reg411 (spr311): undefined
	privileged reg412 (spr312): undefined
	privileged reg413 (spr313): undefined
	privileged reg414 (spr314): undefined
	privileged reg415 (spr315): undefined
	privileged reg416 (spr316): undefined
	privileged reg417 (spr317): undefined
	privileged reg418 (spr318): undefined
	privileged reg419 (spr319): undefined
	privileged reg420 (spr320): undefined
	privileged reg421 (spr321): undefined
	privileged reg422 (spr322): undefined
	privileged reg423 (spr323): undefined
	privileged reg424 (spr324): undefined
	privileged reg425 (spr325): undefined
	privileged reg426 (spr326): undefined
	privileged reg427 (spr327): undefined
	privileged reg428 (spr328): undefined
	privileged reg429 (spr329): undefined
	privileged reg430 (spr330): undefined
	privileged reg431 (spr331): undefined
	privileged reg432 (spr332): undefined
	privileged reg433 (spr333): undefined
	privileged reg434 (spr334): undefined
	privileged reg435 (spr335): undefined
	privileged reg436 (spr336): undefined
	privileged reg437 (spr337): undefined
	privileged reg438 (spr338): undefined
	privileged reg439 (spr339): undefined
	privileged reg440 (spr340): undefined
	privileged reg441 (spr341): undefined
	privileged reg442 (spr342): undefined
	privileged reg443 (spr343): undefined
	privileged reg444 (spr344): undefined
	privileged reg445 (spr345): undefined
	privileged reg446 (spr346): undefined
	privileged reg447 (spr347): undefined
	privileged reg448 (spr348): undefined
	privileged reg449 (spr349): undefined
	privileged reg450 (spr350): undefined
	privileged reg451 (spr351): undefined
	privileged reg452 (spr352): undefined
	privileged reg453 (spr353): undefined
	privileged reg454 (spr354): undefined
	privileged reg455 (spr355): undefined
	privileged reg456 (spr356): undefined
	privileged reg457 (spr357): undefined
	privileged reg458 (spr358): undefined
	privileged reg459 (spr359): undefined
	privileged reg460 (spr360): undefined
	privileged reg461 (spr361): undefined
	privileged reg462 (spr362): undefined
	privileged reg463 (spr363): undefined
	privileged reg464 (spr364): undefined
	privileged reg465 (spr365): undefined
	privileged reg466 (spr366): undefined
	privileged reg467 (spr367): undefined
	privileged reg468 (spr368): undefined
	privileged reg469 (spr369): undefined
	privileged reg470 (spr370): undefined
	privileged reg471 (spr371): undefined
	privileged reg472 (spr372): undefined
	privileged reg473 (spr373): undefined
	privileged reg474 (spr374): undefined
	privileged reg475 (spr375): undefined
	privileged reg476 (spr376): undefined
	privileged reg477 (spr377): undefined
	privileged reg478 (spr378): undefined
	privileged reg479 (spr379): undefined
	privileged reg480 (spr380): undefined
	privileged reg481 (spr381): undefined
	privileged reg482 (spr382): undefined
	privileged reg483 (spr383): undefined
	privileged reg484 (spr384): undefined
	privileged reg485 (spr385): undefined
	privileged reg486 (spr386): undefined
	privileged reg487 (spr387): undefined
	privileged reg488 (spr388): undefined
	privileged reg489 (spr389): undefined
	privileged reg490 (spr390): undefined
	privileged reg491 (spr391): undefined
	privileged reg492 (spr392): undefined
	privileged reg493 (spr393): undefined
	privileged reg494 (spr394): undefined
	privileged reg495 (spr395): undefined
	privileged reg496 (spr396): undefined
	privileged reg497 (spr397): undefined
	privileged reg498 (spr398): undefined
	privileged reg499 (spr399): undefined
	privileged reg500 (spr400): undefined
	privileged reg501 (spr401): undefined
	privileged reg502 (spr402): undefined
	privileged reg503 (spr403): undefined
	privileged reg504 (spr404): undefined
	privileged reg505 (spr405): undefined
	privileged reg506 (spr406): undefined
	privileged reg507 (spr407): undefined
	privileged reg508 (spr408): undefined
	privileged reg509 (spr409): undefined
	privileged reg510 (spr410): undefined
	privileged reg511 (spr411): undefined
	privileged reg512 (spr412): undefined
	privileged reg513 (spr413): undefined
	privileged reg514 (spr414): undefined
	privileged reg515 (spr415): undefined
	privileged reg516 (spr416): undefined
	privileged reg517 (spr417): undefined
	privileged reg518 (spr418): undefined
	privileged reg519 (spr419): undefined
	privileged reg520 (spr420): undefined
	privileged reg521 (spr421): undefined
	privileged reg522 (spr422): undefined
	privileged reg523 (spr423): undefined
	privileged reg524 (spr424): undefined
	privileged reg525 (spr425): undefined
	privileged reg526 (spr426): undefined
	privileged reg527 (spr427): undefined
	privileged reg528 (spr428): undefined
	privileged reg529 (spr429): undefined
	privileged reg530 (spr430): undefined
	privileged reg531 (spr431): undefined
	privileged reg532 (spr432): undefined
	privileged reg533 (spr433): undefined
	privileged reg534 (spr434): undefined
	privileged reg535 (spr435): undefined
	privileged reg536 (spr436): undefined
	privileged reg537 (spr437): undefined
	privileged reg538 (spr438): undefined
	privileged reg539 (spr439): undefined
	privileged reg540 (spr440): undefined
	privileged reg541 (spr441): undefined
	privileged reg542 (spr442): undefined
	privileged reg543 (spr443): undefined
	privileged reg544 (spr444): undefined
	privileged reg545 (spr445): undefined
	privileged reg546 (spr446): undefined
	privileged reg547 (spr447): undefined
	privileged reg548 (spr448): undefined
	privileged reg549 (spr449): undefined
	privileged reg550 (spr450): undefined
	privileged reg551 (spr451): undefined
	privileged reg552 (spr452): undefined
	privileged reg553 (spr453): undefined
	privileged reg554 (spr454): undefined
	privileged reg555 (spr455): undefined
	privileged reg556 (spr456): undefined
	privileged reg557 (spr457): undefined
	privileged reg558 (spr458): undefined
	privileged reg559 (spr459): undefined
	privileged reg560 (spr460): undefined
	privileged reg561 (spr461): undefined
	privileged reg562 (spr462): undefined
	privileged reg563 (spr463): undefined
	privileged reg564 (spr464): undefined
	privileged reg565 (spr465): undefined
	privileged reg566 (spr466): undefined
	privileged reg567 (spr467): undefined
	privileged reg568 (spr468): undefined
	privileged reg569 (spr469): undefined
	privileged reg570 (spr470): undefined
	privileged reg571 (spr471): undefined
	privileged reg572 (spr472): undefined
	privileged reg573 (spr473): undefined
	privileged reg574 (spr474): undefined
	privileged reg575 (spr475): undefined
	privileged reg576 (spr476): undefined
	privileged reg577 (spr477): undefined
	privileged reg578 (spr478): undefined
	privileged reg579 (spr479): undefined
	privileged reg580 (spr480): undefined
	privileged reg581 (spr481): undefined
	privileged reg582 (spr482): undefined
	privileged reg583 (spr483): undefined
	privileged reg584 (spr484): undefined
	privileged reg585 (spr485): undefined
	privileged reg586 (spr486): undefined
	privileged reg587 (spr487): undefined
	privileged reg588 (spr488): undefined
	privileged reg589 (spr489): undefined
	privileged reg590 (spr490): undefined
	privileged reg591 (spr491): undefined
	privileged reg592 (spr492): undefined
	privileged reg593 (spr493): undefined
	privileged reg594 (spr494): undefined
	privileged reg595 (spr495): undefined
	privileged reg596 (spr496): undefined
	privileged reg597 (spr497): undefined
	privileged reg598 (spr498): undefined
	privileged reg599 (spr499): undefined
	privileged reg600 (spr500): undefined
	privileged reg601 (spr501): undefined
	privileged reg602 (spr502): undefined
	privileged reg603 (spr503): undefined
	privileged reg604 (spr504): undefined
	privileged reg605 (spr505): undefined
	privileged reg606 (spr506): undefined
	privileged reg607 (spr507): undefined
	privileged reg608 (spr508): undefined
	privileged reg609 (spr509): undefined
	privileged reg610 (spr510): undefined
	privileged reg611 (spr511): undefined
	vector reg612 (spefscr): undefined
	privileged reg613 (spr513): undefined
	privileged reg614 (spr514): undefined
	privileged reg615 (spr515): undefined
	privileged reg616 (spr516): undefined
	privileged reg617 (spr517): undefined
	privileged reg618 (spr518): undefined
	privileged reg619 (spr519): undefined
	privileged reg620 (spr520): undefined
	privileged reg621 (spr521): undefined
	privileged reg622 (spr522): undefined
	privileged reg623 (spr523): undefined
	privileged reg624 (spr524): undefined
	privileged reg625 (spr525): undefined
	privileged reg626 (spr526): undefined
	privileged reg627 (spr527): undefined
	privileged reg628 (spr528): undefined
	privileged reg629 (spr529): undefined
	privileged reg630 (spr530): undefined
	privileged reg631 (spr531): undefined
	privileged reg632 (spr532): undefined
	privileged reg633 (spr533): undefined
	privileged reg634 (spr534): undefined
	privileged reg635 (spr535): undefined
	privileged reg636 (spr536): undefined
	privileged reg637 (spr537): undefined
	privileged reg638 (spr538): undefined
	privileged reg639 (spr539): undefined
	privileged reg640 (spr540): undefined
	privileged reg641 (spr541): undefined
	privileged reg642 (spr542): undefined
	privileged reg643 (spr543): undefined
	privileged reg644 (spr544): undefined
	privileged reg645 (spr545): undefined
	privileged reg646 (spr546): undefined
	privileged reg647 (spr547): undefined
	privileged reg648 (spr548): undefined
	privileged reg649 (spr549): undefined
	privileged reg650 (spr550): undefined
	privileged reg651 (spr551): undefined
	privileged reg652 (spr552): undefined
	privileged reg653 (spr553): undefined
	privileged reg654 (spr554): undefined
	privileged reg655 (spr555): undefined
	privileged reg656 (spr556): undefined
	privileged reg657 (spr557): undefined
	privileged reg658 (spr558): undefined
	privileged reg659 (spr559): undefined
	privileged reg660 (spr560): undefined
	privileged reg661 (spr561): undefined
	privileged reg662 (spr562): undefined
	privileged reg663 (spr563): undefined
	privileged reg664 (spr564): undefined
	privileged reg665 (spr565): undefined
	privileged reg666 (spr566): undefined
	privileged reg667 (spr567): undefined
	privileged reg668 (spr568): undefined
	privileged reg669 (spr569): undefined
	privileged reg670 (spr570): undefined
	privileged reg671 (spr571): undefined
	privileged reg672 (spr572): undefined
	privileged reg673 (spr573): undefined
	privileged reg674 (spr574): undefined
	privileged reg675 (spr575): undefined
	privileged reg676 (spr576): undefined
	privileged reg677 (spr577): undefined
	privileged reg678 (spr578): undefined
	privileged reg679 (spr579): undefined
	privileged reg680 (spr580): undefined
	privileged reg681 (spr581): undefined
	privileged reg682 (spr582): undefined
	privileged reg683 (spr583): undefined
	privileged reg684 (spr584): undefined
	privileged reg685 (spr585): undefined
	privileged reg686 (spr586): undefined
	privileged reg687 (spr587): undefined
	privileged reg688 (spr588): undefined
	privileged reg689 (spr589): undefined
	privileged reg690 (spr590): undefined
	privileged reg691 (spr591): undefined
	privileged reg692 (spr592): undefined
	privileged reg693 (spr593): undefined
	privileged reg694 (spr594): undefined
	privileged reg695 (spr595): undefined
	privileged reg696 (spr596): undefined
	privileged reg697 (spr597): undefined
	privileged reg698 (spr598): undefined
	privileged reg699 (spr599): undefined
	privileged reg700 (spr600): undefined
	privileged reg701 (spr601): undefined
	privileged reg702 (spr602): undefined
	privileged reg703 (spr603): undefined
	privileged reg704 (spr604): undefined
	privileged reg705 (spr605): undefined
	privileged reg706 (spr606): undefined
	privileged reg707 (spr607): undefined
	privileged reg708 (spr608): undefined
	privileged reg709 (spr609): undefined
	privileged reg710 (spr610): undefined
	privileged reg711 (spr611): undefined
	privileged reg712 (spr612): undefined
	privileged reg713 (spr613): undefined
	privileged reg714 (spr614): undefined
	privileged reg715 (spr615): undefined
	privileged reg716 (spr616): undefined
	privileged reg717 (spr617): undefined
	privileged reg718 (spr618): undefined
	privileged reg719 (spr619): undefined
	privileged reg720 (spr620): undefined
	privileged reg721 (spr621): undefined
	privileged reg722 (spr622): undefined
	privileged reg723 (spr623): undefined
	privileged reg724 (spr624): undefined
	privileged reg725 (spr625): undefined
	privileged reg726 (spr626): undefined
	privileged reg727 (spr627): undefined
	privileged reg728 (spr628): undefined
	privileged reg729 (spr629): undefined
	privileged reg730 (spr630): undefined
	privileged reg731 (spr631): undefined
	privileged reg732 (spr632): undefined
	privileged reg733 (spr633): undefined
	privileged reg734 (spr634): undefined
	privileged reg735 (spr635): undefined
	privileged reg736 (spr636): undefined
	privileged reg737 (spr637): undefined
	privileged reg738 (spr638): undefined
	privileged reg739 (spr639): undefined
	privileged reg740 (spr640): undefined
	privileged reg741 (spr641): undefined
	privileged reg742 (spr642): undefined
	privileged reg743 (spr643): undefined
	privileged reg744 (spr644): undefined
	privileged reg745 (spr645): undefined
	privileged reg746 (spr646): undefined
	privileged reg747 (spr647): undefined
	privileged reg748 (spr648): undefined
	privileged reg749 (spr649): undefined
	privileged reg750 (spr650): undefined
	privileged reg751 (spr651): undefined
	privileged reg752 (spr652): undefined
	privileged reg753 (spr653): undefined
	privileged reg754 (spr654): undefined
	privileged reg755 (spr655): undefined
	privileged reg756 (spr656): undefined
	privileged reg757 (spr657): undefined
	privileged reg758 (spr658): undefined
	privileged reg759 (spr659): undefined
	privileged reg760 (spr660): undefined
	privileged reg761 (spr661): undefined
	privileged reg762 (spr662): undefined
	privileged reg763 (spr663): undefined
	privileged reg764 (spr664): undefined
	privileged reg765 (spr665): undefined
	privileged reg766 (spr666): undefined
	privileged reg767 (spr667): undefined
	privileged reg768 (spr668): undefined
	privileged reg769 (spr669): undefined
	privileged reg770 (spr670): undefined
	privileged reg771 (spr671): undefined
	privileged reg772 (spr672): undefined
	privileged reg773 (spr673): undefined
	privileged reg774 (spr674): undefined
	privileged reg775 (spr675): undefined
	privileged reg776 (spr676): undefined
	privileged reg777 (spr677): undefined
	privileged reg778 (spr678): undefined
	privileged reg779 (spr679): undefined
	privileged reg780 (spr680): undefined
	privileged reg781 (spr681): undefined
	privileged reg782 (spr682): undefined
	privileged reg783 (spr683): undefined
	privileged reg784 (spr684): undefined
	privileged reg785 (spr685): undefined
	privileged reg786 (spr686): undefined
	privileged reg787 (spr687): undefined
	privileged reg788 (spr688): undefined
	privileged reg789 (spr689): undefined
	privileged reg790 (spr690): undefined
	privileged reg791 (spr691): undefined
	privileged reg792 (spr692): undefined
	privileged reg793 (spr693): undefined
	privileged reg794 (spr694): undefined
	privileged reg795 (spr695): undefined
	privileged reg796 (spr696): undefined
	privileged reg797 (spr697): undefined
	privileged reg798 (spr698): undefined
	privileged reg799 (spr699): undefined
	privileged reg800 (spr700): undefined
	privileged reg801 (spr701): undefined
	privileged reg802 (spr702): undefined
	privileged reg803 (spr703): undefined
	privileged reg804 (spr704): undefined
	privileged reg805 (spr705): undefined
	privileged reg806 (spr706): undefined
	privileged reg807 (spr707): undefined
	privileged reg808 (spr708): undefined
	privileged reg809 (spr709): undefined
	privileged reg810 (spr710): undefined
	privileged reg811 (spr711): undefined
	privileged reg812 (spr712): undefined
	privileged reg813 (spr713): undefined
	privileged reg814 (spr714): undefined
	privileged reg815 (spr715): undefined
	privileged reg816 (spr716): undefined
	privileged reg817 (spr717): undefined
	privileged reg818 (spr718): undefined
	privileged reg819 (spr719): undefined
	privileged reg820 (spr720): undefined
	privileged reg821 (spr721): undefined
	privileged reg822 (spr722): undefined
	privileged reg823 (spr723): undefined
	privileged reg824 (spr724): undefined
	privileged reg825 (spr725): undefined
	privileged reg826 (spr726): undefined
	privileged reg827 (spr727): undefined
	privileged reg828 (spr728): undefined
	privileged reg829 (spr729): undefined
	privileged reg830 (spr730): undefined
	privileged reg831 (spr731): undefined
	privileged reg832 (spr732): undefined
	privileged reg833 (spr733): undefined
	privileged reg834 (spr734): undefined
	privileged reg835 (spr735): undefined
	privileged reg836 (spr736): undefined
	privileged reg837 (spr737): undefined
	privileged reg838 (spr738): undefined
	privileged reg839 (spr739): undefined
	privileged reg840 (spr740): undefined
	privileged reg841 (spr741): undefined
	privileged reg842 (spr742): undefined
	privileged reg843 (spr743): undefined
	privileged reg844 (spr744): undefined
	privileged reg845 (spr745): undefined
	privileged reg846 (spr746): undefined
	privileged reg847 (spr747): undefined
	privileged reg848 (spr748): undefined
	privileged reg849 (spr749): undefined
	privileged reg850 (spr750): undefined
	privileged reg851 (spr751): undefined
	privileged reg852 (spr752): undefined
	privileged reg853 (spr753): undefined
	privileged reg854 (spr754): undefined
	privileged reg855 (spr755): undefined
	privileged reg856 (spr756): undefined
	privileged reg857 (spr757): undefined
	privileged reg858 (spr758): undefined
	privileged reg859 (spr759): undefined
	privileged reg860 (spr760): undefined
	privileged reg861 (spr761): undefined
	privileged reg862 (spr762): undefined
	privileged reg863 (spr763): undefined
	privileged reg864 (spr764): undefined
	privileged reg865 (spr765): undefined
	privileged reg866 (spr766): undefined
	privileged reg867 (spr767): undefined
	privileged reg868 (spr768): undefined
	privileged reg869 (spr769): undefined
	privileged reg870 (spr770): undefined
	privileged reg871 (spr771): undefined
	privileged reg872 (spr772): undefined
	privileged reg873 (spr773): undefined
	privileged reg874 (spr774): undefined
	privileged reg875 (spr775): undefined
	privileged reg876 (spr776): undefined
	privileged reg877 (spr777): undefined
	privileged reg878 (spr778): undefined
	privileged reg879 (spr779): undefined
	privileged reg880 (spr780): undefined
	privileged reg881 (spr781): undefined
	privileged reg882 (spr782): undefined
	privileged reg883 (spr783): undefined
	privileged reg884 (spr784): undefined
	privileged reg885 (spr785): undefined
	privileged reg886 (spr786): undefined
	privileged reg887 (spr787): undefined
	privileged reg888 (spr788): undefined
	privileged reg889 (spr789): undefined
	privileged reg890 (spr790): undefined
	privileged reg891 (spr791): undefined
	privileged reg892 (spr792): undefined
	privileged reg893 (spr793): undefined
	privileged reg894 (spr794): undefined
	privileged reg895 (spr795): undefined
	privileged reg896 (spr796): undefined
	privileged reg897 (spr797): undefined
	privileged reg898 (spr798): undefined
	privileged reg899 (spr799): undefined
	privileged reg900 (spr800): undefined
	privileged reg901 (spr801): undefined
	privileged reg902 (spr802): undefined
	privileged reg903 (spr803): undefined
	privileged reg904 (spr804): undefined
	privileged reg905 (spr805): undefined
	privileged reg906 (spr806): undefined
	privileged reg907 (spr807): undefined
	privileged reg908 (spr808): undefined
	privileged reg909 (spr809): undefined
	privileged reg910 (spr810): undefined
	privileged reg911 (spr811): undefined
	privileged reg912 (spr812): undefined
	privileged reg913 (spr813): undefined
	privileged reg914 (spr814): undefined
	privileged reg915 (spr815): undefined
	privileged reg916 (spr816): undefined
	privileged reg917 (spr817): undefined
	privileged reg918 (spr818): undefined
	privileged reg919 (spr819): undefined
	privileged reg920 (spr820): undefined
	privileged reg921 (spr821): undefined
	privileged reg922 (spr822): undefined
	privileged reg923 (spr823): undefined
	privileged reg924 (spr824): undefined
	privileged reg925 (spr825): undefined
	privileged reg926 (spr826): undefined
	privileged reg927 (spr827): undefined
	privileged reg928 (spr828): undefined
	privileged reg929 (spr829): undefined
	privileged reg930 (spr830): undefined
	privileged reg931 (spr831): undefined
	privileged reg932 (spr832): undefined
	privileged reg933 (spr833): undefined
	privileged reg934 (spr834): undefined
	privileged reg935 (spr835): undefined
	privileged reg936 (spr836): undefined
	privileged reg937 (spr837): undefined
	privileged reg938 (spr838): undefined
	privileged reg939 (spr839): undefined
	privileged reg940 (spr840): undefined
	privileged reg941 (spr841): undefined
	privileged reg942 (spr842): undefined
	privileged reg943 (spr843): undefined
	privileged reg944 (spr844): undefined
	privileged reg945 (spr845): undefined
	privileged reg946 (spr846): undefined
	privileged reg947 (spr847): undefined
	privileged reg948 (spr848): undefined
	privileged reg949 (spr849): undefined
	privileged reg950 (spr850): undefined
	privileged reg951 (spr851): undefined
	privileged reg952 (spr852): undefined
	privileged reg953 (spr853): undefined
	privileged reg954 (spr854): undefined
	privileged reg955 (spr855): undefined
	privileged reg956 (spr856): undefined
	privileged reg957 (spr857): undefined
	privileged reg958 (spr858): undefined
	privileged reg959 (spr859): undefined
	privileged reg960 (spr860): undefined
	privileged reg961 (spr861): undefined
	privileged reg962 (spr862): undefined
	privileged reg963 (spr863): undefined
	privileged reg964 (spr864): undefined
	privileged reg965 (spr865): undefined
	privileged reg966 (spr866): undefined
	privileged reg967 (spr867): undefined
	privileged reg968 (spr868): undefined
	privileged reg969 (spr869): undefined
	privileged reg970 (spr870): undefined
	privileged reg971 (spr871): undefined
	privileged reg972 (spr872): undefined
	privileged reg973 (spr873): undefined
	privileged reg974 (spr874): undefined
	privileged reg975 (spr875): undefined
	privileged reg976 (spr876): undefined
	privileged reg977 (spr877): undefined
	privileged reg978 (spr878): undefined
	privileged reg979 (spr879): undefined
	privileged reg980 (spr880): undefined
	privileged reg981 (spr881): undefined
	privileged reg982 (spr882): undefined
	privileged reg983 (spr883): undefined
	privileged reg984 (spr884): undefined
	privileged reg985 (spr885): undefined
	privileged reg986 (spr886): undefined
	privileged reg987 (spr887): undefined
	privileged reg988 (spr888): undefined
	privileged reg989 (spr889): undefined
	privileged reg990 (spr890): undefined
	privileged reg991 (spr891): undefined
	privileged reg992 (spr892): undefined
	privileged reg993 (spr893): undefined
	privileged reg994 (spr894): undefined
	privileged reg995 (spr895): undefined
	privileged reg996 (spr896): undefined
	privileged reg997 (spr897): undefined
	privileged reg998 (spr898): undefined
	privileged reg999 (spr899): undefined
	vector reg1124 (vr0): undefined
	vector reg1125 (vr1): undefined
	vector reg1126 (vr2): undefined
	vector reg1127 (vr3): undefined
	vector reg1128 (vr4): undefined
	vector reg1129 (vr5): undefined
	vector reg1130 (vr6): undefined
	vector reg1131 (vr7): undefined
	vector reg1132 (vr8): undefined
	vector reg1133 (vr9): undefined
	vector reg1134 (vr10): undefined
	vector reg1135 (vr11): undefined
	vector reg1136 (vr12): undefined
	vector reg1137 (vr13): undefined
	vector reg1138 (vr14): undefined
	vector reg1139 (vr15): undefined
	vector reg1140 (vr16): undefined
	vector reg1141 (vr17): undefined
	vector reg1142 (vr18): undefined
	vector reg1143 (vr19): undefined
	vector reg1144 (vr20): undefined
	vector reg1145 (vr21): undefined
	vector reg1146 (vr22): undefined
	vector reg1147 (vr23): undefined
	vector reg1148 (vr24): undefined
	vector reg1149 (vr25): undefined
	vector reg1150 (vr26): undefined
	vector reg1151 (vr27): undefined
	vector reg1152 (vr28): undefined
	vector reg1153 (vr29): undefined
	vector reg1154 (vr30): undefined
	vector reg1155 (vr31): undefined
EOF

# EM_S390 (ELFCLASS32) (function bar 0x4004d8)
# Note. Only in .eh_frame, there is no .debug_frame.
# Same as PPC above but with -m31.
testfiles testfiles390
testrun_compare ${abs_builddir}/addrcfi -e testfiles390 0x4004d8 <<\EOF
.eh_frame has 0x4004d8 => [0x4004d8, 0x4004e8):
	return address in reg14
	CFA location expression: bregx(15,96)
	integer reg0 (%r0): undefined
	integer reg1 (%r1): undefined
	integer reg2 (%r2): undefined
	integer reg3 (%r3): undefined
	integer reg4 (%r4): undefined
	integer reg5 (%r5): undefined
	integer reg6 (%r6): same_value
	integer reg7 (%r7): same_value
	integer reg8 (%r8): same_value
	integer reg9 (%r9): same_value
	integer reg10 (%r10): same_value
	integer reg11 (%r11): same_value
	integer reg12 (%r12): same_value
	integer reg13 (%r13): same_value
	integer reg14 (%r14): same_value
	integer reg15 (%r15): same_value
	FPU reg16 (%f0): undefined
	FPU reg17 (%f2): undefined
	FPU reg18 (%f4): undefined
	FPU reg19 (%f6): undefined
	FPU reg20 (%f1): undefined
	FPU reg21 (%f3): undefined
	FPU reg22 (%f5): undefined
	FPU reg23 (%f7): undefined
	FPU reg24 (%f8): same_value
	FPU reg25 (%f10): same_value
	FPU reg26 (%f12): same_value
	FPU reg27 (%f14): same_value
	FPU reg28 (%f9): same_value
	FPU reg29 (%f11): same_value
	FPU reg30 (%f13): same_value
	FPU reg31 (%f15): same_value
	control reg32 (%c0): undefined
	control reg33 (%c1): undefined
	control reg34 (%c2): undefined
	control reg35 (%c3): undefined
	control reg36 (%c4): undefined
	control reg37 (%c5): undefined
	control reg38 (%c6): undefined
	control reg39 (%c7): undefined
	control reg40 (%c8): undefined
	control reg41 (%c9): undefined
	control reg42 (%c10): undefined
	control reg43 (%c11): undefined
	control reg44 (%c12): undefined
	control reg45 (%c13): undefined
	control reg46 (%c14): undefined
	control reg47 (%c15): undefined
	access reg48 (%a0): undefined
	access reg49 (%a1): undefined
	access reg50 (%a2): undefined
	access reg51 (%a3): undefined
	access reg52 (%a4): undefined
	access reg53 (%a5): undefined
	access reg54 (%a6): undefined
	access reg55 (%a7): undefined
	access reg56 (%a8): undefined
	access reg57 (%a9): undefined
	access reg58 (%a10): undefined
	access reg59 (%a11): undefined
	access reg60 (%a12): undefined
	access reg61 (%a13): undefined
	access reg62 (%a14): undefined
	access reg63 (%a15): undefined
	control reg64 (%pswm): undefined
	control reg65 (%pswa): undefined
handle_cfi no CFI (.debug_frame): no error
EOF

# EM_S390 (ELFCLASS64) (function bar 0x0000000080000510)
# Note. Only in .eh_frame, there is no .debug_frame.
# Same as s390 above but without -m31.
testfiles testfiles390x
testrun_compare ${abs_builddir}/addrcfi -e testfiles390x 0x0000000080000510 <<\EOF
.eh_frame has 0x80000510 => [0x80000510, 0x80000524):
	return address in reg14
	CFA location expression: bregx(15,160)
	integer reg0 (%r0): undefined
	integer reg1 (%r1): undefined
	integer reg2 (%r2): undefined
	integer reg3 (%r3): undefined
	integer reg4 (%r4): undefined
	integer reg5 (%r5): undefined
	integer reg6 (%r6): same_value
	integer reg7 (%r7): same_value
	integer reg8 (%r8): same_value
	integer reg9 (%r9): same_value
	integer reg10 (%r10): same_value
	integer reg11 (%r11): same_value
	integer reg12 (%r12): same_value
	integer reg13 (%r13): same_value
	integer reg14 (%r14): same_value
	integer reg15 (%r15): same_value
	FPU reg16 (%f0): undefined
	FPU reg17 (%f2): undefined
	FPU reg18 (%f4): undefined
	FPU reg19 (%f6): undefined
	FPU reg20 (%f1): undefined
	FPU reg21 (%f3): undefined
	FPU reg22 (%f5): undefined
	FPU reg23 (%f7): undefined
	FPU reg24 (%f8): same_value
	FPU reg25 (%f10): same_value
	FPU reg26 (%f12): same_value
	FPU reg27 (%f14): same_value
	FPU reg28 (%f9): same_value
	FPU reg29 (%f11): same_value
	FPU reg30 (%f13): same_value
	FPU reg31 (%f15): same_value
	control reg32 (%c0): undefined
	control reg33 (%c1): undefined
	control reg34 (%c2): undefined
	control reg35 (%c3): undefined
	control reg36 (%c4): undefined
	control reg37 (%c5): undefined
	control reg38 (%c6): undefined
	control reg39 (%c7): undefined
	control reg40 (%c8): undefined
	control reg41 (%c9): undefined
	control reg42 (%c10): undefined
	control reg43 (%c11): undefined
	control reg44 (%c12): undefined
	control reg45 (%c13): undefined
	control reg46 (%c14): undefined
	control reg47 (%c15): undefined
	access reg48 (%a0): undefined
	access reg49 (%a1): undefined
	access reg50 (%a2): undefined
	access reg51 (%a3): undefined
	access reg52 (%a4): undefined
	access reg53 (%a5): undefined
	access reg54 (%a6): undefined
	access reg55 (%a7): undefined
	access reg56 (%a8): undefined
	access reg57 (%a9): undefined
	access reg58 (%a10): undefined
	access reg59 (%a11): undefined
	access reg60 (%a12): undefined
	access reg61 (%a13): undefined
	access reg62 (%a14): undefined
	access reg63 (%a15): undefined
	control reg64 (%pswm): undefined
	control reg65 (%pswa): undefined
handle_cfi no CFI (.debug_frame): no error
EOF

# EM_ARM (function bar 0x00008510)
# Note. Only in .debug_frame, the .eh_frame is actually empty.
# Same as s390 and ppc above.
testfiles testfilearm
testrun_compare ${abs_builddir}/addrcfi -e testfilearm 0x00008510 <<\EOF
dwarf_cfi_addrframe (.eh_frame): no matching address range
.debug_frame has 0x8510 => [0x8510, 0x8524):
	return address in reg14
	CFA location expression: bregx(13)
	integer reg0 (r0): undefined
	integer reg1 (r1): undefined
	integer reg2 (r2): undefined
	integer reg3 (r3): undefined
	integer reg4 (r4): same_value
	integer reg5 (r5): same_value
	integer reg6 (r6): same_value
	integer reg7 (r7): same_value
	integer reg8 (r8): same_value
	integer reg9 (r9): undefined
	integer reg10 (r10): same_value
	integer reg11 (r11): same_value
	integer reg12 (r12): undefined
	integer reg13 (sp): location expression: call_frame_cfa stack_value
	integer reg14 (lr): same_value
	integer reg15 (pc): location expression: regx(14)
	FPA reg16 (f0): undefined
	FPA reg17 (f1): undefined
	FPA reg18 (f2): undefined
	FPA reg19 (f3): undefined
	FPA reg20 (f4): undefined
	FPA reg21 (f5): undefined
	FPA reg22 (f6): undefined
	FPA reg23 (f7): undefined
	FPA reg96 (f0): undefined
	FPA reg97 (f1): undefined
	FPA reg98 (f2): undefined
	FPA reg99 (f3): undefined
	FPA reg100 (f4): undefined
	FPA reg101 (f5): undefined
	FPA reg102 (f6): undefined
	FPA reg103 (f7): undefined
	integer reg128 (spsr): undefined
	VFP reg256 (d0): undefined
	VFP reg257 (d1): undefined
	VFP reg258 (d2): undefined
	VFP reg259 (d3): undefined
	VFP reg260 (d4): undefined
	VFP reg261 (d5): undefined
	VFP reg262 (d6): undefined
	VFP reg263 (d7): undefined
	VFP reg264 (d8): same_value
	VFP reg265 (d9): same_value
	VFP reg266 (d10): same_value
	VFP reg267 (d11): same_value
	VFP reg268 (d12): same_value
	VFP reg269 (d13): same_value
	VFP reg270 (d14): same_value
	VFP reg271 (d15): same_value
	VFP reg272 (d16): undefined
	VFP reg273 (d17): undefined
	VFP reg274 (d18): undefined
	VFP reg275 (d19): undefined
	VFP reg276 (d20): undefined
	VFP reg277 (d21): undefined
	VFP reg278 (d22): undefined
	VFP reg279 (d23): undefined
	VFP reg280 (d24): undefined
	VFP reg281 (d25): undefined
	VFP reg282 (d26): undefined
	VFP reg283 (d27): undefined
	VFP reg284 (d28): undefined
	VFP reg285 (d29): undefined
	VFP reg286 (d30): undefined
	VFP reg287 (d31): undefined
EOF

# EM_AARCH64 (function bar 0x400550)
# Same as arm, 390 and ppc above.
# Note missing coverage in .eh_frame.
testfiles testfileaarch64
testrun_compare ${abs_builddir}/addrcfi -e testfileaarch64 0x400550 <<\EOF
dwarf_cfi_addrframe (.eh_frame): no matching address range
.debug_frame has 0x400550 => [0x400550, 0x400568):
	return address in reg30
	CFA location expression: bregx(31)
	integer reg0 (x0): undefined
	integer reg1 (x1): undefined
	integer reg2 (x2): undefined
	integer reg3 (x3): undefined
	integer reg4 (x4): undefined
	integer reg5 (x5): undefined
	integer reg6 (x6): undefined
	integer reg7 (x7): undefined
	integer reg8 (x8): undefined
	integer reg9 (x9): undefined
	integer reg10 (x10): undefined
	integer reg11 (x11): undefined
	integer reg12 (x12): undefined
	integer reg13 (x13): undefined
	integer reg14 (x14): undefined
	integer reg15 (x15): undefined
	integer reg16 (x16): undefined
	integer reg17 (x17): undefined
	integer reg18 (x18): undefined
	integer reg19 (x19): same_value
	integer reg20 (x20): same_value
	integer reg21 (x21): same_value
	integer reg22 (x22): same_value
	integer reg23 (x23): same_value
	integer reg24 (x24): same_value
	integer reg25 (x25): same_value
	integer reg26 (x26): same_value
	integer reg27 (x27): same_value
	integer reg28 (x28): same_value
	integer reg29 (x29): same_value
	integer reg30 (x30): same_value
	integer reg31 (sp): undefined
	integer reg33 (elr): undefined
	FP/SIMD reg64 (v0): undefined
	FP/SIMD reg65 (v1): undefined
	FP/SIMD reg66 (v2): undefined
	FP/SIMD reg67 (v3): undefined
	FP/SIMD reg68 (v4): undefined
	FP/SIMD reg69 (v5): undefined
	FP/SIMD reg70 (v6): undefined
	FP/SIMD reg71 (v7): undefined
	FP/SIMD reg72 (v8): same_value
	FP/SIMD reg73 (v9): same_value
	FP/SIMD reg74 (v10): same_value
	FP/SIMD reg75 (v11): same_value
	FP/SIMD reg76 (v12): same_value
	FP/SIMD reg77 (v13): same_value
	FP/SIMD reg78 (v14): same_value
	FP/SIMD reg79 (v15): same_value
	FP/SIMD reg80 (v16): undefined
	FP/SIMD reg81 (v17): undefined
	FP/SIMD reg82 (v18): undefined
	FP/SIMD reg83 (v19): undefined
	FP/SIMD reg84 (v20): undefined
	FP/SIMD reg85 (v21): undefined
	FP/SIMD reg86 (v22): undefined
	FP/SIMD reg87 (v23): undefined
	FP/SIMD reg88 (v24): undefined
	FP/SIMD reg89 (v25): undefined
	FP/SIMD reg90 (v26): undefined
	FP/SIMD reg91 (v27): undefined
	FP/SIMD reg92 (v28): undefined
	FP/SIMD reg93 (v29): undefined
	FP/SIMD reg94 (v30): undefined
	FP/SIMD reg95 (v31): undefined
EOF

# EM_X86_64/ELFCLASS32 (function bar 0x00400390)
#
# Note. Only in .eh_frame, there is no .debug_frame.
# Same as PPC above but with -mx32.
testfiles testfile-x32
testrun_compare ${abs_builddir}/addrcfi -e testfile-x32 0x00400390 <<\EOF
.eh_frame has 0x400390 => [0x400390, 0x40039c):
	return address in reg16
	CFA location expression: bregx(7,8)
	integer reg0 (%rax): same_value
	integer reg1 (%rdx): undefined
	integer reg2 (%rcx): undefined
	integer reg3 (%rbx): undefined
	integer reg4 (%rsi): undefined
	integer reg5 (%rdi): undefined
	integer reg6 (%rbp): same_value
	integer reg7 (%rsp): location expression: call_frame_cfa stack_value
	integer reg8 (%r8): undefined
	integer reg9 (%r9): undefined
	integer reg10 (%r10): undefined
	integer reg11 (%r11): undefined
	integer reg12 (%r12): same_value
	integer reg13 (%r13): same_value
	integer reg14 (%r14): same_value
	integer reg15 (%r15): same_value
	integer reg16 (%rip): location expression: call_frame_cfa plus_uconst(-8)
	SSE reg17 (%xmm0): undefined
	SSE reg18 (%xmm1): undefined
	SSE reg19 (%xmm2): undefined
	SSE reg20 (%xmm3): undefined
	SSE reg21 (%xmm4): undefined
	SSE reg22 (%xmm5): undefined
	SSE reg23 (%xmm6): undefined
	SSE reg24 (%xmm7): undefined
	SSE reg25 (%xmm8): undefined
	SSE reg26 (%xmm9): undefined
	SSE reg27 (%xmm10): undefined
	SSE reg28 (%xmm11): undefined
	SSE reg29 (%xmm12): undefined
	SSE reg30 (%xmm13): undefined
	SSE reg31 (%xmm14): undefined
	SSE reg32 (%xmm15): undefined
	x87 reg33 (%st0): undefined
	x87 reg34 (%st1): undefined
	x87 reg35 (%st2): undefined
	x87 reg36 (%st3): undefined
	x87 reg37 (%st4): undefined
	x87 reg38 (%st5): undefined
	x87 reg39 (%st6): undefined
	x87 reg40 (%st7): undefined
	MMX reg41 (%mm0): undefined
	MMX reg42 (%mm1): undefined
	MMX reg43 (%mm2): undefined
	MMX reg44 (%mm3): undefined
	MMX reg45 (%mm4): undefined
	MMX reg46 (%mm5): undefined
	MMX reg47 (%mm6): undefined
	MMX reg48 (%mm7): undefined
	integer reg49 (%rflags): undefined
	segment reg50 (%es): undefined
	segment reg51 (%cs): undefined
	segment reg52 (%ss): undefined
	segment reg53 (%ds): undefined
	segment reg54 (%fs): undefined
	segment reg55 (%gs): undefined
	segment reg58 (%fs.base): undefined
	segment reg59 (%gs.base): undefined
	control reg62 (%tr): undefined
	control reg63 (%ldtr): undefined
	control reg64 (%mxcsr): undefined
	control reg65 (%fcw): undefined
	control reg66 (%fsw): undefined
handle_cfi no CFI (.debug_frame): no error
EOF
