#******************************************************************************
#*
#* ====================================================
#* Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
#*
#* Developed at SunPro, a Sun Microsystems, Inc. business.
#* Permission to use, copy, modify, and distribute this
#* software is freely granted, provided that this notice
#* is preserved.
#* ====================================================
#*
#* Copyright (c) 2004 Freescale Semiconductor, Inc
#* All rights reserved.
#*
#* Redistribution and use in source and binary forms, with or without
#* modification, are permitted provided that the following conditions are met:
#*     * Redistributions of source code must retain the above copyright
#*       notice, this list of conditions and the following disclaimer.
#*     * Redistributions in binary form must reproduce the above copyright
#*       notice, this list of conditions and the following disclaimer in the
#*       documentation and/or other materials provided with the distribution.
#*     * Neither the name of Freescale Semiconductor nor the
#*       names of its contributors may be used to endorse or promote products
#*       derived from this software without specific prior written permission.
#*
#* THIS SOFTWARE IS PROVIDED BY Freescale Semiconductor ``AS IS'' AND ANY
#* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#* DISCLAIMED. IN NO EVENT SHALL Freescale Semiconductor BE LIABLE FOR ANY
#* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#*
#*  Functions:    log, log10
#*
#*  Description:  implements floating point double precision
#*                software emulation for log() and log10() functions
#*                from MATH library (libmath)
#*
#*  Notes:        none
#*
#******************************************************************************

#include <powerpc/asm.h>


#define r0 0
#define r1 1
#define r2 2
#define r3 3
#define r4 4
#define r5 5
#define r6 6
#define r7 7
#define r8 8
#define r9 9
#define r10 10
#define r11 11
#define r12 12
#define r13 13
#define r14 14
#define r15 15
#define r16 16
#define r17 17
#define r18 18
#define r19 19
#define r20 20
#define r21 21
#define r22 22
#define r23 23
#define r24 24
#define r25 25
#define r26 26
#define r27 27
#define r28 28
#define r29 29
#define r30 30
#define r31 31

	.extern	__muldf3
	.extern	__divdf3
	.extern	__adddf3
	.extern	__subdf3
	.extern	__floatsidf

	.section	".text"

/*******************************************
*	fast implementation of log         *
*******************************************/
	.align  2

ENTRY(__ieee754_log)
#ifdef _SOFT_DOUBLE
#define hx r3
#define lx r4

#define y 19
#define k 20
#define xhi 21
#define dhi 22
#define dlo 23
#define fhi 24
#define flo 25
#define shi 26
#define slo 27
#define whi 28
#define wlo 29
#define zhi 30
#define zlo 31

	lis	r5,	0x7ff0
	lis	r6,	0x0010
	clrlwi	r0,	hx,	1		# |hx|
	or.	r0,	r0,	lx		# if x = 0

	cmpwi	cr1,	hx,	0		# sign in cr1
	cmpw	cr5,	hx,	r5		# if x is Inf or NaN
	cmpw	cr6,	hx,	r6		# if x < 2**-1022

	beq-	cr0,	L(log_return_ninf)		# log(+-0) = -Inf
	blt-	cr1,	L(log_return_nan)		# log(-x) = NaN
	bgelr-	cr5				# log(+Inf/NaN) = +Inf/NaN

	stwu	r1,	-64(r1)
	mflr	r0
	stw	r0,	68(r1)
	stmw	r18,	8(r1)

	li	r0,	0			# k = 0
	bge+	cr6,	L(log_argument_reduction)

	lis	r5,	0x4350			# 2**54
	li	r6,	0
	bl	JUMP_TARGET(__muldf3)			# x = x * 2**54
	li	r0,	-54			# k = -54

L(log_argument_reduction):
	srawi	r5,	hx,	20		# k += (hx>>20) - 1023
	addi	r5,	r5,	-1023
	add	r0,	r0,	r5

	clrlwi	hx,	hx,	12		# hx &= 0x000fffff
	mr	xhi,	hx

	lis	r6,	0x0009			# i = (hx+0x95f64)&0x100000
	ori	r6, r6,	0x5f64
	add	r6,	r6,	hx
	andis.	r6,	r6,	0x0010

	srawi	r7,	r6,	20		# k += i>>20
	add	r0,	r0,	r7
	mr	k,	r0

	xoris	r6,	r6,	0x3ff0		# HI(x) = hx|(i^0x3ff00000)
	or	hx,	hx,	r6		# normalize x

	lis	r5,	0x3ff0			# f = x - 1.0
	li	r6,	0
	bl	JUMP_TARGET(__subdf3)
	mr	fhi,	r3
	mr	flo,	r4

	mr	r3,	k
	bl	JUMP_TARGET(__floatsidf)			# dk = (double) k
	mr	dhi,	r3
	mr	dlo,	r4

	addi	r5,	xhi,	+2
	clrlwi	r5,	r5,	12
	or	r6,	fhi,	flo

	cmpwi	cr5,	r5,	3		# if ((0x000fffff&(2+hx)) < 3)
	cmpwi	cr6,	r6,	0		# if f == 0

	bge+	cr5,	L(log_calculation)
	beq-	cr6,	L(log_zero_f)

	mr	r3,	fhi
	mr	r4,	flo
	lis	r5,	0x3FD5
	ori	r5, r5,	0x5555
	lis	r6,	0x5555
	ori	r6, r6,	0x5555
	bl	JUMP_TARGET(__muldf3)			# f*0.3333333333333

	mr	r5,	r3
	mr	r6,	r4
	lis	r3,	0x3fe0
	lis	r4,	0
	bl	JUMP_TARGET(__subdf3)			# 0.5 - f*0.3333333333333

	mr	r5,	fhi
	mr	r6,	flo
	bl	JUMP_TARGET(__muldf3)			# f*(0.5 - f*0.3333333333333)

	mr	r5,	fhi
	mr	r6,	flo
	bl	JUMP_TARGET(__muldf3)			# R = f*f*(0.5 - f*0.3333333333333)

	cmpwi	cr0,	k,	0
	bne+	cr0,	L(log_small_f_non_zero_k)

	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	fhi
	mr	r4,	flo
	bl	JUMP_TARGET(__subdf3)			# log(x) = f - R
	b	L(log_exit)

L(log_zero_f):
	cmpwi	cr0,	k,	0
	beq-	cr0,	L(log_zero_f_zero_k)

	lis	r5,	0x3dea
	ori	r5, r5,	0x39ef
	lis	r6,	0x3579
	ori	r6, r6,	0x3c76
	bl	JUMP_TARGET(__muldf3)			# dk*ln2LO
	mr	fhi,	r3
	mr	flo,	r4			# store result temporary in f

	mr	r3,	dhi
	mr	r4,	dlo
	lis	r5,	0x3fe6
	ori	r5, r5,	0x2e42
	lis	r6,	0xfee0
	bl	JUMP_TARGET(__muldf3)			# dk*ln2HI

	mr	r5,	fhi
	mr	r6,	flo
	bl	JUMP_TARGET(__adddf3)			# dk*ln2HI + dk*ln2LO

	b	L(log_exit)

L(log_zero_f_zero_k):
	li	r3,	0
	li	r4,	0
	b	L(log_exit)

L(log_calculation):
	mr	r3,	fhi
	mr	r4,	flo
	lis	r5,	0x4000
	li	r6,	0
	bl	JUMP_TARGET(__adddf3)			# s = f/(f+2.0)

	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	fhi
	mr	r4,	flo
	bl	JUMP_TARGET(__divdf3)
	mr	shi,	r3
	mr	slo,	r4

	mr	r5,	r3
	mr	r6,	r4
	bl	JUMP_TARGET(__muldf3)			# z = s * s
	mr	zhi,	r3
	mr	zlo,	r4

	mr	r5,	r3
	mr	r6,	r4
	bl	JUMP_TARGET(__muldf3)			# w = z * z
	mr	whi,	r3
	mr	wlo,	r4

	lis	r5,	0x3FC2
	ori	r5, r5,	0xF112
	lis	r6,	0xDF3E
	ori	r6, r6,	0x5244
	bl	JUMP_TARGET(__muldf3)			# w*l7

	lis	r5,	0x3FC7
	ori	r5, r5,	0x4664
	lis	r6,	0x96CB
	ori	r6, r6,	0x03DE
	bl	JUMP_TARGET(__adddf3)			# l5+w*l6

	mr	r5,	whi
	mr	r6,	wlo
	bl	JUMP_TARGET(__muldf3)			# w*(l5+w*l7)

	lis	r5,	0x3FD2
	ori	r5, r5,	0x4924
	lis	r6,	0x9422
	ori	r6, r6,	0x9359
	bl	JUMP_TARGET(__adddf3)			# l3+w*(l5+w*l7)

	mr	r5,	whi
	mr	r6,	wlo
	bl	JUMP_TARGET(__muldf3)			# w*(l3+w*(l5+w*l7))

	lis	r5,	0x3FE5
	ori	r5, r5,	0x5555
	lis	r6,	0x5555
	ori	r6, r6,	0x5593
	bl	JUMP_TARGET(__adddf3)			# l1+w*(l3+w*(l5+w*l7))

	mr	r5,	zhi
	mr	r6,	zlo
	bl	JUMP_TARGET(__muldf3)			# t2 = z*(l1+w*(l3+w*(l5+w*l7)))
	mr	zhi,	r3
	mr	zlo,	r4			# store temporary in z

	mr	r3,	whi
	mr	r4,	wlo
	lis	r5,	0x3FC3
	ori	r5, r5,	0x9A09
	lis	r6,	0xD078
	ori	r6, r6,	0xC69F
	bl	JUMP_TARGET(__muldf3)			# w*l6

	lis	r5,	0x3FCC
	ori	r5, r5,	0x71C5
	lis	r6,	0x1D8E
	ori	r6, r6,	0x78AF
	bl	JUMP_TARGET(__adddf3)			# l4+w*l6

	mr	r5,	whi
	mr	r6,	wlo
	bl	JUMP_TARGET(__muldf3)			# w*(l4+w*l6)

	lis	r5,	0x3FD9
	ori	r5, r5,	0x9999
	lis	r6,	0x9997
	ori	r6, r6,	0xFA04
	bl	JUMP_TARGET(__adddf3)			# l2+w*(l4+w*l6)

	mr	r5,	whi
	mr	r6,	wlo
	bl	JUMP_TARGET(__muldf3)			# t1 = w*(l2+w*(l4+w*l6))

	mr	r5,	zhi
	mr	r6,	zlo
	bl	JUMP_TARGET(__adddf3)			# R = t1+t2

	lis	r8,	0x0006
	ori	r7, r8,	0x147a
	ori	r8, r8, 0xb851
	subf	r9,	r7,	xhi		# i = hx - 0x6147a
	subf	r10,	xhi,	r8		# j = 0x6b851 - hx
	or.	r11,	r9,	r10		# i |= j
	bgt+	cr0,	L(log_positive_i)

	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	fhi
	mr	r4,	flo
	bl	JUMP_TARGET(__subdf3)			# f - R

	mr	r5,	shi
	mr	r6,	slo
	bl	JUMP_TARGET(__muldf3)			# s*(f - R)

	cmpwi	cr0,	k,	0
	beq+	cr0,	L(log_f_not_large)

L(log_small_f_non_zero_k):
	mr	zhi,	r3
	mr	zlo,	r4			# store temporary in z

	mr	r3,	dhi
	mr	r4,	dlo
	lis	r5,	0x3dea
	ori	r5, r5,	0x39ef
	lis	r6,	0x3579
	ori	r6, r6,	0x3c76
	bl	JUMP_TARGET(__muldf3)			# dk*ln2LO

	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	zhi
	mr	r4,	zlo
	bl	JUMP_TARGET(__subdf3)			# s*(f - R) - dk*ln2LO

	b	L(log_better_accuracy)

L(log_positive_i):
	mr	zhi,	r3
	mr	zlo,	r4			# store R temporary in z

	mr	r3,	fhi
	mr	r4,	flo
	mr	r5,	fhi
	mr	r6,	flo
	bl	JUMP_TARGET(__muldf3)
	lis	r5,	0x3fe0
	li	r6,	0
	bl	JUMP_TARGET(__muldf3)
	mr	whi,	r3
	mr	wlo,	r4			# store 'hfsq' temporary in w

	mr	r5,	zhi
	mr	r6,	zlo
	bl	JUMP_TARGET(__adddf3)			# hfsq + R

	mr	r5,	shi
	mr	r6,	slo
	bl	JUMP_TARGET(__muldf3)			# s*(hfsq + R)

	cmpwi	cr0,	k,	0
	beq+	cr0,	L(log_f_not_large1)

	mr	zhi,	r3
	mr	zlo,	r4			# store R temporary in z

	mr	r3,	dhi
	mr	r4,	dlo
	lis	r5,	0x3dea
	ori	r5, r5,	0x39ef
	lis	r6,	0x3579
	ori	r6, r6,	0x3c76
	bl	JUMP_TARGET(__muldf3)			# dk*ln2LO

	mr	r5,	zhi
	mr	r6,	zlo
	bl	JUMP_TARGET(__adddf3)			# s*(f - R) + dk*ln2LO

	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	whi
	mr	r4,	wlo
	bl	JUMP_TARGET(__subdf3)			# hfsq - (s*(f - R) + dk*ln2LO)

L(log_better_accuracy):
	mr	r5,	fhi
	mr	r6,	flo
	bl	JUMP_TARGET(__subdf3)			# (...) - f
	mr	fhi,	r3
	mr	flo,	r4			# store result temporary in f

	mr	r3,	dhi
	mr	r4,	dlo
	lis	r5,	0x3fe6
	ori	r5, r5,	0x2e42
	lis	r6,	0xfee0
	bl	JUMP_TARGET(__muldf3)			# dk*ln2HI

	mr	r5,	fhi
	mr	r6,	flo
	bl	JUMP_TARGET(__subdf3)			# dk*ln2HI - ((...) - f)

	b	L(log_exit)

L(log_f_not_large1):
	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	whi
	mr	r4,	wlo
	bl	JUMP_TARGET(__subdf3)			# hfsq - s*(hfsq + R)

L(log_f_not_large):
	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	fhi
	mr	r4,	flo
	bl	JUMP_TARGET(__subdf3)			# log(x) = f - (...)

L(log_exit):
	lmw	r18,	8(r1)
	lwz	r0,	68(r1)
	mtlr	r0
	addi	r1,	r1,	+64
	blr

L(log_return_ninf):
	lis	r3,	0xfff0
	li	r4,	0
	blr

L(log_return_nan):
	lis	r3,	0x7fff
	li	r4,	0
	blr
#else
#define hx r3
#define lx r4

#define x r4
					/* r5, r6 are reserved */
#define t r7
#define k r8
#define z r9
#define w r10
#define s r11
#define f r12

	lis	r5,	0x7ff0
	lis	r6,	0x0010
	clrlwi	r0,	hx,	1		# |hx|
	or.	r0,	r0,	lx		# if x = 0

	cmpwi	cr1,	hx,	0		# sign in cr1
	cmpw	cr5,	hx,	r5		# if x is Inf or NaN
	cmpw	cr6,	hx,	r6		# if x < 2**-1022

	beq-	cr0,	L(log_return_ninf)		# log(+-0) = -Inf
	blt-	cr1,	L(log_return_nan)		# log(-x) = NaN
	bgelr-	cr5				# log(+Inf/NaN) = +Inf/NaN

	li	k,	0			# k = 0
	bge+	cr6,	L(log_argument_reduction)

	li	k,	-54			# k = -54

	cmpwi	cr0,	hx,	0
	bne+	cr0,	L(log_denorm_small_shift)

	cntlzw	r5,	lx			# r5 = N = number of leading 0s
	cmpwi	cr5,	r5,	11
	blt+	cr5,	L(log_denorm_middle_shift)

L(log_denorm_big_shift):
	addi	r6,	r5,	-11
	slw	hx,	lx,	r6
	clrlwi	hx,	hx,	12		# remove leading one
	li	lx,	0
	addi	r5,	r5,	+21
	b	L(log_denorm_calc_exp)

L(log_denorm_middle_shift):
	li	r6,	11
	sub	r6,	r6,	r5		# r6 = 11 - N
	srw	hx,	lx,	r6
	clrlwi	hx,	hx,	12		# remove leading one
	addi	r5,	r5,	+21
	slw	lx,	lx,	r5
	b	L(log_denorm_calc_exp)

L(log_denorm_small_shift):
	cntlzw	r5,	hx			# r5 = N = number of leading 0s
	addi	r5,	r5,	-11		# discard zeroes in exp
	slw	hx,	hx,	r5
	li	r6,	32
	sub	r6,	r6,	r5		# r6 = 32 - N
	srw	r6,	lx,	r6
	or	hx,	hx,	r6
	clrlwi	hx,	hx,	12		# remove leading one
	slw	lx,	lx,	r5
L(log_denorm_calc_exp):
	li	r6,	+55			# 54!!!
	sub	r6,	r6,	r5		# calculate exp
	slwi	r6,	r6,	20
	or	hx,	hx,	r6

L(log_argument_reduction):
	srawi	r5,	hx,	20		# k += (hx>>20) - 1023
	addi	r5,	r5,	-1023
	add	k,	k,	r5

	clrlwi	hx,	hx,	12		# hx &= 0x000fffff

	lis	r6,	0x0009			# i = (hx+0x95f64)&0x100000
	ori	r6, r6,	0x5f64
	add	r6,	r6,	hx
	andis.	r6,	r6,	0x0010

	srawi	r5,	r6,	20		# k += i>>20
	add	k,	k,	r5

	xoris	r7,	r6,	0x3ff0		# HI(x) = hx|(i^0x3ff00000)
	or	r7,	r7,	hx		# normalize x
	evmergelo	x,	r7,lx		# merge x

	lis	r5,	0x3ff0
	li	r6,	0
	evmergelo	t,	r5,r6		# t = 1.0
	efdsub	f,	x,	t		# f = x - 1.0

	addi	r5,	hx,	+2
	clrlwi	r5,	r5,	12
	evmergelohi	t,	f,	f
	or.	t,	t,	f

	cmpwi	cr5,	r5,	3		# if ((0x000fffff&(2+hx)) < 3)

	bge+	cr5,	L(log_calculation)
	beq-	cr0,	L(log_zero_f)

	lis	r5,	0x3FD5
	ori	r5, r5,	0x5555
	lis	r6,	0x5555
	ori	r6, r6,	0x5555
	evmergelo	t,	r5,r6		# t = 0.3(3)
	efdmul	x,	f,	t		# x = f*0.3(3)

	lis	r5,	0x3fe0
	lis	r6,	0
	evmergelo	t,	r5,r6		# t = 0.5
	efdsub	x,	t,	x		# x = 0.5 - x*0.3(3)
	efdmul	x,	x,	f		# x = f*(0.5 - f*0.3333333333333)
	efdmul	x,	x,	f		# x = f*f*(0.5 - f*0.3333333333333)

	cmpwi	cr1,	k,	0
	bne+	cr1,	L(log_small_f_non_zero_k)

	efdsub	x,	f,	x		# log(x) = f - x
	evmergelohi	hx,	lx,	x	# split result
	blr

L(log_zero_f):
	cmpwi	cr1,	k,	0
	beq-	cr1,	L(log_zero_f_zero_k)

	efdcfsi	k,	k			# dk = (double) k

	lis	r5,	0x3dea
	ori	r5, r5,	0x39ef
	lis	r6,	0x3579
	ori	r6, r6,	0x3c76
	evmergelo	t,	r5,r6		# t = ln2LO
	efdmul	x,	k,	t		# x = k*ln2LO

	lis	r5,	0x3fe6
	ori	r5, r5,	0x2e42
	lis	r6,	0xfee0
	evmergelo	t,	r5,r6		# t = ln2HI
	efdmul	f,	k,	t		# f = k*ln2HI
	efdadd	x,	x,	f		# x = f + x
	evmergelohi	hx,	lx,	x	# split result
	blr

L(log_zero_f_zero_k):
	li	r3,	0
	li	r4,	0
	blr

L(log_calculation):
	lis	r5,	0x4000
	li	r6,	0
	evmergelo	t,	r5,r6		# t = 2.0
	efdadd	s,	f,	t
	efddiv	s,	f,	s		# s = f/(f+2.0)
	efdmul	z,	s,	s		# z = s * s
	efdmul	w,	z,	z		# w = z * z

	lis	r5,	0x3FC2
	ori	r5, r5,	0xF112
	lis	r6,	0xDF3E
	ori	r6, r6,	0x5244
	evmergelo	t,	r5,r6		# t = l7
	efdmul	x,	w,	t		# x = w * l7

	lis	r5,	0x3FC7
	ori	r5, r5,	0x4664
	lis	r6,	0x96CB
	ori	r6, r6,	0x03DE
	evmergelo	t,	r5,r6		# t = l5
	efdadd	x,	x,	t		# x = l5 + w*l7
	efdmul	x,	x,	w		# x = w * (l5+w*l7)

	lis	r5,	0x3FD2
	ori	r5, r5,	0x4924
	lis	r6,	0x9422
	ori	r6, r6,	0x9359
	evmergelo	t,	r5,r6		# t = l3
	efdadd	x,	x,	t		# x = l3 + w*(l5+w*l7)
	efdmul	x,	x,	w		# x = w * (l3+(w*(l5+w*l7)))

	lis	r5,	0x3FE5
	ori	r5, r5,	0x5555
	lis	r6,	0x5555
	ori	r6, r6,	0x5593
	evmergelo	t,	r5,r6		# t = l1
	efdadd	x,	x,	t		# x = l1 + w*(l3+(w*(l5+w*l7)))
	efdmul	z,	x,	z		# z = z * x

	lis	r5,	0x3FC3
	ori	r5, r5,	0x9A09
	lis	r6,	0xD078
	ori	r6, r6,	0xC69F
	evmergelo	t,	r5,r6		# t = l6
	efdmul	x,	w,	t		# x = w * l6

	lis	r5,	0x3FCC
	ori	r5, r5,	0x71C5
	lis	r6,	0x1D8E
	ori	r6, r6,	0x78AF
	evmergelo	t,	r5,r6		# t = l4
	efdadd	x,	x,	t		# x = l4 + w*l6
	efdmul	x,	x,	w		# x = w * (l4+w*l6)

	lis	r5,	0x3FD9
	ori	r5, r5,	0x9999
	lis	r6,	0x9997
	ori	r6, r6,	0xFA04
	evmergelo	t,	r5,r6		# t = l2
	efdadd	x,	x,	t		# x = l2 + w*(l4+w*l6)
	efdmul	x,	x,	w		# x = w * (l2+w*(l4+w*l6))
	efdadd	x,	x,	z		# x = x + z

	lis	r5,	0x0006
	ori	r6, r5,	0x147a
	ori	r5, r5, 0xb851
	subf	r6,	r6,	hx		# i = hx - 0x6147a
	subf	r5,	hx,	r5		# j = 0x6b851 - hx
	or.	r5,	r5,	r6		# i |= j
	bgt+	cr0,	L(log_positive_i)

	efdsub	x,	f,	x		# x = f - x
	efdmul	x,	s,	x		# x = s * (f-x)

	cmpwi	cr1,	k,	0
	beq+	cr1,	L(log_f_not_large)

L(log_small_f_non_zero_k):
	efdcfsi	k,	k			# dk = (double) k

	lis	r5,	0x3dea
	ori	r5, r5,	0x39ef
	lis	r6,	0x3579
	ori	r6, r6,	0x3c76
	evmergelo	t,	r5,r6		# t = ln2LO
	efdmul	z,	k,	t		# z = k*ln2LO
	efdsub	x,	x,	z		# x = s*(f-x) - k*ln2LO

	b	L(log_better_accuracy)

L(log_positive_i):
	lis	r5,	0x3fe0
	li	r6,	0
	evmergelo	t,	r5,r6		# t = 0.5
	efdmul	w,	f,	t
	efdmul	w,	w,	f		# w = 0.5*f*f = hfsq

	efdadd	x,	x,	w		# x = x + hfsq
	efdmul	x,	x,	s		# x = s*(hfsq + R)

	cmpwi	cr1,	k,	0
	beq+	cr1,	L(log_f_not_large1)

	efdcfsi	k,	k			# dk = (double) k

	lis	r5,	0x3dea
	ori	r5, r5,	0x39ef
	lis	r6,	0x3579
	ori	r6, r6,	0x3c76
	evmergelo	t,	r5,r6		# t = ln2LO
	efdmul	z,	k,	t		# z = k*ln2LO
	efdadd	x,	x,	z		# s*(f - R) + dk*ln2LO
	efdsub	x,	w,	x		# hfsq - (s*(f-R)+dk*ln2LO)

L(log_better_accuracy):
	efdsub	x,	x,	f		# x = x - f

	lis	r5,	0x3fe6
	ori	r5, r5,	0x2e42
	lis	r6,	0xfee0
	evmergelo	t,	r5,r6		# t = ln2HI
	efdmul	z,	k,	t		# z = k*ln2HI
	efdsub	x,	z,	x		# x = k*ln2HI - (x-f)
	evmergelohi	hx,	lx,	x	# split result
	blr					# and exit

L(log_f_not_large1):
	efdsub	x,	w,	x		# hfsq - s*(hfsq + R)

L(log_f_not_large):
	efdsub	x,	f,	x		# log(x) = f - (...)
	evmergelohi	hx,	lx,	x	# split result
	blr					# and exit

L(log_return_ninf):
	lis	r3,	0xfff0
	li	r4,	0
	blr

L(log_return_nan):
	lis	r3,	0x7fff
	li	r4,	0
	blr
#endif

END(__ieee754_log)
