#ifndef TPU_H
#define TPU_H

//----------------------------------
// Includes and forward declarations
//----------------------------------
#include <cyg/infra/cyg_type.h>
#include <cyg/hal/drv_api.h>

//-----------------
// Type definitions
//-----------------
// Parameter RAM
typedef struct tpu3_channel_parameters {
  volatile cyg_uint16 parameter0;
  volatile cyg_uint16 parameter1;
  volatile cyg_uint16 parameter2;
  volatile cyg_uint16 parameter3;
  volatile cyg_uint16 parameter4;
  volatile cyg_uint16 parameter5;
  volatile cyg_uint16 parameter6;
  volatile cyg_uint16 parameter7;
} tpu3_channel_parameters_t;

// The TPU itself
typedef struct tpu3_port {
  volatile cyg_uint16 tpumcr;                     // 0x304000 - 0x304400
  volatile cyg_uint16 tcr;                        // 0x304002 - 0x304402
  volatile cyg_uint16 dscr;                       // 0x304004 - 0x304404
  volatile cyg_uint16 dssr;                       // 0x304006 - 0x304406
  volatile cyg_uint16 ticr;                       // 0x304008 - 0x304408
  volatile cyg_uint16 cier;                       // 0x30400a - 0x30440a
  volatile cyg_uint16 cfsr0;                      // 0x30400c - 0x30440c
  volatile cyg_uint16 cfsr1;                      // 0x30400e - 0x30440e
  volatile cyg_uint16 cfsr2;                      // 0x304010 - 0x304410
  volatile cyg_uint16 cfsr3;                      // 0x304012 - 0x304412
  volatile cyg_uint16 hsqr0;                      // 0x304014 - 0x304414
  volatile cyg_uint16 hsqr1;                      // 0x304016 - 0x304416
  volatile cyg_uint16 hsrr0;                      // 0x304018 - 0x304418
  volatile cyg_uint16 hsrr1;                      // 0x30401a - 0x30441a
  volatile cyg_uint16 cpr0;                       // 0x30401c - 0x30441c
  volatile cyg_uint16 cpr1;                       // 0x30401e - 0x30441e
  volatile cyg_uint16 cisr;                       // 0x304020 - 0x304420
  volatile cyg_uint16 lr;                         // 0x304022 - 0x304422
  volatile cyg_uint16 sglr;                       // 0x304024 - 0x304424
  volatile cyg_uint16 dcnr;                       // 0x304026 - 0x304426
  volatile cyg_uint16 tpumcr2;                    // 0x304028 - 0x304428
  volatile cyg_uint16 tpumcr3;                    // 0x30402a - 0x30442a

  volatile cyg_uint16 unused[0x6a];               // Inaccessible registers, accessing oe of these will probably
                                                  // yield an access violation exception
  tpu3_channel_parameters_t channel[16];          // The 16 channel of the TPU
} tpu3_port_t;

// And this is how we will build and encoder interface based on the TPU
typedef struct tpu3_encoder{
  tpu3_port_t *   port;                           // The TPU port that will be used to implement the encoder
  cyg_uint8       channel_number;                 // The first of three channels that will be used
  CYG_WORD        index_pulse_interrupt_number;
  cyg_priority_t  index_pulse_interrupt_priority;
  CYG_WORD        probe_pulse_interrupt_number;
  cyg_priority_t  probe_pulse_interrupt_priority;
  cyg_interrupt   index_pulse_interrupt;
  cyg_handle_t    index_pulse_interrupt_handle;
  cyg_interrupt   probe_pulse_interrupt;
  cyg_handle_t    probe_pulse_interrupt_handle;
} tpu3_encoder_t;

#endif // TPU_H
