;; $Id: dbmath.dsl,v 1.1.1.5 1999/01/28 15:21:56 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(define %equation-autolabel% #f)

(element equation ($semiformal-object$))

(element (equation title) (empty-sosofo))
(element (equation alt) (empty-sosofo))
(element (equation graphic) 
  (make paragraph
    space-before: 0pt
    space-after: 0pt
    ($img$ (current-node) #t)))

(element informalequation
  ;; Derived from informal-object
  (if %equation-autolabel%
      (let ((label  (element-label (current-node))))
	(make display-group
	  space-before: (if (object-title-after)
			    %block-sep%
			    0pt)
	  space-after: (if (object-title-after)
			   0pt
			   %block-sep%)
	  start-indent: (+ %block-start-indent% 
			   (inherited-start-indent))
	  keep-with-next?: (object-title-after)
	  (make table
	    (make table-column
	      column-number: 1
	      width: (- %text-width% 1in))
	    (make table-column
	      column-number: 2
	      width: 1in)
	    (make table-row
	      (make table-cell
		cell-row-alignment: 'center
		start-indent: 0pt
		end-indent: 0pt
		(process-children))
	      (make table-cell
		cell-row-alignment: 'center
		quadding: 'end
		start-indent: 0pt
		end-indent: 0pt
		(make paragraph
		  (literal "(" label ")")))))))
      ($informal-object$)))

(element (informalequation alt) (empty-sosofo))
(element (informalequation graphic) 
  (make paragraph
    space-before: 0pt
    space-after: 0pt
    quadding: 'end
    ($img$ (current-node) #t)))

(element inlineequation ($inline-object$))
(element (inlineequation alt) (empty-sosofo))
(element (inlineequation graphic) 
  (make sequence
    ($img$ (current-node) #f)))

