;; $Id: xbl1usen.dsl,v 1.1.1.2 1998/09/02 22:45:25 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x and #x
;; keywords.
;;

(define (gentext-usen-xref-strings giname)
  (case giname
    (("APPENDIX") (if %chapter-autolabel%
		      ^Appendix#^
		      ^AppendixCalled^))
    (("ARTICLE") (string-append %gentext-usen-start-quote%
				"%t"
				%gentext-usen-end-quote%))
    (("BIBLIOGRAPHY") "%t")
    (("BOOK") "%t")
    (("CHAPTER") (if %chapter-autolabel%
		     ^Chapter#^
		     ^ChapterCalled^))
    (("EQUATION") ^Equation#^)
    (("EXAMPLE") ^Example#^)
    (("FIGURE") ^Figure#^)
    (("INFORMALTABLE") "%kg %kn")
    (("LISTITEM") "%n")
    (("PART") ^Part#^)
    (("PREFACE") "%t")
    (("PROCEDURE") ^Procedure#^)
    (("SECT1") (if %section-autolabel% 
		   ^Section#^
		   ^SectionCalled^))
    (("SECT2") (if %section-autolabel% 
		   ^Section#^
		   ^SectionCalled^))
    (("SECT3") (if %section-autolabel% 
		   ^Section#^
		   ^SectionCalled^))
    (("SECT4") (if %section-autolabel% 
		   ^Section#^
		   ^SectionCalled^))
    (("SECT5") (if %section-autolabel% 
		   ^Section#^
		   ^SectionCalled^))
    (("STEP") ^Step#^)
    (("TABLE") ^Table#^)
    (("TITLE") "%kg %kn")
    (else (string-append ^X2^
			 (if giname 
			     giname
			     ^NonE^)
			 ^Unsupported^))))

;; Indirection in the generated text for cross references.  The first
;; element of the list is used for cross references across element
;; boundries, the second element is used for cross references within
;; the same element
;;
(define (gentext-usen-xref-strings-indirect key)
  (case key
    (("b") '("" ""))
    (("c") (list (string-append " " ^in^ " %cg %cn") ""))
    (("d") '("" ""))
    (("k") (list (string-append " " ^in^ " %kg %kn") ""))
    (("s") '("" ""))))

;; Should the TOC come first or last?
;;
(define %generate-usen-toc-in-front% #t)

(define (gentext-usen-element-name giname)
  (gentext-usen-element-name1 giname))

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define (gentext-usen-element-name1 giname)
  (case giname
    (("ABSTRACT") ^Abstract^)
    (("APPENDIX") ^Appendix^)
    (("BIBLIOGRAPHY") ^Bibliography^)
    (("CAUTION") ^Caution^)
    (("CHAPTER") ^Chapter^)
    (("COPYRIGHT") ^Copyright^)
    (("DEDICATION") ^Dedication^)
    (("EDITION") ^Edition^)
    (("EQUATION") ^Equation^)
    (("EXAMPLE") ^Example^)
    (("FIGURE") ^Figure^)
    (("GLOSSARY") ^Glossary^)
    (("GLOSSSEE") ^See^)
    (("GLOSSSEEALSO") ^SeeAlso^)
    (("IMPORTANT") ^Important^)
    (("INDEX") ^Index^)
    (("ISBN") ^ISBN^)
    (("LEGALNOTICE") ^LegalNotice^)
    (("MSGAUD") ^Audience^)
    (("MSGLEVEL") ^Level^)
    (("MSGORIG") ^Origin^)
    (("NOTE") ^Note^)
    (("PART") ^Part^)
    (("PREFACE") ^Preface^)
    (("PROCEDURE") ^Procedure^)
    (("PUBDATE") ^Published^)
    (("REFERENCE") ^Reference^)
    (("REFNAME") ^Name^)
    (("REVHISTORY") ^RevHistory^)
    (("REVISION") ^Revision^)
    (("SECT1") ^Section^)
    (("SECT2") ^Section^)
    (("SECT3") ^Section^)
    (("SECT4") ^Section^)
    (("SECT5") ^Section^)
    (("SIDEBAR") ^Sidebar^)
    (("STEP") ^Step^)
    (("TABLE") ^Table^)
    (("TIP") ^Tip^)
    (("TOC") ^TOC^)
    (("WARNING") ^Warning^)
    (else (string-append ^Unexpected^ giname))))

(define (gentext-usen-element-name2 giname)
  (case giname
    (("ABSTRACT") ^Abstract2^)
    (("APPENDIX") ^Appendix2^)
    (("BIBLIOGRAPHY") ^Bibliography2^)
    (("CAUTION") ^Caution2^)
    (("CHAPTER") ^Chapter2^)
    (("COPYRIGHT") ^Copyright2^)
    (("DEDICATION") ^Dedication2^)
    (("EDITION") ^Edition2^)
    (("EQUATION") ^Equation2^)
    (("EXAMPLE") ^Example2^)
    (("FIGURE") ^Figure2^)
    (("GLOSSARY") ^Glossary2^)
    (("GLOSSSEE") ^See2^)
    (("GLOSSSEEALSO") ^SeeAlso2^)
    (("IMPORTANT") ^Important2^)
    (("INDEX") ^Index2^)
    (("ISBN") ^ISBN2^)
    (("LEGALNOTICE") ^LegalNotice2^)
    (("MSGAUD") ^Audience2^)
    (("MSGLEVEL") ^Level2^)
    (("MSGORIG") ^Origin2^)
    (("NOTE") ^Note2^)
    (("PART") ^Part2^)
    (("PREFACE") ^Preface2^)
    (("PROCEDURE") ^Procedure2^)
    (("PUBDATE") ^Published2^)
    (("REFERENCE") ^Reference2^)
    (("REFNAME") ^Name2^)
    (("REVHISTORY") ^RevHistory2^)
    (("REVISION") ^Revision2^)
    (("SECT1") ^Section2^)
    (("SECT2") ^Section2^)
    (("SECT3") ^Section2^)
    (("SECT4") ^Section2^)
    (("SECT5") ^Section2^)
    (("SIDEBAR") ^Sidebar2^)
    (("STEP") ^Step2^)
    (("TABLE") ^Table2^)
    (("TIP") ^Tip2^)
    (("TOC") ^TOC2^)
    (("WARNING") ^Warning2^)
    (else (string-append ^Unexpected^ giname))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-usen-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;
(define (gentext-usen-intra-label-sep giname)
  (case giname
    (("EQUATION") "-")
    (("EXAMPLE") "-")
    (("FIGURE") "-")
    (("PROCEDURE") ".")
    (("REFENTRY") ".")
    (("REFERENCE") ".")
    (("REFNAME") ", ")
    (("REFSECT1") ".")
    (("REFSECT2") ".")
    (("REFSECT3") ".")
    (("SECT1") ".")
    (("SECT2") ".")
    (("SECT3") ".")
    (("SECT4") ".")
    (("SECT5") ".")
    (("STEP") ".")
    (("TABLE") "-")
    (("_PAGENUMBER") "-")  ;; page number psuedo element
    (else "")))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;
(define (gentext-usen-label-title-sep giname)
  (case giname
    (("ABSTRACT") ": ")
    (("APPENDIX") ". ")
    (("CAUTION") "")
    (("CHAPTER") ". ")
    (("EQUATION") ". ")
    (("EXAMPLE") ". ")
    (("FIGURE") ". ")
    (("FOOTNOTE") ". ")
    (("GLOSSSEE") ": ")
    (("GLOSSSEEALSO") ": ")
    (("IMPORTANT") ": ")
    (("NOTE") ": ")
    (("ORDEREDLIST") ". ")
    (("PART") ". ")
    (("PROCEDURE") ". ")
    (("PREFIX") ". ")
    (("REFENTRY") "")
    (("REFERENCE") ". ")
    (("REFSECT1") ". ")
    (("REFSECT2") ". ")
    (("REFSECT3") ". ")
    (("SECT1") ". ")
    (("SECT2") ". ")
    (("SECT3") ". ")
    (("SECT4") ". ")
    (("SECT5") ". ")
    (("STEP") ". ")
    (("TABLE") ". ")
    (("TIP") ": ")
    (("WARNING") "")
    (else "")))

(define ($lot-title-usen$ lotgi)
  (cond ((string=? "TABLE"   lotgi) (string-append ^ListOf^ ^Tables^))
	((string=? "EXAMPLE" lotgi) (string-append ^ListOf^ ^Examples^))
	((string=? "FIGURE"  lotgi) (string-append ^ListOf^ ^Figures^))
	((string=? "EQUATION" lotgi) (string-append ^ListOf^ ^Equations^))
	(else "List of ???")))

(define %gentext-usen-start-quote% "\U-201C;")

(define %gentext-usen-end-quote% "\U-201D;")

(define %gentext-usen-by% ^by^) ;; e.g. Copyright 1997 "by" A. Nonymous
                                ;; Authored "by" Jane Doe

(define %gentext-usen-edited-by% (string-append ^Editedby^))
                                ;; "Edited by" Jane Doe

(define %gentext-usen-page% "")

(define %gentext-usen-and% ^and^)

(define %gentext-usen-bibl-pages% ^Pgs^)

(define %gentext-usen-endnotes% ^Endnotes^)

(define %gentext-usen-table-endnotes% (string-append ^Notes^ ":"))

(define %gentext-usen-index-see% ^See^)

(define %gentext-usen-index-seealso% ^SeeAlso^)

;; ---

(define ^Next^ "[ Next ]")
(define ^Prev^ "[ Previous ]")
(define ^FF^ "[ Fast Forward ]")
(define ^FB^ "[ Fast Back ]")
(define ^Up^ "[ Up ]")
(define ^Home^ "[ Home ]")
(define ^Chapter^ "Chapter")
(define ^Chapter#^ (string-append ^Chapter^ " %n"))

(define ^ChapterCalled^ "the chapter called %t")

(define ^Appendix^ "Appendix")
(define ^Appendix#^ (string-append ^Appendix^ " %n"))

(define ^AppendixCalled^ "the appendix called %t")

(define ^Equation^ "Equation")
(define ^Equation#^ (string-append ^Equation^ " %n"))
(define ^Example^ "Example")
(define ^Example#^ (string-append ^Example^ " %n"))
(define ^Figure^ "Figure")
(define ^Figure#^ (string-append ^Figure^ " %n"))
(define ^Part^ "Part")
(define ^Part#^ (string-append ^Part^ " %n"))
(define ^Procedure^ "Procedure")
(define ^Procedure#^ (string-append ^Procedure^ " %n, %t"))
(define ^Section^ "Section")
(define ^Section#^ (string-append ^Section^ " %n"))

(define ^SectionCalled^ "the section called %t#c")

(define ^Step^ "Step")
(define ^Step#^  (string-append ^Step^ " %n#k")) 
(define ^Table^ "Table")
(define ^Table#^ (string-append ^Table^ " %n"))
(define ^X2^ "[xref to ")
(define ^NonE^ "non-existent element")
(define ^Unsupported^ " unsupported]")
(define ^Abstract^ "Abstract")
(define ^Bibliography^ "Bibliography")
(define ^Caution^ "Caution")
(define ^Copyright^ "Copyright")
(define ^Dedication^ "Dedication")
(define ^Glossary^ "Glossary")
(define ^See^ "See")
(define ^SeeAlso^ "See Also")
(define ^Important^ "IMPORTANT")
(define ^Index^ "")
(define ^Audience^ "Audience")
(define ^Level^ "Level")
(define ^Origin^ "Origin")
(define ^Preface^ "Preface")
(define ^Note^ "Note")
(define ^NoteSep^ " - ")
(define ^Reference^ "Reference")
(define ^Name^ "NAME")
(define ^RevHistory^ "Revision History")
(define ^Revision^ "Revision")
(define ^Tip^ "TIP")
(define ^TOC^ "Table of Contents")
(define ^Warning^ "WARNING")
(define ^Unexpected^ "UNEXPECTED-ELEMENT-NAME: ")
(define ^Revisedby^ "Revised by: ")
(define ^in^ "in")

(define ^Notes^ "Notes")
(define ^Edition^ "Edition")
(define ^ISBN^ "ISBN")
(define ^LegalNotice^ "LegalNotice")
(define ^Published^ "Published")
(define ^Sidebar^ "Sidebar")
(define ^and^ "and")
(define ^by^ "by")
(define ^Pgs^ "Pgs.")
(define ^Editedby^ "Editedby")
