;; $Id: dbl1en.dsl,v 1.1.1.1 1999/01/28 15:21:15 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x 
;; keywords.
;;

(define (en-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "the &appendix; called %t"))

(define (en-article-xref-string gi-or-name)
  (string-append %gentext-en-start-quote%
		 "%t"
		 %gentext-en-end-quote%))

(define (en-bibliography-xref-string gi-or-name)
  "%t")

(define (en-book-xref-string gi-or-name)
  "%t")

(define (en-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "the &chapter; called %t"))

(define (en-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (en-example-xref-string gi-or-name)
  "&Example; %n")

(define (en-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (en-glossary-xref-string gi-or-name)
  "%t")

(define (en-index-xref-string gi-or-name)
  "%t")

(define (en-listitem-xref-string gi-or-name)
  "%n")

(define (en-part-xref-string gi-or-name)
  "&Part; %n")

(define (en-preface-xref-string gi-or-name)
  "%t")

(define (en-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (en-reference-xref-string gi-or-name)
  "&Reference; %n, %t")

(define (en-sectioning-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "the &section; called %t"))

(define (en-sect1-xref-string gi-or-name)
  (en-sectioning-xref-string gi-or-name))

(define (en-sect2-xref-string gi-or-name)
  (en-sectioning-xref-string gi-or-name))

(define (en-sect3-xref-string gi-or-name)
  (en-sectioning-xref-string gi-or-name))

(define (en-sect4-xref-string gi-or-name)
  (en-sectioning-xref-string gi-or-name))

(define (en-sect5-xref-string gi-or-name)
  (en-sectioning-xref-string gi-or-name))

(define (en-section-xref-string gi-or-name)
  (en-sectioning-xref-string gi-or-name))

(define (en-sidebar-xref-string gi-or-name)
  "the &sidebar; %t")

(define (en-step-xref-string gi-or-name)
  "&step; %n")

(define (en-table-xref-string gi-or-name)
  "&Table; %n")

(define (en-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-en-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (en-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (en-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (en-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (en-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (en-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (en-equation-xref-string gind))
      ((equal? name (normalize "example"))  (en-example-xref-string gind))
      ((equal? name (normalize "figure"))   (en-figure-xref-string gind))
      ((equal? name (normalize "glossary")) (en-glossary-xref-string gind))
      ((equal? name (normalize "index"))    (en-index-xref-string gind))
      ((equal? name (normalize "listitem")) (en-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (en-part-xref-string gind))
      ((equal? name (normalize "preface"))  (en-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (en-procedure-xref-string gind))
      ((equal? name (normalize "reference")) (en-reference-xref-string gind))
      ((equal? name (normalize "sect1"))    (en-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (en-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (en-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (en-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (en-sect5-xref-string gind))
      ((equal? name (normalize "section"))  (en-section-xref-string gind))
      ((equal? name (normalize "sidebar"))  (en-sidebar-xref-string gind))
      ((equal? name (normalize "step"))     (en-step-xref-string gind))
      ((equal? name (normalize "table"))    (en-table-xref-string gind))
      (else (en-default-xref-string gind)))))

(define (en-auto-xref-indirect-connector before) 
  ;; In English, the (cond) is unnecessary since the word is always the
  ;; same, but in other languages, that's not the case.  I've set this
  ;; one up with the (cond) so it stands as an example.
  (cond 
   ((equal? (gi before) (normalize "book"))
    (literal " &in; "))
   ((equal? (gi before) (normalize "chapter"))
    (literal " &in; "))
   ((equal? (gi before) (normalize "sect1"))
    (literal " &in; "))
   (else
    (literal " &in; "))))

;; Should the TOC come first or last?
;;
(define %generate-en-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define en-abstract-name	"&Abstract;")
(define en-appendix-name	"&Appendix;")
(define en-article-name	"&Article;")
(define en-bibliography-name	"&Bibliography;")
(define en-book-name		"&Book;")
(define en-calloutlist-name	"")
(define en-caution-name	"&Caution;")
(define en-chapter-name	"&Chapter;")
(define en-copyright-name	"&Copyright;")
(define en-dedication-name	"&Dedication;")
(define en-edition-name	"&Edition;")
(define en-equation-name	"&Equation;")
(define en-example-name	"&Example;")
(define en-figure-name	"&Figure;")
(define en-glossary-name	"&Glossary;")
(define en-glosssee-name	"&GlossSee;")
(define en-glossseealso-name	"&GlossSeeAlso;")
(define en-important-name	"&Important;")
(define en-index-name		"&Index;")
(define en-colophon-name	"&Colophon;")
(define en-setindex-name	"&SetIndex;")
(define en-isbn-name		"&ISBN;")
(define en-legalnotice-name	"&LegalNotice;")
(define en-msgaud-name	"&MsgAud;")
(define en-msglevel-name	"&MsgLevel;")
(define en-msgorig-name	"&MsgOrig;")
(define en-note-name		"&Note;")
(define en-part-name		"&Part;")
(define en-preface-name	"&Preface;")
(define en-procedure-name	"&Procedure;")
(define en-pubdate-name	"&Published;")
(define en-refentry-name      "&RefEntry;")
(define en-reference-name	"&Reference;")
(define en-refname-name	"&RefName;")
(define en-revhistory-name	"&RevHistory;")
(define en-refsect1-name      "&RefSection;")
(define en-refsect2-name      "&RefSection;")
(define en-refsect3-name      "&RefSection;")
(define en-refsynopsisdiv-name      "&RefSynopsisDiv;")
(define en-revision-name	"&Revision;")
(define en-sect1-name		"&Section;")
(define en-sect2-name		"&Section;")
(define en-sect3-name		"&Section;")
(define en-sect4-name		"&Section;")
(define en-sect5-name		"&Section;")
(define en-section-name		"&Section;")
(define en-simplesect-name	"&Section;")
(define en-seeie-name		"&See;")
(define en-seealsoie-name	"&Seealso;")
(define en-set-name		"&Set;")
(define en-sidebar-name	"&Sidebar;")
(define en-step-name		"&step;")
(define en-table-name		"&Table;")
(define en-tip-name		"&Tip;")
(define en-toc-name		"&TableofContents;")
(define en-warning-name	"&Warning;")

(define (gentext-en-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	en-abstract-name)
     ((equal? name (normalize "appendix"))	en-appendix-name)
     ((equal? name (normalize "article"))	en-article-name)
     ((equal? name (normalize "bibliography"))	en-bibliography-name)
     ((equal? name (normalize "book"))		en-book-name)
     ((equal? name (normalize "calloutlist"))	en-calloutlist-name)
     ((equal? name (normalize "caution"))	en-caution-name)
     ((equal? name (normalize "chapter"))	en-chapter-name)
     ((equal? name (normalize "copyright"))	en-copyright-name)
     ((equal? name (normalize "dedication"))	en-dedication-name)
     ((equal? name (normalize "edition"))	en-edition-name)
     ((equal? name (normalize "equation"))	en-equation-name)
     ((equal? name (normalize "example"))	en-example-name)
     ((equal? name (normalize "figure"))	en-figure-name)
     ((equal? name (normalize "glossary"))	en-glossary-name)
     ((equal? name (normalize "glosssee"))	en-glosssee-name)
     ((equal? name (normalize "glossseealso"))	en-glossseealso-name)
     ((equal? name (normalize "important"))	en-important-name)
     ((equal? name (normalize "index"))		en-index-name)
     ((equal? name (normalize "colophon"))	en-colophon-name)
     ((equal? name (normalize "setindex"))	en-setindex-name)
     ((equal? name (normalize "isbn"))		en-isbn-name)
     ((equal? name (normalize "legalnotice"))	en-legalnotice-name)
     ((equal? name (normalize "msgaud"))	en-msgaud-name)
     ((equal? name (normalize "msglevel"))	en-msglevel-name)
     ((equal? name (normalize "msgorig"))	en-msgorig-name)
     ((equal? name (normalize "note"))		en-note-name)
     ((equal? name (normalize "part"))		en-part-name)
     ((equal? name (normalize "preface"))	en-preface-name)
     ((equal? name (normalize "procedure"))	en-procedure-name)
     ((equal? name (normalize "pubdate"))	en-pubdate-name)
     ((equal? name (normalize "refentry"))	en-refentry-name)
     ((equal? name (normalize "reference"))	en-reference-name)
     ((equal? name (normalize "refname"))	en-refname-name)
     ((equal? name (normalize "revhistory"))	en-revhistory-name)
     ((equal? name (normalize "refsect1"))	en-refsect1-name)
     ((equal? name (normalize "refsect2"))	en-refsect2-name)
     ((equal? name (normalize "refsect3"))	en-refsect3-name)
     ((equal? name (normalize "refsynopsisdiv"))	en-refsynopsisdiv-name)
     ((equal? name (normalize "revision"))	en-revision-name)
     ((equal? name (normalize "sect1"))		en-sect1-name)
     ((equal? name (normalize "sect2"))		en-sect2-name)
     ((equal? name (normalize "sect3"))		en-sect3-name)
     ((equal? name (normalize "sect4"))		en-sect4-name)
     ((equal? name (normalize "sect5"))		en-sect5-name)
     ((equal? name (normalize "section"))	en-section-name)
     ((equal? name (normalize "simplesect"))    en-simplesect-name)
     ((equal? name (normalize "seeie"))		en-seeie-name)
     ((equal? name (normalize "seealsoie"))	en-seealsoie-name)
     ((equal? name (normalize "set"))		en-set-name)
     ((equal? name (normalize "sidebar"))	en-sidebar-name)
     ((equal? name (normalize "step"))		en-step-name)
     ((equal? name (normalize "table"))		en-table-name)
     ((equal? name (normalize "tip"))		en-tip-name)
     ((equal? name (normalize "toc"))		en-toc-name)
     ((equal? name (normalize "warning"))	en-warning-name)
     (else (let* ((msg (string-append "gentext-en-element-name: &unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-en-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define en-equation-intra-label-sep "-")
(define en-informalequation-intra-label-sep "-")
(define en-example-intra-label-sep "-")
(define en-figure-intra-label-sep "-")
(define en-listitem-intra-label-sep ".")
(define en-procedure-intra-label-sep ".")
(define en-refentry-intra-label-sep ".")
(define en-reference-intra-label-sep ".")
(define en-refname-intra-label-sep ", ")
(define en-refsect1-intra-label-sep ".")
(define en-refsect2-intra-label-sep ".")
(define en-refsect3-intra-label-sep ".")
(define en-sect1-intra-label-sep ".")
(define en-sect2-intra-label-sep ".")
(define en-sect3-intra-label-sep ".")
(define en-sect4-intra-label-sep ".")
(define en-sect5-intra-label-sep ".")
(define en-section-intra-label-sep ".")
(define en-step-intra-label-sep ".")
(define en-table-intra-label-sep "-")
(define en-_pagenumber-intra-label-sep "-")
(define en-default-intra-label-sep "")

(define (gentext-en-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	en-equation-intra-label-sep)
     ((equal? name (normalize "informalequation"))	en-informalequation-intra-label-sep)
     ((equal? name (normalize "example"))	en-example-intra-label-sep)
     ((equal? name (normalize "figure"))	en-figure-intra-label-sep)
     ((equal? name (normalize "listitem"))	en-listitem-intra-label-sep)
     ((equal? name (normalize "procedure"))	en-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	en-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	en-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	en-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	en-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	en-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	en-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		en-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		en-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		en-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		en-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		en-sect5-intra-label-sep)
     ((equal? name (normalize "section"))	en-section-intra-label-sep)
     ((equal? name (normalize "step"))		en-step-intra-label-sep)
     ((equal? name (normalize "table"))		en-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	en-_pagenumber-intra-label-sep)
     (else en-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define en-abstract-label-title-sep ": ")
(define en-appendix-label-title-sep ". ")
(define en-caution-label-title-sep "")
(define en-chapter-label-title-sep ". ")
(define en-equation-label-title-sep ". ")
(define en-example-label-title-sep ". ")
(define en-figure-label-title-sep ". ")
(define en-footnote-label-title-sep ". ")
(define en-glosssee-label-title-sep ": ")
(define en-glossseealso-label-title-sep ": ")
(define en-important-label-title-sep ": ")
(define en-note-label-title-sep ": ")
(define en-orderedlist-label-title-sep ". ")
(define en-part-label-title-sep ". ")
(define en-procedure-label-title-sep ". ")
(define en-prefix-label-title-sep ". ")
(define en-refentry-label-title-sep "")
(define en-reference-label-title-sep ". ")
(define en-refsect1-label-title-sep ". ")
(define en-refsect2-label-title-sep ". ")
(define en-refsect3-label-title-sep ". ")
(define en-sect1-label-title-sep ". ")
(define en-sect2-label-title-sep ". ")
(define en-sect3-label-title-sep ". ")
(define en-sect4-label-title-sep ". ")
(define en-sect5-label-title-sep ". ")
(define en-section-label-title-sep ". ")
(define en-seeie-label-title-sep " ")
(define en-seealsoie-label-title-sep " ")
(define en-step-label-title-sep ". ")
(define en-table-label-title-sep ". ")
(define en-tip-label-title-sep ": ")
(define en-warning-label-title-sep "")
(define en-default-label-title-sep "")

(define (gentext-en-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) en-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) en-appendix-label-title-sep)
     ((equal? name (normalize "caution")) en-caution-label-title-sep)
     ((equal? name (normalize "chapter")) en-chapter-label-title-sep)
     ((equal? name (normalize "equation")) en-equation-label-title-sep)
     ((equal? name (normalize "example")) en-example-label-title-sep)
     ((equal? name (normalize "figure")) en-figure-label-title-sep)
     ((equal? name (normalize "footnote")) en-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) en-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) en-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) en-important-label-title-sep)
     ((equal? name (normalize "note")) en-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) en-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) en-part-label-title-sep)
     ((equal? name (normalize "procedure")) en-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) en-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) en-refentry-label-title-sep)
     ((equal? name (normalize "reference")) en-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) en-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) en-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) en-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) en-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) en-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) en-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) en-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) en-sect5-label-title-sep)
     ((equal? name (normalize "section")) en-section-label-title-sep)
     ((equal? name (normalize "seeie")) en-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) en-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) en-step-label-title-sep)
     ((equal? name (normalize "table")) en-table-label-title-sep)
     ((equal? name (normalize "tip")) en-tip-label-title-sep)
     ((equal? name (normalize "warning")) en-warning-label-title-sep)
     (else en-default-label-title-sep))))

(define (en-set-label-number-format gind) "1")
(define (en-book-label-number-format gind) "1")
(define (en-prefix-label-number-format gind) "1")
(define (en-part-label-number-format gind) "I")
(define (en-chapter-label-number-format gind) "1")
(define (en-appendix-label-number-format gind) "A")
(define (en-reference-label-number-format gind) "I")
(define (en-example-label-number-format gind) "1")
(define (en-figure-label-number-format gind) "1")
(define (en-table-label-number-format gind) "1")
(define (en-procedure-label-number-format gind) "1")
(define (en-step-label-number-format gind) "1")
(define (en-refsect1-label-number-format gind) "1")
(define (en-refsect2-label-number-format gind) "1")
(define (en-refsect3-label-number-format gind) "1")
(define (en-sect1-label-number-format gind) "1")
(define (en-sect2-label-number-format gind) "1")
(define (en-sect3-label-number-format gind) "1")
(define (en-sect4-label-number-format gind) "1")
(define (en-sect5-label-number-format gind) "1")
(define (en-section-label-number-format gind) "1")
(define (en-default-label-number-format gind) "1")

(define (en-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (en-set-label-number-format gind))
     ((equal? name (normalize "book")) (en-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (en-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (en-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (en-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (en-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (en-reference-label-number-format gind))
     ((equal? name (normalize "example")) (en-example-label-number-format gind))
     ((equal? name (normalize "figure")) (en-figure-label-number-format gind))
     ((equal? name (normalize "table")) (en-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (en-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (en-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (en-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (en-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (en-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (en-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (en-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (en-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (en-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (en-sect5-label-number-format gind))
     ((equal? name (normalize "section")) (en-section-label-number-format gind))
     (else (en-default-label-number-format gind)))))

(define ($lot-title-en$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-en-start-quote% (dingbat "ldquo"))

(define %gentext-en-end-quote% (dingbat "rdquo"))

(define %gentext-en-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-en-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-en-page% "")

(define %gentext-en-and% "&and;")

(define %gentext-en-bibl-pages% "&Pgs;")

(define %gentext-en-endnotes% "&Notes;")

(define %gentext-en-table-endnotes% "&TableNotes;:")

(define %gentext-en-index-see% "&See;")

(define %gentext-en-index-seealso% "&SeeAlso;")

