;; $Id: dbtitle.dsl,v 1.1 1998/02/18 13:14:22 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(define title-style
  (style
   font-family-name: %title-font-family%
   font-weight: 'bold
   quadding: 'start))

;; So we can pass different sosofo's to this routine and get identical
;; treatment (see REFNAME in dbrfntry.dsl)
;;
(define ($lowtitlewithsosofo$ tlevel sosofo)
  (let ((hs (HSIZE (- 3 tlevel))))
    (make paragraph
	  font-family-name: %title-font-family%
	  font-weight: 'bold
	  font-size: hs
	  line-spacing: (* hs %line-spacing-factor%)
	  space-before: (* hs %head-before-factor%)
	  space-after: (* hs %head-after-factor%)
	  start-indent: %body-start-indent%
	  quadding: 'start
	  keep-with-next?: #t
;;	  heading-level: tlevel
	  sosofo)))

(define ($lowtitle$ tlevel)
  ($lowtitlewithsosofo$ tlevel (process-children)))

(define ($runinhead$)
  (make sequence
	font-weight: 'bold
;;	glyph-subst-table: *small-caps*
	(process-children)
	(literal ". ")))

(element TITLE ($lowtitle$ 2))         ;; the default TITLE format
(element TITLEABBREV (empty-sosofo))
(element SUBTITLE (empty-sosofo))

