;; $Id: dblists.dsl,v 1.1 1998/02/18 13:14:16 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; =============================== LISTS ================================

(define (BULLTREAT bullfcn ilevel override mark)
  (cond
   (override (bullfcn override ilevel))
   (mark (bullfcn mark ilevel))
   (else (bullfcn "bullet" ilevel))))

(define (BULLSTR m lvl)
  (dingbat m))

(define (BULLSHIFT m lvl)
  (let ((md (case-fold-down m)))
    (case md
	  (("bullet") 0.0em)
	  (("box") (if (= lvl 1) 0.0em 0.1em))
	  (("checkbox") (if (= lvl 1) 0.0em 0.1em))
	  (("check") 0.0em)
	  (("checkedbox") 0.0em)
	  (("dash") 0.0em)
	  (("none") 0.0em)
	  (else 0.0em))))

(define (MSIZE m lvl f1 f2)
  (if (= lvl 1)
      (* %bf-size% f1)
      (* %bf-size% f2)))

(define (BULLSIZE m lvl)
  (let ((md (case-fold-down m)))
    (case md
	  (("bullet") (MSIZE m lvl 0.8 0.72))
	  (("box") (MSIZE m lvl 0.9 0.72))
	  (("checkbox") (MSIZE m lvl 0.9 0.72))
	  (("check") (MSIZE m lvl 1.0 1.0))
	  (("checkedbox") (MSIZE m lvl 1.0 1.0))
	  (("dash") (MSIZE m lvl 1.0 1.0))
	  (("none") (MSIZE m lvl 1.0 1.0))
	  (else (MSIZE m lvl 1.0 1.0)))))

(define (OLSTEP)
  (case
   (modulo (length (hierarchical-number-recursive "ORDEREDLIST")) 4)
	((1) 1.2em)
	((2) 1.2em)
	((3) 1.6em)
	((0) 1.4em)))

(define (ILSTEP) 1.0em)

(define (COSTEP) 1.5pi)

(define ($list$)
  (make display-group
    start-indent: (if (INBLOCK?)
		      (inherited-start-indent)
		      (+ %block-start-indent% (inherited-start-indent)))
    space-before: (if (INLIST?) %para-sep% %block-sep%)
    space-after:  (if (INLIST?) %para-sep% %block-sep%)))
 
(element ITEMIZEDLIST ($list$))

(element (ITEMIZEDLIST LISTITEM)
  (let ((itemcontent (children (current-node)))
	(spacing (inherited-attribute-string "spacing"))
	(ilevel (length (hierarchical-number-recursive "ITEMIZEDLIST")))
	(override (inherited-attribute-string "override"))
	(spacing (inherited-attribute-string "spacing"))
	(mark (inherited-attribute-string "mark")))
    (make sequence
      start-indent: (+ (inherited-start-indent) (ILSTEP))

      (make paragraph
	use: para-style
	space-before: (if (equal? "COMPACT" spacing)
			  0pt
			  %para-sep%)
	first-line-start-indent: (- (ILSTEP))
	(make line-field
	  font-size:
	  (BULLTREAT BULLSIZE ilevel override mark)
	  position-point-shift:
	  (BULLTREAT BULLSHIFT ilevel override mark)
	  field-width: (ILSTEP)
	  (literal
	   (BULLTREAT BULLSTR ilevel override mark)))
	(process-node-list (children (node-list-first itemcontent))))
      (process-node-list (node-list-rest itemcontent)))))

(element ORDEREDLIST ($list$))

(element (ORDEREDLIST LISTITEM)
  (let ((spacing (inherited-attribute-string "spacing"))
	(itemcontent (children (current-node))))
    (make sequence
      start-indent: (+ (inherited-start-indent) (OLSTEP))

      (make paragraph
	use: para-style
	space-before: (if (equal? "COMPACT" spacing)
			  0pt
			  %para-sep%)
	first-line-start-indent: (- (OLSTEP))
	(make line-field
	  field-width: (OLSTEP)
	  (literal (number-with-numeration 
		    (inherited-attribute-string "numeration") 
		    (child-number (current-node)))
		   (gentext-label-title-sep "ORDEREDLIST")))
	(process-node-list (children (node-list-first itemcontent))))

      (process-node-list (node-list-rest itemcontent)))))

(define (number-with-numeration numeration number)
  (let* ((depth (length (hierarchical-number-recursive "ORDEREDLIST")))
	 (rawnum (case numeration
		   (("ARABIC") 1)
		   (("LOWERALPHA") 2)
		   (("LOWERROMAN") 3)
		   (("UPPERALPHA") 4)
		   (("UPPERROMAN") 0)
		   (else (modulo depth 5))))
	 (num (case rawnum
		((1) (format-number number "1"))
		((2) (format-number number "a"))
		((3) (format-number number "i"))
		((4) (format-number number "A"))
		((0) (format-number number "I")))))
    (if (> depth 5) 
	(string-append "(" num ")")
	num)))
  
(element VARIABLELIST ($list$))
(element VARLISTENTRY ($para-container$))
(element (VARLISTENTRY TERM)
  (let ((termlength
	  (attribute-string "termlength" (ancestor "VARIABLELIST"))))
    (make paragraph
	  use: para-style
	  space-before: %para-sep%
	  end-indent: (if termlength
			  (- %text-width% (measurement-to-length termlength))
			  0pt)
	  (process-children))))
(element (VARLISTENTRY LISTITEM)
  (make paragraph
    start-indent: (+ (inherited-start-indent) 2em)
    (process-children)))
(element (VARLISTENTRY LISTITEM PARA)
  (make paragraph
	use: para-style
	space-before: %para-sep%
	space-after: %para-sep%
	(process-children)))

(define (simplelist-table majororder cols members)
  (let* ((termcount (node-list-length members))
	 (rows (quotient (+ termcount (- cols 1)) cols)))
    (make table
      space-before: (if (INLIST?) %para-sep% %block-sep%)
      space-after:  (if (INLIST?) %para-sep% %block-sep%)
      start-indent: (if (INBLOCK?)
			(inherited-start-indent)
			(+ %block-start-indent% (inherited-start-indent)))
      (if %simplelist-column-width%
	  (let colloop ((colnum 1))
	    (if (> colnum cols)
		(empty-sosofo)
		(make sequence
		  (make table-column
		    width: %simplelist-column-width%)
		  (colloop (+ colnum 1)))))
	  (empty-sosofo))
      (let rowloop ((rownum 1))
	(if (> rownum rows)
	    (empty-sosofo)
	    (make sequence
	      (simplelist-row rownum majororder rows cols members)
	      (rowloop (+ rownum 1))))))))

(define (simplelist-row rownum majororder rows cols members)
  (make table-row
    (let colloop ((colnum 1))
      (if (> colnum cols)
	  (empty-sosofo)
	  (make sequence
	    (simplelist-entry rownum colnum majororder rows cols members)
	    (colloop (+ colnum 1)))))))

(define (simplelist-entry rownum colnum majororder rows cols members)
  (let ((membernum (if (equal? majororder 'row)
		       (+ (* (- rownum 1) cols) colnum)
		       (+ (* (- colnum 1) rows) rownum))))
    (let loop ((nl members) (count membernum))
      (if (<= count 1)
	  (make table-cell
	    column-number: colnum
	    n-columns-spanned: 1
	    n-rows-spanned: 1
;; removed to avoid dependency between dblists and dbtable
;;	    cell-before-row-margin: %cals-cell-before-row-margin%
;;	    cell-after-row-margin: %cals-cell-after-row-margin%
;;	    cell-before-column-margin: %cals-cell-before-column-margin%
;;	    cell-after-column-margin: %cals-cell-after-column-margin%
;;	    start-indent: %cals-cell-content-start-indent%
;;	    end-indent: %cals-cell-content-end-indent%
;; is another variable needed to parameterize these settings, or are
;; constants good enough?
	    cell-before-row-margin: 0pt
	    cell-after-row-margin: 0pt
	    cell-before-column-margin: 3pt
	    cell-after-column-margin: 3pt
	    start-indent: 0pt
	    end-indent: 0pt
	    (if (node-list-empty? nl)
		(literal " ")
		(process-node-list (node-list-first nl))))
	  (loop (node-list-rest nl) (- count 1))))))

(element SIMPLELIST
  (let ((type (attribute-string "type"))
	(cols (if (attribute-string "columns")
		  (if (> (string->number (attribute-string "columns")) 0)
		      (string->number (attribute-string "columns"))
		      1)
		  1))
	(members (select-elements (children (current-node)) "MEMBER")))
    (case type
       (("INLINE") (process-children))
       (("VERT")   (simplelist-table 'column cols members))
       (("HORIZ")  (simplelist-table 'row    cols members)))))

(element MEMBER
  (let ((type (inherited-attribute-string "type")))
    (if (equal? type "INLINE")
	(make sequence
	  (process-children)
	  (if (not (last-sibling?))
	      (literal ", ")
	      (literal "")))
	(make paragraph
	  quadding: 'start
	  (process-children)))))

(element SEGMENTEDLIST (process-children))
(element (SEGMENTEDLIST TITLE) ($lowtitle$ 2))

(element SEGTITLE (empty-sosofo))
(mode seglist-in-seg
  (element SEGTITLE
    (make sequence
      font-family-name: %title-font-family%
      font-weight: 'bold
      (process-children))))

(element SEGLISTITEM ($paragraph$))
(element SEG 
  (let* ((seg-num (child-number (current-node)))
	 (seglist (parent (parent (current-node))))
	 (segtitle (nth-node (select-elements 
			 (descendants seglist) "SEGTITLE") seg-num)))

    ;; Note: segtitle is only going to be the right thing in a well formed
    ;; SegmentedList.  If there are too many Segs or too few SegTitles,
    ;; you'll get something odd...maybe an error

    (with-mode seglist-in-seg
      (make paragraph
	(make sequence
	  font-family-name: %title-font-family%
	  font-weight: 'bold
	  (sosofo-append (process-node-list segtitle))
	  (literal ": "))
	(process-children)))))

(element CALLOUTLIST ($list$))
(element (CALLOUTLIST TITLE) ($lowtitle$ 2))

(element CALLOUT
  (let* ((calloutcontent (children (current-node)))
	 (arearefs (inherited-attribute-string "AREAREFS"))
	 (idlist (split arearefs)))
    (make sequence
      start-indent: (+ (inherited-start-indent) (COSTEP))

      (make paragraph
	use: para-style
	space-before: %para-sep%
	first-line-start-indent: (- (COSTEP))
	(make line-field
	  field-width: (COSTEP)
	  (let loop ((ids idlist))
	    (if (null? ids)
		(empty-sosofo)
		(make sequence
		  ($callout-mark$ (element-with-id (car ids)))
		  (loop (cdr ids))))))
	(process-node-list (children (node-list-first calloutcontent))))

      (process-node-list (node-list-rest calloutcontent)))))
