;; $Id: dbblock.dsl,v 1.1 1998/02/18 13:14:08 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(element HIGHLIGHTS ($block-container$))

(element BLOCKQUOTE
  (make paragraph
	font-size: (* %bf-size% %smaller-size-factor%)
	line-spacing: (* %bf-size% %line-spacing-factor%
			 %smaller-size-factor%)
	space-before: %para-sep%
	start-indent: (+ %body-start-indent% 1em)
	end-indent: 1em
	(process-children-trim)))

(element EPIGRAPH ($block-container$))

(element ATTRIBUTION ($paragraph$))

(element PARA ($paragraph$))
(element SIMPARA ($paragraph$))

(element FORMALPARA ($para-container$))

(element (FORMALPARA TITLE) ($runinhead$))
(element (FORMALPARA PARA) (make sequence (process-children)))

(element SIDEBAR ($semiformal-object$))
(element (SIDEBAR TITLE) (empty-sosofo))

(element ABSTRACT (process-children))

(element (ABSTRACT PARA) 
  (make paragraph
    use: para-style
    space-before: %para-sep%
    space-after: %para-sep%
    start-indent: %body-start-indent%
    (process-children)))

(element AUTHORBLURB ($block-container$))

(define ($inline-object$)
  (process-children))

(define ($informal-object$)
  (make display-group
    start-indent: (+ %block-start-indent% (inherited-start-indent))
    space-before: %block-sep%
    space-after: %block-sep%
    (process-children)))

(define ($formal-object$)
  (let* ((nsep  (gentext-label-title-sep (gi))))
    (make sequence
      (make paragraph
	use: para-style
	font-weight: 'bold
	space-before: %block-sep%
	space-after: %para-sep%
	start-indent: (+ %block-start-indent% (inherited-start-indent))
	keep-with-next?: #t
	(literal (gentext-element-name (gi)))
	(if (string=? (element-label) "")
	    (literal nsep)
	    (literal " " (element-label) nsep))
	(element-title-sosofo))
      (make paragraph
	use: para-style
	font-weight: 'bold
	space-before: 0pt
	space-after: %block-sep%
	start-indent: (+ %block-start-indent% (inherited-start-indent))
	(process-children)))))

(define ($semiformal-object$)
  (if (node-list-empty? (select-elements (children (current-node)) "TITLE"))
      ($informal-object$)
      ($formal-object$)))

(element EXAMPLE ($formal-object$))

(element (EXAMPLE TITLE) (empty-sosofo)) ; don't show caption below example
(element INFORMALEXAMPLE ($informal-object$))

(element (FIGURE TITLE) (empty-sosofo)) ; don't show caption below figure

(element FIGURE ($formal-object$))

(element INFORMALTABLE ($informal-object$))

(element TABLE 
  ;; can't be a "formal-object" because it requires special handling for
  ;; the PGWIDE attribute
  (let* ((nsep   (gentext-label-title-sep (gi)))
	 (pgwide (attribute-string "PGWIDE"))
	 (indent (lambda () (if (not (equal? pgwide "1"))
				(+ %block-start-indent% 
				   (inherited-start-indent))
				%cals-pgwide-start-indent%))))
    (make sequence
      (make paragraph
	use: para-style
	font-weight: 'bold
	space-before: %block-sep%
	space-after: %para-sep%
	start-indent: (indent)
	keep-with-next?: #t
	(literal (gentext-element-name (gi)))
	(if (string=? (element-label) "")
	    (literal nsep)
	    (literal " " (element-label) nsep))
	(element-title-sosofo))
      (make paragraph
	use: para-style
	font-weight: 'bold
	space-before: 0pt
	space-after: %block-sep%
	start-indent: (indent)
	(process-children)))))

(element (TABLE TITLE) (empty-sosofo))

;; ======================================================================
;; Handle footnotes in the body...

(define %footnote-field-width% 1.6em)
(define %footnote-number-restarts% #t)
(define %footnote-endnote-break% #f)

(define (footnote-number footnote)
  (if %footnote-number-restarts%
      (format-number (component-child-number footnote) "1")
      (format-number (component-child-number footnote '("BOOK")) "1")))

(element FOOTNOTE 
  ($ss-seq$ + (literal (footnote-number (current-node)))))

(define (non-table-footnotes footnotenl)
  (let loop ((nl footnotenl) (result (empty-node-list)))
    (if (node-list-empty? nl)
	result
	(if (has-ancestor-member? (node-list-first nl) 
				  '("TABLE" "INFORMALTABLE"))
	    (loop (node-list-rest nl) 
		  result)
	    (loop (node-list-rest nl)
		  (node-list result (node-list-first nl)))))))

(define (make-endnote-header)
  (let ((headsize (if (equal? (gi) "REFENTRY")
		      (HSIZE 2)
		      (HSIZE 3)))
	(indent   (lambda () (if (equal? (gi) "REFENTRY")
				 (inherited-start-indent)
				 0pt))))
    (make paragraph
      break-before: %footnote-endnote-break%
      font-family-name: %title-font-family%
      font-weight: 'bold
      font-size: headsize
      line-spacing: (* headsize %line-spacing-factor%)
      space-before: (* headsize %head-before-factor%)
      space-after: (* headsize %head-after-factor%)
      start-indent: (indent)
      quadding: 'start
      keep-with-next?: #t
      (literal %gentext-endnotes%))))

(define (make-endnotes)
  (let* ((allfootnotes (select-elements (descendants (current-node)) 
					"FOOTNOTE"))
	 (footnotes    (non-table-footnotes allfootnotes)))
    (if (node-list-empty? footnotes) 
	(empty-sosofo)
	(if (equal? (gi (current-node)) "REFERENCE")
	    (empty-sosofo) ;; Each RefEntry does its own...
	    (make sequence
	      (make-endnote-header)
	      (with-mode endnote-mode
		(process-node-list footnotes)))))))

(mode endnote-mode
  (element FOOTNOTE
    (process-children))

  (element (FOOTNOTE PARA)
    (let ((fnnum  (footnote-number (parent (current-node))))
	  (indent (lambda () (if (have-ancestor? "REFENTRY")
				 (inherited-start-indent)
				 0pt))))
      (if (= (child-number) 1)
	  (make paragraph
	    use: para-style
	    space-before: %para-sep%
	    start-indent: (+ (indent) %footnote-field-width%)
	    first-line-start-indent: (- %footnote-field-width%)
	    (make line-field
	      field-width: %footnote-field-width%
	      (literal fnnum 
		       (gentext-label-title-sep "FOOTNOTE")))
	    (process-children))
	  (make paragraph
	    use: para-style
	    start-indent: (+ (indent) %footnote-field-width%)
	    space-before: %para-sep%
	    (process-children))))))

;; ======================================================================
;; Handle table footnotes

(define (table-footnote-number footnote)
  (format-number (component-child-number footnote 
					 %table-element-list%) "a"))

(element (ENTRY FOOTNOTE)
  ($ss-seq$ + (literal (table-footnote-number (current-node)))))

(element (ENTRY PARA FOOTNOTE)
  ($ss-seq$ + (literal (table-footnote-number (current-node)))))

(define (make-table-endnote-header)
  (make paragraph
    font-family-name: %body-font-family%
    font-weight: 'medium
    font-size: %bf-size%
    start-indent: 0pt
    quadding: 'start
    (literal %gentext-table-endnotes%)))

(define (make-table-endnotes)
  (let* ((footnotes (select-elements (descendants (current-node)) 
				     "FOOTNOTE"))
	 (headsize (HSIZE 3))
	 (tgroup (ancestor-member (current-node) '("TGROUP")))
	 (cols   (string->number (attribute-string "COLS" tgroup))))
    (if (node-list-empty? footnotes) 
	(empty-sosofo)
	(make table-row
	  (make table-cell
	    n-columns-spanned: cols
	    cell-before-row-margin: %cals-cell-before-row-margin%
	    cell-after-row-margin: %cals-cell-after-row-margin%
	    cell-before-column-margin: %cals-cell-before-column-margin%
	    cell-after-column-margin: %cals-cell-after-column-margin%
	    start-indent: %cals-cell-content-start-indent%
	    end-indent: %cals-cell-content-end-indent%
	    (make-table-endnote-header)
	    (with-mode table-footnote-mode
	      (process-node-list footnotes)))))))

(mode table-footnote-mode
  (element FOOTNOTE
    (process-children))

  (element (FOOTNOTE PARA)
    (let ((fnnum (table-footnote-number (parent (current-node)))))
      (if (= (child-number) 1)
	  (make paragraph
	    use: para-style
	    start-indent: %footnote-field-width%
	    first-line-start-indent: (- %footnote-field-width%)
	    (make line-field
	      field-width: %footnote-field-width%
	      (literal fnnum 
		       (gentext-label-title-sep "FOOTNOTE")))
	    (process-children))
	  (make paragraph
	    use: para-style
	    start-indent: %footnote-field-width%
	    (process-children))))))

