/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2004 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtLanguageProc
 *   XtSetLanguageProc()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <locale.h>
#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext, app_ctext2;
Display *display_good;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char client_stuff[] = "These are the times that try men's souls";

/*
** Procedure XtLP_Proc
*/
String XtLP_Proc(display, language, client_data)
Display *display;
String language;
XtPointer client_data;
{
	avs_set_event(1,avs_get_event(1)+1);
	tet_infoline("TEST: Client data correctly passed to language procedure");
	if (strcmp(client_data, client_stuff) != 0) {
		sprintf(ebuf, "ERROR: Expected client_data \"%s\", received \"%s\"", client_stuff, (char *)client_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	return (String)setlocale(LC_ALL, NULL);
}

void WarnH(msg)
String msg;
{
	avs_set_event(2,1);
}



#define T_XtSetLanguageProc	1
char    *TestName = "XtSetLanguageProc";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
Widget	TopLevel2;
XtLanguageProc	oldproc;
int	argcount = 0;
int 	status;
#endif
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSetLanguageProc-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XtLanguageProc XtSetLanguageProc(app_context, proc,");
	report_assertion("client_data) shall register proc as the language procedure");
	report_assertion("that will be called from XtDisplayInitialize() for all");
	report_assertion("subsequent displays initialized in app_context and return");
	report_assertion("the previously registered language procedure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Register XT error handler");
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Call XtSetLanguageProc");
	oldproc = XtSetLanguageProc(app_ctext, &XtLP_Proc, client_stuff);
	tet_infoline("TEST: Initialize display");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    (String *)NULL );
	tet_infoline("TEST: Language procedure was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "language procedure invocation count");
	tet_infoline("PREP: Open another display connection");
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize it");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    (String *)NULL );
	tet_infoline("TEST: Language procedure was invoked again");
	status = avs_get_event(1);
	check_dec(2, status, "language procedure invocation count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2028 */
/* End of included file Mdefcode.tmc.2028 */

static void t002(){

#if XT_X_RELEASE > 4
XtLanguageProc	oldproc;
int	argcount = 0;
int	status;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSetLanguageProc-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XtLanguageProc XtSetLanguageProc(app_context, proc,");
	report_assertion("client_data) when app_context is NULL shall register proc in");
	report_assertion("all application contexts created by the application,");
	report_assertion("including those created in the future.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Register XT error handler");
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Call XtSetLanguageProc with NULL application context");
	oldproc = XtSetLanguageProc(NULL, &XtLP_Proc, client_stuff);
	tet_infoline("TEST: Initialize display");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    (String *)NULL );
	tet_infoline("TEST: Language procedure was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "language procedure invocation count");
	tet_infoline("PREP: Establish another application context");
	app_ctext2 = XtCreateApplicationContext();
	tet_infoline("PREP: Register XT error handler");
	XtAppSetErrorMsgHandler(app_ctext2, xt_handler);
	tet_infoline("PREP: Open another display connection");
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize it");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    (String *)NULL );
	tet_infoline("TEST: Language procedure was invoked again");
	status = avs_get_event(1);
	check_dec(2, status, "language procedure invocation count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2028 */
/* End of included file Mdefcode.tmc.2028 */

static void t003(){

#if XT_X_RELEASE > 4
XtLanguageProc	oldproc, oldproc2;
int	argcount = 0 ;
int	status;
#endif
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtSetLanguageProc-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XtLanguageProc XtSetLanguageProc(app_context, proc,");
	report_assertion("client_data) when proc is NULL shall register a default");
	report_assertion("language procedure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Register XT error handler");
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("TEST: Call XtSetLanguageProc with NULL proc");
	/*when nothing has been registered, returns what gets the default*/
	oldproc = XtSetLanguageProc(app_ctext, NULL, client_stuff);
	tet_infoline("TEST: Call XtSetLanguageProc again to get last proc set");
	oldproc2 = XtSetLanguageProc(app_ctext, &XtLP_Proc, client_stuff);
	tet_infoline("TEST: Compare returns from two calls");
	if (oldproc != oldproc2) {
		sprintf(ebuf, "ERROR: Default language procedure wasn't registered");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Call XtSetLanguageProc again with NULL proc");
	oldproc = XtSetLanguageProc(app_ctext, NULL, client_stuff);
	tet_infoline("TEST: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize display");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    (String *)NULL );
	tet_infoline("TEST: Test procedure was not invoked");
	status = avs_get_event(1);
	check_dec(0, status, "language procedure invocation count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2028 */
/* End of included file Mdefcode.tmc.2028 */

static void t004(){

#if XT_X_RELEASE > 4
int	argcount = 0;
int	status;
XtLanguageProc	oldproc, oldproc2;
#endif
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtSetLanguageProc-4.(C)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has not yet been registered, a call to");
	report_assertion("XtLanguageProc XtSetLanguageProc(app_context, proc,");
	report_assertion("client_data) shall return a value which will cause the");
	report_assertion("default language procedure to be registered when used in a");
	report_assertion("subsequent call to XtSetLanguageProc().");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Register XT error handler");
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("TEST: Call XtSetLanguageProc setting test procedure");
	oldproc = XtSetLanguageProc(app_ctext, &XtLP_Proc, client_stuff);
	tet_infoline("TEST: Call XtSetLanguageProc with return from first call");
	oldproc2 = XtSetLanguageProc(app_ctext, oldproc, client_stuff);
	tet_infoline("TEST: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize display");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc4",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    (String *)NULL );
	tet_infoline("TEST: Test procedure was not invoked");
	status = avs_get_event(1);
	check_dec(0, status, "language procedure invocation count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2028 */
/* End of included file Mdefcode.tmc.2028 */

/* Including from file Mdefcode.tmc.2028 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtSetLanguageProc-5.(B)");
	report_assertion("If the implementation is X11R5 or later: The default");
	report_assertion("language procedure set by a call to XtLanguageProc");
	report_assertion("XtSetLanguageProc(app_context, proc, client_data) shall set");
	report_assertion("the locale according to the environment.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2028 */

/* Including from file Mdefcode.tmc.2028 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtSetLanguageProc-6.(B)");
	report_assertion("If the implementation is X11R5 or later: The default");
	report_assertion("language procedure set by a call to XtLanguageProc");
	report_assertion("XtSetLanguageProc(app_context, proc, client_data) shall");
	report_assertion("issue a warning if an error is encountered in setting the");
	report_assertion("locale.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2028 */

static void t007(){

#if XT_X_RELEASE > 4
Widget	TopLevel2;
XtLanguageProc	oldproc;
int	argcount = 0;
int 	status;
#endif
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtSetLanguageProc-7.(C)");
	report_assertion("If the implementation is X11R5 or later: The default");
	report_assertion("language procedure set by a call to XtLanguageProc");
	report_assertion("XtSetLanguageProc(app_context, proc, client_data) shall");
	report_assertion("issue a warning and the set the locale to C if the locale");
	report_assertion("specified by the environment is not supported.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	putenv("LC_ALL=unreal");
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	XtAppSetWarningHandler(app_ctext, WarnH);
	tet_infoline("TEST: Call XtSetLanguageProc again with NULL proc");
	oldproc = XtSetLanguageProc(app_ctext, NULL, client_stuff);
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize display");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    NULL);
	tet_infoline("TEST: Warning was issued");
	status = avs_get_event(2);
	check_dec(1, status, "warning handler invocation count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2028 */
/* End of included file Mdefcode.tmc.2028 */

static void t008(){

#if XT_X_RELEASE > 4
Widget	TopLevel2;
XtLanguageProc	oldproc;
int	argcount = 0;
int 	status;
char *mod_ret;
#endif
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtSetLanguageProc-8.(C)");
	report_assertion("If the implementation is X11R5 or later: After setting the");
	report_assertion("locale, the default language procedure set by a call to");
	report_assertion("XtLanguageProc XtSetLanguageProc(app_context, proc,");
	report_assertion("client_data) shall set the X locale modifiers to the empty");
	report_assertion("string.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	XtAppSetWarningHandler(app_ctext, WarnH);
	tet_infoline("TEST: Call XtSetLanguageProc again with NULL proc");
	oldproc = XtSetLanguageProc(app_ctext, NULL, client_stuff);
	tet_infoline("PREP: Open a display connection");
	sleep(config.reset_delay);
	display_good = XOpenDisplay(config.display);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Initialize display");
	XtDisplayInitialize(app_ctext, display_good, "tstlnggprc1",
	    "Tstlnggprc1",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0, &argcount,
	    NULL);
	tet_infoline("PREP: Get locale modifiers");
	mod_ret = XSetLocaleModifiers("");
	if (mod_ret == NULL) {
		tet_infoline("ERROR: XSetLocaleModifiers return value is NULL");
		tet_result(TET_FAIL);
	} else {
	if (strcmp(mod_ret, "") != 0) {
		sprintf(ebuf, "ERROR: Expected empty string, received \"%s\"", mod_ret);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	}
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2028 */
/* End of included file Mdefcode.tmc.2028 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
