/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Display *
 *   XtOpenDisplay()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char *args11[] = {
	"-background", "green",
	"-bd", "green",
	"-bg", "green",
	"-borderwidth", "3",
	"-bordercolor", "red",
	"-bw", "3",
	"-fg", "green",
	"-font", XtDefaultFont,
	"-fn", XtDefaultFont,
	"-foreground", "blue",
	"-geometry", "100x100",
	"-iconic", 
	"-reverse",
	"-rv",
	"+rv",
	"-selectionTimeout", "50",
	"-synchronous",
	"+synchronous",
	"-title", "ApTest",
	"-xnlLanguage", "C",
	NULL};


typedef struct _instance_variables {
        long foreground;
        String label;
} instance_variable_rec;

static XtResource resources[] = {
        {
        XtNforeground,
        XtCForeground,
        XtRPixel, sizeof(Pixel),
        XtOffsetOf(instance_variable_rec, foreground),
        XtRString, "XtDefaultForeground"
        },
        {
        XtNlabel,
        XtCLabel,
        XtRString, sizeof(String),
        XtOffsetOf(instance_variable_rec, label),
        XtRString, "very bad idea"
        },
};


#define T_XtOpenDisplay	1
char    *TestName = "XtOpenDisplay";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 0;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtOpenDisplay-1.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall open the display");
	report_assertion("specified by the argument display_string, create a resource");
	report_assertion("database for the display, and return a pointer to the opened");
	report_assertion("display.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,	/* application context */
		(String)config.display,	/* display name */
		"topndsply1",	/* application name use argv[0] */
		"Topndsply1",	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,	 /* command line options */
		&argcount,
		(String *)NULL	/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Get the application name and class");
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	tet_infoline("TEST: Application name and class.");
	check_str("topndsply1", name_good, "Name of Application:");
	check_str("Topndsply1", class_good,"Class of Application:");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t002(){

char	name_good[40];
Display	*display_good;
char	*display_name;
int	argc_count;
char	**argv_string;
int	count = 3;
char	*argvals[4];
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtOpenDisplay-2.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when display_string is");
	report_assertion("NULL shall use the -display option specified in argv as the");
	report_assertion("display to be opened and initialized.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("PREP: Construct -display option");
	argvals[0] = "topndsply2";
	argvals[1] = "-display";
	argvals[2] = (char *)config.display;
	argvals[3] = (char *)NULL;
	argc_count = count;
	argv_string = &argvals[0];
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,	/* application context */
		(String)NULL,	/* display name */
		"topndsply2",	/* application name use argv[0] */
		"Topndsply2",	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,	/* command line options */
		&argc_count,
		argv_string	/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Display name is correct.");
	display_name = XDisplayString(display_good);
	check_str(config.display, display_name, "Display name");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t003(){

Display	*display_good;
String	name_good, class_good;
char	return_name[40];
char	*display_name;
int	argcount = 0;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtOpenDisplay-3.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when display_string is");
	report_assertion("NULL and the -display option is not specified in argv shall");
	report_assertion("use the value set in the DISPLAY environment variable as the");
	report_assertion("display to be opened and initialized.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,	/* application context */
		(String)NULL,	/* display name */
		"topndsply3",	/* application name use argv[0] */
		"Topndsply3",	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,	/* command line options */
		&argcount,
		(String *)NULL	/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Check the env DISPLAY name is used.");
	display_name = XDisplayString(display_good);
	check_str(config.display, display_name, "Display name");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t004(){

Display	*display_good;
String	name_good, class_good;
int	argc_count;
char	**argv_string;
int	count = 3;
char	*argvals[4];
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtOpenDisplay-4.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when the -name option is");
	report_assertion("specified in argv shall use this value as the application");
	report_assertion("name to query the server and screen resource databases for");
	report_assertion("the name.xnlLanguage resource to create the resource");
	report_assertion("database for the display.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("PREP: Construct -name option");
	argvals[0] = "topndsply4";
	argvals[1] = "-name";
	argvals[2] = "topndsply4";
	argvals[3] = (char *)NULL;
	argc_count = count;
	argv_string = &argvals[0];
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,		/* application context */
		(String)config.display,	/* display name */
		(String)NULL,	 	/* application name use argv[0] */
		"Topndsply4",	 	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,		/* command line options */
		&argc_count,
		argv_string		/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Get the application name");
	XtGetApplicationNameAndClass(display_good, &name_good,
		&class_good );
	tet_infoline("TEST: Application name");
	check_str("topndsply4", name_good, "Name of Application:");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t005(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 0;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtOpenDisplay-5.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when the -name option is");
	report_assertion("not specified in argv and application_name is non-NULL shall");
	report_assertion("use this value as the application name to query the server");
	report_assertion("and the screen resource databases for the name.xnlLanguage");
	report_assertion("resource to create the resource database for the display.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,		/* application context */
		(String)config.display,	/* display name */
		"topndsply5",	 	/* application name use argv[0] */
		"Topndsply5",	 	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,	 	/* command line options */
		&argcount,
		(String *)NULL		/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Get the application name");
	XtGetApplicationNameAndClass(display_good, &name_good,
		&class_good );
	tet_infoline("TEST: Application name");
	check_str("topndsply5", name_good, "Name of Application");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t006(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 0;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtOpenDisplay-6.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when the -name option is");
	report_assertion("not specified in argv, application_name is NULL, and the");
	report_assertion("environment variable RESOURCE_NAME is set shall use this");
	report_assertion("value as the application name to query the server and screen");
	report_assertion("resource databases for the name.xnlLanguage resource to");
	report_assertion("create the resource database for the display.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("PREP: Set up env variable RESOURCE_NAME=topndsply5");
	putenv("RESOURCE_NAME=topndsply6");
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,		/* application context */
		(String)config.display,	/* display name */
		(String)NULL,		/* application name use argv[0] */
		"Topndsply6",	 	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,		/* command line options */
		&argcount,
		(String *)NULL		/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Get the application name");
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	tet_infoline("TEST: Application name");
	check_str("topndsply6", name_good, "Name of Application:");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t007(){

Display	*display_good;
String	name_good, class_good;
int	argc_count;
char	**argv_string;
char	argv1[] = "topndsply7";
char	*argvals[2] = { "topndsply7", 0 };
int	count = 1;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtOpenDisplay-7.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when the -name option is");
	report_assertion("not specified in argv, application_name is NULL, the");
	report_assertion("environment variable RESOURCE_NAME is not set, and argv[0]");
	report_assertion("is not an empty string shall use this value as the");
	report_assertion("application name to query the server and screen resource");
	report_assertion("databases for the name.xnlLanguage resource to create the");
	report_assertion("resource database for the display.");
	FORK(pid);
	initconfig();

	argc_count = count;
	argv_string = &argvals[0];
	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,		/* application context */
		(String)config.display,	/* display name */
		(String)NULL,		/* application name use argv[0] */
		"Topndsply7",	 	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,		/* command line options */
		&argc_count,
		(String *)argv_string	/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Get the application name");
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	tet_infoline("TEST: Application name");
	check_str("topndsply7", name_good, "Name of Application:");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t008(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 0;
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtOpenDisplay-8.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when the -name option is");
	report_assertion("not specified in argv, application_name is NULL, the");
	report_assertion("environment variable RESOURCE_NAME is not set, and argv[0]");
	report_assertion("is an empty string shall use the string main as the");
	report_assertion("application name to query the server and screen resource");
	report_assertion("databases for the name.xnlLanguage resource to create the");
	report_assertion("resource database for the display.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,		/* application context */
		(String)config.display,	/* display name */
		(String)NULL,	 	/* application name use argv[0] */
		"Topndsply1",	 	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,		/* command line options */
		&argcount,
		(String *)NULL		/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Get the application name");
	XtGetApplicationNameAndClass(display_good, &name_good,
		&class_good );
	tet_infoline("TEST: Application name is main");
	check_str("main", name_good, "Name of Application:");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t009(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 0;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtOpenDisplay-9.(A)");
	report_assertion("A call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall return NULL on");
	report_assertion("failure.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,	/* application context */
		"gibberish",	/* display name */
		"topndsply1",	/* application name use argv[0] */
		"Topndsply1",	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,	/* command line options */
		&argcount,
		(String *)NULL	/* command line args */
	 );
	tet_infoline("TEST: returns NULL with non-existant display");
	if (display_good != NULL) {
		tet_infoline("ERROR: expected NULL, got a display");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t010(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
int argc = 2;
    /*
    ** -synchronous on
    ** +synchronous off
    */
char *argv[] = { "tdsplyintl2", "-synchronous", NULL };
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtOpenDisplay-10.(A)");
	report_assertion("When the synchronize resource is set to True in the");
	report_assertion("resource database created by a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) it shall put Xlib into synchronous mode for this");
	report_assertion("display connection and any others currently open in the");
	report_assertion("application context app_context.");
	FORK(pid);
	initconfig();

	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("TEST: Open a display connection");
	sleep(config.reset_delay);
	display = XtOpenDisplay(app_ctext,
		config.display,
	    "tdsplyintl2",
	    "Tdsplyintl2",
	    (XrmOptionDescRec *)NULL,
	    (Cardinal)0,
	&argc, &argv[0] );
	if (display == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Create a window for events");
	scr = DefaultScreen(display);
	window = XCreateWindow(display, RootWindow(display, scr),
	       0, 0, 5, 5, 0, /* x,y,wid,ht,brd width */
	       DefaultDepth(display, scr),
	       InputOutput,
	       DefaultVisual(display, scr),
	       (XtValueMask) 0,
	       (XSetWindowAttributes *) 0);
	tet_infoline("TEST: Check Xlib is in synchronous mode");
	queued_events = XQLength(display);
	XSelectInput(display, window,
	     (unsigned long)PropertyChangeMask);
	for (events = 0; events < 3; events++)
		XChangeProperty(display, window, XA_RESOURCE_MANAGER,
			XA_STRING, 8,0, (unsigned char *)property_data, 16);
	check_dec(3+queued_events, XQLength(display), "queue length");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtOpenDisplay-11.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has been registered for the application context");
	report_assertion("app_context a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) shall call the language procedure with a");
	report_assertion("language string determined by searching the following");
	report_assertion("sources in the specified order: - the -xnlLanguage resource");
	report_assertion("or a -xrm option containing the xnlLanguage/XnlLanguage");
	report_assertion("resource defined in the command line, - the resource");
	report_assertion("application_name.xnlLanguage, class");
	report_assertion("application_class.XnlLanguage in the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("if it exists, and in the user preference resource file");
	report_assertion("otherwise.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtOpenDisplay-12.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has been registered for the application context");
	report_assertion("app_context a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) shall call the procedure with the empty string");
	report_assertion("if the server's RESOURCE_MANAGER property for the root");
	report_assertion("window of screen zero exists and a language string is not");
	report_assertion("found on the command line or in this property.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtOpenDisplay-13.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has been registered for the application context");
	report_assertion("app_context a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) shall call the procedure with the empty string");
	report_assertion("if the server's RESOURCE_MANAGER property for the root");
	report_assertion("window of screen zero does not exist and a language string");
	report_assertion("is not found on the command line or in the user preference");
	report_assertion("resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtOpenDisplay-14.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has not been registered for the application");
	report_assertion("context app_context a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) shall determine a language string for the");
	report_assertion("display by searching the following sources in the specified");
	report_assertion("order: - the resource database created from the command");
	report_assertion("line. - the resource application_name.xnlLanguage, class");
	report_assertion("application_class.XnlLanguage in the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("if it exists, or in the user preference resource file");
	report_assertion("otherwise. - the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtOpenDisplay-15.(D)");
	report_assertion("If the implementation is X11R5 or later and is POSIX-based:");
	report_assertion("When a language procedure has not been registered for the");
	report_assertion("application context app_context a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) shall use the LANG environment variable as the");
	report_assertion("environment value to search when determining the language");
	report_assertion("string for the display.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t016(){

pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtOpenDisplay-16.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has not been registered for the application");
	report_assertion("context app_context a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) shall set the language string for the display to");
	report_assertion("the empty string if the server's RESOURCE_MANAGER property");
	report_assertion("for the root window of screen zero exists, and a language");
	report_assertion("string is not found on the command line, in this property,");
	report_assertion("or in the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t017(){

pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtOpenDisplay-17.(D)");
	report_assertion("If the implementation is X11R5 or later: When a language");
	report_assertion("procedure has not been registered for the application");
	report_assertion("context app_context a successful call to Display");
	report_assertion("*XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) shall set the language string for the display to");
	report_assertion("the empty string if the server's RESOURCE_MANAGER property");
	report_assertion("for the root window of screen zero does not exist and a");
	report_assertion("language string is not found on the command line, in the");
	report_assertion("user preference resource file, or in the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t018(){

pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtOpenDisplay-18.(D)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall associate with the");
	report_assertion("default screen of the display a resource database created by");
	report_assertion("combining entries from the following sources, in order, with");
	report_assertion("the first named source having the highest precedence: - the");
	report_assertion("application command line - the user's environment resource");
	report_assertion("file - per-screen resource specifications from the server,");
	report_assertion("as returned by XScreenResourceString() - per display");
	report_assertion("resource specifications from the server (the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen");
	report_assertion("zero) if they exist, otherwise the user preference file -");
	report_assertion("the application-specific user resource file. - the");
	report_assertion("application-specific class resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

static void t019(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 20;
instance_variable_rec base;
pid_t pid2;
pid_t	pid;

 	report_purpose(19);

	report_assertion("Assertion XtOpenDisplay-19.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall recognize options");
	report_assertion("specified on the command line that are in the standard table");
	report_assertion("of options in section 4.4 of the specification or in the");
	report_assertion("table specific to the application specified by options and");
	report_assertion("num_options.");
	FORK(pid);
	initconfig();

        FORK(pid2);
	XtToolkitInitialize();
	app_ctext= XtCreateApplicationContext();
	tet_infoline("TEST: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext,	/* application context */
		(String)config.display,	/* display name */
		"topndsply1",	/* application name use argv[0] */
		"Topndsply1",	/* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,	 /* command line options */
		&argcount,
		args11	 /* command line args */
	);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Create top level widget");
	topLevel = XtAppCreateShell("Hello", "World",
		 applicationShellWidgetClass, display_good,
		 (ArgList)NULL, (Cardinal)0);
        tet_infoline("TEST: Retrieve resource values from resource database");
        XtGetApplicationResources(topLevel,
                        &base,
                        resources,
                        1,
                        (ArgList)NULL,
                        (Cardinal)0);
        tet_infoline("TEST: Retrieved resource value");
        if ((base.foreground != 0) && (base.foreground != 1)) {
                sprintf(ebuf, "ERROR: expected foreground value of 0 or 1, received %d", base.foreground);
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

static void t020(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
int argc = 2;
char *argv[] = { "tdsplyintl2", "+rv", NULL };
Screen *screen;
Colormap colormap;
pid_t pid2;
Pixel res;
Boolean status;
pid_t	pid;

 	report_purpose(20);

	report_assertion("Assertion XtOpenDisplay-20.(A)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when the reverseVideo");
	report_assertion("resource is define as True on the command line shall use the");
	report_assertion("value of XtDefaultForeground instead of XtDefaultBackground");
	report_assertion("and vice versa in the resource database created for the");
	report_assertion("display.");
	FORK(pid);
	initconfig();

        FORK(pid2);
	tet_infoline("PREP: Initialize the Xt toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Create an application context");
	app_ctext = XtCreateApplicationContext();
	tet_infoline("TEST: Open a display connection with +rv in args");
	sleep(config.reset_delay);
	display = XtOpenDisplay(app_ctext,
		config.display,
		"tdsplyintl2",
		"Tdsplyintl2",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argc, &argv[0] );
	if (display == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Set up required conversion args");
        screen = DefaultScreenOfDisplay(display);
        args[0].addr = (XtPointer )&screen;
        args[0].size = sizeof(Screen*);
        colormap = DefaultColormapOfScreen(screen);
        args[1].addr = (XtPointer) &colormap;
        args[1].size = sizeof(Colormap);
        num_args = 2;
        tet_infoline("TEST: Convert XtDefaultForeground");
        fromVal.addr = XtDefaultForeground;
        fromVal.size = strlen(XtDefaultForeground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XBlackPixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        tet_infoline("TEST: Convert XtDefaultBackground");
        fromVal.addr = XtDefaultBackground;
        fromVal.size = strlen(XtDefaultBackground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XWhitePixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3400 */
/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t021(){

pid_t	pid;

 	report_purpose(21);

	report_assertion("Assertion XtOpenDisplay-21.(B)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) when the application");
	report_assertion("context app_context has more than one display and the");
	report_assertion("selectionTimeout resource is specified on the command line");
	report_assertion("shall set this value in the selectionTimeout resource in the");
	report_assertion("resource databases of all the displays in the application");
	report_assertion("context.");
	report_assertion("Reason for omission: Testing the assertion would require an unreasonable amount of time or resources on most systems");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t022(){

pid_t	pid;

 	report_purpose(22);

	report_assertion("Assertion XtOpenDisplay-22.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Display *XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable XENVIRONMENT");
	report_assertion("exists shall use the value of this variable as the name of");
	report_assertion("the user environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t023(){

pid_t	pid;

 	report_purpose(23);

	report_assertion("Assertion XtOpenDisplay-23.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Display *XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable XENVIRONMENT does");
	report_assertion("not exist shall use the file.Xdefaults-host, where host is");
	report_assertion("the name of the system running the application, in the");
	report_assertion("user's home directory as the user environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t024(){

pid_t	pid;

 	report_purpose(24);

	report_assertion("Assertion XtOpenDisplay-24.(B)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall set the values from");
	report_assertion("the higher precedence sources of the resource database being");
	report_assertion("created for the display as the current resource database");
	report_assertion("before determining the file name for the");
	report_assertion("application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t025(){

pid_t	pid;

 	report_purpose(25);

	report_assertion("Assertion XtOpenDisplay-25.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Display *XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) with the value of this variable as path as");
	report_assertion("the name of the application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t026(){

pid_t	pid;

 	report_purpose(26);

	report_assertion("Assertion XtOpenDisplay-26.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Display *XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is not defined and the environment");
	report_assertion("variable XAPPLRESDIR is not defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific user");
	report_assertion("resource file where path contains at least entries");
	report_assertion("containing $HOME as the directory prefix plus the following");
	report_assertion("substitutions, in the order specified: - %C, %N, %L or %C,");
	report_assertion("%N, %l, %t, %c - %C, %N, %l - %C, %N - %N, %L or %N, %l, %t,");
	report_assertion("%c - %N, %l - %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t027(){

pid_t	pid;

 	report_purpose(27);

	report_assertion("Assertion XtOpenDisplay-27.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Display *XtOpenDisplay(app_context, display_string,");
	report_assertion("application_name, application_class, options, num_options,");
	report_assertion("argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is not defined and the environment");
	report_assertion("variable XAPPLRESDIR is defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific user");
	report_assertion("resource file where path contains at least entries");
	report_assertion("containing the following directory prefixes and");
	report_assertion("substitutions, in the order specified: - $XPPLRESDIR with");
	report_assertion("%C, %N, %L or %C, %N, %l, %t, %c - $XPPLRESDIR with %C, %N,");
	report_assertion("%l - $XPPLRESDIR with %C, %N - $XPPLRESDIR with %N, %L or");
	report_assertion("%N, %l, %t, %c - $XPPLRESDIR with %N, %l - $XPPLRESDIR with");
	report_assertion("%N - $HOME with %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* Including from file Mdefcode.tmc.3400 */
static void t028(){

pid_t	pid;

 	report_purpose(28);

	report_assertion("Assertion XtOpenDisplay-28.(B)");
	report_assertion("A successful call to Display *XtOpenDisplay(app_context,");
	report_assertion("display_string, application_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall use the result of");
	report_assertion("calling XtResolvePathname(display, app-defaults, NULL,");
	report_assertion("NULL, NULL, NULL, 0, NULL) as the name of the");
	report_assertion("application-specific class resource file, with the values");
	report_assertion("from the higher precedence sources of the resource database");
	report_assertion("being created for the display set as the current resource");
	report_assertion("database before the call is made.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3400 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
