/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Display *
 *   XtDisplayOfObject()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtDisplayOfObject	1
char    *TestName = "XtDisplayOfObject";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good , widget_good;
Display *display_good;
Window window_good;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDisplayOfObject-1.(A)");
	report_assertion("A call to Display *XtDisplayOfObject(object) when object is");
	report_assertion("a widget shall return the display pointer for the widget.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tdisplofo1", "XtDisplayOfObject");
	tet_infoline("PREP: Create label widget `Hello' in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Get the display pointer for label widget `Hello' ");
	if ((display_good = XtDisplayOfObject(labelw_good) ) == NULL ) {
		sprintf(ebuf, "ERROR: Expected display pointer returned NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Display pointer is valid for widget");
	window_good = XtWindow(labelw_good);
	widget_good = XtWindowToWidget(display_good, window_good);
	check_str("Hello", XtName(widget_good), "widget name");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.244 */
/* End of included file Mdefcode.tmc.244 */

static void t002(){

Widget widget_good;
Display *display_good;
Window window_good;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDisplayOfObject-2.(A)");
	report_assertion("A call to Display *XtDisplayOfObject(object) when object is");
	report_assertion("not a widget shall return the display pointer of the nearest");
	report_assertion("ancestor of object that belongs to class Widget or a");
	report_assertion("subclass thereof.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tdisplofo2", "XtDisplayOfObject");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Get the display pointer for nearest widget");
	tet_infoline("      to push button gadget");
	if ( ( display_good = XtDisplayOfObject(click_quit) ) == NULL ) {
		sprintf(ebuf, "ERROR: Expected valid display pointer returned NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Display pointer is valid");
	window_good = XtWindow(rowcolw);
	widget_good = XtWindowToWidget(display_good, window_good);
	check_str("rowcolw", XtName(widget_good), "widget name");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.244 */
/* End of included file Mdefcode.tmc.244 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
