/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtGetSelectionValue()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

#define	SELECTION	XA_PRIMARY
#define	TYPE	XA_STRING
#define	MSG	 "Hello"
#define	FORMAT	8

/*
** local functions
*/
static Boolean convert_proc();
static void lose_proc();
static void done_proc();
static void requestor_callback();

/* procedure XtTMO_Proc to be invoked */
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}

static void XtEVT_handler1(sender_widget, client_data, event, continue_to_dispatch)
Widget sender_widget;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
Boolean status;
XButtonEvent *bevent;

	bevent = (XButtonEvent*)event;
	avs_set_event(1, 1); 
	status = XtOwnSelection(
		 sender_widget,
		 SELECTION,
		 bevent->time,
		 convert_proc,
		 NULL,
		 done_proc
		 );
	check_dec(True, status, "status");
}

static void XtEVT_handler2(receiver_widget, client_data, event, continue_to_dispatch)
Widget receiver_widget;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XButtonEvent *bevent;

	bevent = (XButtonEvent*)event;
	avs_set_event(2, 1); 
	XtGetSelectionValue(
		receiver_widget,
		SELECTION,
		TYPE,
		requestor_callback, 
		client_data,
		bevent->time
		);
}

static Boolean convert_proc(w, selection, target, type_return, value_return,
		length_return, format_return)
Widget w;
Atom *selection;
Atom *target;
Atom *type_return;
XtPointer *value_return;
unsigned long *length_return;
int *format_return;
{
	
	char *data;
	avs_set_event(4,1);
	if ( *target == TYPE ) {
	*length_return = strlen(MSG) * sizeof(char) + 1;
	data = XtMalloc(*length_return);
	strcpy(data, MSG);
	*value_return = data;
	*type_return = TYPE;
	*format_return = FORMAT;
	return(True);
	} else
	return(False);
}

static void lose_proc(w, selection)
Widget w;
Atom *selection;
{
	sprintf(ebuf, "ERROR: labelw_good widget lost selection ownership");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}

static void done_proc(w, selection, target)
Widget w;
Atom *selection;
Atom *target;
{
	XtDisownSelection(w, *selection, CurrentTime);
}

static void requestor_callback(w, client_data, selection, type, value,
		length, format)
Widget w;
XtPointer client_data;
Atom *selection;
Atom *type;
XtPointer value;
unsigned long *length;
int *format;
{
	avs_set_event(3,1);
	tet_infoline("TEST: Values sent to callback");
	check_dec(SELECTION, *selection, "*selection");
	check_dec(TYPE , *type, "*type");
	check_str(MSG, value, "*value");
	check_dec(strlen(MSG)+1, *length, "*length");
	check_dec(FORMAT, *format, "*format");
}

static void requestor_callback2(w, client_data, selection, type, value,
		length, format)
Widget w;
XtPointer client_data;
Atom *selection;
Atom *type;
XtPointer value;
unsigned long *length;
int *format;
{
	avs_set_event(3,1);
	tet_infoline("TEST: callback: value is NULL");
	if (value != NULL) {
		tet_infoline("ERROR: value is not NULL");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: callback: length is 0");
	check_dec(0, *length, "*length");
}

static void XtEVT2_handler2(receiver_widget, client_data, event, continue_to_dispatch)
Widget receiver_widget;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XButtonEvent *bevent;

	bevent = (XButtonEvent*)event;
	avs_set_event(2, 1); 
	XtGetSelectionValue(
		receiver_widget,
		SELECTION,
		TYPE,
		requestor_callback2, 
		client_data,
		bevent->time
		);
}

static Boolean convert_proc3(w, selection, target, type_return, value_return,
		length_return, format_return)
Widget w;
Atom *selection;
Atom *target;
Atom *type_return;
XtPointer *value_return;
unsigned long *length_return;
int *format_return;
{
	
	return(False);
}
static void XtEVT3_handler1(sender_widget, client_data, event, continue_to_dispatch)
Widget sender_widget;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
Boolean status;
XButtonEvent *bevent;

	bevent = (XButtonEvent*)event;
	avs_set_event(1, 1); 
	status = XtOwnSelection(
		 sender_widget,
		 SELECTION,
		 bevent->time,
		 convert_proc3,
		 NULL,
		 done_proc
		 );
	check_dec(True, status, "status");
}

static void XtEVT3_handler2(receiver_widget, client_data, event, continue_to_dispatch)
Widget receiver_widget;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XButtonEvent *bevent;

	bevent = (XButtonEvent*)event;
	avs_set_event(2, 1); 
	XtGetSelectionValue(
		receiver_widget,
		SELECTION,
		TYPE,
		requestor_callback2, 
		client_data,
		bevent->time
		);
}



#define T_XtGetSelectionValue	1
char    *TestName = "XtGetSelectionValue";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good;
pid_t pid2;
int invoked1, invoked2;
int invoked3;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetSelectionValue-1.(A)");
	report_assertion("A call to void XtGetSelectionValue(w, selection, target,");
	report_assertion("callback, client_data, time) shall cause the callback");
	report_assertion("procedure callback to be called with the value of the");
	report_assertion("selection selection converted to the type target, the widget");
	report_assertion("w, and client_data passed as arguments.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtsvalue1", "XtGetSelectionValue");
	tet_infoline("PREP: Create labelw_good widget Hello");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Register event handler XtEVT_handler1 to handle");
	tet_infoline("      ButtonPress events to labelw_good widget");
	XtAddEventHandler(labelw_good,
		 ButtonPressMask,
		 False,
		 XtEVT_handler1,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Register event handler XtEVT_handler2 to handle");
	tet_infoline("      ButtonRelease events to boxw2 widget");
	XtAddEventHandler(boxw2,
		 ButtonReleaseMask,
		 False,
		 XtEVT_handler2,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event");
	send_event(labelw_good, ButtonPress, ButtonPressMask, FALSE);
	tet_infoline("PREP: Send ButtonRelease event");
	send_event(boxw2, ButtonRelease, ButtonReleaseMask, FALSE);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: XtEVT_handler1 and XtEVT_handler2 invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	invoked1 = avs_get_event(1);
	check_dec(1, invoked1, "XtEVT_handler1 invocations count");
	invoked2 = avs_get_event(2);
	check_dec(1, invoked2, "XtEVT_handler2 invocations count");
	tet_infoline("TEST: Requestor callback invoked");
	invoked3 = avs_get_event(3);
	check_dec(1, invoked3, "requestor callback invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3928 */
/* End of included file Mdefcode.tmc.3928 */

static void t002(){

Widget labelw_good;
pid_t pid2;
int invoked1, invoked2;
int invoked3;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetSelectionValue-2.(A)");
	report_assertion("A call to void XtGetSelectionValue(w, selection, target,");
	report_assertion("callback, client_data, time) when the value of the specified");
	report_assertion("selection is not of type target shall cause the");
	report_assertion("XtConvertSelectionProc procedure of the selection owner to");
	report_assertion("be called to convert the selection value to the specified");
	report_assertion("type.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtsvalue1", "XtGetSelectionValue");
	tet_infoline("PREP: Create labelw_good widget Hello");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Register event handler XtEVT_handler1 to handle");
	tet_infoline("      ButtonPress events to labelw_good widget");
	XtAddEventHandler(labelw_good,
		 ButtonPressMask,
		 False,
		 XtEVT_handler1,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Register event handler XtEVT_handler2 to handle");
	tet_infoline("      ButtonRelease events to boxw2 widget");
	XtAddEventHandler(boxw2,
		 ButtonReleaseMask,
		 False,
		 XtEVT_handler2,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event");
	send_event(labelw_good, ButtonPress, ButtonPressMask, FALSE);
	tet_infoline("PREP: Send ButtonRelease event");
	send_event(boxw2, ButtonRelease, ButtonReleaseMask, FALSE);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: XtEVT_handler1 and XtEVT_handler2 invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	invoked1 = avs_get_event(1);
	check_dec(1, invoked1, "XtEVT_handler1 invocations count");
	invoked2 = avs_get_event(2);
	check_dec(1, invoked2, "XtEVT_handler2 invocations count");
	tet_infoline("TEST: Requestor callback invoked");
	invoked3 = avs_get_event(3);
	check_dec(1, invoked3, "requestor callback invocations count");
	tet_infoline("TEST: conversion procedure invoked");
	invoked3 = avs_get_event(4);
	check_dec(1, invoked3, "conversion procedure invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3928 */
/* End of included file Mdefcode.tmc.3928 */

static void t003(){

Widget labelw_good;
pid_t pid2;
int invoked1, invoked2;
int invoked3;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGetSelectionValue-3.(A)");
	report_assertion("When the selection selection has no owner a call to void");
	report_assertion("XtGetSelectionValue(w, selection, target, callback,");
	report_assertion("client_data, time) shall cause the callback procedure to be");
	report_assertion("called with the value parameter set to NULL and length set");
	report_assertion("to zero.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtsvalue1", "XtGetSelectionValue");
	tet_infoline("PREP: Create labelw_good widget Hello");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Register event handler XtEVT2_handler2 to handle");
	tet_infoline("      ButtonRelease events to boxw2 widget");
	XtAddEventHandler(boxw2,
		 ButtonReleaseMask,
		 False,
		 XtEVT2_handler2,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonRelease event");
	send_event(boxw2, ButtonRelease, ButtonReleaseMask, FALSE);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: XtEVT2_handler2 invoked");
	invoked2 = avs_get_event(2);
	check_dec(1, invoked2, "XtEVT2_handler2 invocations count");
	tet_infoline("TEST: Requestor callback invoked");
	invoked3 = avs_get_event(3);
	check_dec(1, invoked3, "requestor callback invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3928 */
/* End of included file Mdefcode.tmc.3928 */

static void t004(){

Widget labelw_good;
pid_t pid2;
int invoked1, invoked2;
int invoked3;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtGetSelectionValue-4.(A)");
	report_assertion("When the owner of the selection selection cannot convert");
	report_assertion("the selection value to the type target a call to void");
	report_assertion("XtGetSelectionValue(w, selection, target, callback,");
	report_assertion("client_data, time) shall cause the callback procedure to be");
	report_assertion("called with the value parameter set to NULL and length set");
	report_assertion("to zero.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtsvalue1", "XtGetSelectionValue");
	tet_infoline("PREP: Create labelw_good widget Hello");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Register event handler XtEVT3_handler1 to handle");
	tet_infoline("      ButtonPress events to labelw_good widget");
	XtAddEventHandler(labelw_good,
		 ButtonPressMask,
		 False,
		 XtEVT3_handler1,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Register event handler XtEVT3_handler2 to handle");
	tet_infoline("      ButtonRelease events to boxw2 widget");
	XtAddEventHandler(boxw2,
		 ButtonReleaseMask,
		 False,
		 XtEVT3_handler2,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event");
	send_event(labelw_good, ButtonPress, ButtonPressMask, FALSE);
	tet_infoline("PREP: Send ButtonRelease event");
	send_event(boxw2, ButtonRelease, ButtonReleaseMask, FALSE);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: XtEVT_handler1 and XtEVT_handler2 invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	invoked1 = avs_get_event(1);
	check_dec(1, invoked1, "XtEVT_handler1 invocations count");
	invoked2 = avs_get_event(2);
	check_dec(1, invoked2, "XtEVT_handler2 invocations count");
	tet_infoline("TEST: Requestor callback invoked");
	invoked3 = avs_get_event(3);
	check_dec(1, invoked3, "requestor callback invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3928 */
/* End of included file Mdefcode.tmc.3928 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
