/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   GC
 *   XtGetGC()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** actual gc values 
*/
void CheckValues(values_good)
XGCValues *values_good;
{
	check_dec((long) GXcopy,
		(long) values_good->function, "function");
	check_dec((long) ~0L, (long) values_good->plane_mask, "plane_mask");
	check_dec((long) 0, (long) values_good->foreground, "foreground");
	check_dec((long) 1, (long) values_good->background, "background");
	check_dec((long) 0, (long)values_good->line_width, "line_width");
	 check_dec((long)LineSolid, (long)values_good->line_style, "line_style");
	check_dec((long)CapButt, (long)values_good->cap_style, "cap_style");
	check_dec((long)JoinMiter, (long)values_good->join_style, "join_style");
	check_dec((long)FillSolid, (long)values_good->fill_style, "fill_style");
	check_dec((long)ArcPieSlice, (long)values_good->arc_mode, "arc_mode");
	check_dec((long)0, (long)values_good->ts_x_origin, "ts_x_origin");
	check_dec((long)0, (long)values_good->ts_y_origin, "ts_y_origin");
	check_dec((long)ClipByChildren, (long)values_good->subwindow_mode, "subwindow_mode");
	check_dec((long)True, (long)values_good->graphics_exposures, "graphics_exposures");
	check_dec((long)0, (long)values_good->clip_x_origin, "clip_x_origin");
	check_dec((long)0, (long)values_good->clip_y_origin, "clip_y_origin");
	check_dec((long)0, (long)values_good->dash_offset, "dash_offset");
}
XtGCMask ConstructGC(w, vals)
Widget w;
XGCValues *vals;
{
	Display *display_good;
	Window window_good;
	XtGCMask value_mask;
	Pixmap pixmap1, tilemap, stipmap;
	display_good = XtDisplay(w);
	window_good = XtWindow(w);
	value_mask = ( GCFunction | GCPlaneMask | GCForeground |
		GCBackground | GCLineWidth | GCLineStyle |
		GCCapStyle | GCJoinStyle | GCFillStyle |
		GCFillRule | GCTile | GCStipple |
		GCTileStipXOrigin | GCTileStipYOrigin |
		GCSubwindowMode | GCGraphicsExposures |
		GCClipXOrigin | GCClipYOrigin | GCDashOffset |
		GCArcMode );
	pixmap1 = XCreatePixmap(display_good, window_good,
		 (unsigned int)100,
		 (unsigned int)100,
		 (unsigned int)XDefaultDepth(display_good,
		 XDefaultScreen(display_good)));
	tilemap = pixmap1;
	{
	static unsigned short pixarr[] = {
		0xaa55, 0x0a55, 0xaa22, 0xaa55,
		0xaacc, 0xaa55, 0xaa55, 0x1a55,
		0xaa55, 0xaa05, 0xaa55, 0xa355,
		0xaa51, 0xaa55, 0xa455, 0x0055
			};
	stipmap = XCreateBitmapFromData (display_good,
			XDefaultRootWindow(display_good),
			(char *)pixarr, 16, 16);
	}
	vals->function = (int)GXcopy;
	vals->plane_mask = ~0L;
	vals->foreground = (unsigned long)0;
	vals->background = (unsigned long)1;
	vals->line_width = (int)0;
	vals->line_style = (int)LineSolid;
	vals->cap_style = (int)CapButt;
	vals->join_style = (int)JoinMiter;
	vals->fill_style = (int)FillSolid;
	vals->fill_rule = (int)EvenOddRule;
	vals->arc_mode = (int)ArcPieSlice;
	vals->tile =	tilemap;
	vals->stipple = stipmap;
	vals->ts_x_origin = (int)0;
	vals->ts_y_origin = (int)0;
	vals->subwindow_mode = (int)ClipByChildren;
	vals->graphics_exposures = (Bool)True;
	vals->clip_x_origin = (int)0;
	vals->clip_y_origin = (int)0;
	vals->dash_offset = (int)0;
	vals->dashes = (char)4;
	return((XtGCMask)value_mask);
}


#define T_XtGetGC	1
char    *TestName = "XtGetGC";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

GC GC_good;
XtGCMask value_mask;
XGCValues values, org_val;
Display *display_good;
Boolean status;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetGC-1.(A)");
	report_assertion("A call to GC XtGetGC(object, value_mask, values) shall");
	report_assertion("return a sharable graphics context that has its root set to");
	report_assertion("the screen associated with the object object and its");
	report_assertion("drawable depth set to the value specified by the depth field");
	report_assertion("of the object.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtgc1", "XtGetGC");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Obtain read-only shareable GC");
	display_good = XtDisplay(topLevel);
	value_mask = ConstructGC(topLevel, &org_val);
	GC_good = XtGetGC(topLevel, value_mask, &org_val);
	tet_infoline("TEST: GC is valid");
	status = XGetGCValues(display_good, GC_good, value_mask, &values);
	if (!status) {
		sprintf(ebuf, "ERROR: XGetGCValues failed, expected non-zero value");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Release GC");
	XtReleaseGC(topLevel, GC_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3788 */
/* End of included file Mdefcode.tmc.3788 */

static void t002(){

GC GC_good;
XtGCMask value_mask;
XGCValues values, org_val;
Display *display_good;
Boolean status;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetGC-2.(A)");
	report_assertion("On a call to GC XtGetGC(object, value_mask, values) the");
	report_assertion("fields in the graphics context returned that are specified");
	report_assertion("in value_mask shall be set to the corresponding values");
	report_assertion("specified in values.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtgc2", "XtGetGC");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Obtain read-only shareable GC");
	display_good = XtDisplay(topLevel);
	value_mask = ConstructGC(topLevel, &org_val);
	GC_good = XtGetGC(topLevel, value_mask, &org_val);
	tet_infoline("TEST: GC values");
	status = XGetGCValues(display_good, GC_good, value_mask, &values);
	if (status)
		CheckValues(&values);
	else {
		sprintf(ebuf, "ERROR: XGetGCValues failed, expected non-zero value");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Release GC");
	XtReleaseGC(topLevel, GC_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3788 */
/* End of included file Mdefcode.tmc.3788 */

/* Including from file Mdefcode.tmc.3788 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGetGC-3.(B)");
	report_assertion("On a call to GC XtGetGC(object, value_mask, values) the");
	report_assertion("fields in the graphics context returned that are not");
	report_assertion("specified in value_mask shall be set to default values.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3788 */

/* Including from file Mdefcode.tmc.3788 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtGetGC-4.(B)");
	report_assertion("On a call to GC XtGetGC(object, value_mask, values) the");
	report_assertion("graphics context returned shall have no fields that are");
	report_assertion("modifiable by the calling process.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3788 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
