/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2004 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   char *
 *   XtCalloc()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern int alloc_handler_called;
extern void alloc_handler();


#define T_XtCalloc	1
char    *TestName = "XtCalloc";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *ptr , *array;
int i;
unsigned int num = 2;
unsigned int size = 12;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCalloc-1.(A)");
	report_assertion("A successful call to char *XtCalloc(num, size) shall");
	report_assertion("allocate space for num number of array elements each of size");
	report_assertion("size and initialize the space to zero.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalloc1", "XtCalloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	sprintf(ebuf, "TEST: Allocate elements %d of size %d to zero", num, size);
	tet_infoline(ebuf);
	array = (char *) XtCalloc(num, size);
	ptr = (char *) array;
	for (i = 1; i <= size * num; i++ , ptr++)
	if (*ptr != (char) 0) {
		sprintf(ebuf, "ERROR: Allocated memory location not initialized to zero");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.480 */
/* End of included file Mdefcode.tmc.480 */

static void t002(){

char *array;
size_t num;
unsigned int size = 14;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCalloc-2.(A)");
	report_assertion("When there is insufficient memory to allocate the requested");
	report_assertion("block a call to char *XtCalloc(num, size) shall issue an");
	report_assertion("allocError error and return NULL.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalloc2", "XtCalloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
 
	tet_infoline("PREP: Set up toolkit handler for XtCalloc failure");
	XtAppSetErrorMsgHandler(app_ctext, alloc_handler);
	tet_infoline("PREP: Determine largest malloc");
	num = mem_limit();
	tet_infoline("PREP: Over the limit XtCalloc should call XtErrorMessage");
	array = (char *) XtCalloc( ( num + 10 ), size);
	if (alloc_handler_called != 1) {
		sprintf(ebuf, "ERROR: XtCalloc did not generate toolkit error message");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Free memory");
	XtFree(array);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.480 */
/* End of included file Mdefcode.tmc.480 */

/* Including from file Mdefcode.tmc.480 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCalloc-3.(B)");
	report_assertion("The order and contiguity of the storage allocated by");
	report_assertion("successive calls to char *XtCalloc(num, size).");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.480 */

/* Including from file Mdefcode.tmc.480 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCalloc-4.(B)");
	report_assertion("A successful call to char *XtCalloc(num, size) shall return");
	report_assertion("a pointer to an object that is disjoint from any other");
	report_assertion("object.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.480 */

/* Including from file Mdefcode.tmc.480 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCalloc-5.(B)");
	report_assertion("The pointer returned by a successful call to char");
	report_assertion("*XtCalloc(num, size) shall point to the lowest byte address");
	report_assertion("of the allocated space.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.480 */

/* Including from file Mdefcode.tmc.480 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCalloc-6.(B)");
	report_assertion("The pointer returned by a call to char *XtCalloc(num, size)");
	report_assertion("when size is zero.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.480 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
