/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAppWarningMsg()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char msg[1024] ="/tmp/outfile";
char file_name[128] ="/tmp/dbfile";
/*
** XtWMH_Proc()
*/
void XtWMH_Proc(name_good, type_good, class_good, defaultp, params, num_params)
String name_good;
String type_good;
String class_good;
String defaultp;
String *params;
Cardinal *num_params;
{
	fprintf(stdout, "%s %s %s %s", name_good, type_good, class_good, defaultp);
	avs_set_event(1, avs_get_event(1)+1);
}


#define T_XtAppWarningMsg	1
char    *TestName = "XtAppWarningMsg";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
long invoked = 0;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppWarningMsg-1.(A)");
	report_assertion("A call to void XtAppWarningMsg(app_context, name, type,");
	report_assertion("class, default, params, num_params) shall invoke the");
	report_assertion("high-level warning handler for the application context");
	report_assertion("app_context passing name, type, class, default, params, and");
	report_assertion("num_params as arguments to it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapwrnmsg1", "XtAppWarningMsg");
	tet_infoline("PREP: Get the file name to store warning message");
	tet_infoline("PREP: Register XtWMH_Proc to be called on non fatal conditions");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("TEST: Call XtAppWarningMsg");
 	push_stdout("outfile", "w");
	XtAppWarningMsg(app_ctext, "This", "is a", "test",
		"Hello World", NULL, (Cardinal *)0);
	pop_stdout();
	tet_infoline("TEST: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		exit(0);
	}
	tet_infoline("TEST: Message is correct");
	string = (char *)strstr(line, "Hello World");
	if (string == NULL) {
		sprintf(ebuf, "ERROR: Expected message to contain \"Hello World\" Received \"%s\"", buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	fclose(stream);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Installed handler was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked , "XtWMH_Proc invovocations count");
	tet_infoline("CLEANUP: Unlink the file");
	unlink(msg);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3968 */
/* End of included file Mdefcode.tmc.3968 */

static void t002(){

char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
String	params = "aptest";
Cardinal	n_params;
XrmDatabase *database, file_database, db_return;
char *contents = "testString.error:Testing XtWarningMsg %s\n";
char *ErrorString = "Testing XtWarningMsg aptest";
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppWarningMsg-2.(A)");
	report_assertion("When a user-defined high-level warning handler has not been");
	report_assertion("installed in the application context app_context a call to");
	report_assertion("void XtAppWarningMsg(app_context, name, type, class,");
	report_assertion("default, params, num_params) shall invoke the default");
	report_assertion("warning handler provided by the Intrinsics.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier_no_warn("Tapwrnmsg2", "XtAppWarningMsg");
	tet_infoline("PREP: Create error database");
	XrmInitialize();
	db_return = XrmGetStringDatabase(contents);
	(void)XrmPutFileDatabase(db_return,file_name);
	file_database = XrmGetFileDatabase(file_name);
	database = XtAppGetErrorDatabase(app_ctext);
	if (database == (XrmDatabase *)NULL) {
		tet_infoline("ERROR: XtAppGetErrorDatabase returned NULL");
		tet_result(TET_FAIL);
		unlink(file_name);
		exit(0);
	}
	tet_infoline("PREP: Merge original database with new database");
	XrmMergeDatabases(file_database, database);
	tet_infoline("TEST: Call XtAppWarningMsg");
	n_params = 1;
	push_stderr("outfile", "w");
	XtAppWarningMsg(app_ctext, "testString", "error", "AppWarning", "This is the default passed in", &params, &n_params);
	pop_stderr();
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	tet_infoline("TEST: Message is correct");
	string = (char *)strstr(line, ErrorString);
	if (string == NULL) {
		sprintf(ebuf, "ERROR: Expected message to contain \"%s\", received \"%s\"", ErrorString, buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3968 */
/* End of included file Mdefcode.tmc.3968 */

static void t003(){

char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppWarningMsg-3.(A)");
	report_assertion("When a user-defined warning handler has not been installed");
	report_assertion("in the application context app_context and no entry for the");
	report_assertion("specified error exists in the error database the");
	report_assertion("Intrinsics-defined default warning handler invoked by a call");
	report_assertion("to void XtAppWarningMsg(app_context, name, type, class,");
	report_assertion("default, params, num_params) shall display the message");
	report_assertion("specified by default.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier_no_warn("Tapwrnmsg2", "XtAppWarningMsg");
	tet_infoline("TEST: Call XtAppWarningMsg for non-existent message");
	push_stderr("outfile", "w");
	XtAppWarningMsg(app_ctext, "This", "is a", "test", "Hello World", NULL, 0);
	pop_stderr();
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	tet_infoline("TEST: Message is correct");
	string = (char *)strstr(line, "Hello World");
	if (string == NULL) {
		sprintf(ebuf, "ERROR: Expected message to contain \"Hello World\" Received \"%s\"", buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	tet_result(TET_PASS);
	unlink(msg);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3968 */
/* End of included file Mdefcode.tmc.3968 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
