/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   GC
 *   XCreateGC(display, d, valuemask, values)
 *   Display *display;
 *   Drawable d;
 *   unsigned long valuemask;
 *   XGCValues *values;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreateGC	1
char    *TestName = "XCreateGC";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE d


/*
 * Arguments to the XCreateGC function
 */
static Display *display;
static Drawable d;
static unsigned long valuemask;
static XGCValues *values;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	d = 0;
	valuemask = 0L;
	values = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	d = ErrdefDrawable;
}

static void t001(){

XVisualInfo	*vp;
int		nvis;
GC		gc;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreateGC-1.(A)");
	report_assertion("A call to XCreateGC creates a graphics context and returns");
	report_assertion("a GC which may be used with any destination drawable having");
	report_assertion("the same root and depth as the drawable d.");

	report_strategy("For pixmaps and windows:");
	report_strategy("   Create a gc for the drawable using XCreateGC.");
	report_strategy("   Set pixel (0,0) of the drawable.");
	report_strategy("   Verify that the pixel was set.");

	tpstartup();
	setargs();
	for(resetvinf(VI_WIN); 	nextvinf(&vp);) {
		d = makewin(display, vp);

		startcall(display);
		if (isdeleted())
			return;
		gc = XCreateGC(display, d, valuemask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XDrawPoint(display,d,gc,0,0);

		/* 0 is the default foreground pixel value. */
		if( ! checkpixel(display, d, 0, 0, 0) ) {  
			report("For window depth %d, pixel was not set to foreground",
								vp -> depth);
			FAIL;
		} else
			CHECK;
	}

	nvis = nvinf();
	for(resetvinf(VI_PIX); 	nextvinf(&vp);) {
		d = makepixm(display, vp);		

		startcall(display);
		if (isdeleted())
			return;
		gc = XCreateGC(display, d, valuemask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XDrawPoint(display,d,gc,0,0);

		/* 0 is the default foreground pixel value. */
		if( ! checkpixel(display, d, 0, 0, 0) ) {  
			report("For pixmap depth %d, pixel was not set to foreground",
								vp -> depth);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nvis + nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

GC gc;
XGCValues vals;
XVisualInfo *vp;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreateGC-2.(A)");
	report_assertion("A call to XCreateGC initialises the components specified by");
	report_assertion("the valuemask argument in the newly created GC to the values");
	report_assertion("in the values argument.");

	report_strategy("Create a window.");
	report_strategy("Initialise XGCValues structure with fg W_FG, fn GXxor.");
	report_strategy("Create a gc for the window with a valuemask of GCFunction | GCForeground.");
	report_strategy("Plot point (0,0) with XDrawPoint.");
	report_strategy("Verify that pixel at (0,0) is W_FG.");
	report_strategy("Initialise XGCValues structure with fg W_FG ^ W_BG, fn GXxor.");
	report_strategy("Create a gc for the window with a valuemask of GCFunction | GCForeground.");
	report_strategy("Plot point (0,0) with XDrawPoint.");
	report_strategy("Verify that pixel at (0,0) is W_BG.");

	tpstartup();
	setargs();
/* Function */
	
	resetvinf(VI_WIN);
	nextvinf(&vp);

	d = makewin(display, vp);
	vals.function = GXxor;
	vals.foreground = W_FG;
	values = &vals;
	valuemask = (GCFunction | GCForeground);
	startcall(display);
	if (isdeleted())
		return;
	gc = XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XDrawPoint(display, d, gc, 0, 0);

	if( ! checkpixel(display, d, 0, 0, W_FG)) {
		delete("Pixel at (0, 0) was not set to foreground.");
		return;
	} else
		CHECK;

	vals.foreground = W_FG ^ W_BG;
	values = &vals;
	valuemask = (GCFunction | GCForeground);
	startcall(display);
	if (isdeleted())
		return;
	gc = XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XDrawPoint(display, d, gc, 0, 0);

	if( ! checkpixel(display, d, 0, 0, W_BG)) {
		report("Pixel at (0, 0) was not set to background.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo	*vp;
XGCValues	vals;
GC		gc;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreateGC-3.(A)");
	report_assertion("When the tile pixmap is not set and the fill_style is");
	report_assertion("FillTiled, then a call to XCreateGC creates a GC in which a");
	report_assertion("pixel set to the foreground value of GC is used for tiling.");

	report_strategy("Create a gc with the fill_style FillTiled, foreground set to W_FG, tile set to NULL.");
	report_strategy("Create a window.");
	report_strategy("Tile entire window with XFillRectangle.");
	report_strategy("Verify that all the window pixels were W_FG.");
	report_strategy("Plot point (0,0) with XDrawPoint.");
	report_strategy("Set fg to W_FG ^ W_BG.");
	report_strategy("Plot point (0,0) with XDrawPoint.");
	report_strategy("Verify that pixel at (0,0) is W_BG.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN); 
	nextvinf(&vp);
	d = makewin(display, vp);
	vals.fill_style = FillTiled;
	vals.foreground = W_FG;
	valuemask = GCForeground | GCFillStyle;
	values = &vals;
	startcall(display);
	if (isdeleted())
		return;
	gc = XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XFillRectangle(display, d, gc, 0, 0, W_STDWIDTH, W_STDHEIGHT);

	if( checkarea(display, d, (struct area *) 0, W_FG, 0, CHECK_IN) == False) {
		report("Window was not filled with foreground.");
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreateGC-4.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EDra.mc */
/* End of included file error/EDra.mc */

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreateGC-5.(A)");
	report_assertion("When a drawable argument does not name a valid Drawable,");
	report_assertion("then a BadDrawable error occurs.");

	report_strategy("Create a window and destroy the window.");
	report_strategy("Create a GC with window as the drawable.");
	report_strategy("Verify that a BadDrawable error occurs. ");

	tpstartup();
	setargs();
	d = badwin(Dsp);
	valuemask = 0L;
	values = (XGCValues *)NULL;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadDrawable)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Window w;
Font font;
XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreateGC-6.(A)");
	report_assertion("When the font does not name a valid font, and the GCFont");
	report_assertion("bit is set in valuemask, then a BadFont error occurs.");

	report_strategy("Create a font for the default screen and free font with XFreeFont.");
	report_strategy("Create a GC with root window as the drawable and bad font as the font component.");
	report_strategy("Verify that a BadFont error occurs. ");

	tpstartup();
	setargs();
	w = DefaultRootWindow(Dsp);
	font = badfont(Dsp);

	vals.font = font;
	d = w;
	valuemask = GCFont;
	values = &vals;

	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadFont) {
		report("Got %s, Expecting BadFont", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadFont) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCreateGC-7.(A)");
	report_assertion("When the tile does not name a valid pixmap, and the GCTile");
	report_assertion("bit is set in valuemask, then a BadPixmap error occurs.");

	report_strategy("Create a bad pixmap for the root window and free pixmap with XFreePixmap.");
	report_strategy("Create a GC with window as the drawable and pixmap as the tile.");
	report_strategy("Verify that a BadPixmap error occurs. ");

	tpstartup();
	setargs();
	vals.tile = badpixm(display);

	values = &vals;
	d = DRW(display);
	valuemask = GCTile;

	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadPixmap) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XCreateGC-8.(A)");
	report_assertion("When the stipple does not name a valid pixmap, and the");
	report_assertion("GCStipple bit is set in valuemask, then a BadPixmap error");
	report_assertion("occurs.");

	report_strategy("Create a bad pixmap for the root window and free pixmap with XFreePixmap.");
	report_strategy("Create a GC with window as the drawable and pixmap as the stipple.");
	report_strategy("Verify that a BadPixmap error occurs. ");

	tpstartup();
	setargs();
	vals.stipple = badpixm(display);

	values = &vals;
	d = DRW(display);
	valuemask = GCStipple;

	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadPixmap) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XCreateGC-9.(A)");
	report_assertion("When the clip-mask does not name a valid pixmap, or None,");
	report_assertion("and the GCClipMask bit is set in valuemask, then a");
	report_assertion("BadPixmap error occurs.");

	report_strategy("Create a bad pixmap for the root window and free pixmap with XFreePixmap.");
	report_strategy("Create a GC with window as the drawable and pixmap as the clip_mask.");
	report_strategy("Verify that a BadPixmap error occurs. ");

	tpstartup();
	setargs();
	vals.clip_mask = badpixm(display);

	values = &vals;
	d = DRW(display);
	valuemask = GCClipMask;

	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadPixmap)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int		count;
XGCValues 	vals;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XCreateGC-10.(C)");
	report_assertion("When the graphics context and the tile pixmap do not have");
	report_assertion("the same depth, and the GCTile bit is set in valuemask,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("For all non-depth1 drawables:");
	report_strategy("	Created such a drawable.");
	report_strategy("	Create a depth 1 pixmap.");
	report_strategy("	Create a GC with window as the drawable and pixmap as the tile.");
	report_strategy("	Verify that a BadMatch error occurs. ");

	tpstartup();
	setargs();

	count = 0;
	vals.tile = XCreatePixmap(display, DRW(display), 1,1,1);
	valuemask = GCTile;
	values = &vals;
	for(resetvinf(VI_WIN); nextvinf(&vp);)
		if(vp->depth != 1) {
			trace("Testing a window of depth %d",vp->depth);
			count++;
			d = makewin(display, vp);
			startcall(display);
			if (isdeleted())
				return;
			XCreateGC(display, d, valuemask, values);
			endcall(display);
			if (geterr() != BadMatch) {
				report("Got %s, Expecting BadMatch", errorname(geterr()));
				FAIL;
			}
			if(geterr() == BadMatch)
				CHECK;
			else
				FAIL;
		}

	for(resetvinf(VI_PIX); nextvinf(&vp);)
		if(vp->depth != 1) {
			trace("Testing a window of depth %d",vp->depth);
			count++;
			d = makepixm(display, vp);
			startcall(display);
			if (isdeleted())
				return;
			XCreateGC(display, d, valuemask, values);
			endcall(display);
			if (geterr() != BadMatch) {
				report("Got %s, Expecting BadMatch", errorname(geterr()));
				FAIL;
			}
			if(geterr() == BadMatch)
				CHECK;
			else
				FAIL;
		}


	if(count == 0) {
		tet_result(TET_UNSUPPORTED);
		report("Only depth one drawables are supported.");
		return;
	} else
		CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

char    *altroot;
int     scr_num;
XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XCreateGC-11.(A)");
	report_assertion("When the graphics context and the tile pixmap were not");
	report_assertion("created for the same root, and the GCTile bit is set in");
	report_assertion("valuemask, then a BadMatch error occurs.");

	report_strategy("If multiple roots are supported:");
	report_strategy("	Create a pixmap for one root.");
	report_strategy("	Create a GC for another root with pixmap as the tile component.");
	report_strategy("	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	altroot = tet_getvar("XT_ALT_SCREEN");
	if (altroot == NULL) {
		delete("XT_ALT_SCREEN not set");
		return;
	}
	if (*altroot == 'U') {
		report("Only one screen supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	scr_num = atoi(altroot);
	if (scr_num == DefaultScreen(display)) {
		delete("The Alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(display)) {
		delete("Screen given in XT_ALT_SCREEN could not be accessed");
		return;
	}

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */
	
	vals.tile =  XCreatePixmap(display, RootWindow(display, scr_num), 1, 1, 1);
	values = &vals;
	valuemask = GCTile;
	d = DRW(display);

	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XCreateGC-12.(C)");
	report_assertion("When the stipple pixmap does not have depth one, and the");
	report_assertion("GCStipple bit is set in valuemask, then a BadMatch error");
	report_assertion("occurs.");

	report_strategy("If pixmaps with depth other than one are supported:");
	report_strategy("	Create a pixmap with depth other than one.");
	report_strategy("  	Create a GC with the pixmap as the stipple component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	if((vals.stipple = nondepth1pixmap(display, DRW(display))) == (Pixmap) 0) {
		tet_result(TET_UNSUPPORTED);
		report("Only depth 1 pixmaps are supported.");
		return;
	} else
		CHECK;

	d = DRW(display);
	valuemask = GCStipple;
	values = &vals;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	
	if(geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

char    *altroot;
int     scr_num;
XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XCreateGC-13.(C)");
	report_assertion("When the graphics context and the stipple pixmap were not");
	report_assertion("created for the same root, and the GCStipple bit is set in");
	report_assertion("valuemask, then a BadMatch error occurs.");

	report_strategy("If multiple roots are supported:");
	report_strategy("	Create a pixmap for one root.");
	report_strategy("	Create a GC for another root with pixmap as the stipple component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	altroot = tet_getvar("XT_ALT_SCREEN");
	if (altroot == NULL) {
		delete("XT_ALT_SCREEN not set");
		return;
	}
	if (*altroot == 'U') {
		report("Only one screen supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	scr_num = atoi(altroot);
	if (scr_num == DefaultScreen(display)) {
		delete("The Alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(display)) {
		delete("Screen given in XT_ALT_SCREEN could not be accessed");
		return;
	}

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */
	
	d = DRW(display);
	vals.stipple = XCreatePixmap(display, RootWindow(display, scr_num), 1, 1, 1);
	values = &vals;
	valuemask = GCStipple;
	
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XCreateGC-14.(C)");
	report_assertion("When the clip-mask is set to a pixmap, and the clip-mask");
	report_assertion("does not have depth one, and the GCClipMask bit is set in");
	report_assertion("valuemask, then a BadMatch error occurs.");

	report_strategy("If pixmaps with depth other than one are supported:");
	report_strategy("	Create a pixmap with depth other than one.");
	report_strategy("  	Create a GC with the pixmap as the clip_mask component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	if((vals.clip_mask = nondepth1pixmap(display, DRW(display))) == (Pixmap) 0) {
		tet_result(TET_UNSUPPORTED);
		report("Only depth 1 pixmaps are supported.");
		return;
	} else
		CHECK;

	d = DRW(display);
	valuemask = GCClipMask;
	values = &vals;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

char    *altroot;
int     scr_num;
XGCValues	vals;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XCreateGC-15.(C)");
	report_assertion("When the clip-mask is set to a pixmap, and the graphics");
	report_assertion("context and the clip-mask were not created for the same");
	report_assertion("root, and the GCClipMask bit is set in valuemask, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("If multiple roots are supported:");
	report_strategy("	Create a pixmap for one root.");
	report_strategy("	Create a GC for another root with the pixmap as the clip_mask component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	altroot = tet_getvar("XT_ALT_SCREEN");
	if (altroot == NULL) {
		delete("XT_ALT_SCREEN not set");
		return;
	}
	if (*altroot == 'U') {
		report("Only one screen supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	scr_num = atoi(altroot);
	if (scr_num == DefaultScreen(display)) {
		delete("The Alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(display)) {
		delete("Screen given in XT_ALT_SCREEN could not be accessed");
		return;
	}

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */

	d = DRW(display);
	vals.clip_mask = XCreatePixmap(display, RootWindow(display, scr_num), 1, 1, 1);
	valuemask = GCClipMask;
	values = &vals;

	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

XGCValues vals;
int i;
unsigned char *p;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XCreateGC-16.(A)");
	report_assertion("When the valuemask argument is other than a bitwise OR of");
	report_assertion("none or any of GCFunction, GCPlaneMask, GCForeground,");
	report_assertion("GCBackground, GCLineWidth, GCLineStyle, GCCapStyle,");
	report_assertion("GCJoinStyle, GCFillStyle, GCFillRule, GCTile, GCStipple,");
	report_assertion("GCTileStipXOrigin, GCTileStipYOrigin, GCFont,");
	report_assertion("GCSubwindowMode, GCGraphicsExposures, GCClipXOrigin,");
	report_assertion("GCClipYOrigin, GCClipMask, GCDashOffset, GCDashList, or");
	report_assertion("GCArcMode, then a BadValue error occurs.");

	report_strategy("Create a GC with valuemask = GCFunction | GCForeground | ");
	report_strategy("	 ~(GCFunction | GCPlaneMask | GCForeground | GCBackground |");
	report_strategy("	  GCLineWidth | GCLineStyle | GCCapStyle | GCJoinStyle |");
	report_strategy("	  GCFillStyle | GCFillRule | GCTile | GCStipple |");
	report_strategy("	  GCTileStipXOrigin | GCTileStipYOrigin | GCFont | GCSubwindowMode |");
	report_strategy("	  GCGraphicsExposures | GCClipXOrigin | GCClipYOrigin | GCClipMask |");
	report_strategy("	  GCDashOffset | GCDashList | GCArcMode.");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();

	/* first fill XGCValues with ff's and try creating that rubbish */

	i = sizeof(XGCValues);
	p = (unsigned char *)&vals;
	while( i-- > 0 )
		*p++ = 0xff;

	d = DRW(display);
	values = &vals;
	vals.foreground = 1;
	vals.function = ~0;
	valuemask = GCFunction | GCForeground | 
	 ~(GCFunction | GCPlaneMask | GCForeground | GCBackground |
	  GCLineWidth | GCLineStyle | GCCapStyle | GCJoinStyle |
	  GCFillStyle | GCFillRule | GCTile | GCStipple |
	  GCTileStipXOrigin | GCTileStipYOrigin | GCFont | GCSubwindowMode |
	  GCGraphicsExposures | GCClipXOrigin | GCClipYOrigin | GCClipMask |
	  GCDashOffset | GCDashList | GCArcMode);
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadValue)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XCreateGC-17.(A)");
	report_assertion("When the function is other than GXclear, GXand,");
	report_assertion("GXandReverse, GXcopy, GXandInverted, GXnoop, GXxor,");
	report_assertion("GXor, GXnor, GXequiv, GXinvert, GXorReverse,");
	report_assertion("GXcopyInverted, GXorInverted, GXnand or GXset, and the");
	report_assertion("GCFunction bit is set in valuemask, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Create a GC with function = GXclear + GXand + GXandReverse + GXcopy + ");
	report_strategy("	GXandInverted + GXnoop + GXxor + GXor + GXnor + GXequiv + GXinvert +");
	report_strategy("	GXorReverse + GXcopyInverted + GXorInverted + GXnand + GXset + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	vals.function = GXclear + GXand + GXandReverse + GXcopy + 
	  GXandInverted + GXnoop + GXxor + GXor + GXnor + GXequiv + GXinvert + 
	  GXorReverse + GXcopyInverted + GXorInverted + GXnand + GXset + 1;
	values = &vals;
	valuemask = GCFunction;
	d = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XCreateGC-18.(A)");
	report_assertion("When the line_style is other than LineSolid,");
	report_assertion("LineDoubleDash or LineOnOffDash, and the GCLineStyle bit is");
	report_assertion("set in valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC with line_style = LineSolid + LineDoubleDash + LineOnOffDash + 1;");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	vals.line_style = LineSolid + LineDoubleDash + LineOnOffDash + 1;
	values = &vals;
	d = DRW(display);
	valuemask = GCLineStyle;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XCreateGC-19.(A)");
	report_assertion("When the cap_style is other than CapNotLast, CapButt,");
	report_assertion("CapRound or CapProjecting, and the GCCapStyle bit is set in");
	report_assertion("valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC with cap_style = CapNotLast + CapButt + CapRound + CapProjecting + 1");
	report_strategy("Verify that a BadValue error occurred");

	tpstartup();
	setargs();
	vals.cap_style = CapNotLast + CapButt + CapRound + CapProjecting + 1;
	values = &vals;
	valuemask = GCCapStyle;
	d = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XCreateGC-20.(A)");
	report_assertion("When the join_style is other than JoinMiter, JoinRound or");
	report_assertion("JoinBevel, and the GCJoinStyle bit is set in valuemask,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Create a GC with join_style = JoinMiter + JoinRound + JoinBevel + 1");
	report_strategy("Verify that a BadValue error occurs");

	tpstartup();
	setargs();
	vals.join_style = JoinMiter + JoinRound + JoinBevel + 1;
	values = &vals;
	d = DRW(display);
	valuemask = GCJoinStyle;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XCreateGC-21.(A)");
	report_assertion("When the fill_style is other than FillSolid, FillTiled,");
	report_assertion("FillStippled or FillOpaqueStippled, and the GCFillStyle bit");
	report_assertion("is set in valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC with fill_style = FillSolid + FillTiled + FillStippled + FillOpaqueStippled + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	vals.fill_style = FillSolid + FillTiled + FillStippled + FillOpaqueStippled + 1;
	values = &vals;
	d = DRW(display);
	valuemask = GCFillStyle;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XCreateGC-22.(A)");
	report_assertion("When the fill_rule is other than EvenOddRule or WindingRule,");
	report_assertion("and the GCFillRule bit is set in valuemask, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Create a gc with fill_rule = EvenOddRule + WindingRule + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	vals.fill_rule = EvenOddRule + WindingRule + 1;
	values = &vals;
	d = DRW(display);
	valuemask = GCFillRule;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XCreateGC-23.(A)");
	report_assertion("When arc_mode is other than ArcChord or ArcPieSlice, and");
	report_assertion("the GCArcMode bit is set in valuemask, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Create a gc with arc_mode = ArcChord + ArcPieSlice + 1.");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	vals.arc_mode = ArcChord + ArcPieSlice + 1;
	values = &vals;
	d = DRW(display);
	valuemask = GCArcMode;
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XCreateGC-24.(A)");
	report_assertion("When the subwindow_mode is other than ClipByChildren or");
	report_assertion("IncludeInferiors, and the GCSubwindowMode bit is set in");
	report_assertion("valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC with subwindow_mode = ClipByChildren + IncludeInferiors + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	vals.subwindow_mode = ClipByChildren + IncludeInferiors + 1;
	values = &vals;
	valuemask = GCSubwindowMode;
	d = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion XCreateGC-25.(A)");
	report_assertion("When graphics_exposure is other than True or False, and");
	report_assertion("the GCGraphicsExposures bit is set in valuemask, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Create a GC with graphics_exposures component set to  ");
	report_strategy("	(int) False + (int) True + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	vals.graphics_exposures = (int) False + (int) True + 1;
	values = &vals;
	valuemask = GCGraphicsExposures;
	d = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t026(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(26);

	report_assertion("Assertion XCreateGC-26.(A)");
	report_assertion("When dashes is set to zero, and the GCDashList bit is set");
	report_assertion("in valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC with dashes component = 0");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	vals.dashes = (char) 0;
	values = &vals;
	d = DRW(display);
	valuemask = GCDashList;

	startcall(display);
	if (isdeleted())
		return;
	XCreateGC(display, d, valuemask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
