/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XStoreColors(display, colormap, color, ncolors)
 *   Display	*display;
 *   Colormap colormap;
 *   XColor *color;
 *   int ncolors;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XStoreColors	1
char    *TestName = "XStoreColors";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XStoreColors function
 */
static Display	*display;
static Colormap colormap;
static XColor *color;
static int ncolors;


XColor dummycol = { 0L, 0,0,0, DoRed|DoGreen|DoBlue, 0 };

#define lowbit(x)		((x) & (~(x) + 1))
#define bitcontig(x)	((((x) + lowbit(x)) & (x)) == 0)
#define bitsubset(a,b)	(((a) & (b)) == (a))

static int
maskshift(mask)
register unsigned long mask;
{
register int i;

	for (i = 0; mask; i++) {
		if (mask & 0x1)
			return i;
		mask >>= 1;
	}
	return i;
}

static
Bool set_one_col(refp, s, flags, mask)
	unsigned long *refp;
	char *s;
	char flags;
	unsigned long mask;
{
	unsigned long i;
	XColor *cp1;
	unsigned long *lrefp = refp;
	int fail = 0; /* used in the FAIL in XCall (spelt wrong intentionally) */
	/* expects to find color and ncolors in-scope */

	for(i=0, cp1 = color; i < ncolors; i++, cp1++, lrefp++) {
		unsigned long subfield_ix = i << maskshift(mask);

		if (!bitsubset(subfield_ix, mask)) {
			delete("Inconsistent maxsize() result: size of %d is too big to fit into %s mask 0x%lx (detected at index %lu, giving pixel 0x%lx)",
				ncolors, s, mask, i, subfield_ix);
			return False;
		}
		*lrefp = cp1->pixel = subfield_ix;
		cp1->flags = flags;
		switch (flags) {
		case DoRed:
			cp1->red = i;
			break;
		case DoGreen:
			cp1->green = i;
			break;
		case DoBlue:
			cp1->blue = i;
			break;
		default:
			delete("Flags 0x%x has more than one colour in it.", (unsigned int)flags);
			return False;
		}
	}
	/* The following may give a warning about the return; */
	startcall(display);
	if (isdeleted())
		return;
	XStoreColors(display, colormap, color, ncolors);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XQueryColors(display, colormap, color, ncolors);
	for(i=0,cp1=color,lrefp=refp; i < ncolors; i++, lrefp++, cp1++) {
		*lrefp = (flags==DoRed) ? cp1->red :
				((flags==DoGreen) ? cp1->green : cp1->blue);
	}
	return (geterr() == Success);
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	color = &dummycol;
	ncolors = 1;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo 	*vp;
XColor		*colp, *cp, *testcol;
unsigned long 	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
unsigned long	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XStoreColors-1.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("Grayscale is supported: A call to XStoreColors obtains the");
	report_assertion("closest available RGB values for the colormap argument to");
	report_assertion("those specified in the red, green and blue components of");
	report_assertion("the XColor structures named by the color argument, and");
	report_assertion("stores those values in the read-write colourmap entries");
	report_assertion("specified by the pixel components of the XColor structures.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colourmap with alloc set to AllocAll;");
	report_strategy("  Store the color r = 0xffff g = 0xf1f0 b = 0x0ff8 in each cell of the colourmap with XStoreColors.");
	report_strategy("  Obtain the stored r,g b values with XQueryColors.  ");
	report_strategy("  Store the obtained r,g b values in each cell with XStoreColors.");
	report_strategy("  Obtain the stored r, g, b values with XQueryColors.");
	report_strategy("  Verify that these values are identical to those originally obtained.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocAll);
		ncolors = maxsize(vp);

		color = (XColor *) malloc(ncolors * sizeof(XColor));
		if(color == (XColor *) 0) {
			delete("malloc() couldn't allocate %d cells for the XColor array.", ncolors);
			return;
		} else
			CHECK;

		for(i=0, colp = color; i < ncolors; i++, colp++) {
			colp->pixel = i;
			colp->red = 0xffff ^ (i*4);
			colp->green =  0xf1f0 ^ (i*8);
			colp->blue =  0x0ff8 ^ (i*6);
			colp->flags = (char) (DoRed|DoGreen|DoBlue);
		}

		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(geterr() == Success)
			CHECK;

		/* Write colormap stored values back over the original array */
		XQueryColors(display, colormap, color, ncolors);

		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(geterr() == Success)
			CHECK;

		testcol = (XColor *) malloc(ncolors * sizeof(XColor));
		if(testcol == (XColor *) 0) {
			delete("malloc() couldn't allocate %d cells for the XColor array.", ncolors);
			return;
		} else
			CHECK;

		for(i=0; i<ncolors; i++)
			testcol[i].pixel = i;

		XQueryColors(display, colormap, testcol, ncolors);

		for(i=0, colp = testcol, cp = color; i < ncolors; i++, colp++, cp++)
			if( (cp->red != colp->red) || (cp->green != colp->green) || (cp->blue != colp->blue) ) {
				report("cell %ld:  r %u g %u b %u instead of r %u g %u b %u",
						i,
						cp->red, cp->green, cp->blue,
						colp->red, colp->green, colp->blue);
				FAIL;
			}

		if( i == ncolors)
			CHECK;
		free((char *)color);
		free((char *)testcol);
	}
	CHECKPASS(5*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo 	*vp;
XColor		*colp, *cp, *testcol, *refcol, *quercol;
unsigned long 	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
unsigned long	i,j;
char		flags;
XColor		*redp, *greenp, *bluep;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XStoreColors-2.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("Grayscale is supported: A call to XStoreColors changes the");
	report_assertion("red, green and blue values in each of the ncolors read-write");
	report_assertion("colourmap entries in accordance with the flags components of");
	report_assertion("the XColor structures named by the color argument.");

	report_strategy("For each supported visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Obtain two distinct colormap values using XStoreColors and XQueryColors.");
	report_strategy("  For each possible combination DoRed, DoGreen and DoBlue in flags:");
	report_strategy("    Set all colormap cells to the first value with flags = DoRed|DoGreen|DoBlue");
	report_strategy("    Set all colormap cells to the second value with rbg components selected by the flag combination with XStoreColors.");
	report_strategy("    Verify that only the components of the colourcell specified by the flags were altered with XQueryColor.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocAll);
		ncolors = maxsize(vp);

		refcol = (XColor *) malloc(ncolors * sizeof(XColor));
		testcol = (XColor *) malloc(ncolors * sizeof(XColor));
		quercol = (XColor *) malloc(ncolors * sizeof(XColor));

		if((quercol == (XColor *) 0) ||  (refcol == (XColor *) 0) ||  (testcol == (XColor *) 0)){
			delete("malloc() couldn't allocate %d cells for the XColor array.", ncolors);
			return;
		} else
			CHECK;

		for(i=0, cp = testcol, colp = refcol; i < ncolors; i++, cp++, colp++) {
			colp->pixel = i;
			colp->red = 0;
			colp->green = 0;
			colp->blue = 0;
			colp->flags = (DoRed|DoGreen|DoBlue);

			cp->pixel = i;
			cp->red = 0xffff;
			cp->green = 0xffff;
			cp->blue = 0xffff;
			cp->flags = (DoRed|DoGreen|DoBlue);

			quercol[(int)i].pixel = i;
		}

		color = refcol;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(geterr() == Success)
			CHECK;

		/* Write colormap stored values back over the original array */
		XQueryColors(display, colormap, refcol, ncolors);


		color = testcol;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(geterr() == Success)
			CHECK;
		/* Write colormap stored values back over the original array */
		XQueryColors(display, colormap, testcol, ncolors);


		for(i=0; i<8; i++) {

			flags = 0;

			if(i&DoRed) {
				flags |= DoRed;
				redp = testcol;
			} else
				redp = refcol;

			if(i&DoGreen) {
				flags |= DoGreen;
				greenp = testcol;
			} else
				greenp = refcol;

			if(i&DoBlue) {
				flags |= DoBlue;
				bluep = testcol;
			} else
				bluep = refcol;

			color = refcol;
			startcall(display);
			if (isdeleted())
				return;
			XStoreColors(display, colormap, color, ncolors);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			if(geterr() == Success)
				CHECK;

			for(j=0, cp=testcol; j < ncolors; cp++, j++)
				cp->flags = flags;

			color = testcol;
			startcall(display);
			if (isdeleted())
				return;
			XStoreColors(display, colormap, color, ncolors);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			if(geterr() == Success)
				CHECK;


			XQueryColors(display, colormap, quercol, ncolors);

			for(j=0, cp = quercol; j < ncolors; j++, cp++, redp++, greenp++, bluep++)
				if( (cp->red != redp->red) || (cp->green != greenp->green) || (cp->blue != bluep->blue) ) {
					report("cell %ld)  r %u g %u b %u instead of r %u g %u b %u",
							i,  cp->red, cp->green, cp->blue,  redp->red, greenp->green, bluep->blue);
					FAIL;
				}
			if (j == ncolors)
				CHECK;
		}

		free((char*)quercol);
		free((char*)testcol);
		free((char*)refcol);
	}
	CHECKPASS((3 + 3*i) * nsupvis());


	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.3504 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XStoreColors-3.(D)");
	report_assertion("When the colormap is an installed colourmap for its screen,");
	report_assertion("then any changes made by a call to XStoreColors are visible");
	report_assertion("immediately.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.3504 */

static void t004(){

XVisualInfo 	*vp;
XColor		*cp1;
XColor		*cp2;
XColor		colors[2];
unsigned long 	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
unsigned long	i;
unsigned long	junk;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XStoreColors-4.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: When one or more colourmap entries");
	report_assertion("cannot be changed, then all the specified colourmap entries");
	report_assertion("that are allocated writable by any client are changed.");

	report_strategy("If visual class is DirectColor, PseudoColor or GrayScale:");
	report_strategy("   Create a colormap with AllocNone");
	report_strategy("   Check >= 2 cells in colormap");
	report_strategy("   Allocate first cell as r/o, second as read write");
	report_strategy("   Update r/w cell to known value with XStoreColor.");
	report_strategy("   Discover what it was really set to, and remember.");
	report_strategy("   Update both cells, the r/w one to an opposite value, with XStoreColors");
	report_strategy("   Verify BadAccess occurred, will have Failed if not -- see CODE arg.");
	report_strategy("   Check that despite error the 2nd, r/w, cell was changed in value");
	report_strategy("   Repeat for next matching visual.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

/* If visual class is DirectColor, PseudoColor or GrayScale: */
	for(resetsupvis(vmask); nextsupvis(&vp); ) {

/*    Create a colormap with AllocNone */
		colormap = makecolmap(display, vp->visual, AllocNone);
		ncolors = maxsize(vp);
/*    Check >= 2 cells in colormap */
		if (ncolors < 2) {
			delete("Need at least two cells in colormap to test this assertion, only had %d available.", ncolors);
			return;
		} else
			CHECK;

		ncolors = 2;
		color = colors;

/*    Allocate first cell as r/o, second as read write */
		for(i=0, cp1 = color; i < 2; i++, cp1++) {
			cp1->pixel = i;
			cp1->green = cp1->blue = cp1->red = 0xffff ^ (i*32767);
			cp1->flags = (DoRed|DoGreen|DoBlue);
		}
		if (XAllocColor(display, colormap, &color[0]) == False) {
			delete("Could not allocate first cell as r/o.");
			return;
		} else
			CHECK;

		if (XAllocColorCells(display, colormap, True, &junk, 0,
					&color[1].pixel, 1) == False) {
			delete("Could not allocate second cell as r/w.");
			return;
		} else
			CHECK;

/*    Update r/w cell to known value with XStoreColor. */
		XStoreColor(display, colormap, &color[1]);
/*    Discover what it was really set to, and remember. */
		XQueryColor(display, colormap, &color[0]);

/*    Update both cells, the r/w one to an opposite value, with xname */
		color[1].red = color[1].green = color[1].blue ^= 0xffff;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}
/*    Verify BadAccess occurred, will have Failed if not -- see CODE arg. */
		if (geterr() == BadAccess)
			CHECK;
		else
			report("Updating 2 cells, 1st r/o & 2nd r/w, did not give expected BadAccess error.");

/*    Check that despite error the 2nd, r/w, cell was changed in value */
		XQueryColor(display, colormap, cp2 = &color[1]);
		cp1 = cp2 - 1;
		/* now cp1 == remembered (different), cp2 == actual */

		if (cp1->red == cp2->red && cp1->green == cp2->green &&
					cp1->blue == cp2->blue) {
			report("After error the r/w cell was not updated: got r,g,b = %lu,%lu,%lu",
				cp2->red, cp2->green, cp2->blue);
			FAIL;
		} else
			CHECK;

/*    Repeat for next matching visual. */
	}

	CHECKPASS(5*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int		errval;
XVisualInfo 	*vp;
XColor		*cp1;
unsigned long 	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
XColor		colors[3];
unsigned long	i;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XStoreColors-5.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: When the pixel component in more");
	report_assertion("than one of the XColor structures named by the color");
	report_assertion("argument is not a valid entry in the colormap argument, then");
	report_assertion("a BadValue error occurs which will report any one of the");
	report_assertion("invalid pixel values.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with alloc set to AllocAll.");
	report_strategy("  Store an array of 3 colorvalues with pixel values -1, 0, -2.");
	report_strategy("  Verify that a BadValue error occurs.");
	report_strategy("  Verify that the erroneous pixel was reported as either -1 or -2.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocAll);
		for(i=0, cp1 = colors; i < 3; i++, cp1++) {
			cp1->pixel = 0;
			cp1->red = 0xffff;
			cp1->green = 0;
			cp1->blue = 0;
			cp1->flags = (DoRed|DoGreen|DoBlue);
		}

		colors[0].pixel = -1;
		colors[1].pixel = 0;
		colors[2].pixel = -2;
		color = colors;
		ncolors = 3;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadValue) {
 			errval = getbadvalue();
                        if( (errval != -1) && (errval != -2) ) {
                                report("Erroneous value was reported as %d, instead of -1 or -2", errval);
                                FAIL;
                        } else {
                                CHECK;
				trace("Reported BadValue was %d", errval);
			}
		}
	}

	CHECKPASS(nsupvis());

		
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAcc3.mc */
/* End of included file error/EAcc3.mc */

static void t006(){

XVisualInfo	*vp;
XColor          *cp, *testcol;
Display		*disp2;
unsigned long	i;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XStoreColors-6.(A)");
	report_assertion("When an attempt to store into a read-only or an unallocated");
	report_assertion("colormap entry is made, then a BadAccess error occurs.");

	report_strategy("For all visuals:");
	report_strategy("  Create a colormap with alloc set to AllocNone. (Unallocated for visual");
	report_strategy("	classes DirectColor, PseudoColor and GrayScale; R/O for visual");
	report_strategy("	classes TrueColor, StaticColor and StaticGray: all should");
	report_strategy("	provoke BadAccess)");
	report_strategy("  If visual class is not one of DirectColor, PseudoColor or GrayScale;");
	report_strategy("    Store distinct colors into all of the (already r/o) cells using XStoreColors.");
	report_strategy("    Verify that a BadAccess error is generated.");
	report_strategy("  Create a new client with XOpenDisplay.");
	report_strategy("  Allocate a readonly cell for the new client with XAllocColor.");
	report_strategy("  Store a value in the cell with XStoreColors.");
	report_strategy("  Verify that a BadAccess error occurred.");
	report_strategy("  Allocate a readonly cell with XAllocColor.");
	report_strategy("  Store a value in the cell with XStoreColors.");
	report_strategy("  Verify that a BadAccess error occurred.");

	tpstartup();
	setargs();
	for(resetvinf(VI_WIN); nextvinf(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocNone);
		ncolors = maxsize(vp);
		testcol = (XColor *) malloc(ncolors * sizeof(XColor));

		if(testcol == (XColor *) 0) {
			delete("malloc() couldn't allocate %d cells for the XColor array.", ncolors);
			return;
		} else
			CHECK;

		for(i=0, cp = testcol; i < ncolors; i++, cp++) {
			cp->pixel = i;
			cp->green = cp->blue = cp->red = 0xffff ^ (i*3);
			cp->flags = (DoRed|DoGreen|DoBlue);
		}

		if (vp->class == TrueColor || vp->class == StaticColor ||
		    vp->class == StaticGray) { /* read-only map */

			trace("Testing a colormap with just r-o cells.");

			color = testcol;
			startcall(display);
			if (isdeleted())
				return;
			XStoreColors(display, colormap, color, ncolors);
			endcall(display);
			if (geterr() != BadAccess) {
				report("Got %s, Expecting BadAccess", errorname(geterr()));
				FAIL;
			}
			if(geterr() == BadAccess)
				CHECK;
		} else {
			trace("Testing a colormap with unallocated cells.");
			XSync(display, False);
			CHECK;
		}

		trace("Open second client connection.");
		disp2 = XOpenDisplay(config.display);
		if (!disp2) {
			delete("XOpenDisplay() failed.");
			return;
		}

		if(XAllocColor(disp2, colormap, &testcol[0]) == False) {
			delete("XAllocColor() failed to allocate a r/o cell for a second client.");
			XCloseDisplay(disp2);
			return;
		} else
			CHECK;

		trace("Trying to write into a r/o cell allocated by another client.");
		color = &testcol[0];
		ncolors = 1;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadAccess)
			CHECK;

		if(XAllocColor(display, colormap, &testcol[1]) == False) {
			delete("XAllocColor() failed to allocate a r/o cell");
			XCloseDisplay(disp2);
			return;
		} else
			CHECK;

		trace("Trying to write into a r/o cell allocated by self.");
		color = &testcol[1];
		ncolors = 1;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColors(display, colormap, color, ncolors);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadAccess)
			CHECK;

		XCloseDisplay(disp2);
	}

	CHECKPASS(6*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XStoreColors-7.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	XStoreColors(display, colormap, color, ncolors);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

/* Including from file Mdefcode.tmc.3504 */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XStoreColors-8.(D)");
	report_assertion("When rmask_return, gmask_return and bmask_return have been");
	report_assertion("returned by a previous call to XAllocColorPlanes and a");
	report_assertion("read-write colourmap entry for a pixel value is changed by a");
	report_assertion("call to XStoreColors, then the pixel value is decomposed");
	report_assertion("into three components using the masks and the independent");
	report_assertion("colourmap entries are updated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.3504 */

static void t009(){

XVisualInfo 	*vp;
unsigned long 	vmask = (1<<DirectColor);
XColor		*colors;
unsigned long	i;
XColor		*refp;
unsigned long	*reds, *greens, *blues;
int		pathcnt = 0;
static XColor triples[] = {
		{ ~0UL, 0,0,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 1,0,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 0,1,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 0,0,1, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 3,2,1, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 1,3,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 7,3,1, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 7,8,5, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 15,11,12, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 42,99,13, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 112,127,64, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 255,64,33, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 64,255,33, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 64,33,255, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 255,255,255, DoRed|DoGreen|DoBlue, 0 },
	};
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XStoreColors-9.(C)");
	report_assertion("If the visual class DirectColor is supported: When the");
	report_assertion("colormap argument was created with visual type DirectColor");
	report_assertion("and with alloc set to AllocAll, and a read-write colourmap");
	report_assertion("entry for a pixel value is changed by a call to XStoreColors,");
	report_assertion("then the pixel value is decomposed into three components");
	report_assertion("using the red_mask, green_mask and blue_mask in the visual");
	report_assertion("and the independent colourmap entries are updated.");

	report_strategy("If visual class DirectColor is supported:");
	report_strategy("   Create a colourmap using makecolmap and AlocAll");
	report_strategy("   Allocate an array of XColor's and one for each of reds, greens & blues");
	report_strategy("   Set up each of reds, greens & blues to have a distinguishable value,");
	report_strategy("     using XStoreColors, and make sure that's what's in the equivalent colourmaps.");
	report_strategy("   Read back some suitably \"random\" triples and check their components");
	report_strategy("   Verify that each component is the same as the corresponding entry in");
	report_strategy("     reds, greens & blues.");
	report_strategy("   Free the allocated storage: colors, reds, greens & blues.");

	tpstartup();
	setargs();
/* If visual class DirectColor is supported: */
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

/*    Create a colourmap using makecolmap and AlocAll */
		colormap = makecolmap(display, vp->visual, AllocAll);
		ncolors = maxsize(vp);
/*    Allocate an array of XColor's and one for each of reds, greens & blues */
		colors = (XColor *) malloc(ncolors * sizeof(XColor));
		color = colors;
		reds = (unsigned long *) malloc(ncolors * sizeof(unsigned long));
		greens = (unsigned long *) malloc(ncolors * sizeof(unsigned long));
		blues = (unsigned long *) malloc(ncolors * sizeof(unsigned long));
		if ((colors == (XColor *) 0) || (reds == (unsigned long *) 0) ||
				(greens == (unsigned long *) 0) ||
				(blues == (unsigned long *) 0)) {
			delete("malloc() couldn't allocate %d cells for the XColor array.", ncolors);
			return;
		} else
			CHECK;

/*    Set up each of reds, greens & blues to have a distinguishable value, */
/*      using xname, and make sure that's what's in the equivalent colourmaps. */
		/*
		   kept in reds, greens or blues. This routine expects
		   color and ncolors to be set right. It uses XCall as well.
		*/
		if (!set_one_col(reds, "red", DoRed, vp->red_mask) ||
		    !set_one_col(greens, "green", DoGreen, vp->green_mask) ||
		    !set_one_col(blues, "blue", DoBlue, vp->blue_mask)
		   ) {
			delete("Failed to set up colourmap for test.");
			return;
		} else
			CHECK;

/*    Read back some suitably "random" triples and check their components */
		for (i=0, refp=triples; i < NELEM(triples); i++, refp++) {
			XColor testcol;
			unsigned long r,g,b;

			if (refp->red >= (unsigned)ncolors ||
					refp->green >= (unsigned)ncolors ||
					refp->blue >= (unsigned)ncolors)
				continue;

			r = refp->red << maskshift(vp->red_mask);
			if (!bitsubset(r, vp->red_mask))
				continue;
			g = refp->green << maskshift(vp->green_mask);
			if (!bitsubset(g, vp->green_mask))
				continue;
			b = refp->blue << maskshift(vp->blue_mask);
			if (!bitsubset(b, vp->blue_mask))
				continue;
			testcol.pixel = r | g | b;

			XQueryColor(display, colormap, &testcol);

/*    Verify that each component is the same as the corresponding entry in */
/*      reds, greens & blues. */
			if (testcol.flags != (DoRed | DoGreen | DoBlue) ||
			    testcol.red != reds[refp->red] ||
			    testcol.green != greens[refp->green] ||
			    testcol.blue != blues[refp->blue]) {
				report("Expected r,g,b = %lu, %lu, %lu but got %lu, %lu, %lu for pixel 0x%lx with r-,g-,b-masks 0x%lx, 0x%lx, 0x%lx",
					reds[refp->red], greens[refp->green], blues[refp->blue],
					testcol.red, testcol.green, testcol.blue,
					testcol.pixel, vp->red_mask,
					vp->green_mask, vp->blue_mask);
				FAIL;
			} else
				CHECK;

			pathcnt++;
		}

/*    Free the allocated storage: colors, reds, greens & blues. */
		free((char*)colors);
		free((char*)reds);
		free((char*)greens);
		free((char*)blues);
	}

	CHECKPASS(pathcnt+2*nsupvis());
			

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
