/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Colormap
 *   XCreateColormap(display, win, visual, alloc)
 *   Display	*display;
 *   Window	win;
 *   Visual	*visual;
 *   int 	alloc;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreateColormap	1
char    *TestName = "XCreateColormap";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW win
#define A_DRAWABLE win


/*
 * Arguments to the XCreateColormap function
 */
static Display	*display;
static Window	win;
static Visual	*visual;
static int 	alloc;


Visual dummyvisual;


/* Value list for use in test t010 */
static int 	allocvallist[] = {
	AllocNone,
	AllocAll,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	win = DRW(display);
	visual = &dummyvisual;
	alloc = AllocNone;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo *vp;
Colormap	cmap;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreateColormap-1.(A)");
	report_assertion("A call to XCreateColormap creates a colourmap of the type");
	report_assertion("visual on the screen for which the window argument was");
	report_assertion("created and returns a colourmap ID.");

	report_strategy("For each visual type");
	report_strategy("  Create a colourmap for that visual.");
	report_strategy("  Verify that the colourpmap is usable by  Installing it.");

	tpstartup();
	setargs();

	alloc = AllocNone;
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {

		win = makewin(display, vp);
		visual = vp->visual;
		startcall(display);
		if (isdeleted())
			return;
		cmap = XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		/*
		 * The only way that we can really check that we have a valid colourmap
		 * is to try and use it.  So try to install it.  Of course it
		 * could be that the install routine is broken but the point is that
		 * something is wrong.  Print out both routine names to alert the tester
		 * about possible sources of the problem.
		 */
		CATCH_ERROR(display);
		XInstallColormap(display, cmap);
		RESTORE_ERROR(display);
		if (GET_ERROR(display) != Success) {
			report("Result of a XCreateColormap could not be used with XInstallColormap");
			FAIL;
		} else {
			CATCH_ERROR(display);
			XUninstallColormap(display, cmap);
			RESTORE_ERROR(display);

			if (GET_ERROR(display) != Success) {
				report("Result of a XCreateColormap could not be used with XUninstallColormap");
				FAIL;
			} else 
				CHECK;
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Colormap	cmap;
XVisualInfo	*vp;
unsigned long vmask = ((1L<<TrueColor) | (1L<<StaticColor) | (1L<<StaticGray));
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreateColormap-2.(D)");
	report_assertion("If any of the visual classes StaticGray, StaticColor or");
	report_assertion("TrueColor are supported: When XCreateColormap is called with");
	report_assertion("a visual class that is one of StaticGray, StaticColor or");
	report_assertion("TrueColor and alloc is AllocNone, then the entries have");
	report_assertion("defined values specific to the visual that are");
	report_assertion("implementation defined.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("For the visual classes TrueColor, StaticColor and StaticGray:");
	report_strategy("  Verify that a colormap of that class can be created with XCreateColormap.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("TrueColor, StaticColor and StaticGray are not supported");
		return;
	}

	alloc = AllocNone;
	for ( resetsupvis(vmask); nextsupvis(&vp); ) {

		visual = vp->visual;
		startcall(display);
		if (isdeleted())
			return;
		cmap = XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (geterr() == Success)
			CHECK;
	}

	CHECKUNTESTED(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Colormap	cmap;
XVisualInfo	*vi;
Status 		status;
unsigned long	*pix;
unsigned long	vmask;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreateColormap-3.(C)");
	report_assertion("If any of the visual classes PseudoColor, GrayScale or");
	report_assertion("DirectColor are supported: When XCreateColormap is called");
	report_assertion("with a visual class that is one of PseudoColor, GrayScale");
	report_assertion("or DirectColor and alloc is AllocNone, then the colourmap");
	report_assertion("has no allocated entries.");

	report_strategy("For each visual class PseudoColor, GrayScale and DirectColor:");
	report_strategy("  Create a colourmap with alloc set to AllocNone.");
	report_strategy("  Verify that no cells were allocated by Allocating all the colourmap cells");
	report_strategy("   with XAllocColorCells.");

	tpstartup();
	setargs();

#define RW_COLORMAP_MASK ((1L<<DirectColor) | (1L<<PseudoColor) | (1L<<GrayScale))

	if( (vmask = visualsupported(display, RW_COLORMAP_MASK)) == 0L) {
		unsupported("DirectColor, PseudoColor and GrayScale are not supported");
		return;
	}

	alloc = AllocNone;
	for(resetsupvis(vmask); nextsupvis(&vi); ) {

		visual = vi->visual;
		startcall(display);
		if (isdeleted())
			return;
		cmap = XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		n = maxsize(vi);
		pix = (unsigned long *)malloc(n * sizeof(unsigned long));

		if (pix == NULL) {
			delete("malloc failed for pix array");
			return;
		}

		trace("allocate %d colour cells", n);
		status = XAllocColorCells(display, cmap, False, (unsigned long *)0, 0, pix, n);
		free((void*)pix);
		if (status == False) {
			report("Unable to allocate all colour cells");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo	*vi;
Colormap	cmap;
Status	status;
unsigned long	pix;
unsigned long 	vmask;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreateColormap-4.(A)");
	report_assertion("If any of the visual classes PseudoColor, GrayScale or");
	report_assertion("DirectColor are supported: When XCreateColormap is called");
	report_assertion("with a visual class that is one of PseudoColor, GrayScale");
	report_assertion("or DirectColor and the argument alloc is AllocAll, then the");
	report_assertion("entire colourmap is allocated read-write.");

	report_strategy("For each of the visual classes DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with alloc set to AllocAll.");
	report_strategy("  Verify that the allocation of another r/w cell fails with XAllocColorCells.");

	tpstartup();
	setargs();
#define RW_COLORMAP_MASK ((1L<<DirectColor) | (1L<<PseudoColor) | (1L<<GrayScale))

	if( (vmask = visualsupported(display, RW_COLORMAP_MASK)) == 0L) {
		unsupported("DirectColor, PseudoColor and GrayScale are not supported");
		return;
	}

	alloc = AllocAll;
	for (resetsupvis(vmask); nextsupvis(&vi); ) {

		visual = vi->visual;
		startcall(display);
		if (isdeleted())
			return;
		cmap = XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		/*
		 * If the entire colourmap is allocated then it should not be
		 * possible to allocate any more entries.
		 */

		status = XAllocColorCells(display, cmap, False, (unsigned long*)0, 0, &pix, 1);

		if (status != (Status) 0) {
			report("There was an unallocated colour cell");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Colormap	cmap;
XVisualInfo	*vi;
XColor		col;
unsigned long	pix;
unsigned long		vmask 	= (1L<<PseudoColor) | (1L<<GrayScale);
int 		n;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreateColormap-5.(C)");
	report_assertion("If either of the visual classes GrayScale or PseudoColor");
	report_assertion("are supported: When the visual class is GrayScale or");
	report_assertion("PseudoColor, and the argument alloc is AllocAll, then a");
	report_assertion("call to XCreateColormap allocates N read-write colourmap");
	report_assertion("entries with pixel values from zero to N - 1, where N is the");
	report_assertion("number of colourmap entries value in the specified visual.");

	report_strategy("For each of the visuals GrayScale and PseudoColor:");
	report_strategy("  Create a colormap with alloc set to AllocAll.");
	report_strategy("  For each of the 0..N-1 allocated cells:");
	report_strategy("    Write value r 31<<8, g 63<<8, b 127<<8 with XStoreColor.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("PseudoColor and GrayScale are not supported");
		return;
	}

	col.red = 31<<8;
	col.green = 63<<8;
	col.blue = 127<<8;
	col.flags = DoRed|DoGreen|DoBlue;

	alloc = AllocAll;
	for(resetsupvis(vmask); nextsupvis(&vi); ) {

		visual = vi->visual;
		startcall(display);
		if (isdeleted())
			return;
		cmap = XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(geterr() != Success)
			continue;

		n = maxsize(vi);
		for(pix = 0L; pix < n; pix++) {
			col.pixel = pix;

			CATCH_ERROR(display);
			XStoreColor(display, cmap, &col);
			RESTORE_ERROR(display);
	
			if(GET_ERROR(display) != Success) {
				report("Pixel %lu could not be written in the colourmap.", pix);
				FAIL;
			}
		}

		if(pix == n)
			CHECK;
	}
	
	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

#define  NUM_COLS 4096
Colormap	cmap;
XVisualInfo	*vi;
XColor		colarr[NUM_COLS];
unsigned long	count;
unsigned long		vmask = (1L<<DirectColor);
int		n, i,  bitsum;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreateColormap-6.(C)");
	report_assertion("If the visual class DirectColor is supported: When the");
	report_assertion("visual class is DirectColor and the argument alloc is");
	report_assertion("AllocAll, then a call to XCreateColormap allocates");
	report_assertion("2pow(nred+ngreen+nblue) read-write colourmap entries with");
	report_assertion("pixel values obtained by ORing zero or more of the planes");
	report_assertion("obtained by ORing the red_mask, green_mask and blue_mask");
	report_assertion("values in the visual argument, where nreds, ngreens and");
	report_assertion("nblues are the number of bits in the respective masks.");

	report_strategy("For the visual Directcolor:");
	report_strategy("  Create a colormap with alloc set to AllocAll.");
	report_strategy("  For each of the 0..N-1 allocated cells:");
	report_strategy("    Write value r 31<<8, g 63<<8, b 127<<8 with XStoreColor.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("DirectColor is not supported");
		return;
	}

	for(i=0; i<NUM_COLS; i++) {
		colarr[i].red = 31<<8;
		colarr[i].green = 63<<8;
		colarr[i].blue = 127<<8;
		colarr[i].flags = DoRed|DoGreen|DoBlue;
	}		

	resetsupvis(vmask); 
	nextsupvis(&vi);

	alloc = AllocAll;
	visual = vi->visual;
	startcall(display);
	if (isdeleted())
		return;
	cmap = XCreateColormap(display, win, visual, alloc);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(geterr() == Success) {
		bitsum = (bitcount(vi->red_mask) + bitcount(vi->green_mask) + bitcount(vi->blue_mask));
		n = 1<< bitsum;
		for(count = 0L; count < n; count+=NUM_COLS) { 
			for (i=0; i<NUM_COLS; i++)
				colarr[i].pixel = count+i;
			CATCH_ERROR(display);
			XStoreColors(display, cmap, colarr,
				(count+NUM_COLS <= n) ? NUM_COLS : n-count);
			RESTORE_ERROR(display);
	
			if(GET_ERROR(display) != Success) {
				report("Pixel in range [%lu-%lu] could not be written in the colourmap.", count,count+NUM_COLS);
				FAIL;
			} 

		}
	}

	if (count >= n)
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XVisualInfo	*vi;
Colormap	cmap;
Status	status;
unsigned long	pix;
unsigned long 	vmask = ((1L<<DirectColor) | (1L<<PseudoColor) | (1L<<GrayScale));
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCreateColormap-7.(C)");
	report_assertion("If any of the visual classes PseudoColor, GrayScale or");
	report_assertion("DirectColor are supported: When XCreateColormap is called");
	report_assertion("with a visual class that is one of PseudoColor, GrayScale");
	report_assertion("or DirectColor and the alloc argument is AllocAll, then");
	report_assertion("none of the entries can be freed with XFreeColors().");

	report_strategy("For the visual classes DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colourmap with XCreateColormap with alloc set to AllocAll.");
	report_strategy("  Deallocate a colorcell with XFreeColor.");
	report_strategy("  Allocate a colorcell with XAllocColorCell.");
	report_strategy("  Verify that the allocation failed.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("DirectColor, PseudoColor and GrayScale are not supported");
		return;
	}

	alloc = AllocAll;
	for (resetsupvis(vmask); nextsupvis(&vi); ) {

		visual = vi->visual;
		startcall(display);
		if (isdeleted())
			return;
		cmap = XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		status = XAllocColorCells(display, cmap, False, (unsigned long*)0, 0, &pix, 1);

		pix = 0;

		CATCH_ERROR(display);
		XFreeColors(display, cmap, &pix, 1, 0);
		RESTORE_ERROR(display);
		if( GET_ERROR(display) == Success) {
			delete("XFreeColors() did not give an error deallocating a cell.");
			FAIL;
		} else
			CHECK;

		status = XAllocColorCells(display, cmap, False, (unsigned long*)0, 0, &pix, 1);

		if (status != (Status) 0) {
			report("A cell was deallocated by XFreeColors().");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(2*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Colormap	cmap;
XVisualInfo	*vp;
unsigned long vmask = (1L<<TrueColor) | (1L<<StaticColor) | (1L<<StaticGray);
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XCreateColormap-8.(C)");
	report_assertion("If any of the visual classes StaticGray, StaticColor or");
	report_assertion("TrueColor are supported: When XCreateColormap is called with");
	report_assertion("a visual that is one of StaticGray, StaticColor or");
	report_assertion("TrueColor, and the argument alloc is other than AllocNone,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("For each visual class in TrueColor, StaticColor and StaticGray:");
	report_strategy("  Call XCreateColormap with Alloc set to AllocAll.");
	report_strategy("  Verify that a BadMatch error occurred.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("TrueColor, StaticColor and StaticGray are not supported");
		return;
	}

	alloc = AllocAll;
	for ( resetsupvis(vmask); nextsupvis(&vp); ) {
		visual = vp->visual;
		startcall(display);
		if (isdeleted())
			return;
		cmap = XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != BadMatch) {
			report("Got %s, Expecting BadMatch", errorname(geterr()));
			FAIL;
		}
		if (geterr() == BadMatch)
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.452 */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XCreateColormap-9.(D)");
	report_assertion("If there is a visual class that is not supported on the");
	report_assertion("screen: When XCreateColormap is called with a visual that is");
	report_assertion("not supported on the screen for which the window argument");
	report_assertion("was created, then a BadMatch error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.452 */

/* Including from file Mval.tmc.452 */
/* End of included file Mval.tmc.452 */

/* Including from file error/EVal.mc */
static void t010(){

#undef	VALUE_ARG
#define	VALUE_ARG alloc
#undef	VALUE_LIST
#define	VALUE_LIST allocvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XCreateColormap-10.(A)");
	report_assertion("When the value of alloc is other than AllocNone or AllocAll,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XCreateColormap(display, win, visual, alloc);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

static void t011(){

Visual	vi;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XCreateColormap-11.(A)");
	report_assertion("When XCreateColormap is called with an invalid visual, then");
	report_assertion("a BadMatch error occurs.");

	report_strategy("Make a visual structure invalid using badvis.");
	report_strategy("Create a colourmap for this visual with XCreateColorMap.");
	report_strategy("Verify that a BadMatch error occurred.");

	tpstartup();
	setargs();
	alloc = AllocNone;
	badvis(&vi);
	visual = &vi;
	startcall(display);
	if (isdeleted())
		return;
	XCreateColormap(display, win, visual, alloc);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadMatch)
		PASS;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XCreateColormap-12.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreateColormap(display, win, visual, alloc);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XCreateColormap-13.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
