/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   
 *   XShrinkRegion(r, dx, dy)
 *   Region	r;
 *   int	dx;
 *   int	dy;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XShrinkRegion	1
char    *TestName = "XShrinkRegion";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XShrinkRegion function
 */
static Region	r;
static int	dx;
static int	dy;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	r = 0;
	dx = 0;
	dy = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Region			R1;
Region			R2;
static XRectangle	rect = { 7,5, 23, 45};
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XShrinkRegion-1.(A)");
	report_assertion("When dx and dy are zero, then a call to XShrinkRegion does");
	report_assertion("not change the size of region r.");

	report_strategy("Create two regions using XCreateRegion.");
	report_strategy("Verify that the calls did not return NULL.");
	report_strategy("Set the regions to the same rectangle using XUnionRectWithRegion.");
	report_strategy("Shrink the first region with parameters dx = dy = 0.");
	report_strategy("Verify that the two regions are identical using XEqualRegion.");

	tpstartup();
	setargs();
	if( ((R1 = XCreateRegion()) == (Region) NULL) ||
	    ((R2 = XCreateRegion()) == (Region) NULL) ){
		delete("XCreateRegion() returned NULL.");
		return;
	} else
		CHECK;

	XUnionRectWithRegion(&rect, R1, R1);
	XUnionRectWithRegion(&rect, R2, R2);

	r = R1;
	dx = dy = 0;
	startcall(Dsp);
	if (isdeleted())
		return;
	XShrinkRegion(r, dx, dy);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( XEqualRegion(R1, R2) != True ) {
		report("%s() changed a region when dx and dy were zero.", TestName);
		FAIL;
	} else
		PASS;

	XDestroyRegion(R1);	
	XDestroyRegion(R2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

static XRectangle	rect = { 5,7, 100, 200};
Region			R1;
Region			R2;
Region			R3;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XShrinkRegion-2.(A)");
	report_assertion("When dx and dy are both positive, and a point x, y is");
	report_assertion("outside region r, then call to XShrinkRegion changes the");
	report_assertion("size of the region r such that the point x, y remains");
	report_assertion("outside region r, and some point x1, y1 previously inside");
	report_assertion("region r is now outside region r.");

	report_strategy("Create regions R1, R2 and R3 using XCreateRegion.");
	report_strategy("Verify that none of the calls returned NULL.");
	report_strategy("Set region R1 to a rectangle using XUnionRectWithRegion.");
	report_strategy("Copy region R1 to R2 using XUnionRegion.");
	report_strategy("Shrink R2 using XShrinkRegion.");
	report_strategy("Set R3 to the difference of the union and intersection of R1 and R2 using XXorRegion.");
	report_strategy("Verify that R3 is not empty using XEmptyRegion.");
	report_strategy("Set R3 to be the union of R2 and R3 using XUnionRegion.");
	report_strategy("Verify that R3 is the same as R1 using XEqualRegion.");

	tpstartup();
	setargs();
	R1 = XCreateRegion();
	R2 = XCreateRegion();
	R3 = XCreateRegion();

	if( (R1 == (Region) NULL) || (R2 == (Region) NULL) || R3 == (Region) NULL) {
		delete("XCreateRegion() returned NULL.");
		return;
	} else
		CHECK;

	XUnionRectWithRegion(&rect, R1, R1);
	XUnionRegion(R1, R1, R2);

	dx = dy = 1;
	r = R2;
	startcall(Dsp);
	if (isdeleted())
		return;
	XShrinkRegion(r, dx, dy);	
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XXorRegion(R1, R2, R3);

	if(XEmptyRegion(R3) == True) {
		report("%s() did not change the size of the source region.", TestName);
		FAIL;
		return;
	} else
		CHECK;

	XUnionRegion(R2, R3, R3);

	if( XEqualRegion(R1, R3) == False) {
		report("%s() did not produce a shrunk region contained in its source.", TestName);
		FAIL;
	} else
		CHECK;

	XDestroyRegion(R1);
	XDestroyRegion(R2);
	XDestroyRegion(R3);

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

static XRectangle	rect = { 5,7, 100, 200};
Region			R1;
Region			R2;
Region			R3;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XShrinkRegion-3.(A)");
	report_assertion("When dx and dy are both negative, and a point x, y is in");
	report_assertion("region r, then call to XShrinkRegion changes the size of");
	report_assertion("the region r such that the point x, y remains in region r,");
	report_assertion("and some point x1, y1 previously outside region r is now");
	report_assertion("inside region r.");

	report_strategy("Create regions R1, R2 and R3 using XCreateRegion.");
	report_strategy("Verify that none of the calls returned NULL.");
	report_strategy("Set region R1 to a rectangle using XUnionRectWithRegion.");
	report_strategy("Copy region R1 to R2 using XUnionRegion.");
	report_strategy("Enlarge R2 using XShrinkRegion.");
	report_strategy("Set R3 to the difference of the union and intersection of R1 and R2 using XXorRegion.");
	report_strategy("Verify that R3 is not empty using XEmptyRegion.");
	report_strategy("Set R3 to be the union of R2 and R3 using XUnionRegion.");
	report_strategy("Verify that R3 is the same as R2 using XEqualRegion.");

	tpstartup();
	setargs();
	R1 = XCreateRegion();
	R2 = XCreateRegion();
	R3 = XCreateRegion();

	if( (R1 == (Region) NULL) || (R2 == (Region) NULL) || R3 == (Region) NULL) {
		delete("XCreateRegion() returned NULL.");
		return;
	} else
		CHECK;

	XUnionRectWithRegion(&rect, R1, R1);
	XUnionRegion(R1, R1, R2);

	dx = dy = -1;
	r = R2;
	startcall(Dsp);
	if (isdeleted())
		return;
	XShrinkRegion(r, dx, dy);	
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XXorRegion(R1, R2, R3);

	if(XEmptyRegion(R3) == True) {
		report("%s() did not change the size of the source region.", TestName);
		FAIL;
		return;
	} else
		CHECK;

	XUnionRegion(R2, R3, R3);

	if( XEqualRegion(R2, R3) == False) {
		report("%s() did not produce an enlarged region containing its source.", TestName);
		FAIL;
	} else
		CHECK;

	XDestroyRegion(R1);
	XDestroyRegion(R2);
	XDestroyRegion(R3);

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
