/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XLookupString(event_struct, buffer_return, bytes_buffer, keysym_return, status_in_out)
 *   XKeyEvent	*event_struct;
 *   char		*buffer_return;
 *   int		bytes_buffer;
 *   KeySym		*keysym_return;
 *   XComposeStatus	*status_in_out;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XLookupString	1
char    *TestName = "XLookupString";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XLookupString function
 */
static XKeyEvent	*event_struct;
static char		*buffer_return;
static int		bytes_buffer;
static KeySym		*keysym_return;
static XComposeStatus	*status_in_out;


static int 	ValueReturn;

#define XK_LATIN1
#define XK_MISCELLANY
#include	"X11/keysymdef.h"
#undef XK_MISCELLANY
#undef XK_LATIN1

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	event_struct = 0;
	buffer_return = 0;
	bytes_buffer = 0;
	keysym_return = 0;
	status_in_out = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

KeySym		ks = 0;
KeyCode		kc;
static char	buf[]="Xtest uninitialised string.";
int		res;
int		cmplen;
int		mlen = strlen(buf);
XKeyEvent	ke;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XLookupString-1.(A)");
	report_assertion("A call to XLookupString returns in the keysym_return");
	report_assertion("argument the KeySym and in the buffer_return the string of");
	report_assertion("maximum length bytes_buffer specified by the keycode and");
	report_assertion("state of the event_struct argument, using the standard shift");
	report_assertion("modifier computations as defined in the X protocol");
	report_assertion("specification, and returns the length of the returned");
	report_assertion("string.");

	report_strategy("Obtain the keycode corresponding to the keysym XK_b using XKeysymToKeycode.");
	report_strategy("Obtain the string and keysym bound to that keycode using XLookupString.");
	report_strategy("Verify that the returned string is correct.");
	report_strategy("Obtain the string and keysym bound to that keycode using XLookupString with state = ShiftMask.");
	report_strategy("Verify that the returned string is correct.");

	tpstartup();
	setargs();
	kc = XKeysymToKeycode(Dsp, XK_b);

	ke.type = KeyPress;
	ke.display = Dsp;
	ke.keycode = kc;
	ke.state = 0;

	event_struct = &ke;
	buffer_return = (char *) buf;
	bytes_buffer = mlen;
	keysym_return = &ks;
	status_in_out = (XComposeStatus *) NULL;

	startcall(Dsp);
	if (isdeleted())
		return;
	res = XLookupString(event_struct, buffer_return, bytes_buffer, keysym_return, status_in_out);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(ks != XK_b) {
		report("%s() returned keysym %d instead of %d.", TestName, (int) ks, (int) XK_b);
		FAIL;
	} else
		CHECK;

	if(res != 1) {
		report("%s() returned %d instead of 1.", TestName, res);
		FAIL;
	} else
		CHECK;

	cmplen = mlen;
	if(res>0 && res<mlen)
		cmplen = res;
	buf[cmplen] = '\0';

	if(strncmp(buffer_return, "b", cmplen) != 0) {
		report("%s() returned string \"%s\" instead of \"b\".", TestName, buffer_return);
		FAIL;
	} else
		CHECK;

	ke.state = ShiftMask;
	event_struct = &ke;
	startcall(Dsp);
	if (isdeleted())
		return;
	res = XLookupString(event_struct, buffer_return, bytes_buffer, keysym_return, status_in_out);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(ks != XK_B) {
		report("%s() returned keysym %d instead of %d.", TestName, (int) ks, (int) XK_B);
		FAIL;
	} else
		CHECK;

	cmplen = mlen;
	if(res>0 && res<mlen)
		cmplen = res;
	buf[cmplen] = '\0';

	if(strncmp(buffer_return, "B", cmplen) != 0) {
		report("%s() returned string \"%s\" instead of \"B\".", TestName, buffer_return);
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

KeySym		ks = 0;
KeyCode		kc;
static char	buf[]="XtestRebound";
static char	buf_ret[4];
int		res;
int		cmplen;
int		mlen = 3;
XKeyEvent	ke;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XLookupString-2.(A)");
	report_assertion("When the KeySym corresponding to the event_struct argument");
	report_assertion("has been rebound, then the bound string is returned,");
	report_assertion("truncated to bytes_buffer, in the buffer_return argument.");

	report_strategy("Rebind the keysym XK_c to the string XtestRebound using XRebindKeysym.");
	report_strategy("Obtain the keycode bound to the XK_c keysym using XKeysymToKeycode.");
	report_strategy("Obtain the first three characters of the string to which the keycode is bound using XLookupString.");
	report_strategy("Verify that the returned string is correct.");

	tpstartup();
	setargs();
	kc = XKeysymToKeycode(Dsp, XK_c);
	XRebindKeysym(Dsp, XK_c, (KeySym *) NULL, 0, (unsigned char *) buf, strlen(buf));

	ke.type = KeyPress;
	ke.display = Dsp;
	ke.keycode = kc;
	ke.state = 0;

	event_struct = &ke;
	buffer_return = (char *) buf_ret;
	bytes_buffer = mlen;
	keysym_return = &ks;
	status_in_out = (XComposeStatus *) NULL;

	startcall(Dsp);
	if (isdeleted())
		return;
	res = XLookupString(event_struct, buffer_return, bytes_buffer, keysym_return, status_in_out);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(ks != XK_c) {
		report("%s() returned keysym %d instead of %d.", TestName, (int) ks, (int) XK_b);
		FAIL;
	} else
		CHECK;

	if(res != mlen) {
		report("%s() returned %d instead of %d.", TestName, res, mlen);
		FAIL;
	} else
		CHECK;

	cmplen = mlen;
	if(res>0 && res<mlen)
		cmplen = res;
	buf[cmplen] = '\0';
	buffer_return[cmplen] = '\0';

	if(strncmp(buffer_return, buf, cmplen) != 0) {
		report("%s() returned string \"%s\" instead of \"%s\".", TestName, buffer_return, buf);
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.484 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XLookupString-3.(B)");
	report_assertion("When the status_in_out argument is not NULL, then a call to");
	report_assertion("XLookupString records in it the state of compose processing.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.484 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
