/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmPutFileDatabase(database, stored_db)
 *   XrmDatabase database;
 *   const char *stored_db;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmPutFileDatabase	1
char    *TestName = "XrmPutFileDatabase";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmPutFileDatabase function
 */
static XrmDatabase database;
static const char *stored_db;



static XrmDatabase
xrm_create_database(data)
char *data;
{
	/* Create a new database for testing with */
	return(XrmGetStringDatabase(data));
}

static void
xrm_fill_value(value, data)
XrmValue *value;
char *data;
{
	value->addr = (caddr_t)data;
	value->size = (unsigned int)(strlen(data)+1);
}

static int
xrm_check_entry(dbase, fullspec, fullclass, type, val)
XrmDatabase dbase;
char *fullspec;
char *fullclass;
char *type;
char *val;
{
	int ret_val;
	char	*type_ret;
	XrmValue	value_ret;

	ret_val=0;
	type_ret=(char *)NULL;
	value_ret.size=0;
	value_ret.addr=(caddr_t)NULL;

	if(XrmGetResource(dbase, fullspec, fullclass, &type_ret, &value_ret)
		==False) {
		report("XrmGetResource failed to find database entry");
		report("Specifier was: %s", fullspec);
		ret_val++;
	} else {
		if (type_ret==NULL || strcmp(type_ret, type)) {
			report("XrmGetResource returned unexpected type information.");
			report("Specifier was: %s", fullspec);
			report("Expected type: '%s'", type);
			report("Returned type: '%s'",
				(type_ret==NULL)?"<NULL POINTER>":type_ret);
			ret_val++;
		}

		if (( value_ret.addr==(caddr_t)NULL)
			|| (strncmp((char *)value_ret.addr, val, strlen(val)))) {
			report("XrmGetResource returned unexpected value information.");
			report("Specifier was: %s", fullspec);
			report("Expected value: '%s'", val);
			if(value_ret.addr == (caddr_t)NULL) {
				report("Returned value: <NULL POINTER>");
			} else {
				report("Returned value: '%.*s' (%u bytes)",
					value_ret.size, (char *)value_ret.addr, value_ret.size);
			}
			ret_val++;
		}
	}

	return(ret_val);
}

static int
xrm_tabulate(from, into)
char *from, *into;
{
	int i,j;

	j = strlen(from);
	for(i=0; i<j; i++) {
		if(from[i]=='T') {
			into[i]='\t';
		} else {
			into[i]=from[i];
		}
	}
	return(j);
}


#define XPFD_T1_COUNT	4
static char *t1_data[XPFD_T1_COUNT][3] = {
	{ "a.b.c",	"ONE",	"a.b.c" },
	{ "D.E.F",	"TWO",	"D.E.F"},
	{ "*Z",	"THREE",	"A.Z"	},
	{ ".e.f.g.h.i.j",	"*!++ X&",	"e.f.g.h.i.j"	} };


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	database = (XrmDatabase)NULL;
	stored_db = outfile("xpfd_file");
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file rescommon.mc */
/* End of included file rescommon.mc */

static void t001(){

int a;
XrmDatabase rdb;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmPutFileDatabase-1.(A)");
	report_assertion("A call to XrmPutFileDatabase stores the resource name and");
	report_assertion("value pairs in the specified file stored_db from the");
	report_assertion("specified database in ResourceLine format.");

	report_strategy("Create a new database containing the test information.");
	report_strategy("Call XrmPutFileDatabase to write the database.");
	report_strategy("Call XrmGetFileDatabase to check the database was written out.");
	report_strategy("Check the retrieved database contents were as expected.");
	report_strategy("Remove created file.");

	tpstartup();
	setargs();
/* Create a new database containing the test information. */
	for(a=0; a<XPFD_T1_COUNT; a++) {
		XrmPutStringResource(&database, t1_data[a][0], t1_data[a][1]);
		CHECK;
	}

/* Call xname to write the database. */
	unlink( stored_db );
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutFileDatabase(database, stored_db);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call XrmGetFileDatabase to check the database was written out. */
	rdb = XrmGetFileDatabase( stored_db );
	if (rdb == (XrmDatabase)NULL) {
		FAIL;
		delete("XrmGetFileDatabase could not open the written database.");
		return;
	} else {
/* Check the retrieved database contents were as expected. */
		for(a=0; a<XPFD_T1_COUNT; a++) {
			if (xrm_check_entry(rdb, t1_data[a][2], t1_data[a][2],
				"String", t1_data[a][1])) {
				delete("Unexpected data item returned from read in database");
				report("%s may have failed.", TestName);
			} else
				CHECK;
		}
	}

	CHECKPASS(XPFD_T1_COUNT + XPFD_T1_COUNT);

/* Remove created file. */
#ifndef TESTING
	unlink( stored_db ); 	/* To examine test file, */
				/* use pmake CFLOCAL=-DTESTING */
#endif
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int a;
XrmDatabase rdb;
static XrmValue xpr_value;
char    	*type_ret;
XrmValue        value_ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmPutFileDatabase-2.(A)");
	report_assertion("On a call to XrmPutFileDatabase entries with representation");
	report_assertion("types other than String shall be ignored.");

	report_strategy("Create a new database containing the test information.");
	report_strategy("Call XrmPutFileDatabase to write the database with a representation other than String.");
	report_strategy("Call XrmGetFileDatabase to check the database was written out.");
	report_strategy("Check that the entry was not added.");
	report_strategy("Remove created file.");

	tpstartup();
	setargs();
	/* Create a new database containing the test information. */
	for(a=0; a<XPFD_T1_COUNT; a++) {
		XrmPutStringResource(&database, t1_data[a][0], t1_data[a][1]);
	}

	/* Add a non-string resource to the database */
	xrm_fill_value(&xpr_value, "Value One");
	XrmPutResource(&database, "calvin*and.hobbes", "Thing", &xpr_value);
	/* Call xname to write the database. */
	unlink( stored_db );
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutFileDatabase(database, stored_db);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Call XrmGetFileDatabase to check the database was written out. */
	rdb = XrmGetFileDatabase( stored_db );
	if (rdb == (XrmDatabase)NULL) {
		FAIL;
		delete("XrmGetFileDatabase could not open the written database.");
		return;
	} 
	else
	{
		/* Check the retrieved database contents were as expected. */
/*
		if (xrm_check_entry(rdb, "calvin.and.hobbes","Boy.Thingy0.Tiger",
				"Thing", "Value One")) 
		{
			delete("Unexpected data item returned from read in database");
			report("%s may have failed.", TestName);
		}
*/
	
		if (XrmGetResource(rdb,  "calvin.and.hobbes", "Boy.Thingy0.Tiger", &type_ret, &value_ret) != False) 
		{
                	report("Non-string entry was added to the database file");
			tet_result(TET_FAIL);
			return;
        	}
	}

/* Remove created file. */
#ifndef TESTING
	unlink( stored_db ); 	/* To examine test file, */
				/* use pmake CFLOCAL=-DTESTING */
#endif
	tet_result(TET_PASS);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.1908 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmPutFileDatabase-3.(B)");
	report_assertion("The order in which entries from database are written to the");
	report_assertion("stored database file stored_db on a call to");
	report_assertion("XrmPutFileDatabase.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.1908 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
