/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XrmGetResource(database, str_name, str_class, str_type_return, value_return)
 *   XrmDatabase database;
 *   char *str_name;
 *   char *str_class;
 *   char **str_type_return;
 *   XrmValue *value_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmGetResource	1
char    *TestName = "XrmGetResource";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmGetResource function
 */
static XrmDatabase database;
static char *str_name;
static char *str_class;
static char **str_type_return;
static XrmValue *value_return;



static XrmDatabase
xrm_create_database(data)
char *data;
{
	/* Create a new database for testing with */
	return(XrmGetStringDatabase(data));
}

static void
xrm_fill_value(value, data)
XrmValue *value;
char *data;
{
	value->addr = (caddr_t)data;
	value->size = (unsigned int)(strlen(data)+1);
}

static int
xrm_check_entry(dbase, fullspec, fullclass, type, val)
XrmDatabase dbase;
char *fullspec;
char *fullclass;
char *type;
char *val;
{
	int ret_val;
	char	*type_ret;
	XrmValue	value_ret;

	ret_val=0;
	type_ret=(char *)NULL;
	value_ret.size=0;
	value_ret.addr=(caddr_t)NULL;

	if(XrmGetResource(dbase, fullspec, fullclass, &type_ret, &value_ret)
		==False) {
		report("XrmGetResource failed to find database entry");
		report("Specifier was: %s", fullspec);
		ret_val++;
	} else {
		if (type_ret==NULL || strcmp(type_ret, type)) {
			report("XrmGetResource returned unexpected type information.");
			report("Specifier was: %s", fullspec);
			report("Expected type: '%s'", type);
			report("Returned type: '%s'",
				(type_ret==NULL)?"<NULL POINTER>":type_ret);
			ret_val++;
		}

		if (( value_ret.addr==(caddr_t)NULL)
			|| (strncmp((char *)value_ret.addr, val, strlen(val)))) {
			report("XrmGetResource returned unexpected value information.");
			report("Specifier was: %s", fullspec);
			report("Expected value: '%s'", val);
			if(value_ret.addr == (caddr_t)NULL) {
				report("Returned value: <NULL POINTER>");
			} else {
				report("Returned value: '%.*s' (%u bytes)",
					value_ret.size, (char *)value_ret.addr, value_ret.size);
			}
			ret_val++;
		}
	}

	return(ret_val);
}

static int
xrm_tabulate(from, into)
char *from, *into;
{
	int i,j;

	j = strlen(from);
	for(i=0; i<j; i++) {
		if(from[i]=='T') {
			into[i]='\t';
		} else {
			into[i]=from[i];
		}
	}
	return(j);
}


#define	XGR_T1_DATA	13
static char *t1_data[XGR_T1_DATA][3] = {
/* Specifier, type, value */
	{	"a.b.c",	"String",	"one"	},
	{	"a.z",	"String",	"two"	},
	{	"a*z",	"String",	"three"	},
	{	"b.d.z",	"String",	"four"	},
	{	"b.d.Z",	"String",	"five"	},
	{	"c*z",	"String",	"six"	},
	{	"c.a.z",	"String",	"seven"	},
	{	"c.A.z",	"String",	"eight"	},
	{	".d.z",	"String",	"nine"	},
	{	"*d.z",	"String",	"ten"	},
	{	"e.d.z",	"String",	"eleven"	},
	{	"*f*z",	"String",	"twelve"	},
	{	"*g*z",	"String",	"thriteen"	} };

#define	XGR_T1_TEST	8
static char *t1_test[XGR_T1_TEST][5] = {
/* Full Name, Full Class, Expected Type, Expected Value, Failure message */
	{	"a.b.c",	"I.J.K",	"String",	"one", "Simple match failed" },
	{	"a.z",	"I.K",	"String",	"two", "period not more specific than asterisk" },
	{	"b.d.z",	"B.D.Z",	"String",	"four", "name was not more specific than class" },
	{	"c.a.z",	"I.J.K", "String",	"seven",	"specifying a name was not more specific than ommiting one" },
	{	"c.z.z",	"C.A.Z",	"String",	"eight",	"specifying a class was not more specific than ommiting one" },
	{	"e.d.z",	"I.J.K",	"String",	"eleven",	"left components were not more specific than right components" },
	{	"f.g.z",	"I.J.K",	"String",	"twelve",	"left components were not more specific than right components" },
	{	"d.z",	"I.J",	"String",	"nine",	"absent prefix not identical to a period"} };

#define XGR_T2_TEST 3
static char *t2_test[XGR_T2_TEST][3] = {
	{ "a.b", "A.B", "Name and class didn't match an entry" },
	{ "A.B", "a,b", "Name and class didn't match an entry" },
	{ "q",	"Q",	"Non-existant database entry matched." } };


char *str_type;
XrmValue value;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	database = (XrmDatabase)NULL;
	str_name = 0;
	str_class = 0;
	str_type_return = &str_type;
	value_return = &value;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file rescommon.mc */
/* End of included file rescommon.mc */

/* Including from file getres.mc */
/* End of included file getres.mc */

static void t001(){

int a;
XrmValue b;
Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmGetResource-1.(A)");
	report_assertion("When str_name is a fully qualified resource name and");
	report_assertion("str_class is a fully qualified resource class and the");
	report_assertion("database contains one or more corresponding resources, then");
	report_assertion("a call to XrmGetResource places the representation type as a");
	report_assertion("string in str_type_return and the value in value_return of");
	report_assertion("the closest matching resource as defined by the matching");
	report_assertion("rules, and returns True.");

	report_strategy("Create a database containing test information.");
	report_strategy("Interrogate database using XrmGetResource.");
	report_strategy("Verify that the returned type and value were as expected.");

	tpstartup();
	setargs();
/* Create a database containing test information. */
	database = xrm_create_database("");
	if (database == (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

	for(a=0; a<XGR_T1_DATA; a++) {
		xrm_fill_value(&b, t1_data[a][2]);
		XrmPutResource(&database, t1_data[a][0], t1_data[a][1], &b );
		CHECK;
	}

#ifdef TESTING
	XrmPutFileDatabase(database, "xgr_one");
#endif

/* Interrogate database using xname. */
/* Verify that the returned type and value were as expected. */
	for(a=0; a<XGR_T1_TEST; a++) {
		str_name = t1_test[a][0];
		str_class = t1_test[a][1];
		trace("Testing: %s (class %s)", str_name, str_class);
		str_type = NULL;
		value.addr = NULL;
		startcall(Dsp);
		if (isdeleted())
			return;
		ret = XrmGetResource(database, str_name, str_class, str_type_return, value_return);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (ret==False) {
			FAIL;
			report("%s failed to match a database entry.",
				TestName);
			report("name :%s", t1_test[a][0]);
			report("class:%s", t1_test[a][1]);
			report("Possible diagnosis: %s", t1_test[a][4]);
		} else {
			CHECK;

			if (str_type == NULL || strcmp(t1_test[a][2], str_type)) {
				FAIL;
				report("%s failed to return expected type.",
					TestName);
				report("Expected type: '%s'", t1_test[a][2]);
				report("Returned type: '%s'",
					(str_type==NULL?"<NULL POINTER>":str_type));
			} else
				CHECK;


			if (value.addr == NULL
				|| strncmp(t1_test[a][3], (char *)value.addr, strlen(t1_test[a][3]))){
				char tb[100];
				unsigned int l;
				if (value.addr == NULL) {
					strcpy(tb, "<NULL POINTER>");
					l = strlen(tb);
				} else {
					strncpy(tb, (char*)value.addr, value.size);
					tb[value.size]='\0';
					l = value.size;
				}
				FAIL;
				report("%s failed to return expected value.",
					TestName);
				report("Expected value: '%s'", t1_test[a][3]);
				report("Returned value: '%.*s'", l, tb);
				report("Possible diagnosis: %s", t1_test[a][4]);
			} else
				CHECK;
		}
	}

	CHECKPASS(1 + XGR_T1_DATA + 3*XGR_T1_TEST);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int a;
XrmValue b;
Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmGetResource-2.(A)");
	report_assertion("When str_name is a fully qualified resource name and");
	report_assertion("str_class is a fully qualified resource class and the");
	report_assertion("database does not contain a corresponding resource as");
	report_assertion("defined by the matching rules, then a call to XrmGetResource");
	report_assertion("returns False.");

	report_strategy("Create a database containing test information.");
	report_strategy("Interrogate database using XrmGetResource.");
	report_strategy("Verify that the test examples were not found.");

	tpstartup();
	setargs();
/* Create a database containing test information. */
	database = xrm_create_database("");
	if (database == (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

	for(a=0; a<XGR_T1_DATA; a++) {
		xrm_fill_value(&b, t1_data[a][2]);
		XrmPutResource(&database, t1_data[a][0], t1_data[a][1], &b );
		CHECK;
	}

#ifdef TESTING
	XrmPutFileDatabase(database, "xgr_two");
#endif

/* Interrogate database using xname. */
/* Verify that the test examples were not found. */
	for(a=0; a<XGR_T2_TEST; a++) {
		str_name = t2_test[a][0];
		str_class = t2_test[a][1];
		trace("Testing: %s (class %s)", str_name, str_class);
		str_type = NULL;
		value.addr = NULL;
		startcall(Dsp);
		if (isdeleted())
			return;
		ret = XrmGetResource(database, str_name, str_class, str_type_return, value_return);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (ret==False) {
			CHECK;
		} else {
			char tb[100];
			unsigned int l;

			FAIL;
			report("%s returned a database match when a failure was expected.",
				TestName);
			report("Returned type: '%s'",
					(str_type==NULL?"<NULL POINTER>":str_type));
			if (value.addr == NULL) {
				strcpy(tb, "<NULL POINTER>");
				l = strlen(tb);
			} else {
				strncpy(tb, (char*)value.addr, value.size);
				tb[value.size]='\0';
				l = value.size;
			}
			report("Returned value: '%.*s'", l, tb);
			report("Possible diagnosis: %s", t2_test[a][3]);
		}
	}

	CHECKPASS(1 + XGR_T1_DATA + XGR_T2_TEST);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
