/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetRGBColormaps(display, w, std_colormap_return, count_return, property)
 *   Display			*display;
 *   Window			w;
 *   XStandardColormap	**std_colormap_return;
 *   int			*count_return;
 *   Atom			property;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetRGBColormaps	1
char    *TestName = "XGetRGBColormaps";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w
#define A_ATOM property


/*
 * Arguments to the XGetRGBColormaps function
 */
static Display			*display;
static Window			w;
static XStandardColormap	**std_colormap_return;
static int			*count_return;
static Atom			property;


static int 	StatusReturn;


#include		"X11/Xatom.h"
static XStandardColormap	*scolormap;
static int			cntret;
static XStandardColormap	scmp1 = { (Colormap)  1,  2L,  3L,  4L,  5L,  6L,  7L,  8L, (VisualID) -1, (XID) -2 };
static XStandardColormap	scmp2 = { (Colormap) 11, 12L, 13L, 14L, 15L, 16L, 17L, 18L, (VisualID) 19, (XID) 20 };
static XStandardColormap	scmp3 = { (Colormap) 21, 22L, 23L, 24L, 25L, 26L, 27L, 28L, (VisualID) 21, (XID) 22 };


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	std_colormap_return = &scolormap;
	count_return = &cntret;
	property = XA_ATOM;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status			status;
int			ncmp = 3;
XStandardColormap	scmp[3];
XStandardColormap	*rscmp = (XStandardColormap *) NULL;
XStandardColormap	*cmpp;
int			rncmp = 0;
int			i;
XVisualInfo		*vp;
Atom			prop = XA_RGB_DEFAULT_MAP;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetRGBColormaps-1.(A)");
	report_assertion("When the property named by the property argument is set on");
	report_assertion("the window named by the w argument, is of type");
	report_assertion("RGB_COLOR_MAP, is of format 32, and is of length n1*8+ n2*9+");
	report_assertion("n3*10 elements (where n1,n2,n3 (>= 0 and n1+n2+n3 (>= 1),");
	report_assertion("then a call to XGetRGBColormaps returns in the");
	report_assertion("std_colormap_return argument the RBG colormap definitions,");
	report_assertion("which can be freed with XFree, and in count_return the");
	report_assertion("number of structures and returns non-zero.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Set the RGB_DEFAULT_MAP property using XSetRGBColormaps.");
	report_strategy("Obtain the value of the RGB_DEFAULT_MAP property using XGetRGBColormaps.");
	report_strategy("Verify that the call did not return False.");
	report_strategy("Verify that the value was correct.");
	report_strategy("Free the allocated memory using XFree.");

	tpstartup();
	setargs();
	scmp[0] = scmp1;
	scmp[1] = scmp2;
	scmp[2] = scmp3;

	resetvinf(VI_WIN);	
	nextvinf(&vp);

	w = makewin(display, vp);
	XSetRGBColormaps(display, w, scmp, ncmp, prop);

	std_colormap_return = &rscmp;
	count_return = &rncmp;
	property = prop;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == False) {
		delete("%s returned False.", TestName);
		return;
	} else
		CHECK;

	if(rscmp == (XStandardColormap *) NULL) {	
		report("The returned list of XStandardColormap structures was NULL.");
		FAIL;
	} else {

		CHECK;
		if( rncmp != ncmp) {
			report("%d XStandardColormap structures were returned instead of %d.", rncmp, ncmp);
			FAIL;
		} else {

			CHECK;
			
			for(i = 0, cmpp = rscmp; i < ncmp; i++, cmpp++) {

				if(cmpp->colormap != scmp[i].colormap) {
					report("The colormap component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->red_max != scmp[i].red_max)  {
					report("The red_max component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->red_mult != scmp[i].red_mult) {
					report("The red_mult component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->green_max !=scmp[i].green_max) {
					report("The green_max component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->green_mult != scmp[i].green_mult) {
					report("The green_mult component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->blue_max != scmp[i].blue_max) {
					report("The blue_max component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->blue_mult != scmp[i].blue_mult) {
					report("The blue_mult component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->base_pixel != scmp[i].base_pixel) {
					report("The base_pixel component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->visualid != scmp[i].visualid) {
					report("The visualid component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
				if(cmpp->killid != scmp[i].killid ) {
					report("The killid component of the XStandardColormap structure %d was incorrect.", i);
					FAIL;
				} else
					CHECK;
			
			}
		}
		XFree((char*)rscmp);
	}

	CHECKPASS(ncmp * 10 + 3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status			status;
char			*when;
XStandardColormap	*rscmp = (XStandardColormap *) NULL;
int			rncmp = 0;
XVisualInfo		*vp;
Atom			prop = XA_RGB_BEST_MAP;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetRGBColormaps-2.(A)");
	report_assertion("When the property named by the property argument is not set");
	report_assertion("on the window named by the w argument, or is not of type");
	report_assertion("RGB_COLOR_MAP, or is not of format 32, or is not of length");
	report_assertion("n1*8+ n2*9+ n3*10 elements (where n1,n2,n3 (>= 0 and");
	report_assertion("n1+n2+n3 (>= 1), then a call to XGetRGBColormaps does not");
	report_assertion("set the std_colormap_return or count_return arguments and");
	report_assertion("returns zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Obtain the value of the unset RGB_COLOR_MAP property using XGetRGBColormaps.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that the std_colormap_return argument was not changed.");
	report_strategy("Verify that the count_return argument was not changed.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the RGB_COLOR_MAP property to have format 8.");
	report_strategy("Obtain the value of the RGB_COLOR_MAP property using XGetRGBColormaps.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that the std_colormap_return argument was not changed.");
	report_strategy("Verify that the count_return argument was not changed.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the RGB_COLOR_MAP property to have type ATOM.");
	report_strategy("Obtain the value of the RGB_COLOR_MAP property using XGetRGBColormaps.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that the std_colormap_return argument was not changed.");
	report_strategy("Verify that the count_return argument was not changed.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the RGB_COLOR_MAP property to have size 7 elements.");
	report_strategy("Obtain the value of the RGB_COLOR_MAP property using XGetRGBColormaps.");
	report_strategy("Verify that the call returned False.");
	report_strategy("Verify that the std_colormap_return argument was not changed.");
	report_strategy("Verify that the count_return argument was not changed.");
	report_strategy("");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	std_colormap_return = &rscmp;
	count_return = &rncmp;
	property = prop;

	w = makewin(display, vp);
/* Property unset */

	rscmp = (XStandardColormap *) -1;
	rncmp = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	when = "when the RGB_BEST_MAP property was not set.";

	if( status != False ) {
		report("%s() did not return False %s", TestName, when);
		FAIL;
	} else
		CHECK;

	if(rscmp != (XStandardColormap *) -1) {
		report("The std_colormap_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	if(rncmp != -1) {
		report("The count_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	when = "when the RGB_BEST_MAP property format was 8.";

	w = makewin(display, vp);
/* format 8 */
 	XChangeProperty(display, w, prop,  XA_RGB_COLOR_MAP, 8, PropModeReplace, (unsigned char *) &scmp1, 10);

	rscmp = (XStandardColormap *) -1;
	rncmp = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( status != False ) {
		report("%s() did not return False %s", TestName, when);
		FAIL; 
	} else
		CHECK;

	if(rscmp != (XStandardColormap *) -1) {
		report("The std_colormap_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	if(rncmp != -1) {
		report("The count_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	when = "when the RGB_BEST_MAP property type was ATOM.";

	w = makewin(display, vp);
/* type ATOM */
 	XChangeProperty(display, w, prop,  XA_ATOM, 32, PropModeReplace, (unsigned char *) &scmp1, 10);

	rscmp = (XStandardColormap *) -1;
	rncmp = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( status != False ) {
		report("%s() did not return False %s.", TestName, when);
		FAIL;
	} else
		CHECK;

	if(rscmp != (XStandardColormap *) -1) {
		report("The std_colormap_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	if(rncmp != -1) {
		report("The count_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	when = "when the RGB_BEST_MAP property number of elements was 7.";

	w = makewin(display, vp);
/* Bad number of elements */
 	XChangeProperty(display, w, prop,  XA_RGB_COLOR_MAP, 32, PropModeReplace, (unsigned char *) &scmp1, 7);

	rscmp = (XStandardColormap *) -1;
	rncmp = -1;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( status != False ) {
		report("%s() did not return False %s.", TestName, when);
		FAIL;
	} else
		CHECK;

	if(rscmp != (XStandardColormap *) -1) {
		report("std_colormap_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	if(rncmp != -1) {
		report("The count_return argument was updated %s", when);
		FAIL;
	} else
		CHECK;

	CHECKPASS(12);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Status			status;
XStandardColormap	*rscmp = (XStandardColormap *) NULL;
int			rncmp = 0;
XVisualInfo		*vp;
Visual			*vi;
VisualID		vid;
Atom			prop = XA_RGB_GRAY_MAP;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetRGBColormaps-3.(A)");
	report_assertion("When the visualid is not specified in the property");
	report_assertion("colormaps, then the visualid of the returned structures is");
	report_assertion("set to the default visual for the screen of the window w.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Set the RGB_GRAY_MAP property to have 8 elements using XChangeProperty.");
	report_strategy("Obtain the default visual ID using DefaultVisual.");
	report_strategy("Obtain the value of the RGB_GRAY_MAP property using XGetRGBColormaps.");
	report_strategy("Verify that the value of the visual component of the returned XStandardColormap ");
	report_strategy("  structure was the same as the default visual.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	std_colormap_return = &rscmp;
	count_return = &rncmp;
	property = prop;

	w = makewin(display, vp);
 	XChangeProperty(display, w, prop,  XA_RGB_COLOR_MAP, 32, PropModeReplace, (unsigned char *) &scmp1, 8);

	startcall(display);
	if (isdeleted())
		return;
	status = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	vi = XDefaultVisual(display, XDefaultScreen(display));
	vid = XVisualIDFromVisual(vi);

	if(status == False) {
		delete("%s() returned False.", TestName);
		return;
	} else
		CHECK;

	if(vid != rscmp->visualid) {
		report("%s() did not report the default visual in the returned visualid component.", TestName);
		FAIL;
	} else
		CHECK;

	XFree((char*)rscmp);

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Status			status;
XStandardColormap	*rscmp = (XStandardColormap *) NULL;
int			rncmp = 0;
XVisualInfo		*vp;
Atom			prop = XA_RGB_GRAY_MAP;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetRGBColormaps-4.(A)");
	report_assertion("When the killid is not specified in the property colormaps,");
	report_assertion("then the killid of the returned structures is set to None.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Set the RGB_GRAY_MAP property to have 9 elements using XChangeProperty.");
	report_strategy("Obtain the value of the RGB_GRAY_MAP property using XGetRGBColormaps.");
	report_strategy("Verify that the value of the killid component of the returned XStandardColormap ");
	report_strategy("  structure was set to None.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	std_colormap_return = &rscmp;
	count_return = &rncmp;
	property = prop;

	w = makewin(display, vp);
 	XChangeProperty(display, w, prop,  XA_RGB_COLOR_MAP, 32, PropModeReplace, (unsigned char *) &scmp1, 9);

	startcall(display);
	if (isdeleted())
		return;
	status = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == False) {
		delete("%s() returned False.", TestName);
		return;
	} else
		CHECK;

	if(rscmp->killid != None) {
		report("%s() did not set the returned killid component to None.", TestName);
		FAIL;
	} else
		CHECK;

	XFree((char*)rscmp);

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAto.mc */
/* End of included file error/EAto.mc */

/* Including from file error/EAto.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGetRGBColormaps-5.(A)");
	report_assertion("When an atom argument does not name a valid Atom, then a");
	report_assertion("BadAtom error occurs.");

	report_strategy("Call test function using a value with the top bits set as the atom argument.");
	report_strategy("Verify that a BadAtom error occurs.");

	tpstartup();
	setargs();
	A_ATOM = ~0L;
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadAtom) {
		report("Got %s, Expecting BadAtom", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadAtom)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAto.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGetRGBColormaps-6.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetRGBColormaps(display, w, std_colormap_return, count_return, property);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
