/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XQueryKeymap(display, keys_return)
 *   Display	*display;
 *   char	*keys_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XQueryKeymap	1
char    *TestName = "XQueryKeymap";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XQueryKeymap function
 */
static Display	*display;
static char	*keys_return;



static	char	Keys[32];


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	keys_return = Keys;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int i;
char *p,*q;
int fcount;
char pressed[32];
int minkc, maxkc;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XQueryKeymap-1.(B)");
	report_assertion("A call to XQueryKeymap returns a bit vector with bits set");
	report_assertion("to 1 where the corresponding key is currently in the logical");
	report_assertion("down state and all other bits set to 0.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Check no keys pressed down at start.");
	report_strategy("  Press some keys down.");
	report_strategy("  Call XQueryKeymap and check they, and only they, are down.");
	report_strategy("  Release them all.");
	report_strategy("  Call XQueryKeymap to check all released.");
	report_strategy("else");
	report_strategy("  Call XQueryKeymap.");
	report_strategy("  UNTESTED touch test only.");

	tpstartup();
	setargs();
	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XQueryKeymap(display, keys_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		report("There is no reliable test method, but a touch test was performed");

		UNTESTED;
		return;
	} else
		CHECK;

	/* expect all zero map. If not can't start. Should we fail? */
	startcall(display);
	if (isdeleted())
		return;
	XQueryKeymap(display, keys_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for(fcount=i=0,p=keys_return; i<32; i++,p++)
		if (*p)
			fcount++;

	if (fcount) {
		delete("%d keys appear to be pressed down.", fcount);
		return;
	} else
		CHECK;

	XDisplayKeycodes(display, &minkc, &maxkc);

	for(p=pressed,i=0; i<32; i++,p++)
		*p = (char) 0;

	for(i=minkc; i < minkc+5 && i <= maxkc; i++) {
		keypress(display, i);
		pressed[i/8] |= (char) (0x1 << (i % 8));
	}

	/* check map now has only those set */
	startcall(display);
	if (isdeleted())
		return;
	XQueryKeymap(display, keys_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for(p=pressed,q=keys_return,fcount=i=0; i<32; i++,p++,q++)
		if (*p != *q) {
			char diffs = (unsigned)*p ^ (unsigned)*q;
			int di;

			fcount++;
			for(di=0; di<8; di++) {
				char mask = (char) (0x1 << di);

				if (diffs & mask)
					report("Key %d%s pressed.", 8*i + di,
						(*p & mask) ? "" : " not");
			}
		}

	if (fcount)
		FAIL;
	else
		CHECK;

	relalldev(); /* now all released */

	/* check map now all zero. */
	startcall(display);
	if (isdeleted())
		return;
	XQueryKeymap(display, keys_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for(fcount=i=0,p=keys_return; i<32; i++,p++)
		if (*p)
			fcount++;

	if (fcount) {
		report("%d keys appear to be pressed down.", fcount);
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
