/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSync(display, discard)
 *   Display *display;
 *   Bool discard;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSync	1
char    *TestName = "XSync";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSync function
 */
static Display *display;
static Bool discard;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	discard = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file Mdefcode.tmc.3364 */
static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSync-1.(B)");
	report_assertion("A call to XSync flushes the output buffer and waits until");
	report_assertion("all requests have been received and processed by the X");
	report_assertion("server.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.3364 */

static void t002(){

Pixmap	pm;
Display *client1;
Display *client2;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSync-2.(A)");
	report_assertion("A call to XSync calls the client's error handling routine");
	report_assertion("for each error event received.");

	report_strategy("Create client1.");
	report_strategy("Create pixmap with client1.");
	report_strategy("Create client2.");
	report_strategy("Call XFreePixmap from client2.");
	report_strategy("Call XSync from client2 to insure all potential errors arrive.");
	report_strategy("Verify that an error was received.");

	tpstartup();
	setargs();
	resetvinf(VI_PIX);
	nextvinf(&vp);
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create pixmap with client1. */
	/* avoid using makepixm() */
	pm = XCreatePixmap(client1, DRW(client1), 10, 10, 1);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Call XFreePixmap from client2. */
	_startcall(client2);
	XFreePixmap(client2, pm);
/* Call XSync from client2 to insure all potential errors arrive. */
	XSync(client2, True);
	_endcall(client2);
/* Verify that an error was received. */
	if (geterr() != BadPixmap || getbadvalue() != pm) {
		report("Missing error event");
		FAIL;
	}
	else
		CHECK;
	XFreePixmap(client1, pm);

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display *client1;
Display *client2;
Window	w;
XEvent	event;
XWindowAttributes attrs;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSync-3.(A)");
	report_assertion("During a call to XSync, any events generated by the X");
	report_assertion("server are enqueued into the client's event queue.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select MapNotify events with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select MapNotify events with client2 on this window.");
	report_strategy("Call XFlush with client1 to insure server has received create");
	report_strategy("window request before client2 requests which reference the window.");
	report_strategy("Call XFlush with client2 to insure server has received select");
	report_strategy("request before the event is generated.");
	report_strategy("Map window.");
	report_strategy("Call XSync for client1.");
	report_strategy("Verify that there are no errors.");
	report_strategy("Verify that client1 was delivered expected event.");
	report_strategy("Call XSync for client2.");
	report_strategy("Verify that there are no errors.");
	report_strategy("Verify that client2 was delivered expected event.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select MapNotify events with client1 on this window. */
	XSelectInput(client1, w, StructureNotifyMask);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Call XGetWindowAttributes with client1 to insure server has received create */
/* window request before client2 requests which reference the window. */
	XFlush(client1);
	XGetWindowAttributes(client1, w, &attrs);
/* Select MapNotify events events with client2 on this window. */
	XSelectInput(client2, w, StructureNotifyMask);
/* Call XFlush & do req. with client2 to insure server has received select */
/* request before the event is generated. */
	XFlush(client2);
	XGetWindowAttributes(client2, w, &attrs);
/* Map window. */
	XMapWindow(client1, w);
/* Call XSync for client1. */
	_startcall(client1);
	XSync(client1, False);
	_endcall(client1);
/* Verify that there are no errors. */
	if (geterr() != Success) {
		delete("Got %s, Expecting Success", errorname(geterr()));
		return;
	}
	else
		CHECK;
/* Verify that client1 was delivered expected event. */
	if (!XCheckTypedWindowEvent(client1, w, MapNotify, &event)) {
		report("Selected event was not delivered to client1.");
		FAIL;
	}
	else
		CHECK;
/* Call XSync for client2. */
	_startcall(client2);
	XSync(client2, False);
	_endcall(client2);
/* Verify that there are no errors. */
	if (geterr() != Success) {
		delete("Got %s, Expecting Success", errorname(geterr()));
		return;
	}
	else
		CHECK;
/* Verify that client2 was delivered expected event. */
	if (!XCheckTypedWindowEvent(client2, w, MapNotify, &event)) {
		report("Selected event was not delivered to client2.");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion XSync-4.(-)");
	report_assertion("A call to XSync with discard set to False does not discard");
	report_assertion("the events in the queue.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t005(){

Display *client1;
Display *client2;
Window	w;
XEvent	event;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSync-5.(A)");
	report_assertion("A call to XSync with discard set to True discards all");
	report_assertion("events in the queue.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select MapNotify events with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select MapNotify events with client2 on this window.");
	report_strategy("Map window.");
	report_strategy("Call XSync for client1.");
	report_strategy("Verify that client1 was not delivered MapNotify event.");
	report_strategy("Call XSync for client2.");
	report_strategy("Verify that client2 was not delivered MapNotify event.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select MapNotify events with client1 on this window. */
	XSelectInput(client1, w, StructureNotifyMask);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select MapNotify events with client2 on this window. */
	XSelectInput(client2, w, StructureNotifyMask);
/* Map window. */
	XMapWindow(client1, w);
/* Call XSync for client1. */
	_startcall(client1);
	XSync(client1, True);
	_endcall(client1);
/* Verify that client1 was not delivered MapNotify event. */
	if (XCheckTypedWindowEvent(client1, w, MapNotify, &event)) {
		report("Selected event was delivered.");
		FAIL;
	}
	else
		CHECK;
/* Call XSync for client2. */
	_startcall(client2);
	XSync(client2, True);
	_endcall(client2);
/* Verify that client2 was not delivered MapNotify event. */
	if (XCheckTypedWindowEvent(client2, w, MapNotify, &event)) {
		report("Selected event was delivered.");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
