/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_GraphicsExpose	1
char    *TestName = "GraphicsExpose";



#define	EVENT		GraphicsExpose

int 	tet_thistest;

static void t001(){

Display	*display = Dsp;
int	i;
int	expected;
int	lastcount;
Window  w1, w2;
XVisualInfo *vp;
GC	gc;
int	numevents;
unsigned int	width;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion GraphicsExpose-1.(A)");
	report_assertion("When GraphicsExpose events are generated, then they are");
	report_assertion("contiguously delivered by the server.");

	report_strategy("Create a pair of windows.");
	report_strategy("Create a gc with graphics-exposures flag set to True.");
	report_strategy("Generate GraphicsExpose events.");
	report_strategy("Verify that events were generated.");
	report_strategy("Verify that events were delivered contiguously.");

	tpstartup();
/* Create a pair of windows. */
	resetvinf(VI_WIN);
	nextvinf(&vp);
		
	winpair(display, vp, &w1, &w2);
	getsize(display, w1, &width, NULL);
/* Create a gc with graphics-exposures flag set to True. */
	gc = makegc(display, w2);
	XSetGraphicsExposures(display, gc, True);
	XSelectInput(display, w1, NoEventMask);	/* is this necessary?...pc */
	XSelectInput(display, w2, NoEventMask);
/* Generate GraphicsExpose events. */
	XSync(display, True);
	XCopyPlane(display, w1, w2, gc, 50, 0, width, 40, 0, 5, 1);
	XSync(display, False);

/* Verify that events were generated. */
	numevents = XPending(display);
	if (numevents == 0) {
		delete("No events delivered");
		return;
	}
	else
		CHECK;
/* Verify that events were delivered contiguously. */
	expected = -1;
	for (i=0; i<numevents; i++) {
		XEvent	event_return;

		if (i == 0)
			CHECK;
		XNextEvent(display, &event_return);
		if (event_return.type != EVENT) {
			report("Received %s event while only expecting %s types",
				eventname(event_return.type), eventname(EVENT));
			delete("Unexpected event received.");
			return;
		}
		lastcount = event_return.xexpose.count;
		if (expected == -1) {
			expected = lastcount;
		}
		else {
			if (lastcount > expected) {
				report("Count (%d) greater than expected (%d)",
					lastcount, expected);
				FAIL;
				break;
			}
			else if (lastcount < expected)
				expected--;
		}
	}
	if (lastcount != 0) {
		report("Last %s had count set to %d, not zero",
			eventname(EVENT), lastcount);
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
