/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_EnterNotify	1
char    *TestName = "EnterNotify";



#define	EVENT		EnterNotify
#define	OTHEREVENT	LeaveNotify
#define	MASK		EnterWindowMask
#define	OTHERMASK	LeaveWindowMask
#define	BOTHMASKS	(MASK|OTHERMASK)
#define EVENTMASK	MASK
#define	OTHEREVENTMASK	LeaveWindowMask

static	int	_detail_;
static	XEvent	good;

static	int
plant(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	good.xany.window = current->window;
	return(winh_plant(current, &good, NoEventMask, WINH_NOMASK));
}

static	Bool	increasing;	/* event sequence increases as we climb */

static	int
checksequence(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
	Winhe	*d;
	int	current_sequence;
	int	status;
	static	int	last_sequence;

#ifdef	lint
	winh_free(start);
	winh_free(stop);
#endif
	/* look for desired event type */
	for (d = current->delivered; d != (Winhe *) NULL; d = d->next) {
		if (d->event->type == good.type) {
			current_sequence = d->sequence;
			break;
		}
	}
	if (d == (Winhe *) NULL) {
		report("%s event not delivered", eventname(good.type));
		delete("Missing event");
		return(-1);
	}
	if (previous == (Winh *) NULL)
		status = 0;	/* first call, no previous sequence value */
	else {
		/* assume sequence numbers are not the same */
		status = (current_sequence < last_sequence);
		if (increasing)
			status = (status ? 0 : 1);
		if (status)
			report("Ordering problem between 0x%x (%d) and 0x%x (%d)",
				current->window, current_sequence,
				previous->window, last_sequence);
	}
	last_sequence = current_sequence;
	return(status);
}

static	int
checkdetail(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
	Winhe	*d;

#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	/* look for desired event type */
	for (d = current->delivered; d != (Winhe *) NULL; d = d->next)
		if (d->event->type == good.type)
			break;
	if (d == (Winhe *) NULL) {
		report("%s event not delivered to window 0x%x",
			eventname(good.type), current->window);
		delete("Missing event");
		return(-1);
	}
	/* check detail */
	if (_detail_ != d->event->xcrossing.detail) {
		report("Expected detail of %d, got %d on window 0x%x",
			_detail_, d->event->xcrossing.detail, current->window);
		return(1);
	}
	return(0);
}

int 	tet_thistest;

static void t001(){

int	i;
Display	*display = Dsp;
Display	*client2;
Window	w1, w2;
XEvent	event;
struct area	area;
PointerPlace	*warp;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion EnterNotify-1.(A)");
	report_assertion("When an EnterNotify event is generated by a hierarchy");
	report_assertion("change, then the EnterNotify event is delivered after any");
	report_assertion("hierarchy event.");

	report_strategy("Create client2.");
	report_strategy("Create window1.");
	report_strategy("Create window2 on top of window1.");
	report_strategy("Select for EnterNotify events on window1.");
	report_strategy("Select for EnterNotify events on window1 with client2.");
	report_strategy("Select for UnmapNotify events on window2.");
	report_strategy("Move pointer to window2.");
	report_strategy("Call XUnmapWindow on window2.");
	report_strategy("Verify that UnmapNotify event was received on window2.");
	report_strategy("Verify that EnterNotify event was received on window1.");
	report_strategy("Verify that EnterNotify event was received on window1 by client2.");
	report_strategy("Verify that pointer has remained where it was moved.");

	tpstartup();
/* Create client2. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
/* Create window1. */
	area.x = 0;
	area.y = 0;
	area.width = W_STDWIDTH;
	area.height = W_STDHEIGHT;
	w1 = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Create window2 on top of window1. */
	w2 = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Select for xname events on window1. */
	XSelectInput(display, w1, MASK);
/* Select for xname events on window1 with client2. */
	XSelectInput(client2, w1, MASK);
/* Select for UnmapNotify events on window2. */
	XSelectInput(display, w2, StructureNotifyMask);
/* Move pointer to window2. */
	warp = warppointer(display, w2, 0, 0);
	if (warp == (PointerPlace *) NULL)
		return;
	else
		CHECK;
	XSync(display, True);
	XSync(client2, True);
/* Call XUnmapWindow on window2. */
	XUnmapWindow(display, w2);
	XSync(display, False);
	XSync(client2, False);
/* Verify that UnmapNotify event was received on window2. */
	if (XPending(display) < 1) {
		report("Expected UnmapNotify event not delivered.");
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(display, &event);
	if (event.type != UnmapNotify) {
		report("Expected %s, got %s", eventname(UnmapNotify), eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Verify that xname event was received on window1. */
	if (XPending(display) < 1) {
		report("Expected %s event not delivered.", TestName);
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(display, &event);
	if (event.type != EVENT) {
		report("Expected %s, got %s", eventname(EVENT), eventname(event.type));
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(display)) > 0) {
		report("Expected 2 events, got %d", i+2);
		FAIL;
	}
	else
		CHECK;
/* Verify that xname event was received on window1 by client2. */
	if (XPending(client2) < 1) {
		report("Expected %s event not delivered to client2.", TestName);
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(client2, &event);
	if (event.type != EVENT) {
		report("Expected %s, got %s with client2", eventname(EVENT), eventname(event.type));
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(client2)) > 0) {
		report("For client2: Expected 1 event, got %d", i+1);
		FAIL;
	}
	else
		CHECK;

	/* Additional possible testing: */
	/* Select for no events on window1. */
	/* Select for MapNotify events on window2. */
	/* Select for xname events on window2. */
	/* Select for xname events on window2 with client2. */
	/* Call XMapWindow on window2. */
	/* Verify that MapNotify event was received on window2. */
	/* Verify that xname event was received on window2. */
	/* Verify that xname event was received on window2 by client2. */
	/* Verify that pointer has remained where it was moved. */
	/* Select for xname events on window1. */
	/* Select for xname events on window1 with client2. */
	/* Select for ConfigureNotify events on window2. */
	/* Call XLowerWindow on window2. */
	/* Verify that ConfigureNotify event was received on window2. */
	/* Verify that xname event was received on window1. */
	/* Verify that xname event was received on window1 by client2. */
	/* Verify that pointer has remained where it was moved. */

	/* Others: GravityNotify, CirculateNotify. */

/* Verify that pointer has remained where it was moved. */
	if (pointermoved(display, warp)) {
		delete("Pointer moved unexpectedly");
		return;
	}
	else
		CHECK;
	CHECKPASS(11);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion EnterNotify-2.(-)");
	report_assertion("When an EnterNotify event is generated, then all clients");
	report_assertion("having set EnterWindowMask event mask bits on the event");
	report_assertion("window are delivered an EnterNotify event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

int	i;
Display	*display = Dsp;
Display	*client2;
Window	w;
XEvent	event;
XEvent	good;
struct	area	area;
PointerPlace	*warp1, *warp2;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion EnterNotify-3.(A)");
	report_assertion("When an EnterNotify event is generated, then clients not");
	report_assertion("having set EnterWindowMask event mask bits on the event");
	report_assertion("window are not delivered an EnterNotify event.");

	report_strategy("Create client2.");
	report_strategy("Create window.");
	report_strategy("Move pointer outside of window.");
	report_strategy("Select for EnterNotify events on window.");
	report_strategy("Select for no events on window with client2.");
	report_strategy("Warp pointer to window.");
	report_strategy("Verify that a single EnterNotify event was received.");
	report_strategy("Verify that no events were received by client2.");

	tpstartup();
/* Create client2. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
/* Create window. */
	area.x = 10;
	area.y = 10;
	area.width = W_STDWIDTH;
	area.height = W_STDHEIGHT;
	w = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Move pointer outside of window. */
	warp1 = warppointer(display, DRW(display), 0, 0);
	if (warp1 == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select for xname events on window. */
	XSelectInput(display, w, MASK);
/* Select for no events on window with client2. */
	XSelectInput(client2, w, NoEventMask);
/* Warp pointer to window. */
	XSync(display, True);
	XSync(client2, True);
	warp2 = warppointer(display, w, 2, 3);
	if (warp2 == (PointerPlace *) NULL)
		return;
	else
		CHECK;
	XSync(display, False);
	XSync(client2, False);
/* Verify that a single xname event was received. */
	if (XPending(display) < 1) {
		report("Expected %s event not delivered.", TestName);
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(display, &event);
	good.xcrossing.type = EVENT;
	good.xcrossing.serial = event.xcrossing.serial;
	good.xcrossing.send_event = False;
	good.xcrossing.display = display;
	good.xcrossing.window = w;
	good.xcrossing.root = DRW(display);
	good.xcrossing.subwindow = None;
	good.xcrossing.time = event.xcrossing.time;
	good.xcrossing.x = 2;
	good.xcrossing.y = 3;
	ROOTCOORDSET(display, &(good.xcrossing));	/* x_root and y_root */
	good.xcrossing.mode = NotifyNormal;
	/* under virtual root windows detail gets set to NotifyNonlinear */
	good.xcrossing.detail = NotifyAncestor;
	good.xcrossing.same_screen = True;
	good.xcrossing.focus = True;	/* assumes focus follows pointer */
	good.xcrossing.state = 0;
	if (checkevent(&good, &event)) {
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(display)) > 0) {
		report("Expected 1 event, got %d", i+1);
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were received by client2. */
	if ((i = XPending(client2)) > 0) {
		report("For client2: Expected 0 events, got %d", i);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int	status;
Display	*display = Dsp;
Winh	*eventw;
Winh	*sourcew;
XEvent	good;
Winhg	winhg;
PointerPlace	*warp1, *warp2;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion EnterNotify-4.(A)");
	report_assertion("When an EnterNotify event is delivered and the child of the");
	report_assertion("event window contains the final pointer position, then");
	report_assertion("subwindow is set to that child.");

	report_strategy("Build window hierarchy.");
	report_strategy("Create the hierarchy.");
	report_strategy("Move pointer to outside of window.");
	report_strategy("Select no events on the sourcew.");
	report_strategy("Set EnterWindowMask event mask bits on the eventw.");
	report_strategy("Move pointer to child of event window.");
	report_strategy("Verify that a EnterNotify event was received.");
	report_strategy("Verify that subwindow is set to the source window.");

	tpstartup();
/* Build window hierarchy. */
	winhg.area.x = 1;
	winhg.area.y = 1;
	winhg.area.width = W_STDWIDTH;
	winhg.area.height = W_STDHEIGHT;
	winhg.border_width = 1;
	eventw = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (eventw == (Winh *) NULL) {
		report("Could not create eventw");
		return;
	}
	else
		CHECK;
	winhg.area.width /= 2;
	winhg.area.height /= 2;
	sourcew = winh_adopt(display, eventw, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (sourcew == (Winh *) NULL) {
		report("Could not create sourcew");
		return;
	}
	else
		CHECK;
/* Create the hierarchy. */
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Move pointer to outside of window. */
	warp1 = warppointer(display, DRW(display), 0, 0);
	if (warp1 == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select no events on the sourcew. */
	if (winh_selectinput(display, sourcew, NoEventMask))
		return;
	else
		CHECK;
/* Set EnterWindowMask event mask bits on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
	XSync(display, True);
	good.type = EVENT;
	good.xcrossing.display = display;
	good.xcrossing.window = eventw->window;
	good.xcrossing.subwindow = sourcew->window;
/* Move pointer to child of event window. */
	warp2 = warppointer(display, sourcew->window, 2, 2);
	if (warp2 == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Verify that a xname event was received. */
	XSync(display, False);
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK))
		return;
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that subwindow is set to the source window. */
		/* since only one event was expected, it must be first in list */
		if (eventw->delivered->event->xcrossing.subwindow != sourcew->window) {
			report("Subwindow set to 0x%x, expected 0x%x",
				eventw->delivered->event->xcrossing.subwindow, sourcew->window);
			FAIL;
		}
		else
			CHECK;
	}

	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){


 	report_purpose(5);

	report_assertion("Assertion EnterNotify-5.(-)");
	report_assertion("When an EnterNotify event is delivered and the child of the");
	report_assertion("event window does not contain the final pointer position,");
	report_assertion("then subwindow is set to None.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t006(){


 	report_purpose(6);

	report_assertion("Assertion EnterNotify-6.(-)");
	report_assertion("All EnterNotify events are delivered after any related");
	report_assertion("LeaveNotify are delivered.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t007(){

Display	*display = Dsp;
int	depth = 3;
Winh	*A, *B;
int	status;
XEvent	*event;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion EnterNotify-7.(A)");
	report_assertion("When the pointer moves from window A to window B and A is");
	report_assertion("an inferior of B, then an EnterNotify event is generated on");
	report_assertion("window B with detail set to NotifyInferior.");

	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window B.");
	report_strategy("Set window A to child of window B.");
	report_strategy("Select for EnterNotify and LeaveNotify events on windows A and B.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify EnterNotify event received on window B.");
	report_strategy("Verify that detail is set to NotifyInferior.");
	report_strategy("Verify that all EnterNotify events are delivered after all");
	report_strategy("LeaveNotify events.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window B. */
	B = guardian->firstchild;
/* Set window A to child of window B. */
	A = B->firstchild;
/* Select for xname and LeaveNotify events on windows A and B. */
	if (winh_selectinput(display, A, BOTHMASKS)) {
		report("Error selecting for events.");
		return;
	}
	else
		CHECK;
	if (winh_selectinput(display, B, BOTHMASKS)) {
		report("Error selecting for events.");
		return;
	}
	else
		CHECK;

/* Move pointer from window A to window B. */
	XWarpPointer(display, None, A->window, 0, 0, 0, 0, 0, 0);
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify xname event received on window B. */
	if (B->delivered == (Winhe *) NULL || (event = B->delivered->event)->type != EVENT) {
		report("Expected event not generated");
		FAIL;
	}
	else
	{
/* Verify that detail is set to NotifyInferior. */
		if (event->xcrossing.detail != NotifyInferior) {
			report("Got detail %d, expected %d", event->xcrossing.detail, NotifyInferior);
			FAIL;
		}
		else
			CHECK;
/* Verify that all xname events are delivered after all */
/* LeaveNotify events. */
		status = winh_ordercheck(OTHEREVENT, EVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Display	*display;
int	depth = 4;
Winh	*A, *B;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion EnterNotify-8.(A)");
	report_assertion("When the pointer moves from window A to window B and B is");
	report_assertion("an inferior of A, then an EnterNotify event is generated");
	report_assertion("once on each window between window A and window B,");
	report_assertion("exclusive, in window hierarchy order, with detail set to");
	report_assertion("NotifyVirtual and then on window B with detail set to");
	report_assertion("NotifyAncestor.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window A.");
	report_strategy("Set window B to inferior of window A.");
	report_strategy("Select for EnterNotify and LeaveNotify events on all windows.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify events delivered, between window A and window B, exclusive,");
	report_strategy("in proper order.");
	report_strategy("Verify that detail is set to NotifyVirtual.");
	report_strategy("Verify that event delivered to window B with detail set to NotifyAncestor.");
	report_strategy("Verify that all EnterNotify events are delivered after all");
	report_strategy("LeaveNotify events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window A. */
	A = guardian->firstchild;
/* Set window B to inferior of window A. */
	B = A->firstchild->firstchild->firstchild;
/* Select for xname and LeaveNotify events on all windows. */
	if (winh_selectinput(display, (Winh *) NULL, BOTHMASKS)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(B, A->firstchild, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Move pointer from window A to window B. */
	XWarpPointer(display, None, A->window, 0, 0, 0, 0, 0, 0);
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify events delivered, between window A and window B, exclusive, */
/* in proper order. */
		increasing = True;
		if (winh_climb(B, A->firstchild, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that detail is set to NotifyVirtual. */
		_detail_ = NotifyVirtual;
		if (winh_climb(B->parent, A->firstchild, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that event delivered to window B with detail set to NotifyAncestor. */
		_detail_ = NotifyAncestor;
		if (winh_climb(B, B, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered after all */
/* LeaveNotify events. */
		status = winh_ordercheck(OTHEREVENT, EVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(11);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Display	*display;
int	depth = 5;
Winh	*A, *B, *C;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion EnterNotify-9.(A)");
	report_assertion("When the pointer moves from window A to window B and there");
	report_assertion("exists a window C that is their least common ancestor, then");
	report_assertion("an EnterNotify event is generated once on each window");
	report_assertion("between window C and window B, exclusive, with detail set to");
	report_assertion("NotifyNonlinearVirtual and then on window B with detail set");
	report_assertion("to NotifyNonlinear.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set windows A, B, and C.");
	report_strategy("Select for EnterNotify and LeaveNotify events on all windows.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify events delivered, between window C and window B, exclusive,");
	report_strategy("in proper order.");
	report_strategy("Verify that detail is set to NotifyNonlinearVirtual.");
	report_strategy("Verify that event delivered to window B with detail set to NotifyNonlinear.");
	report_strategy("Verify that all EnterNotify events are delivered after all");
	report_strategy("LeaveNotify events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set windows A, B, and C. */
	C = guardian->firstchild;
	A = C->firstchild->nextsibling->firstchild->firstchild;
	B = C->firstchild->             firstchild->firstchild;
/* Select for xname and LeaveNotify events on all windows. */
	if (winh_selectinput(display, (Winh *) NULL, BOTHMASKS)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(B, C->firstchild, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Move pointer from window A to window B. */
	XWarpPointer(display, None, A->window, 0, 0, 0, 0, 0, 0);
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify events delivered, between window C and window B, exclusive, */
/* in proper order. */
		increasing = True;
		if (winh_climb(B, C->firstchild, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that detail is set to NotifyNonlinearVirtual. */
		_detail_ = NotifyNonlinearVirtual;
		if (winh_climb(B->parent, C->firstchild, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that event delivered to window B with detail set to NotifyNonlinear. */
		_detail_ = NotifyNonlinear;
		if (winh_climb(B, B, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered after all */
/* LeaveNotify events. */
		status = winh_ordercheck(OTHEREVENT, EVENT);
		if (status == -1)
			return;
		else if (status) {
			report("Incorrect event ordering.");
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(11);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display	*display;
int	depth = 5;
Winh	*A, *B, *Broot;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion EnterNotify-10.(A)");
	report_assertion("If the implementation supports multiple screens: When the");
	report_assertion("pointer moves from window A to window B and window A and");
	report_assertion("window B are on different screens and window B is not a root");
	report_assertion("window, then an EnterNotify event is generated on each");
	report_assertion("window from window B's root down to but not including window");
	report_assertion("B with detail set to NotifyNonlinearVirtual and then on");
	report_assertion("window B with detail set to NotifyNonlinear.");

	report_strategy("Check to see if multiple screens are supported.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Select for EnterNotify and LeaveNotify events between windows B and");
	report_strategy("B's root window.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify events delivered on each window from window B's root");
	report_strategy("down to but not including window B in proper order.");
	report_strategy("Verify that detail is set to NotifyNonlinearVirtual.");
	report_strategy("Verify that event delivered to window B with detail set to NotifyNonlinear.");
	report_strategy("Verify that all EnterNotify events are delivered after all");
	report_strategy("LeaveNotify events.");

	tpstartup();
/* Check to see if multiple screens are supported. */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	}
	else
		CHECK;
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set windows A and B. */ 
	A = guardian->firstchild;
	Broot = guardian->nextsibling;
	B = Broot->firstchild->firstchild->firstchild;
/* Select for xname and LeaveNotify events on all windows. */
	if (winh_selectinput(display, (Winh *) NULL, BOTHMASKS)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(B, Broot, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Move pointer from window A to window B. */
	XWarpPointer(display, None, A->window, 0, 0, 0, 0, 0, 0);
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify events delivered on each window from window B's root */
/* down to but not including window B in proper order. */
		increasing = True;
		if (winh_climb(B, Broot, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that detail is set to NotifyNonlinearVirtual. */
		_detail_ = NotifyNonlinearVirtual;
		if (winh_climb(B->parent, Broot, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that event delivered to window B with detail set to NotifyNonlinear. */
		_detail_ = NotifyNonlinear;
		if (winh_climb(B, B, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered after all */
/* LeaveNotify events. */
		status = winh_ordercheck(OTHEREVENT, EVENT);
		if (status == -1)
			return;
		else if (status) {
			report("Incorrect event ordering.");
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){


 	report_purpose(11);

	report_assertion("Assertion EnterNotify-11.(-)");
	report_assertion("If the implementation supports multiple screens: When the");
	report_assertion("pointer moves from window A to window B and window A and");
	report_assertion("window B are on different screens, then an EnterNotify event");
	report_assertion("is generated on window B with detail set to NotifyNonlinear.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t012(){

Display	*display = Dsp;
Winh	*eventw;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion EnterNotify-12.(A)");
	report_assertion("When an EnterNotify event is delivered and the event window");
	report_assertion("is the focus window, then focus is set to True.");

	report_strategy("Build window hierarchy.");
	report_strategy("Set input focus to eventw.");
	report_strategy("Move pointer to known location.");
	report_strategy("Select EnterNotify events on the eventw.");
	report_strategy("Call XWarpPointer to move the pointer to eventw.");
	report_strategy("Verify event was delivered with focus set to True.");
	report_strategy("Move pointer back to known location.");
	report_strategy("Clear event expectations.");
	report_strategy("Set input focus to known window.");
	report_strategy("Call XWarpPointer to move the pointer to eventw.");
	report_strategy("Verify event was delivered with focus set to False.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, 1, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
	eventw = guardian->firstchild;
/* Set input focus to eventw. */
	XSetInputFocus(display, eventw->window, RevertToPointerRoot, CurrentTime);
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select xname events on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
/* Call XWarpPointer to move the pointer to eventw. */
	XSync(display, True);
	XWarpPointer(display, None, eventw->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify event was delivered with focus set to True. */
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = eventw->window;
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK)) {
		report("Could not initialize for event delivery");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		if (eventw->delivered->event->xcrossing.focus != True) {
			report("Focus set to %d, expected %d",
				eventw->delivered->event->xcrossing.focus,True);
			FAIL;
		}
		else
			CHECK;
	}
/* Move pointer back to known location. */
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);
/* Set input focus to known window. */
	XSetInputFocus(display, eventw->nextsibling->window, RevertToPointerRoot, CurrentTime);
/* Call XWarpPointer to move the pointer to eventw. */
	XSync(display, True);
	XWarpPointer(display, None, eventw->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify event was delivered with focus set to False. */
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK)) {
		report("Could not initialize for event delivery");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		if (eventw->delivered->event->xcrossing.focus != False) {
			report("Focus set to %d, expected %d",
				eventw->delivered->event->xcrossing.focus, False);
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(9);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

Display	*display = Dsp;
Winh	*eventw, *focusw;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion EnterNotify-13.(A)");
	report_assertion("When an EnterNotify event is delivered and the event window");
	report_assertion("is an inferior of the focus window, then focus is set to");
	report_assertion("True.");

	report_strategy("Build window hierarchy.");
	report_strategy("Set input focus to ancestor of window eventw.");
	report_strategy("Move pointer to known location.");
	report_strategy("Select EnterNotify events on the eventw.");
	report_strategy("Call XWarpPointer to move the pointer to eventw.");
	report_strategy("Verify event was delivered with focus set to True.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, 2, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
	focusw = guardian->firstchild;
	eventw = guardian->firstchild->firstchild;
/* Set input focus to ancestor of window eventw. */
	XSetInputFocus(display, focusw->window, RevertToPointerRoot, CurrentTime);
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select xname events on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
/* Call XWarpPointer to move the pointer to eventw. */
	XSync(display, True);
	XWarpPointer(display, None, eventw->window, 0, 0, 0, 0, 2, 2);
	XSync(display, False);
/* Verify event was delivered with focus set to True. */
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = eventw->window;
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK)) {
		report("Could not initialize for event delivery");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		if (eventw->delivered->event->xcrossing.focus != True) {
			report("Focus set to %d, expected %d",
				eventw->delivered->event->xcrossing.focus, True);
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
