/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XChangeDeviceDontPropagateList(display, win, count, events, mode)
 *   Display	*display;
 *   Window	win;
 *   int	count;
 *   XEventClass *events;
 *   int	mode;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeDeviceDontPropagateList	1
char    *TestName = "XChangeDeviceDontPropagateList";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW win
#define A_DRAWABLE win


/*
 * Arguments to the XChangeDeviceDontPropagateList function
 */
static Display	*display;
static Window	win;
static int	count;
static XEventClass *events;
static int	mode;


static int 	ValueReturn;


extern XEventClass classes[];


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	win = 0;
	count = 0;
	events = 0;
	mode = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	win = ErrdefWindow;
}

static void t001(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeDeviceDontPropagateList-1.(B)");
	report_assertion("A successful call to XChangeDeviceDontPropagateList can add");
	report_assertion("to the DontPropagateList for the specified window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XChangeDeviceDontPropagateList to add to the list of events whose propagation is suppressed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension devices.\n", TestName);
	    return;
	    }

	win = defwin(display);
	SelectExtensionEvents(display,win);
	mode = AddToList;
	events = classes;
	count = 2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeDeviceDontPropagateList-2.(B)");
	report_assertion("A successful call to XChangeDeviceDontPropagateList can");
	report_assertion("delete from the DontPropagateList for the specified window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XChangeDeviceDontPropagateList to delete from the list of events whose propagation is suppressed.");
	report_strategy("Call when the list has elements to be deleted, as well as when the list is");
	report_strategy("empty.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension devices.\n", TestName);
	    return;
	    }
	win = defwin(display);
	mode = DeleteFromList;
	events = classes;
	count = 2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(1);

	SelectExtensionEvents(display,win);
	mode = AddToList;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(2);

	mode = DeleteFromList;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	ret, count;
XEventClass *list;
Display	*client1, *save;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeDeviceDontPropagateList-3.(B)");
	report_assertion("A successful call to XChangeDeviceDontPropagateList changes");
	report_assertion("the propagate mask for all clients.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Get the original propagate list.");
	report_strategy("Call XChangeDeviceDontPropagateList to add to the list of events whose propagation is suppressed.");
	report_strategy("Verify the list is changed.");
	report_strategy("Get the propagate list for another client.");
	report_strategy("Verify it is the same.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension devices.\n", TestName);
	    return;
	    }
/* Create client1. */
	if ((client1 = opendisplay()) == NULL)
		return;

	win = defwin(display);
	list = XGetDeviceDontPropagateList (display, win, &count);
	if (count !=0 || list != NULL)
	    {
	    report("%s: Count was %d (should be 0), list was %x (should be NULL)",TestName,count,list);
	    FAIL;
	    }
	else 
	    CHECK;
	mode = AddToList;
	events = classes;
	count = 2;
	save = display;
	display = client1;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;

	list = XGetDeviceDontPropagateList (save, win, &count);
	if (count !=2 || list == NULL)
	    {
	    report("%s: Count was %d (should be 2), list was NULL (shouldn't be)",TestName,count,list);
	    FAIL;
	    }
	else if ((*list != classes[0] && *list != classes[1]) ||
	    (*(list+1) != classes[0] && *(list+1)!= classes[1]))
	    {
	    report("%s: returned list (%x %x) didn't match sent (%x %x)",TestName,*list,*(list+1),classes[0],classes[1]);
	    FAIL;
	    }
	else
	    CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	ret, count;
XEventClass *list;
Display	*client1, *save;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeDeviceDontPropagateList-4.(B)");
	report_assertion("The termination of the client that changed the propagate");
	report_assertion("list for a window does not affect that list.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Get the original propagate list.");
	report_strategy("Call XChangeDeviceDontPropagateList to add to the list of events whose propagation is suppressed.");
	report_strategy("Terminate the client and see if the propagate list has changed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension devices.\n", TestName);
	    return;
	    }
/* Create client1. */
	if ((client1 = opendisplay()) == NULL)
		return;

	win = defwin(display);
	list = XGetDeviceDontPropagateList (display, win, &count);
	if (count !=0 || list != NULL)
	    {
	    report("%s: Count was %d (should be 0), list was %x (should be NULL)",TestName,count,list);
	    FAIL;
	    }
	else
	    CHECK;
	mode = AddToList;
	events = classes;
	count = 2;
	save = display;
	display = client1;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	list = XGetDeviceDontPropagateList (save, win, &count);
	if (count !=2 || list == NULL)
	    {
	    report("%s: Count was %d (should be 2), list was NULL (shouldn't be)",TestName,count,list);
	    FAIL;
	    }
	else if ((*list != classes[0] && *list != classes[1]) ||
	    (*(list+1) != classes[0] && *(list+1)!= classes[1]))
	    {
	    report("%s: returned list (%x %x) didn't match sent (%x %x)",TestName,*list,*(list+1),classes[0],classes[1]);
	    FAIL;
	    }
	else
	    CHECK;

	display = save;
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeDeviceDontPropagateList-5.(B)");
	report_assertion("A call to XChangeDeviceDontPropagateList with an invalid");
	report_assertion("window id will cause the server to return a BadWindow error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XChangeDeviceDontPropagateList with an invalid window id.  Verify that a BadWindow error is ");
	report_strategy("generated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension devices.\n", TestName);
	    return;
	    }
	win = 0;
	mode = AddToList;
	events = classes;
	count = 2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() != BadWindow)
		FAIL;
	else
		CHECK;
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	ret, badmode;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangeDeviceDontPropagateList-6.(B)");
	report_assertion("A call to XChangeDeviceDontPropagateList with an invalid");
	report_assertion("mode will cause the server to return a BadMode error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XChangeDeviceDontPropagateList with an invalid window id.  Verify that a BadWindow error is ");
	report_strategy("generated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension devices.\n", TestName);
	    return;
	    }

	BadMode (display, badmode);
	mode = -1;
	win = defwin(display);
	events = classes;
	count = 2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != badmode) {
		report("Got %s, Expecting badmode", errorname(geterr()));
		FAIL;
	}
	if (geterr() != badmode)
		FAIL;
	else
		CHECK;
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	ret, badclass;
XEventClass badclasses[2];
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangeDeviceDontPropagateList-7.(B)");
	report_assertion("A call to XChangeDeviceDontPropagateList with an invalid");
	report_assertion("event class will cause the server to return a BadClass");
	report_assertion("error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XChangeDeviceDontPropagateList with an invalid event class.  Verify that a BadClass error is ");
	report_strategy("generated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension devices.\n", TestName);
	    return;
	    }
	BadClass (display, badclass);
	badclasses[0] = -1;
	badclasses[1] = -1;
	mode = AddToList;
	win = defwin(display);
	events = badclasses;
	count = 2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != badclass) {
		report("Got %s, Expecting badclass", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);
	if (geterr() != badclass)
		FAIL;
	else
		CHECK;

	mode = DeleteFromList;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeDeviceDontPropagateList(display, win, count, events, mode);
	endcall(display);
	if (geterr() != badclass) {
		report("Got %s, Expecting badclass", errorname(geterr()));
		FAIL;
	}
	if (geterr() != badclass)
		FAIL;
	else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
