/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators)
 *   Display	*display;
 *   XDevice *device;
 *   int *valuators;
 *   int first_valuator;
 *   int num_valuators;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetDeviceValuators	1
char    *TestName = "XSetDeviceValuators";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetDeviceValuators function
 */
static Display	*display;
static XDevice *device;
static int *valuators;
static int first_valuator;
static int num_valuators;


extern ExtDeviceInfo Devs;
extern int NumValuators;
int tvals[256];


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	valuators = tvals;
	first_valuator = 0;
	num_valuators = 1;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int i, j, k, l, ret, ndevices, count=1;
XDeviceState *state;
XValuatorState *vs;
XDeviceInfo *list;
XAnyClassPtr any;
XAxisInfoPtr a=NULL;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetDeviceValuators-1.(B)");
	report_assertion("A call to XSetDeviceValuators will change the value of the");
	report_assertion("valuators on the device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with a valid device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(DValMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.DvVal;
	XSetDeviceMode(display, Devs.DvVal, Absolute);
	state = XQueryDeviceState(display, device);
	vs = (XValuatorState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (vs->class == ValuatorClass)
		if (vs->mode == Absolute)
		    CHECK;
		else
		    {
		    report("%s: Couldn't set Absolute mode\n",TestName);
		    FAIL;
		    }
	    vs = (XValuatorState *) ((char *) vs + vs->length);
	    }

	list = XListInputDevices(display, &ndevices);
	for (i=0,num_valuators=0; i<ndevices; i++,list++)
	    {
	    if (list->id!=Devs.DvVal->device_id)
		continue;
	    any = (XAnyClassPtr) (list->inputclassinfo);
	    for (j=0,l=0; j<list->num_classes; j++)
		{
		if (any->class == ValuatorClass)
		    {
		    a = ((XValuatorInfo *) any)->axes;
		    num_valuators += ((XValuatorInfo *) any)->num_axes;
		    for (k=0; k<((XValuatorInfo *)any)->num_axes; k++)
			tvals[l++] = (a+k)->max_value;
		    }
	        any = (XAnyClassPtr) ((char *) any + any->length);
		}
	    }
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	state = XQueryDeviceState(display, device);
	vs = (XValuatorState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (vs->class == ValuatorClass)
		{
		for (j=0; j<vs->num_valuators; j++)
		    if (*(vs->valuators + j) == tvals[j])
			{
			CHECK;
			count++;
			}
		    else
			{
			report("%s: Wrong value for valuator %d, got %d wanted %d\n",TestName,j,*(vs->valuators+j),tvals[j]);
			FAIL;
			}
		break;
		}
	    vs = (XValuatorState *) ((char *) vs + vs->length);
	    }
	CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int i, j, k, l, ret, ndevices, count=1;
XDeviceState *state;
XValuatorState *vs;
XDeviceInfo *list;
XAnyClassPtr any;
XAxisInfoPtr a=NULL;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetDeviceValuators-2.(B)");
	report_assertion("A call to SetDeviceValuators will not affect the value of");
	report_assertion("valuators outside the specified range.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XSetDeviceValuators to set one of the valuators.");
	report_strategy("Verify that the others are unchanged.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(DValMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.DvVal;
	num_valuators=0;
	XSetDeviceMode(display, Devs.DvVal, Absolute);
	state = XQueryDeviceState(display, device);
	vs = (XValuatorState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (vs->class == ValuatorClass)
		if (vs->mode == Absolute)
		    CHECK;
		else
		    {
		    report("%s: Couldn't set Absolute mode\n",TestName);
		    FAIL;
		    }
	    vs = (XValuatorState *) ((char *) vs + vs->length);
	    }

	list = XListInputDevices(display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    {
	    if (list->id!=Devs.DvVal->device_id)
		continue;
	    any = (XAnyClassPtr) (list->inputclassinfo);
	    for (j=0,l=0; j<list->num_classes; j++)
		{
		if (any->class == ValuatorClass)
		    {
		    a = ((XValuatorInfo *) any)->axes;
		    num_valuators += ((XValuatorInfo *) any)->num_axes;
		    for (k=0; k<((XValuatorInfo *) any)->num_axes;k++)
			tvals[l++] = (a+k)->min_value;
		    }
	        any = (XAnyClassPtr) ((char *) any + any->length);
		}
	    }
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	state = XQueryDeviceState(display, device);
	vs = (XValuatorState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (vs->class == ValuatorClass)
		{
		for (j=0; j<vs->num_valuators; j++)
		    if (*(vs->valuators + j) == tvals[j])
			{
			CHECK;
			count++;
			}
		    else
			{
			report("%s: Wrong value for valuator %d, got %d wanted %d\n",TestName,j,*(vs->valuators+j),tvals[j]);
			FAIL;
			}
		break;
		}
	    vs = (XValuatorState *) ((char *) vs + vs->length);
	    }
	num_valuators = 1;
	tvals[0] = a->max_value;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	state = XQueryDeviceState(display, device);
	vs = (XValuatorState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (vs->class == ValuatorClass)
		{
		if (*vs->valuators == a->max_value)
		    {
		    CHECK;
		    count++;
		    }
		else
		    {
		    report("%s: Wrong value for valuator 0, got %d wanted %d\n",TestName,*vs->valuators,tvals[0]);
		    FAIL;
		    }
		for (j=1; j<vs->num_valuators; j++)
		    if (*(vs->valuators + j) == tvals[j])
			{
			CHECK;
			count++;
			}
		    else
			{
			report("%s: Wrong value for valuator %d, got %d wanted %d\n",TestName,j,*(vs->valuators+j),tvals[j]);
			FAIL;
			}
		break;
		}
	    vs = (XValuatorState *) ((char *) vs + vs->length);
	    }
	CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int ret;
Display	*client2;
Window grab_window;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetDeviceValuators-3.(B)");
	report_assertion("A call to XSetDeviceValuators will return a status of");
	report_assertion("AlreadyGrabbed if a another client has the device grabbed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab the device from another client.");
	report_strategy("Make the call with an valid device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(DValMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.DvVal;
        grab_window = defwin(Dsp);

	XGrabDevice(Dsp, Devs.DvVal, grab_window, True, 0, 
		NULL, GrabModeAsync, GrabModeAsync, CurrentTime);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == AlreadyGrabbed)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetDeviceValuators-4.(B)");
	report_assertion("A call to XSetDeviceValuators will fail with a BadValue");
	report_assertion("error if too many valuators are specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify a first_valuator equal to the number of valuators - 1.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(DValMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.DvVal;

	first_valuator = NumValuators-1;
	num_valuators = 2;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetDeviceValuators-5.(B)");
	report_assertion("A call to XSetDeviceValuators will fail with a BadMatch");
	report_assertion("error if an valid device that has no valuators is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an valid device that has no valuators.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NValsMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.NoValuators;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XDevice nodevice;
int baddevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetDeviceValuators-6.(B)");
	report_assertion("A call to XSetDeviceValuators will fail with a BadDevice");
	report_assertion("error if an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err)) {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceValuators(display, device, valuators, first_valuator, num_valuators);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
